<?php
namespace App\Widget;

use App\Banner;

class BannersByIdWidget extends Widget {

    protected $slug = 'banners-by-id';

    protected $fields = [
        [ 'slug' => 'widget_title', 'type' => 'text', 'title' => 'عنوان ابزارک', 'default_value' => 'بنرهای سایدبار', 'description'=> 'در صورت خالی بودن، بخش عنوان و کادر اطراف بنرها نمایش داده نخواهد شد'],
        [ 'slug' => 'ids', 'type' => 'text', 'title' => 'شناسه بنرها', 'default_value' => '', 'description'=> 'شناسه بنرها را با کاما , جدا کنید'],
    ];

    public function render() {
        $banners = (new Banner())->byIds(explode(',', $this->setting('ids')));
        $widget = $this;

        if ($banners) {
            include($this->viewPath());
        }

        return true;
    }

    /**
     * Returns path to view file
     *
     * @return mixed
     */
    protected function viewPath() {
        return "includes/theme/widgets/banners.php";
    }
}