<?php

namespace App;

class UniqueSMS
{

    protected $api_key;
    protected $secret_key;
    protected $api_url;
    protected $_from;

    /**
     * Gets config parameters for sending request.
     *
     * @param $api_key
     * @param $secret_key
     * @param $api_url
     */
    public function __construct($api_key, $secret_key, $api_url)
    {
        $this->api_key = $api_key;
        $this->secret_key = $secret_key;
        $this->api_url = $api_url;
        $this->_from = setting('SITE_SMS_NUMBER');
    }

    /**
     * Sends SMS with service Number
     *
     * @param $to
     * @param $variables
     * @param $template_id
     * @return bool|string
     */
    public function send($to, $variables, $template_id)
    {
        try {
        
            return $this->analyzeParameters($to, $variables, $template_id);

            // return $this->ultraFastSend($unique_data);
        } catch (\Exception $e) {
            return false;
        }
    }

    /**
     * Ultra Fast Send Message.
     *
     * @param array $data array structure of message data
     *
     * @return string Indicates the sent sms result
     */
    protected function ultraFastSend($data)
    {
        $ch = new MyCurl($data);

        $ch->createCurl();

        return $ch->getCurlResault();
    }


    /**
     * returns the data array needed for sending unique sms
     *
     * @param $to
     * @param $variables
     * @param $template_id
     * @return array
     */
    protected function analyzeParameters($to, $variables, $template_id)
    {
        unset($variables['siteName']);
        unset($variables['password']);

        $post = [
            'code' => $template_id,
            'sender' => $this->_from,
            'recipient' => $to,
            'variable' => $variables
        ];

        $ch = curl_init();

        curl_setopt($ch, CURLOPT_URL, 'https://api2.ippanel.com/api/v1/sms/pattern/normal/send');
        curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1);
        curl_setopt($ch, CURLOPT_POST, 1);
        curl_setopt($ch, CURLOPT_POSTFIELDS, json_encode($post));

        $headers = array();
        $headers[] = 'Accept: */*';
        $headers[] = 'Apikey: ' . $this->api_key;
        $headers[] = 'Content-Type: application/json';
        curl_setopt($ch, CURLOPT_HTTPHEADER, $headers);

        $result = curl_exec($ch);
        curl_close($ch);

        $res = json_decode($result);
        return $res->status;
    }

    protected function analyzeParametersPayamResan($to, $variables, $template_id)
    {
        unset($variables['siteName']);
        unset($variables['password']);

        $post = [
            'code' => $template_id,
            'sender' => $this->_from,
            'recipient' => $to,
            'variable' => $variables
        ];

        $var_values = "";
        $i = 1;
        foreach ($variables as $var) {
            $var_values = "&p{$i}={$var}";
        }

        $this->api_key = '212872-7cb639c1650645e9aec35170fd7b071f';

        $send_url = "http://api.sms-webservice.com/api/V3/SendTokenSingle?ApiKey={$this->api_key}&TemplateKey={$template_id}&Destination={$to}{$var_values}";

        $curl = curl_init();

        curl_setopt_array($curl, array(
            CURLOPT_URL => $send_url,
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_ENCODING => '',
            CURLOPT_MAXREDIRS => 10,
            CURLOPT_TIMEOUT => 0,
            CURLOPT_FOLLOWLOCATION => true,
            CURLOPT_HTTP_VERSION => CURL_HTTP_VERSION_1_1,
            CURLOPT_CUSTOMREQUEST => 'GET',
            // CURLOPT_POSTFIELDS => '{"ApiKey": "123456","Recipients": [{"Sender": 0,"Text": "test","Destination": 0,"UserTraceId": 0}]}',
            CURLOPT_HTTPHEADER => array(
                'Content-Type: application/json'
            ),
        ));

        $response = curl_exec($curl);

        curl_close($curl);
        return $response;
    }
}
