<?php

namespace App;

class SoapSMS
{
    private $_soap;
    private $_from;
    private $_username;
    private $_password;
    private $_APISendUrl;
    private $_APIDeliveryUrl;
    private $_APICreditUrl;
    private $_APIContactUrl;
    private $_to;
    private $_text;
    private $_isFlash = false;
    private $_sendUrl;
    private $_deliveryUrl;
    private $_creditUrl;
    private $_resId;
    private $_deliveryStatus;
    private $_deliveryStatusParams;
    private $_ContactsGroupId;

    function SoapSMS()
    {
        $this->_from = setting('SITE_SMS_NUMBER');
        $this->_username = setting('SMS_USERNAME');
        $this->_password = setting('SMS_PASSWORD');
        $this->_APISendUrl = setting('SMS_SEND_URL');
        $this->_APICreditUrl = setting('SMS_CREDIT_URL');
        $this->_APIContactUrl = setting('SMS_CONTACT_URL');

        $this->_deliveryStatusParams = array();
    }

    public function set_to($number = '')
    {
        $this->_to = $number;
    }

    public function set_text($text = '')
    {
        $this->_text = $text;
    }

    public function SendOne()
    {
        $this->_soap = new SoapClient($this->_APISendUrl, array('encoding' => 'UTF-8'));
        $parameters = $this->setParameters('SEND');
        return $this->_soap->call('SendSimpleSMS', $parameters);
    }

    public function Send() // $params[to] must be an array of numbers
    {
        $this->_soap = new SoapClient($this->_APISendUrl, array('encoding' => 'UTF-8'));
        $params = $this->setParameters('SEND');
        return $this->_soap->SendSms($params)->SendSmsResult;
    }

    public function getDelivery($recId) // $parma[to] must be an array of numbers
    {
        $this->_soap = new SoapClient($this->_APISendUrl);
        return $this->_soap->GetDelivery($recId)->GetDeliveryResult;
    }

    public function getCredit()
    {
        $this->_soap = new SoapClient($this->_APICreditUrl, array('encoding' => 'UTF-8'));
        $params = $this->setParameters('CREDIT');
        return round($this->_soap->GetCredit($params)->GetCreditResult);
    }

    public function GetInboxCount($is_read = false)
    {
        $this->_soap = new SoapClient($this->_APISendUrl, array('encoding' => 'UTF-8'));
        $params = $this->setInboxParameters($is_read);
        return $this->_soap->GetInboxCount($params)->GetInboxCountResult;
    }

    public function GetMessages($location = 1, $count = 10) // location 1 : recived  ; 2 : sent ; -1 : all
    {
        $this->_soap = new SoapClient($this->_APISendUrl, array('encoding' => 'UTF-8'));
        $params = $this->setGetMessageParameters($location, $count);
        return $this->_soap->GetMessageStr($params)->GetMessageStrResult;
        // returns an object for every sms that contains body,date and ...
    }

    public function addContact($mobile = '', $email = '', $name = '')
    {
        $this->_soap = new SoapClient($this->_APIContactUrl, array('encoding' => 'UTF-8'));
        $params = $this->setAddContactParameters($mobile, $email, $name);
        return $this->_soap->AddContact($params)->AddContactResult;
    }

    private function setParameters($type = 'SEND')
    {

        switch ($type) {

            case 'SEND' :
                $parameters['username'] = $this->_username;
                $parameters['password'] = $this->_password;
                $parameters['to'] = $this->_to;
                $parameters['from'] = $this->_from;
                $parameters['text'] = $this->_text;
                $parameters['isflash'] = $this->_isFlash;
                $parameters['udh'] = "";
                $parameters['recId'] = array(0);
                $parameters['status'] = 0x0;
                break;

            case 'CREDIT' :
                $parameters['username'] = $this->_username;
                $parameters['password'] = $this->_password;
                break;

        }
        return $parameters;
    }

    private function setInboxParameters($is_read = false)
    {

        $parameters['username'] = $this->_username;
        $parameters['password'] = $this->_password;
        $parameters['isRead'] = $is_read;

        return $parameters;
    }

    private function setGetMessageParameters($location = 1, $count = 10)
    {

        $parameters['username'] = $this->_username;
        $parameters['password'] = $this->_password;
        $parameters['location'] = $location; // 1 : recived  ; 2 : sent ; -1 : all
        $parameters['count'] = $count;
        $parameters['from'] = "";
        $parameters['index'] = 0;

        return $parameters;
    }

    private function setAddContactParameters($mobile = '', $email = '', $name = '')
    {

        $parameters['username'] = $this->_username;
        $parameters['password'] = $this->_password;
        $parameters['groupIds'] = $this->_ContactsGroupId; // 1 : recived  ; 2 : sent ; -1 : all
        $parameters['mobilenumber'] = $mobile;
        $parameters['email'] = $email;
        $parameters['firstname'] = $name;

        return $parameters;
    }

}


?>