<?php

namespace App;

class Session
{
    protected $_msgSession = 'SESS_MSG';
    protected $_msgArraySession = 'SESS_MSG_ARRAY';

    public function exists($name)
    {
        return (isset($_SESSION[$name])) ? true : false;
    }

    public function put($name, $value)
    {
        return $_SESSION[$name] = $value;
    }

    /**
     * @param $name
     * @return mixed
     */
    public function get($name)
    {
        if ($this->exists($name)) {
            return $_SESSION[$name];
        }

        return false;
    }

    public function not_empty($name)
    {
        $session = $this->get($name);
        if ($this->exists($name) && ! empty($session)) {
            return true;
        }

        return false;
    }

    public function is_empty($name)
    {
        return (! $this->not_empty($name));
    }

    public function delete($name)
    {
        if ($this->exists($name)) {
            unset($_SESSION[$name]);
        }
    }

    public function alert($type = 'error', $text = '', $is_array = false)
    {
        $class = ($type === 'error') ? 'danger' : 'accent';
        $icon = ($type === 'error') ? 'warning' : 'check';

        if (! $is_array) {
            $msg = "
                <div class='m-alert m-alert--icon alert alert-{$class}' role='alert'>
                    <div class='m-alert__icon'>
                        <i class='la la-{$icon}'></i>
                    </div>
                    <div class='m-alert__text'>
                        {$text}
                    </div>
                    <div class='m-alert__close'>
                        <button type='button' class='close' data-dismiss='alert' aria-label='Close'>
                        </button>
                    </div>
                </div>
            ";

            $this->put($this->_msgSession, $msg);
        } else {
            $this->put($this->_msgArraySession, $text);
        }
    }

    public function showAlert()
    {

        if ($this->not_empty($this->_msgSession)) {
            echo $_SESSION[$this->_msgSession];
            $this->delete($this->_msgSession);
        }

        if ($this->not_empty($this->_msgArraySession)) {

            echo "
                <div class='m-alert m-alert--icon alert alert-danger' role='alert'>
                    <div class='m-alert__icon'>
                        <i class='la la-warning'></i>
                    </div>
                    <div class='m-alert__text'>
                        <ul class='msg-array'>
            ";
            foreach ($_SESSION[$this->_msgArraySession] as $error) {
                echo "<li>" . $error . "</li>";
            }
            echo "
                        </ul>
                    </div>
                    <div class='m-alert__close'>
                        <button type='button' class='close' data-dismiss='alert' aria-label='Close'>
                        </button>
                    </div>
                </div>
            ";

            $this->delete($this->_msgArraySession);
        }

        return false;
    }

    public function error($text = '', $is_array = false)
    {
        if (empty($text)) {
            $text = _e('OPERATION_FAILED', true);
        }

        $this->alert('error', $text, $is_array);
    }


    public function success($text = '', $is_array = false)
    {
        if (empty($text)) {
            $text = _e('OPERATION_SUCCESS', true);
        }

        $this->alert('success', $text, $is_array);
    }
}
