<?php
namespace App;

class RestSMS{
	protected $_from;
	protected $_username;
	protected $_password;
	protected $_APISendUrl;
	protected $_APICreditUrl;
	protected $_to;
	protected $_text;
	protected $_sendUrl;
	protected $_creditUrl;
	protected $_resId;
	protected $_deliveryStatusParams;

    /**
     * RestSMS constructor.
     */
	public function __construct()
	{
        $this->_from 			= setting('SITE_SMS_NUMBER');
        $this->_username 		= setting('SMS_USERNAME');
        $this->_password 		= setting('SMS_PASSWORD');
        $this->_APISendUrl 		= setting('SMS_SEND_URL');
        $this->_APICreditUrl 	= setting('SMS_CREDIT_URL');
        $this->_deliveryStatusParams = array();
	}

    /**
     * Sets recipients
     *
     * @param string $number
     */
	public function set_to($number=''){
		$this->_to=$number;
	}

    /**
     * Sets Body of sms
     *
     * @param string $text
     */
	public function set_text($text=''){
		$this->_text = urlencode($text);
	}

    /**
     * Sends Sms
     *
     * @return mixed
     */
	public function Send()
	{
		$this->setSendUrl();

         $ch = new MyCurl($this->_sendUrl);

         $ch->createCurl();

		return $this->_resId=$ch->getCurlResault();
	}

    /**
     * Returns Remaining Credit for sms panel
     *
     * @return mixed
     */
	public function getCredit()
	{
		$this->setCreditUrl();

		$ch=new MyCurl($this->_creditUrl);
		$ch->createCurl();
		return $ch->getCurlResault();
	}

    /**
     * Sets Url to send sms
     */
	protected function setSendUrl()
	{
		$this->_sendUrl = $this->_APISendUrl."?uname=" . $this->_username . "&pass=" . $this->_password . "&from=" . $this->_from . "&to=" . $this->_to . "&msg=" . $this->_text . "";
	}

    /**
     * Sets Url to get remaining credits from sms panel
     */
	protected function setCreditUrl()
	{
		$this->_creditUrl=$this->_APICreditUrl."?uname=" . $this->_username . "&pass=" . $this->_password . "" ;
	}
}
