<?php

namespace App;

use PHPMailer\PHPMailer\Exception;
use PHPMailer\PHPMailer\PHPMailer;

class Mailer
{
	private $MAIL_HOST = '';
	private $MAIL_PORT = '';
	private $SMTP_USERNAME = '';
	private $SMTP_PASSWORD = '';
	private $FROM_NAME;
	private $FROM_EMAIL;
	private $TO_NAME;
	private $TO_EMAIL;
	private $SUBJECT;
	private $MESSAGE;
	private $IS_SMTP = true;

	public function __construct()
	{
		$this->MAIL_HOST 	 = setting('MAIL_HOST');
		$this->MAIL_PORT 	 = setting('MAIL_PORT');
		$this->SMTP_USERNAME = setting('MAIL_USERNAME');
		$this->SMTP_PASSWORD = setting('MAIL_PASSWORD');
	}

	/**
	 * Sends a new message
	 *
	 * @param  String $to :: receiver email
	 * @param  string $message :: email content
	 * @param  string $subject :: email subject
	 * @param  string $receiver_name :: receiver name
	 * @param  String $from_email :: sender sender
	 * @param  String $from_name :: sender name
	 * @return bool
	 */
	public function send($to, $message = '', $subject = '', $receiver_name = '', $from_email = null, $from_name = null)
	{

		if (empty($to)) {
			return false;
		}

		$from_email = (! empty($from_email)) ? $from_email : setting('EMAIL');
		$from_name 	= (! empty($from_name))  ? $from_name  : setting('SITE_TITLE');

		$this->set_from_email($from_email);
		$this->set_from_name($from_name);
		$this->set_to_email($to);
		$this->set_to_name($receiver_name);
		$this->set_subject($subject);
		$this->set_message($message);

		return $this->send_mail();
	}

	public function send_mail()
	{
		try {
			$mail = new PHPMailer(true);
			$mail->CharSet = 'UTF-8';

			if ($this->IS_SMTP) {
				$mail->IsSMTP();
				$mail->Host = $this->MAIL_HOST;
				$mail->Port = $this->MAIL_PORT;
				$mail->SMTPDebug = false; // 2
				$mail->SMTPAuth = true;


				$mail->Username = $this->SMTP_USERNAME;
				$mail->Password = $this->SMTP_PASSWORD;

				if (setting('IS_SSL') === 'YES') {
					$mail->SMTPSecure = 'ssl';
					$mail->SMTPOptions = array(
						'ssl' => array(
							'verify_peer' => false,
							'verify_peer_name' => false,
							'allow_self_signed' => true
						)
					);
				}
			}

			$mail->From 	= $this->FROM_EMAIL;
			$mail->FromName = $this->FROM_NAME;
			$mail->Subject 	= $this->SUBJECT;
			$mail->MsgHTML($this->MESSAGE);
			$mail->AddAddress($this->TO_EMAIL, $this->TO_NAME);
			$mail->Send();

			return true;
		} catch (Exception $e) {
			 //dd($e->getMessage());
			return false;
		}
	}

	public function set_from_name($param)
	{
		$this->FROM_NAME = $param;
	}

	public function set_from_email($param)
	{
		$this->FROM_EMAIL = $param;
	}

	public function set_to_name($param)
	{
		$this->TO_NAME = $param;
	}

	public function set_to_email($param)
	{
		$this->TO_EMAIL = $param;
	}

	public function set_subject($param)
	{
		$this->SUBJECT = $param;
	}

	public function set_message($param)
	{
		$this->MESSAGE = $param;
	}

	public static function prepare_body($mailTemplate = '', $mailVariables = array())
	{
		foreach ($mailVariables as $key => $value) {
			$mailTemplate = str_replace($key, $value, $mailTemplate);
		}
		return $mailTemplate;
	}
}
