<?php

namespace App;

class Input
{
    /**
     * Checks whether a post or get request is exists or not
     *
     * @param string $type
     * @return bool
     */
    public function exists($type = 'post')
    {
        switch ($type) {
            case 'post':
                return (!empty($_POST)) ? true : false;
                break;
            case 'get':
                return (!empty($_GET)) ? true : false;
                break;
            default:
                return false;
                break;
        }
    }

    /**
     * Returns the value of a specific input
     *
     * @param $item
     * @return mixed
     */
    public function get($item)
    {
        if (isset($_POST[$item])) {
            return $_POST[$item];
        } elseif (isset($_GET[$item])) {
            return $_GET[$item];
        }

        return '';
    }

    /**
     * Checks whether a specified input is exists or not
     *
     * @param $item
     * @return bool
     */
    public function is_set($item)
    {
        if (isset($_POST[$item]) || isset($_GET[$item])) {
            return true;
        }

        return false;
    }

    /**
     * Checks whether a specified input is not empty
     *
     * @param $item
     * @param bool $not_equal_to_any
     * @return bool
     */
    public function not_empty($item, $not_equal_to_any = false)
    {
        $input = $this->get($item);

        if (is_array($input) && count($input) > 0) {
            return true;
        }

        if ($this->is_set($item) && !empty($input) && trim($input) !== "") {
            if ($not_equal_to_any && $input == 'any') {
                return false;
            }

            return true;
        }

        return false;
    }

    /**
     * Checks if the requested input is empty
     *
     * @param $item
     * @param bool $not_equal_to_any
     * @return bool
     */
    public function isEmpty($item, $not_equal_to_any = false)
    {
        return (!$this->not_empty($item, $not_equal_to_any));
    }

    public function not_any($item)
    {
        return $this->not_empty($item, true);
    }


    /**
     * Casts all members of a specific kind of request into an associative array and returns it
     *
     * @param string $type
     * @return array
     */
    public function all($type = null)
    {
        $output = array();
        switch ($type) {
            case 'post':
                foreach ($_POST as $key => $value) {
                    $output[$key] = $value;
                }

                break;
            case 'get':
                foreach ($_GET as $key => $value) {
                    $output[$key] = $value;
                }

                break;
            default:
                foreach ($_GET as $key => $value) {
                    $output[$key] = $value;
                }
                foreach ($_POST as $key => $value) {
                    $output[$key] = $value;
                }
                break;
        }

        return $output;
    }

    /**
     * Casts only specified members of specific kind of request into an associative array and returns it
     *
     * @param array $data
     * @param string $type
     * @return array
     */
    public function only($data = array(), $type = null)
    {
        $data = makeArray($data);
        $output = array();

        switch ($type) {
            case 'get':
                $source = $_GET;
                break;

            case 'post':
                $source = $_POST;
                break;

            default:
                $source = $_REQUEST;
                break;
        }

        foreach ($source as $key => $value) {
            if (in_array($key, $data)) {
                $output[$key] = $value;
            }
        }

        return $output;
    }

    /**
     * Casts all members of a specific kind of request Except the specified ones into an associative array and returns it
     *
     * @param array $data
     * @param string $type
     * @return mixed
     */
    public function except($data = array(), $type = 'get')
    {
        $data = makeArray($data);

        switch ($type) {
            case 'get':
                $output = $_GET;
                break;

            case 'post':
                $output = $_POST;
                break;

            default:
                $output = $_REQUEST;
                break;
        }

        foreach ($data as $key => $value) {
            unset($output[$value]);
        }

        return $output;
    }

    /**
     * Returns the requested input file
     *
     * @param  String $item :: upload name
     * @param  String $data_type :: type of info
     * @return array|String
     */
    public function file($item, $data_type = null)
    {
        if (!empty($data_type)) {
            return $_FILES[$item][$data_type];
        }

        return $_FILES[$item];
    }

    /**
     * Returns only the inputs beginning with meta_ string
     *
     * @return array
     */
    public function metas()
    {
        $output = [];
        foreach ($this->all() as $key => $value) {
            if (str_starts_with($key, 'meta_')) {
                $output[str_replace('meta_', '', $key)] = $value;
            }
        }

        return $output;
    }

    public function isFileUploaded($input_name)
    {
        return not_empty(data_get($this->file($input_name), 'name'));
    }

    /**
     * Returns only the inputs beginning with meta_ string
     *
     * @param $string
     * @return array
     */
    public function startsWith($string)
    {
        $output = [];
        foreach ($this->all() as $key => $value) {
            if (str_starts_with($key, $string)) {
                $output[str_replace($string, '', $key)] = $value;
            }
        }

        return $output;
    }
}
