<?php

use App\Page;

function ipLink($ip)
{
    return 'http://whatismyipaddress.com/ip/'.$ip;
}

/**
 * shows the calendar widget
 *
 */
function show_calendar()
{
    echo "
        <li class='pull-left no-text-shadow hidden-phone'>
            <div id='dashboard-calender'>
                <i class='icon-calendar' style='color:white'></i>
                امروز " . miladiToShamsiAdmin(now(), 'l j F Y', true) . "
            </div>
        </li>
    ";
}


function makeHash($algorithem, $string) {
    return hash($algorithem, $string);
}


/**
 * @param Page $page
 * @return string
 */
function bodyClass(Page $page) {
    $output = "m-page--fluid m--skin- m-content--skin-light2 m-header--fixed m-header--fixed-mobile m-aside-left--enabled m-aside-left--skin-dark m-aside-left--offcanvas m-footer--push m-aside--offcanvas-default";

    if ($page->getOptions()->minimize_sidebar) {
        $output .= " m-brand--minimize m-aside-left--minimize";
    }

    return $output;
}

/**
 * Converts miladi date to shamsi
 *
 * @param $date_main
 * @param string $type
 * @param string $lang
 * @return string
 */
function miladiToShamsiAdmin($date_main, $type='l j F Y', $lang='false')
{
    return mi_to_sh_base($date_main, $type, $lang, false);
}

function writeVariablesCssFile($colors) {
    $template = ":root {\n";
    foreach ($colors as $key => $value) {
        $template .= "--{$key}_COLOR: {$value}; \n";
    }
    $template .="}";
    file_put_contents(SITE_ROOT.'public/variables.css', $template);
}
