-- 2024-05-31T19:29:07+03:30 - mysql:dbname=niazmandi_v10;host=localhost

-- Table structure for table `tbl_ads`

DROP TABLE IF EXISTS `tbl_ads`;
CREATE TABLE `tbl_ads` (
  `ID` bigint unsigned NOT NULL AUTO_INCREMENT,
  `ADS_TITLE` varchar(255) NOT NULL,
  `ADS_SLUG` varchar(255) NOT NULL,
  `ADS_DESCRIPTION` text NOT NULL,
  `ADS_KEYWORDS` text,
  `ADS_OWNER_NAME` varchar(255) DEFAULT NULL,
  `ADS_OWNER_EMAIL` varchar(255) DEFAULT NULL,
  `ADS_OWNER_PHONE` varchar(20) DEFAULT NULL,
  `ADS_OWNER_ADDRESS` text,
  `ADS_PRICE` varchar(20) DEFAULT NULL,
  `ADS_LINK` varchar(100) DEFAULT NULL,
  `ADS_DISCOUNT` int DEFAULT NULL,
  `CATEGORY_ID` int NOT NULL,
  `STATE_ID` int DEFAULT NULL,
  `CITY_ID` int DEFAULT NULL,
  `LONGITUDE` varchar(100) DEFAULT NULL,
  `LATITUDE` varchar(100) DEFAULT NULL,
  `DATE_CREATED` datetime NOT NULL,
  `DATE_UPDATED` datetime DEFAULT NULL,
  `USER_ID` int NOT NULL,
  `IS_ACTIVE` tinyint NOT NULL DEFAULT '1',
  `VIEWS` int DEFAULT '0',
  `IS_DELETED` smallint NOT NULL DEFAULT '1',
  `IS_EDITED` smallint NOT NULL DEFAULT '1',
  `REJECTION_CAUSE` longtext,
  `IP` varchar(100) DEFAULT NULL,
  `TELEGRAMED` tinyint(1) NOT NULL DEFAULT '0',
  `SHOW_MAP` tinyint(1) NOT NULL DEFAULT '1',
  `featured_image_id` bigint unsigned DEFAULT NULL,
  PRIMARY KEY (`ID`),
  KEY `IS_ACTIVE` (`IS_ACTIVE`),
  KEY `CATEGORY_ID` (`CATEGORY_ID`),
  KEY `DATE_CREATED` (`DATE_CREATED`),
  KEY `IS_DELETED` (`IS_DELETED`),
  KEY `USER_ID` (`USER_ID`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3;

-- Dumping data for table `tbl_ads`

LOCK TABLES `tbl_ads` WRITE;
INSERT INTO `tbl_ads` VALUES ('1','saf sa fsa fsa fas','saf-sa-fsa-fsa-fas','<p>sa fsaf asf as fsaf saf saf safsafsa</p>\r\n',NULL,NULL,'info@kodesign.ir',NULL,'asf asf saf saf ',NULL,'',NULL,'27','2','78','','','2024-05-31 00:25:33','2024-05-31 00:57:33','1','2','5','1','1','','127.0.0.1','1','1','1');
UNLOCK TABLES;

-- Table structure for table `tbl_ads_info`

DROP TABLE IF EXISTS `tbl_ads_info`;
CREATE TABLE `tbl_ads_info` (
  `id` int NOT NULL AUTO_INCREMENT,
  `ads_id` int NOT NULL,
  `field_id` int NOT NULL,
  `info_value` text,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=13 DEFAULT CHARSET=utf8mb3;

-- Dumping data for table `tbl_ads_info`

LOCK TABLES `tbl_ads_info` WRITE;
INSERT INTO `tbl_ads_info` VALUES ('7','1','22',25000000);
INSERT INTO `tbl_ads_info` VALUES ('8','1','23','mvm');
INSERT INTO `tbl_ads_info` VALUES ('9','1','24',1401);
INSERT INTO `tbl_ads_info` VALUES ('10','1','25',200);
INSERT INTO `tbl_ads_info` VALUES ('11','1','26','rent');
INSERT INTO `tbl_ads_info` VALUES ('12','1','53','asfsaf.com');
UNLOCK TABLES;

-- Table structure for table `tbl_affiliates`

DROP TABLE IF EXISTS `tbl_affiliates`;
CREATE TABLE `tbl_affiliates` (
  `id` int NOT NULL AUTO_INCREMENT,
  `user_id` int NOT NULL,
  `price` int NOT NULL,
  `commision` int NOT NULL,
  `date_created` datetime NOT NULL,
  `status` int NOT NULL DEFAULT '1',
  `comment` varchar(255) DEFAULT NULL,
  `payment_id` int NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

-- Dumping data for table `tbl_affiliates`

LOCK TABLES `tbl_affiliates` WRITE;
UNLOCK TABLES;

-- Table structure for table `tbl_auth_tokens`

DROP TABLE IF EXISTS `tbl_auth_tokens`;
CREATE TABLE `tbl_auth_tokens` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `selector` char(12) NOT NULL,
  `token` varchar(255) NOT NULL,
  `user_id` int unsigned NOT NULL,
  `type` enum('remember','forgot','activation') NOT NULL DEFAULT 'remember',
  `data` varchar(100) DEFAULT NULL,
  `created_at` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `expires` datetime NOT NULL,
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb3;

-- Dumping data for table `tbl_auth_tokens`

LOCK TABLES `tbl_auth_tokens` WRITE;
UNLOCK TABLES;

-- Table structure for table `tbl_backups`

DROP TABLE IF EXISTS `tbl_backups`;
CREATE TABLE `tbl_backups` (
  `id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(255) DEFAULT NULL,
  `created_at` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

-- Dumping data for table `tbl_backups`

LOCK TABLES `tbl_backups` WRITE;
UNLOCK TABLES;

-- Table structure for table `tbl_banners`

DROP TABLE IF EXISTS `tbl_banners`;
CREATE TABLE `tbl_banners` (
  `ID` int NOT NULL AUTO_INCREMENT,
  `BANNER_DESC` varchar(255) DEFAULT NULL,
  `BANNER_IMAGE` varchar(255) DEFAULT NULL,
  `BANNER_LINK` varchar(255) DEFAULT NULL,
  `WIDTH` int DEFAULT '1200',
  `HEIGHT` int DEFAULT '80',
  `POSITION` varchar(100) DEFAULT 'CONTENT',
  `CATEGORY_ID` int DEFAULT '0',
  `SUBCATEGORY_ID` int DEFAULT '0',
  `SUBSIDIARY_ID` int DEFAULT '0',
  `DATE_CREATED` datetime DEFAULT NULL,
  `WILL_EXPIRE` tinyint(1) NOT NULL DEFAULT '0',
  `STARTS_AT` datetime NOT NULL,
  `EXPIRES_AT` datetime NOT NULL,
  PRIMARY KEY (`ID`)
) ENGINE=InnoDB AUTO_INCREMENT=45 DEFAULT CHARSET=utf8mb3;

-- Dumping data for table `tbl_banners`

LOCK TABLES `tbl_banners` WRITE;
INSERT INTO `tbl_banners` VALUES ('2','بنر شماره 2','14245270101169.gif','http://www.kodesign.ir','600','40','CONTENT','0','0','0','2021-10-28 15:27:17','0','2017-06-09 15:27:17','2017-06-09 15:27:17');
INSERT INTO `tbl_banners` VALUES ('3','بنر شماره 3','1424527018611.gif','http://www.kodesign.ir','600','40','CONTENT','0','0','0','2015-02-21 17:27:25','0','2017-06-09 05:24:22','2017-06-06 00:00:00');
INSERT INTO `tbl_banners` VALUES ('5','توضیح دلخواه','141590446143.gif','http://www.kodesign.ir','200','80','SIDEBAR','0','0','0','2014-11-13 22:20:25','0','2017-06-09 05:24:22','2017-06-06 00:00:00');
INSERT INTO `tbl_banners` VALUES ('7',NULL,'143055019953.gif',NULL,'600','40','AFFILIATE','0','0','0','2015-05-02 11:33:19','0','2017-06-09 05:24:22','2017-06-06 00:00:00');
INSERT INTO `tbl_banners` VALUES ('8',NULL,'1430556173352.gif',NULL,'120','300','AFFILIATE','0','0','0','2015-05-02 13:12:53','0','2017-06-09 05:24:22','2017-06-06 00:00:00');
INSERT INTO `tbl_banners` VALUES ('9',NULL,'14305673601282.gif',NULL,'300','300','AFFILIATE','0','0','0','2015-05-02 16:19:20','0','2017-06-09 05:24:22','2017-06-06 00:00:00');
INSERT INTO `tbl_banners` VALUES ('10','طراحی سایت کدیزاین','1635369348.jpg','http://kodesign.ir','1300','400','SLIDER','0','0','0','2021-10-28 00:46:50','0','2017-11-22 00:46:50','2017-12-01 00:46:50');
INSERT INTO `tbl_banners` VALUES ('11','طراحی سایت نیازمندی ها','1635369372.jpg','http://kodesign.ir','1300','400','SLIDER','0','0','0','2021-10-28 00:47:08','0','2017-06-18 00:47:08','2017-06-18 00:47:08');
INSERT INTO `tbl_banners` VALUES ('18','تبلیغات خود را اینجا قرار دهید','1635424806.jpg','http://kodesign.ir','1200','80','CONTENT','0','0','0','2021-10-28 16:10:06','0','2021-04-02 16:10:06','2021-04-02 16:10:06');
INSERT INTO `tbl_banners` VALUES ('24','جدید','1634064829.jpg','http://kodesign.ir','1300','400','APP-SLIDER','0','0','0','2021-10-12 22:23:49','0','2021-10-12 22:23:49','2021-10-12 22:23:49');
INSERT INTO `tbl_banners` VALUES ('25','','1634064979.jpg','','1300','400','APP-SLIDER','0','0','0','2021-10-12 22:26:19','0','2021-10-12 22:26:19','2021-10-12 22:26:19');
INSERT INTO `tbl_banners` VALUES ('27','اسکریپت نیازمندی های کدیزاین','1635422588.jpg','http://classified.kodesign.ir','260','260','SIDEBAR','0','0','0','2021-10-28 15:34:55','0','2021-10-28 15:34:55','2021-10-28 15:34:55');
INSERT INTO `tbl_banners` VALUES ('28','اسکریپت املاک کدیزاین','1635423404.jpg','http://classified.kodesign.ir/real-estate/','260','260','SIDEBAR','0','0','0','2021-10-28 15:46:44','0','2021-10-28 15:46:44','2021-10-28 15:46:44');
INSERT INTO `tbl_banners` VALUES ('31','آگهی های خودرو','1638295081.jpg','http://localhost/php/niazmandi/version9/category/2/%D9%88%D8%B3%D8%A7%DB%8C%D9%84-%D9%86%D9%82%D9%84%DB%8C%D9%87','1300','400','SLIDER','2','0','0','2021-11-30 21:32:57','0','2021-11-30 21:32:57','2021-11-30 21:32:57');
INSERT INTO `tbl_banners` VALUES ('33','خرید و فروش املاک','1638296019.jpg','','260','500','SIDEBAR','1','0','0','2021-11-30 21:45:32','0','2021-11-30 21:45:32','2021-11-30 21:45:32');
INSERT INTO `tbl_banners` VALUES ('35','','1638296526.jpg','','260','550','SIDEBAR','2','0','0','2021-11-30 21:52:06','0','2021-11-30 21:52:06','2021-11-30 21:52:06');
INSERT INTO `tbl_banners` VALUES ('37','','1638297138.jpg','','260','258','SIDEBAR','10','0','0','2021-11-30 22:06:57','0','2021-11-30 22:06:57','2021-11-30 22:06:57');
INSERT INTO `tbl_banners` VALUES ('38','','1638297345.jpg','','260','380','SIDEBAR','9','0','0','2021-11-30 22:06:32','0','2021-11-30 22:06:32','2021-11-30 22:06:32');
INSERT INTO `tbl_banners` VALUES ('39','','1638297542.jpg','','260','380','SIDEBAR','5','0','0','2021-11-30 22:09:02','0','2021-11-30 22:09:02','2021-11-30 22:09:02');
INSERT INTO `tbl_banners` VALUES ('40','','1638297636.jpg','','260','380','SIDEBAR','7','0','0','2021-11-30 22:10:36','0','2021-11-30 22:10:36','2021-11-30 22:10:36');
INSERT INTO `tbl_banners` VALUES ('41','','1638297843.jpg','','260','380','SIDEBAR','3','0','0','2021-11-30 22:14:03','0','2021-11-30 22:14:03','2021-11-30 22:14:03');
INSERT INTO `tbl_banners` VALUES ('42','','1638297862.jpg','','260','380','SIDEBAR','4','0','0','2021-11-30 22:14:22','0','2021-11-30 22:14:22','2021-11-30 22:14:22');
INSERT INTO `tbl_banners` VALUES ('43','','1638297970.jpg','','260','380','SIDEBAR','6','0','0','2021-11-30 22:16:10','0','2021-11-30 22:16:10','2021-11-30 22:16:10');
INSERT INTO `tbl_banners` VALUES ('44','','1638298133.jpg','','260','380','SIDEBAR','8','0','0','2021-11-30 22:18:53','0','2021-11-30 22:18:53','2021-11-30 22:18:53');
UNLOCK TABLES;

-- Table structure for table `tbl_callouts`

DROP TABLE IF EXISTS `tbl_callouts`;
CREATE TABLE `tbl_callouts` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `callout_id` int NOT NULL,
  `read_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM DEFAULT CHARSET=utf8mb3;

-- Dumping data for table `tbl_callouts`

LOCK TABLES `tbl_callouts` WRITE;
UNLOCK TABLES;

-- Table structure for table `tbl_categories`

DROP TABLE IF EXISTS `tbl_categories`;
CREATE TABLE `tbl_categories` (
  `ID` int NOT NULL AUTO_INCREMENT,
  `CATEGORY_NAME` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_persian_ci NOT NULL,
  `CATEGORY_SLUG` varchar(255) NOT NULL,
  `COLOR` varchar(20) DEFAULT NULL,
  `ICON` varchar(50) DEFAULT NULL,
  `ICON_APP` varchar(50) DEFAULT NULL,
  `image` text,
  `rang` smallint NOT NULL,
  `parent_id` smallint NOT NULL DEFAULT '0',
  `PARENT` varchar(1) DEFAULT NULL,
  `CATEGORY_DESCRIPTION` text,
  `CATEGORY_KEYWORDS` text,
  `CATEGORY_EXTRA_DESCRIPTION` text,
  `enable` tinyint(1) NOT NULL DEFAULT '1',
  `CATEGORY_SEO_TITLE` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`ID`)
) ENGINE=InnoDB AUTO_INCREMENT=12 DEFAULT CHARSET=utf8mb3;

-- Dumping data for table `tbl_categories`

LOCK TABLES `tbl_categories` WRITE;
INSERT INTO `tbl_categories` VALUES ('1','املاک','املاک','E74D3C','fa-home','home','6066a56407c1a1617339744.png','1','0',NULL,'','','<p>آگهی های خرید و فروش املاک با قیمت های مناسب و اطلاعات بنگاه های معاملات ملکی را مشاهده کنید. قیمت خرید و فروش ملک و قیمت اجاره بهای آپارتمان را بررسی کنید و اطلاعات خریداران و فروشندگان خود را پیدا کنید.</p>\r\n','1','خرید و فروش املاک و آپارتمان در سراسر کشور');
INSERT INTO `tbl_categories` VALUES ('2','وسایل نقلیه','وسایل-نقلیه','F1C40F','fa fa-car','carSport',NULL,'2','0',NULL,'','','<p>آگهی های خرید و فروش ماشین و موتورسیکلت&nbsp;با قیمت های مناسب&nbsp;و اطلاعات مراکز بنگاهی معاملات خودرو، لوازم یدکی،&nbsp;تجهیزات و مراکز تزییناتی&nbsp;ماشین، محصولاتی مصرفی خودرو &nbsp;خود را از&nbsp;<em>نیازمندی های بازار</em>&nbsp;پیدا کنید.</p>\r\n','1','');
INSERT INTO `tbl_categories` VALUES ('3','استخدام و کاریابی','استخدام-و-کاریابی','BECD4A','fa-globe','idCard',NULL,'3','0',NULL,'','','<p>تمامی آگهی های مربوط به استخدام و کاریابی را اینجا مشاهده کنید. برای آینده خود برنامهخ ریزی کنید و بروزترین آگهی های مربوط به استخدام را مشاهده کنید</p>\r\n','1','');
INSERT INTO `tbl_categories` VALUES ('4','مربوط به خانه','مربوط-به-خانه','31BF31','fa-hotel','cart',NULL,'6','0',NULL,'','','<p>آگهی های خرید و فروش لوازم خانگی و کالاهای مصرفی&nbsp;با قیمت های مناسب&nbsp;و اطلاعات مراکز تولیدی و پخش ظروف، شوینده و کالای مختلف،&nbsp;تجهیزات دیجیتال و سرگرمی&nbsp;خود را اینجا&nbsp;پیدا کنید.</p>\r\n','1','');
INSERT INTO `tbl_categories` VALUES ('5','خدمات','خدمات','0078C1','fa-cogs','cog',NULL,'4','0',NULL,'','','<p>آگهی های ارائه دهندگان خدمات مختلف&nbsp;با قیمت های مناسب&nbsp;و اطلاعات مراکز خدماتی تعمیرات، خدمات تاسیسات، خدمات اجتماعی، مسافرت، سرگرمی، خدمات تبلیغاتی و جشن و مجموعه های آموزشی&nbsp;و بهداشتی را در این قسمت پیدا کنید</p>\r\n','1','');
INSERT INTO `tbl_categories` VALUES ('6','وسایل شخصی','وسایل-شخصی','14B8CF','fa-child','happy',NULL,'7','0',NULL,'','','<h3>آگهی خرید و فروش محصولات آرایشی، محصولات زیبایی&nbsp;با قیمت های مناسب&nbsp;و اطلاعات مراکز فروش و تامین کنندگان تجهیزات سالن های زیبایی و آرایشگاهی خود را از&nbsp;<em>اینجا</em>&nbsp;پیدا کنید.</h3>\r\n','1','');
INSERT INTO `tbl_categories` VALUES ('7','لوازم الکترونیکی','لوازم-الکترونیکی','7BA48A','fa-tv-retro','tv',NULL,'5','0',NULL,'','','<p>آگهی های خرید و فروش کالای برقی و الکترونیک&nbsp;با قیمت های مناسب&nbsp;و اطلاعات مراکز تامین و تولید سیستم های کنترل برق، کلید و فیوز، فروشندگان کابل و سیم، انواع لامپ و پروژکتور و&nbsp;تجهیزات جانبی برقی&nbsp;خود را اینجا&nbsp;پیدا کنید.</p>\r\n','1','');
INSERT INTO `tbl_categories` VALUES ('8','سرگرمی و فراغت','سرگرمی-و-فراغت','FF9900','fa-dice','gameController','1497789991.png','9','0',NULL,'','','<p>خرید و فروش وسایل مربوط به سرگرمی، اسباب بازی، بلیط کنسرت و هرچیزی که به سرگرمی و اوقات فراغت خود و خانواده تان مربوط می شود را در این قسمت پیدا کنید</p>\r\n','1','');
INSERT INTO `tbl_categories` VALUES ('9','اجتماعی','اجتماعی','7D3E2C','fa-users','peopleCircle',NULL,'10','0',NULL,'','','','1','');
INSERT INTO `tbl_categories` VALUES ('10','برای کسب و کار','برای-کسب-و-کار','9C59B6','fa-briefcase','briefcase',NULL,'8','0',NULL,'','','<h3>آگهی های&nbsp;کسب و کارهای مختلف را ببینید و با مشاغل بزرگ و کوچک خدماتی، اجتماعی و بازرگانی آشنا شوید.&nbsp;&nbsp;با قیمت های مناسب از خدمات مختلف استفاده کنید. اطلاعات بهترین کسب و کارها&nbsp;را پیدا کنید.</h3>\r\n\r\n<p>&nbsp;</p>\r\n\r\n<p><strong>اهمیت تبلیغات در توسعه کسب و کار</strong></p>\r\n\r\n<p>هر فردی می داند که موثرترین راه برای توسعه دادن به کسب و کار، تبلیغات است.&nbsp;اما بهتر است بدانید تنها تبلیغاتی می تواند در جذب مشتری، بیشترین اثر بخشی را داشته باشند که شفاف باشد و به دور از هر گونه بزرگنمایی با صداقت کالا و یا خدمات را معرفی کند. این نکته را نیز به یاد داشته باشید که تبلیغات درست و اصولی باید صورت بگیرد و بهتر است تبلیغات مداوم داشته باشید حتی اگر سرشناس شدید. و محصولات و خدماتتان را به مخاطبان خود&nbsp;معرفی کنید.</p>\r\n\r\n<p>&nbsp;</p>\r\n','1','');
UNLOCK TABLES;

-- Table structure for table `tbl_cities`

DROP TABLE IF EXISTS `tbl_cities`;
CREATE TABLE `tbl_cities` (
  `ID` int NOT NULL AUTO_INCREMENT,
  `CITY_NAME` varchar(255) NOT NULL,
  `SLUG` varchar(255) DEFAULT NULL,
  `STATE_ID` int NOT NULL,
  `latitude` varchar(200) DEFAULT NULL,
  `longitude` varchar(200) DEFAULT NULL,
  PRIMARY KEY (`ID`)
) ENGINE=InnoDB AUTO_INCREMENT=1365 DEFAULT CHARSET=utf8mb3;

-- Dumping data for table `tbl_cities`

LOCK TABLES `tbl_cities` WRITE;
INSERT INTO `tbl_cities` VALUES ('21','آبش احمد','آبش-احمد','1','39.0484318','47.31599440000002');
INSERT INTO `tbl_cities` VALUES ('22','آذرشهر','آذرشهر','1','37.7443158','45.9872077');
INSERT INTO `tbl_cities` VALUES ('23','اسکو','اسکو','1','37.9152298','46.11990059999994');
INSERT INTO `tbl_cities` VALUES ('24','آقکند','آقکند','1','37.2568415','48.06479569999999');
INSERT INTO `tbl_cities` VALUES ('25','اهر','اهر','1','38.4894305','47.06835750000005');
INSERT INTO `tbl_cities` VALUES ('26','ایلخچی','ایلخچی','1','37.9458657','45.97192849999999');
INSERT INTO `tbl_cities` VALUES ('27','باسمنج','باسمنج','1','38.0114006','46.45010100000002');
INSERT INTO `tbl_cities` VALUES ('28','بخشایش','بخشایش','1','38.1308482','46.94696369999997');
INSERT INTO `tbl_cities` VALUES ('29','بستان‌ آباد','بستان','1','37.8431059','46.83035040000004');
INSERT INTO `tbl_cities` VALUES ('30','بناب','بناب','1','37.3445959','46.0564799');
INSERT INTO `tbl_cities` VALUES ('31','تبریز','تبریز','1','38.096239','46.27380130000006');
INSERT INTO `tbl_cities` VALUES ('34','تسوج','تسوج','1','38.31830650000001','45.35008740000001');
INSERT INTO `tbl_cities` VALUES ('35','تیکمه داش','تیکمه-داش','1','37.72577929999999','46.937555299999985');
INSERT INTO `tbl_cities` VALUES ('36','جلفا','جلفا','1','38.8055029','45.809125199999926');
INSERT INTO `tbl_cities` VALUES ('37','خاروانا','خاروانا','1','38.68424599999999','46.16997409999999');
INSERT INTO `tbl_cities` VALUES ('38','خامنه','خامنه','1','38.19039219999999','45.638289999999984');
INSERT INTO `tbl_cities` VALUES ('39','خراجو','خراجو','1','37.3104319','46.52967279999996');
INSERT INTO `tbl_cities` VALUES ('40','خسروشهر','خسروشهر','1','37.96417840000001','46.05170499999997');
INSERT INTO `tbl_cities` VALUES ('41','خمارلو','خمارلو','1','39.1578805','47.03129469999999');
INSERT INTO `tbl_cities` VALUES ('42','خواجه','خواجه','1','38.1552064','46.58439550000003');
INSERT INTO `tbl_cities` VALUES ('43','دوزدوزان','دوزدوزان','1','37.9494615','47.117399999999975');
INSERT INTO `tbl_cities` VALUES ('44','زرنق','زرنق','1','38.0926256','47.0820526');
INSERT INTO `tbl_cities` VALUES ('45','زنوز','زنوز','1','38.58989400000001','45.830320099999994');
INSERT INTO `tbl_cities` VALUES ('46','سراب','سراب','1','38.58989400000001','45.830320099999994');
INSERT INTO `tbl_cities` VALUES ('47','سردرود','سردرود','1','38.025523','46.15252899999996');
INSERT INTO `tbl_cities` VALUES ('48','سیس','سیس','1','38.1961492','45.817911200000026');
INSERT INTO `tbl_cities` VALUES ('49','سیه رود','سیه-رود','1','38.87022','46.00276120000001');
INSERT INTO `tbl_cities` VALUES ('50','شبستر','شبستر','1','38.18015750000001','45.70793600000002');
INSERT INTO `tbl_cities` VALUES ('51','شربیان','شربیان','1','37.88139170000001','47.09926150000001');
INSERT INTO `tbl_cities` VALUES ('52','شرفخانه','شرفخانه','1','38.1816764','45.48859570000002');
INSERT INTO `tbl_cities` VALUES ('53','شندآباد','شندآباد','1','38.1444589','45.627658699999984');
INSERT INTO `tbl_cities` VALUES ('54','صوفیان','صوفیان','1','38.2793615','45.98435040000004');
INSERT INTO `tbl_cities` VALUES ('55','عجب شیر','عجب-شیر','1','37.4788324','45.89292739999996');
INSERT INTO `tbl_cities` VALUES ('56','قره آغاج','قره-آغاج','1','37.1286824','46.97585579999998');
INSERT INTO `tbl_cities` VALUES ('57','کشک سرای','کشک-سرای','1','38.463463','45.567012100000056');
INSERT INTO `tbl_cities` VALUES ('58','کلوانق','کلوانق','1','38.1019233','46.99543070000004');
INSERT INTO `tbl_cities` VALUES ('59','کلیبر','کلیبر','1','38.864241','47.04053799999997');
INSERT INTO `tbl_cities` VALUES ('60','کوزه کنان','کوزه-کنان','1','38.1895128','45.57883770000001');
INSERT INTO `tbl_cities` VALUES ('61','گوگان','گوگان','1','37.7810379','45.908996900000034');
INSERT INTO `tbl_cities` VALUES ('62','لیلان','لیلان','1','37.0118254','46.203776800000014');
INSERT INTO `tbl_cities` VALUES ('63','مراغه','مراغه','1','37.38919659999999','46.25338820000002');
INSERT INTO `tbl_cities` VALUES ('64','مرند','مرند','1','38.4277623','45.76208099999997');
INSERT INTO `tbl_cities` VALUES ('65','ملکان','ملکان','1','37.14287880000001','46.104271100000005');
INSERT INTO `tbl_cities` VALUES ('66','ممقان','ممقان','1','37.8304404','45.98915199999999');
INSERT INTO `tbl_cities` VALUES ('67','مهربان','مهربان','1','38.0841098','47.13386390000005');
INSERT INTO `tbl_cities` VALUES ('68','میانه','میانه','1','37.4264344','47.724111300000004');
INSERT INTO `tbl_cities` VALUES ('69','وایقان','وایقان','1','38.12687','45.712054999999964');
INSERT INTO `tbl_cities` VALUES ('70','ورزقان','ورزقان','1','38.59725159999999','46.61051220000002');
INSERT INTO `tbl_cities` VALUES ('71','هادی شهر','هادی-شهر','1','38.82648','45.6678508');
INSERT INTO `tbl_cities` VALUES ('72','هریس','هریس','1','38.2468667','47.116845900000044');
INSERT INTO `tbl_cities` VALUES ('73','هشترود','هشترود','1','37.4757815','47.05046649999997');
INSERT INTO `tbl_cities` VALUES ('74','هوراند','هوراند','1','38.9515621','47.364411399999995');
INSERT INTO `tbl_cities` VALUES ('75','یامچی','یامچی','1','38.9515621','47.364411399999995');
INSERT INTO `tbl_cities` VALUES ('76','ارومیه','ارومیه','2','37.54980609999999','45.078628200000026');
INSERT INTO `tbl_cities` VALUES ('77','خوی','خوی','2','38.5534106','44.93966230000001');
INSERT INTO `tbl_cities` VALUES ('78','بوکان','بوکان','2','36.51869600000001','46.209431600000016');
INSERT INTO `tbl_cities` VALUES ('79','مهاباد','مهاباد','2','36.7683527','45.73370909999994');
INSERT INTO `tbl_cities` VALUES ('80','میاندوآب','میاندوآب','2','36.9594997','46.10537820000002');
INSERT INTO `tbl_cities` VALUES ('81','سلماس','سلماس','2','38.2021406','44.770550999999955');
INSERT INTO `tbl_cities` VALUES ('82','نقده','نقده','2','36.956333','45.387834800000064');
INSERT INTO `tbl_cities` VALUES ('83','پیرانشهر','پیرانشهر','2','36.6950261','45.14456949999999');
INSERT INTO `tbl_cities` VALUES ('84','تکاب','تکاب','2','36.4051945','47.115609199999994');
INSERT INTO `tbl_cities` VALUES ('85','ماکو','ماکو','2','39.2956209','44.51418509999996');
INSERT INTO `tbl_cities` VALUES ('86','سردشت','سردشت','2','36.158405','45.47598979999998');
INSERT INTO `tbl_cities` VALUES ('87','شاهین‌دژ','شاهین','2','36.6740953','46.57013299999994');
INSERT INTO `tbl_cities` VALUES ('88','اشنویه','اشنویه','2','37.0364358','45.09713720000002');
INSERT INTO `tbl_cities` VALUES ('89','قره ضیاالدین','قره-ضیاالدین','2','38.8884333','45.03040009999995');
INSERT INTO `tbl_cities` VALUES ('90','شوط','شوط','2','39.2165612','44.765185299999985');
INSERT INTO `tbl_cities` VALUES ('91','سیه‌چشمه','سیه','2','39.0649837','44.384467900000004');
INSERT INTO `tbl_cities` VALUES ('92','ربط','ربط','2','36.210185','45.54803979999997');
INSERT INTO `tbl_cities` VALUES ('93','پلدشت','پلدشت','2','39.3471366','45.0665583');
INSERT INTO `tbl_cities` VALUES ('94','بازرگان','بازرگان','2','39.3902118','44.39014339999994');
INSERT INTO `tbl_cities` VALUES ('95','تازه‌شهر','تازه','2','38.17523800000001','44.69093269999996');
INSERT INTO `tbl_cities` VALUES ('96','فیرورق','فیرورق','2','38.5729281','44.85914930000001');
INSERT INTO `tbl_cities` VALUES ('97','چهاربرج','چهاربرج','2','37.1222553','45.97325969999997');
INSERT INTO `tbl_cities` VALUES ('98','محمدیار','محمدیار','2','36.9836119','45.51905179999994');
INSERT INTO `tbl_cities` VALUES ('99','دیزج دیز','دیزج-دیز','2','38.46043659999999','45.02007000000003');
INSERT INTO `tbl_cities` VALUES ('100','نوشین‌شهر','نوشین','2','37.73081189999999','45.054280999999946');
INSERT INTO `tbl_cities` VALUES ('101','محمودآباد','محمودآباد','2','36.72145380000001','46.504346199999986');
INSERT INTO `tbl_cities` VALUES ('102','میرآباد','میرآباد','2','36.4071252','45.37100910000004');
INSERT INTO `tbl_cities` VALUES ('103','قطور','قطور','2','38.47307109999999','44.40776970000002');
INSERT INTO `tbl_cities` VALUES ('104','باروق','باروق','2','36.9542037','46.31851889999996');
INSERT INTO `tbl_cities` VALUES ('105','کشاورز','کشاورز','2','36.8350198','46.35842530000002');
INSERT INTO `tbl_cities` VALUES ('106','ایواوغلی','ایواوغلی','2','38.7116377','45.206898499999966');
INSERT INTO `tbl_cities` VALUES ('107','نالوس','نالوس','2','36.98271','45.143101');
INSERT INTO `tbl_cities` VALUES ('108','نازک علیا','نازک-علیا','2','39.0124487','45.05589110000005');
INSERT INTO `tbl_cities` VALUES ('109','قوشچی','قوشچی','2','37.9898232','45.034747400000015');
INSERT INTO `tbl_cities` VALUES ('110','مرگنلر','مرگنلر','2','39.15191919999999','44.95412550000003');
INSERT INTO `tbl_cities` VALUES ('111','گردکشانه','گردکشانه','2','36.8086439','45.26495');
INSERT INTO `tbl_cities` VALUES ('112','سرو','سرو','2','37.72219800000001','44.65613899999994');
INSERT INTO `tbl_cities` VALUES ('113','آواجیق','آواجیق','2','39.3355116','44.15662539999994');
INSERT INTO `tbl_cities` VALUES ('114','سیلوانه','سیلوانه','2','37.4217619','44.855453200000056');
INSERT INTO `tbl_cities` VALUES ('115','زرآباد','زرآباد','2','38.8027494','44.58534439999994');
INSERT INTO `tbl_cities` VALUES ('116','سیمینه','سیمینه','2','36.9244041','46.11673810000002');
INSERT INTO `tbl_cities` VALUES ('117','خلیفان','خلیفان','2','36.5073682','45.79649930000005');
INSERT INTO `tbl_cities` VALUES ('120','آبی بیگلو','آبی-بیگلو','3','38.28479409999999','48.55206020000003');
INSERT INTO `tbl_cities` VALUES ('121','اردبیل','اردبیل','3','38.25373629999999','48.29999010000006');
INSERT INTO `tbl_cities` VALUES ('122','اصلاندوز','اصلاندوز','3','39.441547','47.4111795');
INSERT INTO `tbl_cities` VALUES ('123','بیله سوار','بیله-سوار','3','39.3822864','48.350172499999985');
INSERT INTO `tbl_cities` VALUES ('124','پارس آباد','پارس-آباد','3','39.6207779','47.90506149999999');
INSERT INTO `tbl_cities` VALUES ('125','تازه کند انگوت','تازه-کند-انگوت','3','39.0433379','47.742631099999926');
INSERT INTO `tbl_cities` VALUES ('126','جعفرآباد','جعفرآباد','3','39.4371135','48.098028699999986');
INSERT INTO `tbl_cities` VALUES ('127','خلخال','خلخال','3','37.6205429','48.53302180000003');
INSERT INTO `tbl_cities` VALUES ('128','رضی','رضی','3','38.6256021','48.09163609999996');
INSERT INTO `tbl_cities` VALUES ('129','سرعین','سرعین','3','38.14308329999999','48.06776209999998');
INSERT INTO `tbl_cities` VALUES ('130','عنبران','عنبران','3','38.4899016','48.433271500000046');
INSERT INTO `tbl_cities` VALUES ('131','کلور','کلور','3','37.3936989','48.729981599999974');
INSERT INTO `tbl_cities` VALUES ('132','گرمی','گرمی','3','39.0372267','47.92770210000003');
INSERT INTO `tbl_cities` VALUES ('133','گیوی','گیوی','5','37.6854422','48.34126390000006');
INSERT INTO `tbl_cities` VALUES ('134','لاهرود','لاهرود','3','38.50695949999999','47.829799800000046');
INSERT INTO `tbl_cities` VALUES ('135','مشگین شهر','مشگین-شهر','3','38.39482899999999','47.66484869999999');
INSERT INTO `tbl_cities` VALUES ('136','نمین','نمین','3','38.4244545','48.47824190000006');
INSERT INTO `tbl_cities` VALUES ('137','نیر','نیر','3','38.033837','48.01046889999998');
INSERT INTO `tbl_cities` VALUES ('138','هشتجین','هشتجین','3','37.3724381','48.322327900000005');
INSERT INTO `tbl_cities` VALUES ('139','هیر','هیر','3','38.079731','48.506628999999975');
INSERT INTO `tbl_cities` VALUES ('140','ابریشم','ابریشم','4','32.5669677','51.57285389999993');
INSERT INTO `tbl_cities` VALUES ('141','ابوزیدآباد','ابوزیدآباد','4','33.9005432','51.76252099999999');
INSERT INTO `tbl_cities` VALUES ('142',' آران و بیدگل','آران-و-بیدگل','4','34.1665545','51.85227299999997');
INSERT INTO `tbl_cities` VALUES ('143','اردستان','اردستان','4','33.3839078','52.37730669999996');
INSERT INTO `tbl_cities` VALUES ('144','اژیه','اژیه','4','32.4395232','52.379968599999984');
INSERT INTO `tbl_cities` VALUES ('145','اصفهان','اصفهان','4','35.6891975','51.388973599999986');
INSERT INTO `tbl_cities` VALUES ('146','افوس','افوس','4','33.02303759999999','50.093242799999985');
INSERT INTO `tbl_cities` VALUES ('147','انارک','انارک','4','33.3045352','53.696250700000064');
INSERT INTO `tbl_cities` VALUES ('148','ایمان شهر','ایمان-شهر','4','32.4765469','51.47559609999996');
INSERT INTO `tbl_cities` VALUES ('149','بادرود','بادرود','4','33.6912391','52.0083022');
INSERT INTO `tbl_cities` VALUES ('150','باغ بهادران','باغ-بهادران','4','32.3788386','51.19252970000002');
INSERT INTO `tbl_cities` VALUES ('151','برزک','برزک','4','33.7922463','51.229154300000005');
INSERT INTO `tbl_cities` VALUES ('152','برف انبار','برف-انبار','4','33.000719','50.19612089999998');
INSERT INTO `tbl_cities` VALUES ('153','بهاران شهر','بهاران-شهر','4','32.6510998','51.72493989999998');
INSERT INTO `tbl_cities` VALUES ('154','بهارستان','بهارستان','4','32.4969312','51.77250419999996');
INSERT INTO `tbl_cities` VALUES ('155','بوئین و میاندشت','بویین-و-میاندشت','4','33.0687645','50.1665256');
INSERT INTO `tbl_cities` VALUES ('156','پیربکران','پیربکران','4','32.4688013','51.557704400000034');
INSERT INTO `tbl_cities` VALUES ('157','تودشک','تودشک','4','32.7224032','52.66269579999994');
INSERT INTO `tbl_cities` VALUES ('158','تیران','تیران','4','32.7014728','51.15592590000006');
INSERT INTO `tbl_cities` VALUES ('159','جندق','جندق','4','34.0416675','54.4150654');
INSERT INTO `tbl_cities` VALUES ('160','جوشقان و کامو','جوشقان-و-کامو','4','33.5653577','51.20037609999997');
INSERT INTO `tbl_cities` VALUES ('161','چادگان','چادگان','4','32.7826434','50.606776800000034');
INSERT INTO `tbl_cities` VALUES ('162','چرمهین','چرمهین','4','32.3388876','51.1950918');
INSERT INTO `tbl_cities` VALUES ('163','چم گردان','چم-گردان','4','32.3935535','51.33915179999997');
INSERT INTO `tbl_cities` VALUES ('164','حبیب آباد','حبیب-آباد','4','32.5133979','51.532750599999986');
INSERT INTO `tbl_cities` VALUES ('165','حسن آباد','حسن-آباد','4','32.14154440000001','52.622618500000044');
INSERT INTO `tbl_cities` VALUES ('166','حنا','حنا','4','31.1970468','51.724280799999974');
INSERT INTO `tbl_cities` VALUES ('167','خمینی شهر','خمینی-شهر','4','32.69326','51.53603680000003');
INSERT INTO `tbl_cities` VALUES ('168','خوانسار','خوانسار','4','33.2811677','50.31722489999993');
INSERT INTO `tbl_cities` VALUES ('169','خور','خور','4','33.7757611','55.08793379999997');
INSERT INTO `tbl_cities` VALUES ('170','خوراسگان','خوراسگان','4','32.644678','51.76252099999999');
INSERT INTO `tbl_cities` VALUES ('171','خورزوق','خورزوق','4','32.776403','51.64654919999998');
INSERT INTO `tbl_cities` VALUES ('172','داران','داران','4','32.9943312','50.4113423');
INSERT INTO `tbl_cities` VALUES ('173','دامنه','دامنه','4','33.01723630000001','50.490276300000005');
INSERT INTO `tbl_cities` VALUES ('174','درچه پیاز','درچه-پیاز','4','32.6108914','51.55444280000006');
INSERT INTO `tbl_cities` VALUES ('175','دستگرد','دستگرد','4','32.7998782','51.664985799999954');
INSERT INTO `tbl_cities` VALUES ('176','دهاقان','دهاقان','4','31.93676080000001','51.65445');
INSERT INTO `tbl_cities` VALUES ('177','دهق','دهق','4','33.10773249999999','50.95497580000006');
INSERT INTO `tbl_cities` VALUES ('178','دولت آباد','دولت-آباد','4','32.804988','51.69923870000002');
INSERT INTO `tbl_cities` VALUES ('179','دیزیچه','دیزیچه','4','32.4102104','51.5255214');
INSERT INTO `tbl_cities` VALUES ('180','رزوه','رزوه','4','32.83645979999999','50.56921390000002');
INSERT INTO `tbl_cities` VALUES ('181','رضوان شهر','رضوان-شهر','4','32.665563','51.06450700000005');
INSERT INTO `tbl_cities` VALUES ('182','زاینده رود','زاینده-رود','4','32.3895751','51.26841779999995');
INSERT INTO `tbl_cities` VALUES ('183','زرین شهر','زرین-شهر','4','32.4033247','51.399467200000004');
INSERT INTO `tbl_cities` VALUES ('184','زواره','زواره','4','33.4471283','52.48119329999997');
INSERT INTO `tbl_cities` VALUES ('185','زیباشهر','زیباشهر','4','32.38968500000001','51.56233259999999');
INSERT INTO `tbl_cities` VALUES ('186','سده لنجان','سده-لنجان','4','32.3734223','51.32342649999998');
INSERT INTO `tbl_cities` VALUES ('187','سفیدشهر','سفیدشهر','4','34.1234669','51.35488090000001');
INSERT INTO `tbl_cities` VALUES ('188','سگزی','سگزی','4','32.690865','52.09572890000004');
INSERT INTO `tbl_cities` VALUES ('189','سمیرم','سمیرم','4','31.41513660000001','51.568327400000044');
INSERT INTO `tbl_cities` VALUES ('190','شاهین شهر','شاهین-شهر','4','32.8796692','51.546553899999935');
INSERT INTO `tbl_cities` VALUES ('191','شهرضا','شهرضا','4','32.0081068','51.862839899999926');
INSERT INTO `tbl_cities` VALUES ('192','طالخونچه','طالخونچه','4','32.2306606','51.53603680000003');
INSERT INTO `tbl_cities` VALUES ('193','عسگران','عسگران','4','32.865681','50.8521356');
INSERT INTO `tbl_cities` VALUES ('194','علویجه','علویجه','4','33.0548126','51.06972740000003');
INSERT INTO `tbl_cities` VALUES ('195','فریدون شهر','فریدون-شهر','4','32.9401173','50.12408800000003');
INSERT INTO `tbl_cities` VALUES ('196','فلاورجان','فلاورجان','4','32.4890303','51.55707259999997');
INSERT INTO `tbl_cities` VALUES ('197','فولادشهر','فولادشهر','4','32.4803441','51.399467200000004');
INSERT INTO `tbl_cities` VALUES ('198','قمصر','قمصر','4','33.7484994','51.42570860000001');
INSERT INTO `tbl_cities` VALUES ('199','قهدریجان','قهدریجان','4','32.5725079','51.44145849999995');
INSERT INTO `tbl_cities` VALUES ('200','کاشان','کاشان','4','33.9850358','51.409962500000006');
INSERT INTO `tbl_cities` VALUES ('201','کرکوند','کرکوند','4','32.34401640000001','51.445396500000015');
INSERT INTO `tbl_cities` VALUES ('202','کلیشاد و سودرجان','کلیشاد-و-سودرجان','4','32.55181509999999','51.53077889999997');
INSERT INTO `tbl_cities` VALUES ('203','کمشجه','کمشجه','4','32.90587539999999','51.8126618');
INSERT INTO `tbl_cities` VALUES ('204','کمه','کمه','4','31.06168089999999','51.59521700000005');
INSERT INTO `tbl_cities` VALUES ('205','کهریزسنگ','کهریزسنگ','4','32.6290883','51.478222800000026');
INSERT INTO `tbl_cities` VALUES ('206','کوشک','کوشک','4','32.6400378','51.50186789999998');
INSERT INTO `tbl_cities` VALUES ('207','کوهپایه','کوهپایه','4','32.701805','52.4572058');
INSERT INTO `tbl_cities` VALUES ('208','گز','گز','4','32.8131036','51.61495549999995');
INSERT INTO `tbl_cities` VALUES ('209','گلپایگان','گلپایگان','4','33.4572358','50.27081629999998');
INSERT INTO `tbl_cities` VALUES ('210','گل دشت','گل-دشت','4','32.6273077','51.44670929999995');
INSERT INTO `tbl_cities` VALUES ('211','گل شهر','گل-شهر','4','33.5050303','50.46441690000006');
INSERT INTO `tbl_cities` VALUES ('212','گوگد','گوگد','4','33.4779193','50.35592559999998');
INSERT INTO `tbl_cities` VALUES ('213','مبارکه','مبارکه','4','32.3477273','51.4992403');
INSERT INTO `tbl_cities` VALUES ('214','محمدآباد','محمدآباد','4','32.3193189','52.10262890000001');
INSERT INTO `tbl_cities` VALUES ('215','منظریه','منظریه','4','31.948567','51.86944500000004');
INSERT INTO `tbl_cities` VALUES ('216','مهاباد','مهاباد-1','4','33.5276705','52.22043819999999');
INSERT INTO `tbl_cities` VALUES ('218','میمه','میمه','4','33.4476373','51.171610699999974');
INSERT INTO `tbl_cities` VALUES ('219','نائین','نایین','4','32.8599445','53.087832100000014');
INSERT INTO `tbl_cities` VALUES ('220','نجف آباد','نجف-آباد','4','32.6324231','51.36799139999994');
INSERT INTO `tbl_cities` VALUES ('221','نصرآباد','نصرآباد','4','32.64617750000001','51.61232340000004');
INSERT INTO `tbl_cities` VALUES ('222','نطنز','نطنز','4','33.5132762','51.913055299999996');
INSERT INTO `tbl_cities` VALUES ('223','نوش آباد','نوش-آباد','4','34.0787437','51.43883329999994');
INSERT INTO `tbl_cities` VALUES ('224','نیاسر','نیاسر','4','33.9797489','51.153312099999994');
INSERT INTO `tbl_cities` VALUES ('225','نیک آباد','نیک-آباد','4','32.3049946','52.19654020000007');
INSERT INTO `tbl_cities` VALUES ('226','ورزنه','ورزنه','4','32.4217402','52.649537399999986');
INSERT INTO `tbl_cities` VALUES ('227','ورنامخواست','ورنامخواست','4','32.355758','51.38110449999999');
INSERT INTO `tbl_cities` VALUES ('228','وزوان','وزوان','4','33.4181759','51.182069400000046');
INSERT INTO `tbl_cities` VALUES ('229','ونک','ونک','4','31.52486279999999','51.33666519999997');
INSERT INTO `tbl_cities` VALUES ('230','هرند','هرند','4','32.5585485','52.43589050000003');
INSERT INTO `tbl_cities` VALUES ('233','آسارا و شهرستانک','آسارا-و-شهرستانک','5','36.03753680000001','51.196452799999975');
INSERT INTO `tbl_cities` VALUES ('234','اشتهارد','اشتهارد','5','35.72438309999999','50.366179800000054');
INSERT INTO `tbl_cities` VALUES ('235','ساوجبلاغ','ساوجبلاغ','5','35.9617348','50.68320169999993');
INSERT INTO `tbl_cities` VALUES ('236','طالقان','طالقان','5','36.21498620000001','50.63788039999997');
INSERT INTO `tbl_cities` VALUES ('237','کرج','کرج','5','35.84001879999999','50.939090599999986');
INSERT INTO `tbl_cities` VALUES ('238','گرمدره','گرمدره','5','35.758327','51.06972740000003');
INSERT INTO `tbl_cities` VALUES ('239','مشکین دشت و ولدآباد','مشکین-دشت-و-ولدآباد','5','35.7500263','50.93934379999996');
INSERT INTO `tbl_cities` VALUES ('240','نظرآباد','نظرآباد','5','35.97256789999999','50.606776800000034');
INSERT INTO `tbl_cities` VALUES ('241','هشتگرد','هشتگرد','5','35.9846429','50.72835810000004');
INSERT INTO `tbl_cities` VALUES ('242','آبدانان','آبدانان','6','32.9886195','47.424531900000034');
INSERT INTO `tbl_cities` VALUES ('243','ارکواز','ارکواز','6','33.3924085','46.588517499999966');
INSERT INTO `tbl_cities` VALUES ('244','ایلام','ایلام','6','33.6349736','46.41528100000005');
INSERT INTO `tbl_cities` VALUES ('245','ایوان','ایوان','6','33.82979929999999','46.30731609999998');
INSERT INTO `tbl_cities` VALUES ('246','بدره','بدره','6','33.3045437','47.03641110000001');
INSERT INTO `tbl_cities` VALUES ('247','پهله','پهله','6','33.0106215','46.882225699999935');
INSERT INTO `tbl_cities` VALUES ('248','توحید','توحید','6','33.1465768','47.382205399999975');
INSERT INTO `tbl_cities` VALUES ('249','چوار','چوار','6','33.69596730000001','46.2989288');
INSERT INTO `tbl_cities` VALUES ('250','دره شهر','دره-شهر','6','33.1438988','47.38289520000001');
INSERT INTO `tbl_cities` VALUES ('251','دهلران','دهلران','6','32.6921969','47.26795549999997');
INSERT INTO `tbl_cities` VALUES ('252','زرنه','زرنه','6','33.92767920000001','46.18404750000002');
INSERT INTO `tbl_cities` VALUES ('253','سرابله','سرابله','6','33.7659639','46.569239100000004');
INSERT INTO `tbl_cities` VALUES ('254','صالح آباد','صالح-آباد','6','33.4665944','46.19241510000006');
INSERT INTO `tbl_cities` VALUES ('255','لومار','لومار','6','33.5679037','46.81196620000003');
INSERT INTO `tbl_cities` VALUES ('256','مهران','مهران','6','33.1176647','46.173291199999994');
INSERT INTO `tbl_cities` VALUES ('257','موسیان','موسیان','6','32.5187033','47.377998899999966');
INSERT INTO `tbl_cities` VALUES ('258','میمه','میمه-1','6','33.22778909999999','46.9186052');
INSERT INTO `tbl_cities` VALUES ('259','آب پخش','آب-پخش','7','29.3638203','51.06972740000003');
INSERT INTO `tbl_cities` VALUES ('260','آبدان','آبدان','7','28.0761099','51.77043549999996');
INSERT INTO `tbl_cities` VALUES ('261','امام حسن','امام-حسن','7','28.9471428','51.11345440000002');
INSERT INTO `tbl_cities` VALUES ('262','اهرم','اهرم','6','33.6349736','46.41528100000005');
INSERT INTO `tbl_cities` VALUES ('263','برازجان','برازجان','7','29.2673269','51.23177110000006');
INSERT INTO `tbl_cities` VALUES ('264','بردخون','بردخون','7','28.0310002','51.455899199999976');
INSERT INTO `tbl_cities` VALUES ('265','بندر دیر','بندر-دیر','7','27.8458503','51.94214439999996');
INSERT INTO `tbl_cities` VALUES ('266','بندر دیلم','بندر-دیلم','7','30.0589813','50.16781209999999');
INSERT INTO `tbl_cities` VALUES ('267','بندر ریگ','بندر-ریگ','7','29.4854596','50.62880689999997');
INSERT INTO `tbl_cities` VALUES ('268','بندر کنگان','بندر-کنگان','7','27.8370437','52.06454729999996');
INSERT INTO `tbl_cities` VALUES ('269','بندر گناوه','بندر-گناوه','7','29.5692083','50.523909600000025');
INSERT INTO `tbl_cities` VALUES ('270','بوشهر','بوشهر','7','28.9233837','50.82031400000005');
INSERT INTO `tbl_cities` VALUES ('271','جم','جم','7','27.8122083','52.350693999999976');
INSERT INTO `tbl_cities` VALUES ('272','چغادک','چغادک','7','28.9810286','51.020150400000034');
INSERT INTO `tbl_cities` VALUES ('273','خارک','خارک','7','29.2457199','50.31206670000006');
INSERT INTO `tbl_cities` VALUES ('274','خورموج','خورموج','7','28.6555539','51.37951899999996');
INSERT INTO `tbl_cities` VALUES ('275','دالکی','دالکی','7','29.4280205','51.29198730000007');
INSERT INTO `tbl_cities` VALUES ('276','دلوار','دلوار','7','28.754575','51.06972740000003');
INSERT INTO `tbl_cities` VALUES ('277','سعدآباد','سعدآباد','7','29.3882958','51.11934280000003');
INSERT INTO `tbl_cities` VALUES ('278','شبانکاره','شبانکاره','7','29.4721746','50.98625130000005');
INSERT INTO `tbl_cities` VALUES ('279','کاکی','کاکی','7','28.34176429999999','51.52289280000002');
INSERT INTO `tbl_cities` VALUES ('280','وحدتیه','وحدتیه','7','29.4865675','51.22653749999995');
INSERT INTO `tbl_cities` VALUES ('281','اردل','اردل','9','31.99466049999999','50.648251699999946');
INSERT INTO `tbl_cities` VALUES ('282','آلونی','آلونی','9','31.55373689999999','51.06059189999996');
INSERT INTO `tbl_cities` VALUES ('283','باباحیدر','باباحیدر','9','32.32991550000001','50.47088080000003');
INSERT INTO `tbl_cities` VALUES ('284','بروجن','بروجن','9','31.9797908','51.29460659999995');
INSERT INTO `tbl_cities` VALUES ('285','بلداجی','بلداجی','9','31.93773170000001','51.051457700000014');
INSERT INTO `tbl_cities` VALUES ('286','بن ','بن','9','32.5402721','50.74426760000006');
INSERT INTO `tbl_cities` VALUES ('287','جونقان','جونقان','9','32.1505008','50.68715939999993');
INSERT INTO `tbl_cities` VALUES ('288','چلگرد','چلگرد','9','32.4626078','50.12923030000002');
INSERT INTO `tbl_cities` VALUES ('289','سامان','سامان','9','32.4485429','50.9106951');
INSERT INTO `tbl_cities` VALUES ('290','سفیددشت','سفیددشت','9','32.1344414','51.182069400000046');
INSERT INTO `tbl_cities` VALUES ('291','سودجان','سودجان','9','32.5209577','50.40110709999999');
INSERT INTO `tbl_cities` VALUES ('292','سورشجان','سورشجان','9','32.3172101','50.671593400000006');
INSERT INTO `tbl_cities` VALUES ('293','شلمزار','شلمزار','9','32.04540999999999','50.815725799999996');
INSERT INTO `tbl_cities` VALUES ('294','شهرکرد','شهرکرد','9','32.32823859999999','50.876854099999946');
INSERT INTO `tbl_cities` VALUES ('295','طاقانک','طاقانک','9','32.2180899','50.83592999999996');
INSERT INTO `tbl_cities` VALUES ('296','فارسان','فارسان','9','32.25820660000001','50.57050879999997');
INSERT INTO `tbl_cities` VALUES ('297','فرادنبه','فرادنبه','9','32.0141999','51.21607170000004');
INSERT INTO `tbl_cities` VALUES ('298','فرخ شهر','فرخ-شهر','9','32.27046070000001','50.9810377');
INSERT INTO `tbl_cities` VALUES ('299','کیان','کیان','9','32.2845639','50.89507389999994');
INSERT INTO `tbl_cities` VALUES ('300','گندمان','گندمان','9','31.8646314','51.15592590000006');
INSERT INTO `tbl_cities` VALUES ('301','گهرو','گهرو','9','32.0069588','50.88466200000005');
INSERT INTO `tbl_cities` VALUES ('302','لردگان','لردگان','9','31.51658519999999','50.81442590000006');
INSERT INTO `tbl_cities` VALUES ('303','مال خلیفه','مال-خلیفه','9','31.2907475','51.25925419999999');
INSERT INTO `tbl_cities` VALUES ('304','ناغان','ناغان','9','31.932058','50.72609120000004');
INSERT INTO `tbl_cities` VALUES ('305','نافچ','نافچ','9','32.42360339999999','50.791031100000055');
INSERT INTO `tbl_cities` VALUES ('306','هفشجان','هفشجان','9','32.2252753','50.79329789999997');
INSERT INTO `tbl_cities` VALUES ('307','بیرجند','بیرجند','10','32.8649039','59.22624719999999');
INSERT INTO `tbl_cities` VALUES ('308','فردوس','فردوس','10','34.0227698','58.17220750000001');
INSERT INTO `tbl_cities` VALUES ('309','قائن','قاین','10','33.72267489999999','59.17882039999995');
INSERT INTO `tbl_cities` VALUES ('310','سرایان','سرایان','10','33.3451882','58.28045410000004');
INSERT INTO `tbl_cities` VALUES ('311','نهبندان','نهبندان','10','31.5122675','59.65644939999993');
INSERT INTO `tbl_cities` VALUES ('312','سربیشه','سربیشه','10','32.5018115','59.65644939999993');
INSERT INTO `tbl_cities` VALUES ('313','اسدیه','اسدیه','10','32.91407','60.02305590000003');
INSERT INTO `tbl_cities` VALUES ('314','بشرویه','بشرویه','10','33.8625391','57.4259624');
INSERT INTO `tbl_cities` VALUES ('315','اسلامیه','اسلامیه','10','32.5175643','59.10417580000001');
INSERT INTO `tbl_cities` VALUES ('316','آیسک','آیسک','10','33.8808197','58.38422300000002');
INSERT INTO `tbl_cities` VALUES ('317','سه قلعه','سه-قلعه','10','33.84802250000001','58.50632589999998');
INSERT INTO `tbl_cities` VALUES ('318','خوسف','خوسف','10','32.7810773','58.89197560000002');
INSERT INTO `tbl_cities` VALUES ('319','شوسف','شوسف','10','31.8038791','60.00715850000006');
INSERT INTO `tbl_cities` VALUES ('320','انابد','انابد','11','35.2508433','57.81120499999997');
INSERT INTO `tbl_cities` VALUES ('321','باجگیران','باجگیران','11','37.6225036','58.41876249999996');
INSERT INTO `tbl_cities` VALUES ('322','باخرز','باخرز','11','34.997898','60.309525399999984');
INSERT INTO `tbl_cities` VALUES ('323','بایک','بایک','11','35.1020253','59.10417580000001');
INSERT INTO `tbl_cities` VALUES ('324','بجستان','بجستان','11','34.5220565','58.17220750000001');
INSERT INTO `tbl_cities` VALUES ('325','بردسکن','بردسکن','11','35.26175070000001','57.97308199999998');
INSERT INTO `tbl_cities` VALUES ('326','بیدخت','بیدخت','11','34.34232839999999','58.76598009999998');
INSERT INTO `tbl_cities` VALUES ('327','تایباد','تایباد','11','34.7444223','60.77954520000003');
INSERT INTO `tbl_cities` VALUES ('328','تربت جام','تربت-جام','11','35.2316863','60.640121799999974');
INSERT INTO `tbl_cities` VALUES ('329','تربت حیدریه','تربت-حیدریه','11','35.279843','59.21614499999998');
INSERT INTO `tbl_cities` VALUES ('330','جغتای','جغتای','11','36.6409424','57.07595570000001');
INSERT INTO `tbl_cities` VALUES ('331','چاپشلو','چاپشلو','11','37.3500535','59.076913099999956');
INSERT INTO `tbl_cities` VALUES ('332','چکنه','چکنه','11','36.8154774','58.50725399999999');
INSERT INTO `tbl_cities` VALUES ('333','چناران','چناران','11','36.6415869','59.12139739999998');
INSERT INTO `tbl_cities` VALUES ('334','حاجی آباد','حاجی-آباد','11','36.0832005','59.076913099999956');
INSERT INTO `tbl_cities` VALUES ('335','خرو','خرو','11','36.1610766','59.01810380000006');
INSERT INTO `tbl_cities` VALUES ('336','خضری دشت بیاض','خضری-دشت-بیاض','11','34.0222628','58.814644300000054');
INSERT INTO `tbl_cities` VALUES ('337','خلیل  آباد','خلیل-آباد','11','35.25310760000001','58.28900429999999');
INSERT INTO `tbl_cities` VALUES ('338','خواف','خواف','11','34.5718257','60.147409100000004');
INSERT INTO `tbl_cities` VALUES ('339','داورزن','داورزن','11','36.3513912','56.88171939999995');
INSERT INTO `tbl_cities` VALUES ('340','دررود','دررود','11','36.138119','59.109916099999964');
INSERT INTO `tbl_cities` VALUES ('341','درگز','درگز','11','37.44548039999999','59.109916099999964');
INSERT INTO `tbl_cities` VALUES ('342','دولت آباد','دولت-آباد-1','11','36.4384967','59.166615800000045');
INSERT INTO `tbl_cities` VALUES ('343','رباط سنگ','رباط-سنگ','11','35.5469303','59.19318039999996');
INSERT INTO `tbl_cities` VALUES ('344','رشتخوار','رشتخوار','11','34.9748974','59.6247439');
INSERT INTO `tbl_cities` VALUES ('345','رضویه','رضویه','11','36.0988489','60.118479699999966');
INSERT INTO `tbl_cities` VALUES ('346','رودآب','رودآب','11','36.0213698','57.312925800000016');
INSERT INTO `tbl_cities` VALUES ('347','ریوش','ریوش','11','35.4773891','58.45729069999993');
INSERT INTO `tbl_cities` VALUES ('348','سبزوار','سبزوار','11','36.2151823','57.66782280000007');
INSERT INTO `tbl_cities` VALUES ('349','سرخس','سرخس','11','36.5448905','61.151971600000024');
INSERT INTO `tbl_cities` VALUES ('350','سلطان آباد','سلطان-آباد','11','36.1477878','58.86476070000003');
INSERT INTO `tbl_cities` VALUES ('351','سنگان','سنگان','11','34.4025117','60.26029160000007');
INSERT INTO `tbl_cities` VALUES ('352','شاندیز','شاندیز','11','36.3983985','59.30811970000002');
INSERT INTO `tbl_cities` VALUES ('353','ششتمد','ششتمد','11','35.9600684','57.76297290000002');
INSERT INTO `tbl_cities` VALUES ('354','صالح آباد','صالح-آباد-1','11','35.6889716','61.090808599999946');
INSERT INTO `tbl_cities` VALUES ('355','طرقبه','طرقبه','11','36.3114565','59.38288699999998');
INSERT INTO `tbl_cities` VALUES ('356','عشق آباد','عشق-آباد','11','37.9600766','58.32606290000001');
INSERT INTO `tbl_cities` VALUES ('357','فرهادگرد','فرهادگرد','11','35.76755420000001','59.73430450000001');
INSERT INTO `tbl_cities` VALUES ('358','فریمان','فریمان','11','35.70178989999999','59.84684319999997');
INSERT INTO `tbl_cities` VALUES ('359','فیروزه','فیروزه','11','36.2806383','58.58295399999997');
INSERT INTO `tbl_cities` VALUES ('360','فیض آباد','فیض-آباد','11','35.0144726','58.77742869999997');
INSERT INTO `tbl_cities` VALUES ('361','قاسم آباد','قاسم-آباد','11','36.360176','59.529674200000045');
INSERT INTO `tbl_cities` VALUES ('362','قدمگاه','قدمگاه','11','36.10863','59.06256680000001');
INSERT INTO `tbl_cities` VALUES ('363','قلندرآباد','قلندرآباد','11','35.60052099999999','59.94501100000002');
INSERT INTO `tbl_cities` VALUES ('364','قوچان','قوچان','11','37.1293332','58.474418499999956');
INSERT INTO `tbl_cities` VALUES ('365','کاخک','کاخک','11','34.1462854','58.64440730000001');
INSERT INTO `tbl_cities` VALUES ('366','کاریز','کاریز','11','34.8106632','60.820235000000025');
INSERT INTO `tbl_cities` VALUES ('367','کاشمر','کاشمر','11','35.2434225','58.46870899999999');
INSERT INTO `tbl_cities` VALUES ('368','کدکن','کدکن','11','35.5877144','58.87908349999998');
INSERT INTO `tbl_cities` VALUES ('369','کلات','کلات','11','36.9952626','59.75305430000003');
INSERT INTO `tbl_cities` VALUES ('370','گناباد','گناباد','11','34.339552','58.70303260000003');
INSERT INTO `tbl_cities` VALUES ('371','لطف آباد','لطف-آباد','11','37.51800650000001','59.33687110000005');
INSERT INTO `tbl_cities` VALUES ('372','مشهد','مشهد','11','36.4190601','59.56423689999997');
INSERT INTO `tbl_cities` VALUES ('373','ملک آباد','ملک-آباد','11','35.9917762','59.56999829999995');
INSERT INTO `tbl_cities` VALUES ('374','نشتیفان','نشتیفان','11','34.4364824','60.1792385');
INSERT INTO `tbl_cities` VALUES ('375','نصرآباد','نصرآباد-1','11','35.4189953','60.309525399999984');
INSERT INTO `tbl_cities` VALUES ('376','نقاب','نقاب','11','36.70673420000001','57.41465310000001');
INSERT INTO `tbl_cities` VALUES ('377','نوخندان','نوخندان','11','37.51852210000001','58.990860399999974');
INSERT INTO `tbl_cities` VALUES ('378','نیشابور','نیشابور','11','36.2140865','58.79609149999999');
INSERT INTO `tbl_cities` VALUES ('379','اسفراین','اسفراین','12','37.0666772','57.49667299999999');
INSERT INTO `tbl_cities` VALUES ('380','آشخانه','آشخانه','12','37.5544156','56.92672589999995');
INSERT INTO `tbl_cities` VALUES ('381','بجنورد','بجنورد','12','37.4702063','57.31433479999998');
INSERT INTO `tbl_cities` VALUES ('382','پیش قلعه','پیش-قلعه','12','37.6517333','56.99427390000005');
INSERT INTO `tbl_cities` VALUES ('383','حصار گرم خان','حصار-گرم-خان','12','37.4710353','57.101318799999945');
INSERT INTO `tbl_cities` VALUES ('384','درق','درق','12','36.9703792','56.20633120000002');
INSERT INTO `tbl_cities` VALUES ('385','راز','راز','12','37.9323899','57.10977460000004');
INSERT INTO `tbl_cities` VALUES ('386','سنخواست','سنخواست','12','37.1005957','56.85641229999999');
INSERT INTO `tbl_cities` VALUES ('387','شوقان','شوقان','12','37.338705','56.884531700000025');
INSERT INTO `tbl_cities` VALUES ('388','شیروان','شیروان','12','37.4092357','57.92761840000003');
INSERT INTO `tbl_cities` VALUES ('389','صفی آباد','صفی-آباد','12','36.6938707','57.93045940000002');
INSERT INTO `tbl_cities` VALUES ('390','فاروج','فاروج','12','37.0851182','58.09820460000003');
INSERT INTO `tbl_cities` VALUES ('391','قاضی','قاضی','12','37.84648689999999','57.31716240000003');
INSERT INTO `tbl_cities` VALUES ('392','گرمه جاجرم','گرمه-جاجرم','12','36.9549589','56.36065719999999');
INSERT INTO `tbl_cities` VALUES ('393','لوجلی','لوجلی','12','37.4710353','57.101318799999945');
INSERT INTO `tbl_cities` VALUES ('394','آبادان','آبادان','13','30.347296','48.293400399999996');
INSERT INTO `tbl_cities` VALUES ('395','اروندکنار','اروندکنار','13','30.06136829999999','48.45353350000005');
INSERT INTO `tbl_cities` VALUES ('396','آغاجاری','آغاجاری','13','30.6907753','49.8240194');
INSERT INTO `tbl_cities` VALUES ('397','الوان','الوان','13','31.4360149','49.04131200000006');
INSERT INTO `tbl_cities` VALUES ('398','امیدیه','امیدیه','13','30.760479','49.701348600000074');
INSERT INTO `tbl_cities` VALUES ('399','اندیمشک','اندیمشک','13','32.4538139','48.348935600000004');
INSERT INTO `tbl_cities` VALUES ('400','اهواز','اهواز','13','31.3183272','48.67061869999998');
INSERT INTO `tbl_cities` VALUES ('401','ایذه','ایذه','13','31.8239619','49.87008620000006');
INSERT INTO `tbl_cities` VALUES ('402','باغ ملک','باغ-ملک','13','31.5259995','49.890571799999975');
INSERT INTO `tbl_cities` VALUES ('403','بستان','بستان-1','13','31.7130408','48.00350530000003');
INSERT INTO `tbl_cities` VALUES ('404','بندر امام خمینی','بندر-امام-خمینی','13','30.4472068','49.07160959999999');
INSERT INTO `tbl_cities` VALUES ('405','بندر ماهشهر','بندر-ماهشهر','13','30.5619807','49.17271779999999');
INSERT INTO `tbl_cities` VALUES ('406','بهبهان','بهبهان','13','30.5911589','50.234744999999975');
INSERT INTO `tbl_cities` VALUES ('407','جایزان','جایزان','13','30.8780702','49.84960769999998');
INSERT INTO `tbl_cities` VALUES ('408','چمران','چمران','13','30.7077318','49.16006949999996');
INSERT INTO `tbl_cities` VALUES ('409','حر','حر','13','32.1436786','48.39008579999995');
INSERT INTO `tbl_cities` VALUES ('410','حسینیه','حسینیه','13','32.6763651','48.246817400000054');
INSERT INTO `tbl_cities` VALUES ('411','حمیدیه','حمیدیه','13','31.4778716','48.43376379999995');
INSERT INTO `tbl_cities` VALUES ('412','خرمشهر','خرمشهر','13','30.4256219','48.18911849999995');
INSERT INTO `tbl_cities` VALUES ('413','دزآب','دزآب','13','32.2379601','48.40653420000001');
INSERT INTO `tbl_cities` VALUES ('414','دزفول','دزفول','13','32.3830777','48.42358409999997');
INSERT INTO `tbl_cities` VALUES ('415','دهدز','دهدز','13','31.6708611','50.26566200000002');
INSERT INTO `tbl_cities` VALUES ('416','رامشیر','رامشیر','13','30.89565209999999','49.40947010000002');
INSERT INTO `tbl_cities` VALUES ('417','رامهرمز','رامهرمز','13','31.2777088','49.59931670000003');
INSERT INTO `tbl_cities` VALUES ('418','رفیع','رفیع','13','31.5988558','47.89461979999999');
INSERT INTO `tbl_cities` VALUES ('419','زهره','زهره','13','31.8303807','49.873313499999995');
INSERT INTO `tbl_cities` VALUES ('420','سالند','سالند','13','32.4992468','48.83219529999997');
INSERT INTO `tbl_cities` VALUES ('421','سردشت','سردشت-1','13','30.3259917','50.21671739999999');
INSERT INTO `tbl_cities` VALUES ('422','سوسنگرد','سوسنگرد','13','31.5566879','48.16973299999995');
INSERT INTO `tbl_cities` VALUES ('423','شادگان','شادگان','13','30.6545969','48.65392680000002');
INSERT INTO `tbl_cities` VALUES ('424','شوش','شوش','13','32.19579479999999','48.25428299999999');
INSERT INTO `tbl_cities` VALUES ('425','شوشتر','شوشتر','13','32.0520726','48.84980180000002');
INSERT INTO `tbl_cities` VALUES ('426','شیبان','شیبان','13','31.4083322','48.79574230000003');
INSERT INTO `tbl_cities` VALUES ('427','صفی آباد','صفی-آباد-1','13','32.2631744','48.416288399999985');
INSERT INTO `tbl_cities` VALUES ('428','صیدون','صیدون','13','31.3651314','50.075257100000044');
INSERT INTO `tbl_cities` VALUES ('429','قلعه خواجه','قلعه-خواجه','13','32.2048631','49.44532950000007');
INSERT INTO `tbl_cities` VALUES ('430','قلعه تل','قلعه-تل','13','31.6340154','49.88544969999998');
INSERT INTO `tbl_cities` VALUES ('431','گتوند','گتوند','13','32.243476','48.809566500000074');
INSERT INTO `tbl_cities` VALUES ('432','لالی','لالی','13','32.32954379999999','49.09434329999999');
INSERT INTO `tbl_cities` VALUES ('433','مسجدسلیمان','مسجدسلیمان','13','31.9633663','49.28921289999994');
INSERT INTO `tbl_cities` VALUES ('434','مقاومت','مقاومت','13','32.3983981','48.39928150000003');
INSERT INTO `tbl_cities` VALUES ('435','ملاثانی','ملاثانی','13','31.5825784','48.887548599999946');
INSERT INTO `tbl_cities` VALUES ('436','میانرود','میانرود','13','32.1512337','48.44125489999999');
INSERT INTO `tbl_cities` VALUES ('437','مینوشهر','مینوشهر','13','30.3533069','48.21474250000006');
INSERT INTO `tbl_cities` VALUES ('438','هفتگل','هفتگل','13','31.4525814','49.52545409999993');
INSERT INTO `tbl_cities` VALUES ('439','هندیجان','هندیجان','13','30.2382492','49.706454800000074');
INSERT INTO `tbl_cities` VALUES ('440','هویزه','هویزه','13','31.467293','48.075391699999955');
INSERT INTO `tbl_cities` VALUES ('441','ویس','ویس','13','31.48868800000001','48.8774803');
INSERT INTO `tbl_cities` VALUES ('442','آب بر','آب-بر','14','36.92849450000001','48.94799590000002');
INSERT INTO `tbl_cities` VALUES ('443','ابهر','ابهر','14','36.15247629999999','49.23853389999999');
INSERT INTO `tbl_cities` VALUES ('444','چورزق','چورزق','14','36.9975883','48.77871270000003');
INSERT INTO `tbl_cities` VALUES ('445','حلب','حلب','14','36.29586159999999','48.05803100000003');
INSERT INTO `tbl_cities` VALUES ('446','خرمدره','خرمدره','14','36.21094060000001','49.1929609');
INSERT INTO `tbl_cities` VALUES ('447','دندی','دندی','14','36.5523355','47.61248150000006');
INSERT INTO `tbl_cities` VALUES ('448','زرین آباد','زرین-آباد','14','36.4160928','48.246924899999954');
INSERT INTO `tbl_cities` VALUES ('449','زرین رود','زرین-رود','14','35.76105520000001','48.476226999999994');
INSERT INTO `tbl_cities` VALUES ('450','زنجان','زنجان','14','36.6830045','48.50872090000007');
INSERT INTO `tbl_cities` VALUES ('451','سجاس','سجاس','14','36.2401057','48.551241900000036');
INSERT INTO `tbl_cities` VALUES ('452','سلطانیه','سلطانیه','14','36.43584429999999','48.79197260000001');
INSERT INTO `tbl_cities` VALUES ('453','صائین قلعه','صایین-قلعه','14','36.30349439999999','49.07666070000005');
INSERT INTO `tbl_cities` VALUES ('454','قیدار','قیدار','14','36.1203431','48.59379549999994');
INSERT INTO `tbl_cities` VALUES ('455','گرماب','گرماب','14','35.8467278','48.197073000000046');
INSERT INTO `tbl_cities` VALUES ('456','ماه نشان','ماه-نشان','14','36.7420608','47.67209750000006');
INSERT INTO `tbl_cities` VALUES ('457','هیدج','هیدج','14','36.2572749','49.134781299999986');
INSERT INTO `tbl_cities` VALUES ('458','آرادان','آرادان','15','35.247165','52.492073000000005');
INSERT INTO `tbl_cities` VALUES ('459','امیریه','امیریه','15','36.4918053','54.91507730000001');
INSERT INTO `tbl_cities` VALUES ('460','ایوانکی','ایوانکی','15','35.3450347','52.06657429999996');
INSERT INTO `tbl_cities` VALUES ('461','بسطام','بسطام','15','36.4846777','54.99836230000005');
INSERT INTO `tbl_cities` VALUES ('462','بیارجمند','بیارجمند','15','36.0813537','55.81065269999999');
INSERT INTO `tbl_cities` VALUES ('463','دامغان','دامغان','15','36.1646345','54.35764730000005');
INSERT INTO `tbl_cities` VALUES ('464','دیباج','دیباج','15','36.4291697','54.22383149999996');
INSERT INTO `tbl_cities` VALUES ('465','سرخه','سرخه','15','35.4676811','53.21266349999996');
INSERT INTO `tbl_cities` VALUES ('466','سمنان','سمنان','15','35.578797','53.37981079999997');
INSERT INTO `tbl_cities` VALUES ('467','سنگسر','سنگسر','15','35.7029747','53.342035099999976');
INSERT INTO `tbl_cities` VALUES ('468','شاهرود','شاهرود','15','36.4062241','55.016268999999966');
INSERT INTO `tbl_cities` VALUES ('469','شهمیرزاد','شهمیرزاد','15','35.7729007','53.327702000000045');
INSERT INTO `tbl_cities` VALUES ('470','کلاته خیج','کلاته-خیج','15','36.67451759999999','55.300526200000036');
INSERT INTO `tbl_cities` VALUES ('471','گرمسار','گرمسار','15','35.2030956','52.329410999999936');
INSERT INTO `tbl_cities` VALUES ('472','مجن','مجن','15','36.48008119999999','54.64651700000002');
INSERT INTO `tbl_cities` VALUES ('473','میامی','میامی','15','36.41264779999999','55.649533700000006');
INSERT INTO `tbl_cities` VALUES ('474','ادیمی','ادیمی','16','31.1158746','61.411448199999995');
INSERT INTO `tbl_cities` VALUES ('475','اسپکه','اسپکه','16','26.8347937','60.173450799999955');
INSERT INTO `tbl_cities` VALUES ('476','ایرانشهر','ایرانشهر','16','35.70975600000001','51.42177170000002');
INSERT INTO `tbl_cities` VALUES ('477','بزمان','بزمان','16','27.854035','60.1792385');
INSERT INTO `tbl_cities` VALUES ('478','بمپور','بمپور','16','27.1974156','60.4602294');
INSERT INTO `tbl_cities` VALUES ('479','بنت','بنت','16','26.2971672','59.52391469999998');
INSERT INTO `tbl_cities` VALUES ('480','بنجار','بنجار','16','31.04197','61.56324489999997');
INSERT INTO `tbl_cities` VALUES ('481','پیشین','پیشین','16','26.0836764','61.694719299999974');
INSERT INTO `tbl_cities` VALUES ('482','جالق','جالق','16','27.5965049','62.70299739999996');
INSERT INTO `tbl_cities` VALUES ('483','چابهار','چابهار','16','25.296878','60.64592849999997');
INSERT INTO `tbl_cities` VALUES ('484','خاش','خاش','16','28.2314235','61.19276009999999');
INSERT INTO `tbl_cities` VALUES ('485','دوست محمد','دوست-محمد','16','31.143651','61.791198699999995');
INSERT INTO `tbl_cities` VALUES ('486','راسک','راسک','16','26.2392362','61.39977729999998');
INSERT INTO `tbl_cities` VALUES ('487','زابل','زابل','16','31.0323677','61.49024829999996');
INSERT INTO `tbl_cities` VALUES ('488','زابلی ','زابلی','16',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('489','زاهدان','زاهدان','16','29.45192600000001','60.88419829999998');
INSERT INTO `tbl_cities` VALUES ('490','زهک','زهک','16','30.89083439999999','61.68010600000002');
INSERT INTO `tbl_cities` VALUES ('491','سراوان','سراوان','16','27.3526033','62.344781499999954');
INSERT INTO `tbl_cities` VALUES ('492','سرباز','سرباز','16','26.6328559','61.25833520000003');
INSERT INTO `tbl_cities` VALUES ('493','سوران','سوران','16','27.294359','61.99895790000005');
INSERT INTO `tbl_cities` VALUES ('494','سیرکان','سیرکان','16','26.8275478','62.6412904');
INSERT INTO `tbl_cities` VALUES ('495','فنوج','فنوج','16','26.5738487','59.647801699999945');
INSERT INTO `tbl_cities` VALUES ('497','قصرقند','قصرقند','16','26.2235192','60.75048790000005');
INSERT INTO `tbl_cities` VALUES ('498','کنارک','کنارک','16','25.4039407','60.37326529999996');
INSERT INTO `tbl_cities` VALUES ('499','گلمورتی','گلمورتی','16','27.4822523','59.44618620000006');
INSERT INTO `tbl_cities` VALUES ('500','محمد‌آباد','محمد','16','30.8866829','61.463977399999976');
INSERT INTO `tbl_cities` VALUES ('501','میرجاوه','میرجاوه','16','29.01615210000001','61.44938419999994');
INSERT INTO `tbl_cities` VALUES ('502','نصرت آباد','نصرت-آباد','16','29.8572576','59.97392430000002');
INSERT INTO `tbl_cities` VALUES ('503','نگور','نگور','16','25.3892565','61.13740680000001');
INSERT INTO `tbl_cities` VALUES ('504','نوک آباد','نوک-آباد','16','28.5386392','60.75920450000001');
INSERT INTO `tbl_cities` VALUES ('505','نیک شهر','نیک-شهر','16','26.2350988','60.22844370000007');
INSERT INTO `tbl_cities` VALUES ('507','آباده','آباده','17','31.1594661','52.64399019999996');
INSERT INTO `tbl_cities` VALUES ('508','آباده طشک','آباده-طشک','17','29.8095933','53.728780700000016');
INSERT INTO `tbl_cities` VALUES ('509','اردکان','اردکان','17','30.04505709999999','52.27623219999998');
INSERT INTO `tbl_cities` VALUES ('510','ارسنجان','ارسنجان','17','29.9196861','53.29888619999997');
INSERT INTO `tbl_cities` VALUES ('511','اسير','اسیر','17','27.725544','52.66670469999997');
INSERT INTO `tbl_cities` VALUES ('512','اشکنان','اشکنان','17','27.2371635','53.60145069999999');
INSERT INTO `tbl_cities` VALUES ('513','اقلید','اقلید','17','30.90493660000001','52.69210010000006');
INSERT INTO `tbl_cities` VALUES ('514','اهل','اهل','17','27.2127245','53.6637346');
INSERT INTO `tbl_cities` VALUES ('515','اوز','اوز','17','27.7564247','54.014004200000045');
INSERT INTO `tbl_cities` VALUES ('516','ایج','ایج','17','29.0193869','54.24566370000002');
INSERT INTO `tbl_cities` VALUES ('517','ایزدخواست','ایزدخواست','17','31.5133567','52.124896000000035');
INSERT INTO `tbl_cities` VALUES ('518','باب انار','باب-انار','17','29.1043813','53.04589299999998');
INSERT INTO `tbl_cities` VALUES ('519','بالاده','بالاده','17','29.2823712','51.93949939999993');
INSERT INTO `tbl_cities` VALUES ('520','بنارویه','بنارویه','17','28.0840959','54.04939039999999');
INSERT INTO `tbl_cities` VALUES ('521','بهمن','بهمن','17','31.1951484','52.48119329999997');
INSERT INTO `tbl_cities` VALUES ('522','بیرم','بیرم','17','27.43393829999999','53.51487959999997');
INSERT INTO `tbl_cities` VALUES ('523','بیضا','بیضا','17','29.9723783','52.40259830000002');
INSERT INTO `tbl_cities` VALUES ('524','جنت شهر','جنت-شهر','17','28.6496882','54.691788299999985');
INSERT INTO `tbl_cities` VALUES ('525','جهرم','جهرم','17','28.5177435','53.574386600000025');
INSERT INTO `tbl_cities` VALUES ('526','جویم','جویم','17','28.2602887','53.978634000000056');
INSERT INTO `tbl_cities` VALUES ('527','حاجی آباد','حاجی-آباد-1','17','29.2063895','54.15359990000002');
INSERT INTO `tbl_cities` VALUES ('528','خاوران','خاوران','17','28.9365315','53.31573830000002');
INSERT INTO `tbl_cities` VALUES ('529','خرامه','خرامه','17','29.5020459','53.31236749999994');
INSERT INTO `tbl_cities` VALUES ('530','خشت','خشت','17','36.61206769999999','52.19786769999996');
INSERT INTO `tbl_cities` VALUES ('531','خنج','خنج','17','27.8827043','53.428407600000014');
INSERT INTO `tbl_cities` VALUES ('532','خور','خور-1','17','28.840843','52.320766700000036');
INSERT INTO `tbl_cities` VALUES ('533','داراب','داراب','17','28.7559514','54.554679299999975');
INSERT INTO `tbl_cities` VALUES ('534','داریان','داریان','17','29.5638305','52.93045219999999');
INSERT INTO `tbl_cities` VALUES ('535','رونیز','رونیز','17','29.190829','53.768106200000034');
INSERT INTO `tbl_cities` VALUES ('536','زاهدشهر','زاهدشهر','17','28.7477184','53.80473759999995');
INSERT INTO `tbl_cities` VALUES ('537','زرقان','زرقان','17','29.7641623','52.71349269999996');
INSERT INTO `tbl_cities` VALUES ('538','سده','سده','17','30.71194899999999','52.17265050000003');
INSERT INTO `tbl_cities` VALUES ('539','سروستان','سروستان','17','29.2660973','53.22343590000003');
INSERT INTO `tbl_cities` VALUES ('540','سعادت شهر','سعادت-شهر','17','30.0799439','53.13999119999994');
INSERT INTO `tbl_cities` VALUES ('541','سوريان','سوریان','17','30.46666699999999','53.450000000000045');
INSERT INTO `tbl_cities` VALUES ('542','سیدان','سیدان','17','30.0063306','53.00560210000003');
INSERT INTO `tbl_cities` VALUES ('543','ششده','ششده','17','28.9272872','54.05211310000004');
INSERT INTO `tbl_cities` VALUES ('544','شهر پیر','شهر-پیر','17','28.3148834','54.31939139999997');
INSERT INTO `tbl_cities` VALUES ('545','شیراز','شیراز','17','29.5917677','52.58369820000007');
INSERT INTO `tbl_cities` VALUES ('546','صغاد','صغاد','17','31.19466','52.515856299999996');
INSERT INTO `tbl_cities` VALUES ('547','صفاشهر','صفاشهر','17','30.6107721','53.1911235');
INSERT INTO `tbl_cities` VALUES ('548','علامرودشت','علامرودشت','17','27.6222304','53.00023169999997');
INSERT INTO `tbl_cities` VALUES ('549','فتح آباد','فتح-آباد','17','29.9379545','52.800465799999984');
INSERT INTO `tbl_cities` VALUES ('550','فراشبند','فراشبند','17','28.8543264','52.09838000000002');
INSERT INTO `tbl_cities` VALUES ('551','فسا','فسا','17','28.9440314','53.63394029999995');
INSERT INTO `tbl_cities` VALUES ('552','فیروزآباد','فیروزآباد','17','28.8395155','52.56387940000002');
INSERT INTO `tbl_cities` VALUES ('553','قائمیه','قایمیه','17','29.8499693','51.59127000000001');
INSERT INTO `tbl_cities` VALUES ('554','قادرآباد','قادرآباد','17','30.27938979999999','53.26384610000002');
INSERT INTO `tbl_cities` VALUES ('555','قطب آباد','قطب-آباد','17','28.6520662','53.63394029999995');
INSERT INTO `tbl_cities` VALUES ('556','قیر و کارزین','قیر-و-کارزین','17','28.3559058','52.959966099999974');
INSERT INTO `tbl_cities` VALUES ('557','کازرون','کازرون','17','29.6271233','51.651816300000064');
INSERT INTO `tbl_cities` VALUES ('558','کامفیروز','کامفیروز','17','30.3239322','52.19255799999996');
INSERT INTO `tbl_cities` VALUES ('559','کره ای','کره-ای','17','29.8486298','53.09830420000003');
INSERT INTO `tbl_cities` VALUES ('560','کنارتخته','کنارتخته','17','29.53431059999999','51.39422020000006');
INSERT INTO `tbl_cities` VALUES ('561','کوار','کوار','17','29.21325680000001','52.68675289999999');
INSERT INTO `tbl_cities` VALUES ('562','گراش','گراش','17','27.6903817','54.15019219999999');
INSERT INTO `tbl_cities` VALUES ('563','گله دار','گله-دار','17','27.6561213','52.65735080000002');
INSERT INTO `tbl_cities` VALUES ('564','لار','لار','17','27.6741406','54.335784500000045');
INSERT INTO `tbl_cities` VALUES ('565','لامرد','لامرد','17','27.3423771','53.18035580000003');
INSERT INTO `tbl_cities` VALUES ('566','لپوئی','لپویی','17','29.7978459','52.65735080000002');
INSERT INTO `tbl_cities` VALUES ('567','مرودشت','مرودشت','17','29.878738','52.820551499999965');
INSERT INTO `tbl_cities` VALUES ('568','مشکان','مشکان','17','29.4711343','54.35628070000007');
INSERT INTO `tbl_cities` VALUES ('569','مصیری','مصیری','17','30.2453504','51.52815009999995');
INSERT INTO `tbl_cities` VALUES ('570','مهر','مهر','17','27.55599309999999','52.88472049999996');
INSERT INTO `tbl_cities` VALUES ('571','میمند','میمند','17','28.8682661','52.75362099999995');
INSERT INTO `tbl_cities` VALUES ('572','نودان','نودان','17','29.8005417','51.691332699999975');
INSERT INTO `tbl_cities` VALUES ('573','نورآباد','نورآباد','17','30.1150898','51.541295200000036');
INSERT INTO `tbl_cities` VALUES ('574','نیریز','نیریز','17','29.1893104','54.31392770000002');
INSERT INTO `tbl_cities` VALUES ('575','وراوی','وراوی','17','27.4675502','53.053953800000045');
INSERT INTO `tbl_cities` VALUES ('576','جعفریه','جعفریه','19','34.7748188','50.516146400000025');
INSERT INTO `tbl_cities` VALUES ('577','دستجرد','دستجرد','19','34.6399443','50.87594190000004');
INSERT INTO `tbl_cities` VALUES ('578',' قم ','قم','19','34.6399443','50.87594190000004');
INSERT INTO `tbl_cities` VALUES ('579','قنوات','قنوات','19','34.61335639999999','51.025367200000005');
INSERT INTO `tbl_cities` VALUES ('580','کهک','کهک','19','34.3923283','50.86384320000002');
INSERT INTO `tbl_cities` VALUES ('581','قزوین','قزوین','18','36.2736589','49.99823600000002');
INSERT INTO `tbl_cities` VALUES ('584','سنندج','سنندج','20','35.3218748','46.98616470000002');
INSERT INTO `tbl_cities` VALUES ('586','کرمان','کرمان','21','30.28393789999999','57.08336280000003');
INSERT INTO `tbl_cities` VALUES ('588','کرمانشاه','کرمانشاه','22','34.3276924','47.07776850000005');
INSERT INTO `tbl_cities` VALUES ('590','یاسوج','یاسوج','23','30.6683832','51.587523499999975');
INSERT INTO `tbl_cities` VALUES ('592','گرگان','گرگان','24','36.8456427','54.439336300000036');
INSERT INTO `tbl_cities` VALUES ('598','آستارا','آستارا','25','38.42245620000001','48.868714899999986');
INSERT INTO `tbl_cities` VALUES ('599','بندرانزلی','بندرانزلی','25','37.46390889999999','49.479863499999965');
INSERT INTO `tbl_cities` VALUES ('600','خمام','خمام','25','37.391298','49.65883050000002');
INSERT INTO `tbl_cities` VALUES ('601','رشت','رشت','25','37.2682177','49.58912329999998');
INSERT INTO `tbl_cities` VALUES ('602','فومن','فومن','25','37.2203773','49.30950580000001');
INSERT INTO `tbl_cities` VALUES ('603','لاهیجان','لاهیجان','25','37.20707300000001','50.00336770000001');
INSERT INTO `tbl_cities` VALUES ('605','خرم آباد','خرم-آباد','26','33.4646833','48.33896440000001');
INSERT INTO `tbl_cities` VALUES ('607','ساری','ساری','27','36.5658729','53.05863279999994');
INSERT INTO `tbl_cities` VALUES ('609','اراک','اراک','28','34.0953553','49.701348600000074');
INSERT INTO `tbl_cities` VALUES ('618','تهران','تهران','8','35.6891975','51.388973599999986');
INSERT INTO `tbl_cities` VALUES ('620','بهشهر','بهشهر','27','36.6953128','53.53651309999998');
INSERT INTO `tbl_cities` VALUES ('621','قائمشهر','قایمشهر','27','36.4683746','52.86341970000001');
INSERT INTO `tbl_cities` VALUES ('622','بابل','بابل','27','36.5386629','52.67645429999993');
INSERT INTO `tbl_cities` VALUES ('623','بندرعباس','بندرعباس','29','27.1832216','56.26664549999998');
INSERT INTO `tbl_cities` VALUES ('624','یزد','یزد','31','31.8974232','54.35685620000004');
INSERT INTO `tbl_cities` VALUES ('625','همدان','همدان','30','34.7988575','48.515022499999986');
INSERT INTO `tbl_cities` VALUES ('627','تیمورلو','تیمورلو','1',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('628','سهند','سهند','1',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('629','بستان آباد','بستان-آباد','1',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('630','خسروشاه','خسروشاه','1',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('631','هادیشهر','هادیشهر','1',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('632','جوان قلعه','جوان-قلعه','1',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('633','خداجو[خراجو)','خداجوخراجو','1',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('634','بناب مرند','بناب-مرند','1',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('635','کشکسرای','کشکسرای','1',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('636','مبارک شهر','مبارک-شهر','1',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('637','اچاچی','اچاچی','1',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('638','ترک','ترک','1',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('639','ترکمانچای','ترکمانچای','1',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('640','نظرکهریزی','نظرکهریزی','1',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('641','نوشین','نوشین','2',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('642','سیه چشمه','سیه-چشمه','2',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('644','تازه شهر','تازه-شهر','2',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('645','شاهین دژ','شاهین-دژ','2',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('646','اسلام اباد','اسلام-اباد','3',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('647','تازه کند','تازه-کند','3',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('648','گیوی','گیوی','3',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('649','تازه کندانگوت','تازه-کندانگوت','3',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('650','فخراباد','فخراباد','3',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('651','قصابه','قصابه','3',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('652','مرادلو','مرادلو','3',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('653','کوراییم','کوراییم','3',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('654','آران وبیدگل','آران-وبیدگل','4',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('656','زیار','زیار','4',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('657','سجزی','سجزی','4',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('658','قهجاورستان','قهجاورستان','4',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('659','سین','سین','4',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('660','شاپورآباد','شاپورآباد','4',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('661','کمشچه','کمشچه','4',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('662','بویین ومیاندشت','بویین-ومیاندشت','4',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('663','رضوانشهر','رضوانشهر','4',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('664','اصغرآباد','اصغرآباد','4',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('665','درچه','درچه','4',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('666','فرخی','فرخی','4',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('667','گلشن','گلشن','4',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('668','گرگاب','گرگاب','4',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('669','گزبرخوار','گزبرخوار','4',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('670','لای بید','لای-بید','4',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('671','فریدونشهر','فریدونشهر','4',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('672','ایمانشهر','ایمانشهر','4',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('673','زازران','زازران','4',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('674','کلیشادوسودرجان','کلیشادوسودرجان','4',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('675','جوشقان قالی','جوشقان-قالی','4',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('676','کامو و چوگان','کامو-و-چوگان','4',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('677','مشکات','مشکات','4',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('678','گلشهر','گلشهر','4',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('679','باغشاد','باغشاد','4',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('680','چمگردان','چمگردان','4',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('681','مجلسی','مجلسی','4',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('682','بافران','بافران','4',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('683','نایین','نایین','4',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('684','جوزدان','جوزدان','4',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('685','گلدشت','گلدشت','4',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('686','خالدآباد','خالدآباد','4',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('687','طرق رود','طرق-رود','4',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('688','چهارباغ','چهارباغ','5',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('689','شهرجدیدهشتگرد','شهرجدیدهشتگرد','5',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('690','کوهسار','کوهسار','5',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('691','گلسار','گلسار','5',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('692','فردیس','فردیس','5',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('693','مشکین دشت','مشکین-دشت','5',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('694','آسارا','آسارا','5',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('695','کمال شهر','کمال-شهر','5',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('696','ماهدشت','ماهدشت','5',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('697','محمدشهر','محمدشهر','5',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('698','تنکمان','تنکمان','5',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('699','سراب باغ','سراب-باغ','6',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('700','مورموری','مورموری','6',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('701','آسمان آباد','آسمان-آباد','6',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('702','بلاوه','بلاوه','6',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('703','شباب','شباب','6',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('704','ماژین','ماژین','6',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('705','دلگشا','دلگشا','6',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('706','مهر','مهر','6',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('707','عالی شهر','عالی-شهر','7',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('708','آباد','آباد','7',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('709','اهرم','اهرم-2','7',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('710','انارستان','انارستان','7',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('711','ریز','ریز','7',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('712','بوشکان','بوشکان','7',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('713','تنگ ارم','تنگ-ارم','7',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('714','سعد آباد','سعد-آباد','7',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('715','کلمه','کلمه','7',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('716','بادوله','بادوله','7',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('717','شنبه','شنبه','7',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('718','بردستان','بردستان','7',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('719','بندردیر','بندردیر','7',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('720','دوراهک','دوراهک','7',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('721','بندردیلم','بندردیلم','7',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('722','عسلویه','عسلویه','7',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('723','نخل تقی','نخل-تقی','7',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('724','بندرکنگان','بندرکنگان','7',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('725','بنک','بنک','7',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('726','سیراف','سیراف','7',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('727','بندرریگ','بندرریگ','7',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('728','بندرگناوه','بندرگناوه','7',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('729','احمد آباد مستوفی','احمد-آباد-مستوفی','8',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('730','اسلامشهر','اسلامشهر','8',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('731','چهاردانگه','چهاردانگه','8',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('732','صالحیه','صالحیه','8',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('733','گلستان','گلستان','8',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('734','نسیم شهر','نسیم-شهر','8',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('735','پاکدشت','پاکدشت','8',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('736','شریف آباد','شریف-آباد','8',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('737','فرون اباد','فرون-اباد','8',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('738','بومهن','بومهن','8',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('739','پردیس','پردیس','8',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('740','پیشوا','پیشوا','8',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('741','آبسرد','آبسرد','8',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('742','آبعلی','آبعلی','8',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('743','دماوند','دماوند','8',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('744','رودهن','رودهن','8',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('745','کیلان','کیلان','8',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('746','پرند','پرند','8',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('747','رباطکریم','رباطکریم','8',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('748','نصیرشهر','نصیرشهر','8',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('749','باقرشهر','باقرشهر','8',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('750','حسن آباد','حسن-آباد-2','8',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('751','ری','ری','8',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('752','کهریزک','کهریزک','8',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('753','تجریش','تجریش','8',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('754','شمشک','شمشک','8',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('755','فشم','فشم','8',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('756','لواسان','لواسان','8',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('757','اندیشه','اندیشه','8',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('758','باغستان','باغستان','8',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('759','شاهدشهر','شاهدشهر','8',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('760','شهریار','شهریار','8',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('761','صباشهر','صباشهر','8',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('762','فردوسیه','فردوسیه','8',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('763','وحیدیه','وحیدیه','8',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('764','ارجمند','ارجمند','8',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('765','فیروزکوه','فیروزکوه','8',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('766','قدس','قدس','8',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('767','قرچک','قرچک','8',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('768','صفادشت','صفادشت','8',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('769','ملارد','ملارد','8',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('770','جوادآباد','جوادآباد','8',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('771','ورامین','ورامین','8',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('772','دشتک','دشتک','9',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('773','سرخون','سرخون','9',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('774','کاج','کاج','9',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('775','فرادبنه','فرادبنه','9',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('776','نقنه','نقنه','9',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('777','وردنجان','وردنجان','9',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('778','هارونی','هارونی','9',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('779','پردنجان','پردنجان','9',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('780','چلیچه','چلیچه','9',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('781','گوجان','گوجان','9',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('782','بازفت','بازفت','9',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('783','صمصامی','صمصامی','9',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('784','دستنا','دستنا','9',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('785','سردشت','سردشت','9',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('786','منج','منج','9',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('787','ارسک','ارسک','10',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('788','محمدشهر','محمدشهر','10',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('789','طبس مسینا','طبس-مسینا','10',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('790','قهستان','قهستان','10',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('791','گزیک','گزیک','10',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('792','حاجی آباد','حاجی-آباد-2','10',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('793','زهان','زهان','10',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('794','مود','مود','10',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('795','دیهوک','دیهوک','10',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('796','طبس','طبس','10',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('798','آرین شهر','آرین-شهر','10',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('799','اسفدن','اسفدن','10',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('802','نیمبلوک','نیمبلوک','10',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('803','یونسی','یونسی','11',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('804','شهراباد','شهراباد','11',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('805','مشهدریزه','مشهدریزه','11',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('806','احمدابادصولت','احمدابادصولت','11',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('807','نیل شهر','نیل-شهر','11',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('808','گلبهار','گلبهار','11',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('809','گلمکان','گلمکان','11',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('811','کندر','کندر','11',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('812','سلامی','سلامی','11',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('813','جنگل','جنگل','11',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('814','روداب','روداب','11',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('815','مزدآوند','مزدآوند','11',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('816','سفیدسنگ','سفیدسنگ','11',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('817','همت آباد','همت-آباد','11',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('818','شهرزو','شهرزو','11',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('819','مشهد ثامن','مشهد-ثامن','11',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('820','شادمهر','شادمهر','11',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('821','بار','بار','11',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('822','درود','درود','11',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('823','چناران شهر','چناران-شهر','12',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('824','حصارگرمخان','حصارگرمخان','12',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('825','جاجرم','جاجرم','12',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('826','زیارت','زیارت','12',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('827','قوشخانه','قوشخانه','12',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('828','تیتکانلو','تیتکانلو','12',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('829','ایور','ایور','12',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('830','گرمه','گرمه','12',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('831','آوا','آوا','12',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('832','چویبده','چویبده','13',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('833','آبژدان','آبژدان','13',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('834','آزادی','آزادی','13',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('835','بیدروبه','بیدروبه','13',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('836','چم گلک','چم-گلک','13',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('837','الهایی','الهایی','13',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('838','میداود','میداود','13',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('839','بندرامام خمینی','بندرامام-خمینی','13',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('840','بندرماهشهر','بندرماهشهر','13',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('841','تشان','تشان','13',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('842','منصوریه','منصوریه','13',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('843','چغامیش','چغامیش','13',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('844','حمزه','حمزه','13',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('845','سیاه منصور','سیاه-منصور','13',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('846','شمس آباد','شمس-آباد','13',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('847','شهر امام','شهر-امام','13',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('848','ابوحمیظه','ابوحمیظه','13',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('849','کوت سیدنعیم','کوت-سیدنعیم','13',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('850','مشراگه','مشراگه','13',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('851','خنافره','خنافره','13',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('852','دارخوین','دارخوین','13',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('853','شاوور','شاوور','13',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('854','فتح المبین','فتح-المبین','13',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('855','سرداران','سرداران','13',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('856','شرافت','شرافت','13',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('857','گوریه','گوریه','13',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('858','کوت عبداله','کوت-عبداله','13',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('859','ترکالکی','ترکالکی','13',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('860','جنت مکان','جنت-مکان','13',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('861','سماله','سماله','13',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('862','صالح شهر','صالح-شهر','13',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('863','گلگیر','گلگیر','13',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('865','سهرورد','سهرورد','14',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('866','کرسف','کرسف','14',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('867','نوربهار','نوربهار','14',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('868','ارمغانخانه','ارمغانخانه','14',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('869','نیک پی','نیک-پی','14',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('870','کهن آباد','کهن-آباد','15',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('871','کلاته','کلاته','15',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('872','رودیان','رودیان','15',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('873','درجزین','درجزین','15',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('874','مهدی شهر','مهدی-شهر','15',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('875','محمدان','محمدان','16',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('876','گشت','گشت','16',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('877','محمدی','محمدی','16',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('878','هیدوچ','هیدوچ','16',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('879','زرآباد','زرآباد','16',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('880','مهرستان','مهرستان','16',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('881','شهرک علی اکبر','شهرک-علی-اکبر','16',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('882','محمدآباد','محمدآباد-2','16',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('883','سورمق','سورمق','17',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('884','استهبان','استهبان','17',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('885','حسن اباد','حسن-اباد','17',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('886','دژکرد','دژکرد','17',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('887','بوانات','بوانات','17',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('888','حسامی','حسامی','17',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('889','مزایجان','مزایجان','17',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('890','مادرسلیمان','مادرسلیمان','17',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('891','دوزه','دوزه','17',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('892','سلطان شهر','سلطان-شهر','17',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('893','قادراباد','قادراباد','17',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('894','دوبرجی','دوبرجی','17',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('895','فدامی','فدامی','17',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('896','کوپن','کوپن','17',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('897','دبیران','دبیران','17',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('898','شهرپیر','شهرپیر','17',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('899','هماشهر','هماشهر','17',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('900','کوهنجان','کوهنجان','17',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('901','خانه زنیان','خانه-زنیان','17',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('902','شهرصدرا','شهرصدرا','17',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('904','دهرم','دهرم','17',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('905','نوجین','نوجین','17',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('906','قره بلاغ','قره-بلاغ','17',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('907','میانشهر','میانشهر','17',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('908','نوبندگان','نوبندگان','17',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('909','افزر','افزر','17',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('910','امام شهر','امام-شهر','17',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('911','قیر','قیر','17',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('912','کارزین [فتح آباد)','کارزین-فتح-آباد','17',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('913','مبارک آباددیز','مبارک-آباددیز','17',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('915','عمادده','عمادده','17',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('916','لطیفی','لطیفی','17',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('917','خانیمن','خانیمن','17',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('918','رامجرد','رامجرد','17',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('919','بابامنیر','بابامنیر','17',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('920','خومه زار','خومه-زار','17',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('922','خوزی','خوزی','17',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('923','قطرویه','قطرویه','17',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('924','نی ریز','نی-ریز','17',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('925','آبیک','آبیک','18',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('926','خاکعلی','خاکعلی','18',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('927','آبگرم','آبگرم','18',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('928','آوج','آوج','18',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('929','الوند','الوند','18',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('930','بیدستان','بیدستان','18',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('931','شریفیه','شریفیه','18',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('932','محمدیه','محمدیه','18',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('933','ارداق','ارداق','18',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('934','بویین زهرا','بویین-زهرا','18',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('935','دانسفهان','دانسفهان','18',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('936','سگزآباد','سگزآباد','18',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('937','شال','شال','18',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('938','اسفرورین','اسفرورین','18',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('939','تاکستان','تاکستان','18',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('940','خرمدشت','خرمدشت','18',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('941','ضیاڈآباد','ضیاڈآباد','18',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('942','نرجه','نرجه','18',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('943','اقبالیه','اقبالیه','18',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('944','رازمیان','رازمیان','18',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('945','سیردان','سیردان','18',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('946','کوهین','کوهین','18',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('947','محمودآبادنمونه','محمودآبادنمونه','18',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('948','معلم کلایه','معلم-کلایه','18',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('949','سلفچگان','سلفچگان','19',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('951','آرمرده','آرمرده','20',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('952','بانه','بانه','20',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('953','بویین سفلی','بویین-سفلی','20',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('954','کانی سور','کانی-سور','20',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('955','بابارشانی','بابارشانی','20',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('956','بیجار','بیجار','20',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('957','پیرتاج','پیرتاج','20',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('958','توپ آغاج','توپ-آغاج','20',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('959','یاسوکند','یاسوکند','20',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('960','بلبان آباد','بلبان-آباد','20',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('961','دهگلان','دهگلان','20',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('962','دیواندره','دیواندره','20',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('963','زرینه','زرینه','20',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('964','اورامان تخت','اورامان-تخت','20',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('965','سروآباد','سروآباد','20',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('966','سقز','سقز','20',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('967','صاحب','صاحب','20',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('968','شویشه','شویشه','20',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('969','دزج','دزج','20',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('970','دلبران','دلبران','20',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('971','سریش آباد','سریش-آباد','20',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('972','قروه','قروه','20',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('973','کامیاران','کامیاران','20',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('974','موچش','موچش','20',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('975','برده رشه','برده-رشه','20',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('976','چناره','چناره','20',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('977','کانی دینار','کانی-دینار','20',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('978','مریوان','مریوان','20',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('979','ارزوییه','ارزوییه','21',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('980','امین شهر','امین-شهر','21',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('981','انار','انار','21',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('982','بافت','بافت','21',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('983','بزنجان','بزنجان','21',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('984','بردسیر','بردسیر','21',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('985','دشتکار','دشتکار','21',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('986','گلزار','گلزار','21',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('987','لاله زار','لاله-زار','21',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('988','نگار','نگار','21',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('989','بروات','بروات','21',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('990','بم','بم','21',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('991','بلوک','بلوک','21',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('992','جبالبارز','جبالبارز','21',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('993','جیرفت','جیرفت','21',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('994','درب بهشت','درب-بهشت','21',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('995','رابر','رابر','21',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('996','هنزا','هنزا','21',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('997','راور','راور','21',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('998','هجدک','هجدک','21',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('999','بهرمان','بهرمان','21',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1000','رفسنجان','رفسنجان','21',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1001','صفاییه','صفاییه','21',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1002','کشکوییه','کشکوییه','21',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1003','مس سرچشمه','مس-سرچشمه','21',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1004','رودبار','رودبار','21',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1005','زهکلوت','زهکلوت','21',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1006','گنبکی','گنبکی','21',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1007','محمدآباد','محمدآباد-3','21',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1008','خانوک','خانوک','21',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1009','ریحان','ریحان','21',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1010','زرند','زرند','21',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1011','یزدان شهر','یزدان-شهر','21',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1012','بلورد','بلورد','21',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1013','پاریز','پاریز','21',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1014','خواجو شهر','خواجو-شهر','21',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1015','زیدآباد','زیدآباد','21',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1016','سیرجان','سیرجان','21',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1017','نجف شهر','نجف-شهر','21',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1018','هماشهر','هماشهر','21',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1019','جوزم','جوزم','21',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1020','خاتون اباد','خاتون-اباد','21',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1021','خورسند','خورسند','21',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1022','دهج','دهج','21',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1023','شهربابک','شهربابک','21',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1024','دوساری','دوساری','21',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1025','عنبرآباد','عنبرآباد','21',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1026','مردهک','مردهک','21',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1027','فاریاب','فاریاب','21',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1028','فهرج','فهرج','21',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1029','قلعه گنج','قلعه-گنج','21',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1030','اختیارآباد','اختیارآباد','21',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1031','اندوهجرد','اندوهجرد','21',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1032','باغین','باغین','21',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1033','جوپار','جوپار','21',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1034','چترود','چترود','21',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1035','راین','راین','21',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1036','زنگی آباد','زنگی-آباد','21',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1037','شهداد','شهداد','21',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1038','کاظم آباد','کاظم-آباد','21',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1039','گلباف','گلباف','21',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1040','ماهان','ماهان','21',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1041','محی آباد','محی-آباد','21',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1042','کوهبنان','کوهبنان','21',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1043','کیانشهر','کیانشهر','21',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1044','کهنوج','کهنوج','21',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1045','منوجان','منوجان','21',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1046','نودژ','نودژ','21',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1047','نرماشیر','نرماشیر','21',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1048','نظام شهر','نظام-شهر','21',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1049','اسلام آبادغرب','اسلام-آبادغرب','22',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1050','حمیل','حمیل','22',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1051','بانوره','بانوره','22',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1052','باینگان','باینگان','22',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1053','پاوه','پاوه','22',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1054','نودشه','نودشه','22',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1055','نوسود','نوسود','22',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1056','ازگله','ازگله','22',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1057','تازه آباد','تازه-آباد','22',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1058','جوانرود','جوانرود','22',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1059','ریجاب','ریجاب','22',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1060','کرند','کرند','22',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1061','گهواره','گهواره','22',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1062','روانسر','روانسر','22',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1063','شاهو','شاهو','22',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1064','سرپل ذهاب','سرپل-ذهاب','22',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1065','سطر','سطر','22',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1066','سنقر','سنقر','22',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1067','صحنه','صحنه','22',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1068','میان راهان','میان-راهان','22',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1069','سومار','سومار','22',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1070','قصرشیرین','قصرشیرین','22',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1071','رباط','رباط','22',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1072','کوزران','کوزران','22',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1073','هلشی','هلشی','22',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1074','کنگاور','کنگاور','22',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1075','گودین','گودین','22',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1076','سرمست','سرمست','22',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1077','گیلانغرب','گیلانغرب','22',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1078','بیستون','بیستون','22',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1079','هرسین','هرسین','22',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1080','باشت','باشت','23',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1081','چیتاب','چیتاب','23',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1082','گراب سفلی','گراب-سفلی','23',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1083','مادوان','مادوان','23',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1084','مارگون','مارگون','23',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1085','لیکک','لیکک','23',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1086','چرام','چرام','23',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1087','سرفاریاب','سرفاریاب','23',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1088','پاتاوه','پاتاوه','23',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1089','سی سخت','سی-سخت','23',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1090','دهدشت','دهدشت','23',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1091','دیشموک','دیشموک','23',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1092','سوق','سوق','23',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1093','قلعه رییسی','قلعه-رییسی','23',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1094','دوگنبدان','دوگنبدان','23',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1095','لنده','لنده','23',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1096','آزادشهر','آزادشهر','24',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1097','نگین شهر','نگین-شهر','24',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1098','نوده خاندوز','نوده-خاندوز','24',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1099','آق قلا','آق-قلا','24',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1100','انبارآلوم','انبارآلوم','24',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1101','بندرگز','بندرگز','24',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1102','نوکنده','نوکنده','24',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1103','بندرترکمن','بندرترکمن','24',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1104','تاتارعلیا','تاتارعلیا','24',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1105','خان ببین','خان-ببین','24',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1106','دلند','دلند','24',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1107','رامیان','رامیان','24',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1108','سنگدوین','سنگدوین','24',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1109','علی اباد','علی-اباد','24',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1110','فاضل آباد','فاضل-آباد','24',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1111','مزرعه','مزرعه','24',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1112','کردکوی','کردکوی','24',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1113','فراغی','فراغی','24',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1114','کلاله','کلاله','24',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1115','گالیکش','گالیکش','24',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1116','جلین','جلین','24',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1117','سرخنکلاته','سرخنکلاته','24',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1118','سیمین شهر','سیمین-شهر','24',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1119','گمیش تپه','گمیش-تپه','24',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1120','اینچه برون','اینچه-برون','24',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1121','گنبدکاووس','گنبدکاووس','24',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1122','مراوه','مراوه','24',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1123','مینودشت','مینودشت','24',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1124','لوندویل','لوندویل','25',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1125','آستانه اشرفیه','آستانه-اشرفیه','25',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1126','کیاشهر','کیاشهر','25',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1127','املش','املش','25',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1128','رانکوه','رانکوه','25',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1129','خشکبیجار','خشکبیجار','25',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1130','سنگر','سنگر','25',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1131','کوچصفهان','کوچصفهان','25',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1132','لشت نشاء','لشت-نشا','25',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1133','لولمان','لولمان','25',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1134','پره سر','پره-سر','25',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1135','رضوانشهر','رضوانشهر','25',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1136','بره سر','بره-سر','25',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1137','توتکابن','توتکابن','25',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1138','جیرنده','جیرنده','25',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1139','رستم آباد','رستم-آباد','25',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1140','رودبار','رودبار','25',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1141','لوشان','لوشان','25',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1142','منجیل','منجیل','25',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1143','چابکسر','چابکسر','25',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1144','رحیم آباد','رحیم-آباد','25',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1145','رودسر','رودسر','25',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1146','کلاچای','کلاچای','25',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1147','واجارگاه','واجارگاه','25',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1148','دیلمان','دیلمان','25',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1149','سیاهکل','سیاهکل','25',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1150','احمدسرگوراب','احمدسرگوراب','25',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1151','شفت','شفت','25',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1152','صومعه سرا','صومعه-سرا','25',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1153','گوراب زرمیخ','گوراب-زرمیخ','25',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1154','مرجقل','مرجقل','25',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1155','اسالم','اسالم','25',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1156','چوبر','چوبر','25',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1157','حویق','حویق','25',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1158','لیسار','لیسار','25',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1159','هشتپر [تالش)','هشتپر-تالش','25',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1160','ماسوله','ماسوله','25',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1161','ماکلوان','ماکلوان','25',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1162','رودبنه','رودبنه','25',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1163','اطاقور','اطاقور','25',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1164','چاف و چمخاله','چاف-و-چمخاله','25',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1165','شلمان','شلمان','25',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1166','کومله','کومله','25',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1167','لنگرود','لنگرود','25',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1168','بازار جمعه','بازار-جمعه','25',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1169','ماسال','ماسال','25',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1170','ازنا','ازنا','26',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1171','مومن آباد','مومن-آباد','26',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1172','الیگودرز','الیگودرز','26',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1173','شول آباد','شول-آباد','26',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1174','اشترینان','اشترینان','26',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1175','بروجرد','بروجرد','26',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1176','پلدختر','پلدختر','26',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1177','معمولان','معمولان','26',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1178','بیران شهر','بیران-شهر','26',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1179','زاغه','زاغه','26',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1180','سپیددشت','سپیددشت','26',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1181','نورآباد','نورآباد','26',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1182','هفت چشمه','هفت-چشمه','26',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1183','چالانچولان','چالانچولان','26',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1184','دورود','دورود','26',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1185','سراب دوره','سراب-دوره','26',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1186','ویسیان','ویسیان','26',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1187','چقابل','چقابل','26',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1188','الشتر','الشتر','26',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1189','فیروزآباد','فیروزآباد','26',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1190','درب گنبد','درب-گنبد','26',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1191','کوهدشت','کوهدشت','26',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1192','کوهنانی','کوهنانی','26',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1193','گراب','گراب','26',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1194','آمل','آمل','27',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1195','امامزاده عبدالله','امامزاده-عبدالله','27',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1196','دابودشت','دابودشت','27',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1197','رینه','رینه','27',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1198','گزنک','گزنک','27',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1199','امیرکلا','امیرکلا','27',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1200','خوش رودپی','خوش-رودپی','27',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1201','زرگرمحله','زرگرمحله','27',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1202','گتاب','گتاب','27',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1203','گلوگاه','گلوگاه','27',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1204','مرزیکلا','مرزیکلا','27',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1205','بابلسر','بابلسر','27',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1206','بهنمیر','بهنمیر','27',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1207','هادی شهر','هادی-شهر','27',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1208','خلیل شهر','خلیل-شهر','27',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1209','رستمکلا','رستمکلا','27',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1210','تنکابن','تنکابن','27',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1211','خرم آباد','خرم-آباد-2','27',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1212','شیرود','شیرود','27',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1213','نشتارود','نشتارود','27',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1214','جویبار','جویبار','27',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1215','کوهی خیل','کوهی-خیل','27',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1216','چالوس','چالوس','27',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1217','مرزن آباد','مرزن-آباد','27',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1218','هچیرود','هچیرود','27',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1219','رامسر','رامسر','27',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1220','کتالم وسادات شهر','کتالم-وسادات-شهر','27',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1221','پایین هولار','پایین-هولار','27',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1222','فریم','فریم','27',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1223','کیاسر','کیاسر','27',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1224','آلاشت','آلاشت','27',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1225','پل سفید','پل-سفید','27',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1226','زیرآب','زیرآب','27',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1227','شیرگاه','شیرگاه','27',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1228','کیاکلا','کیاکلا','27',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1229','سلمان شهر','سلمان-شهر','27',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1230','عباس اباد','عباس-اباد','27',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1231','کلارآباد','کلارآباد','27',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1232','فریدونکنار','فریدونکنار','27',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1233','ارطه','ارطه','27',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1234','قایم شهر','قایم-شهر','27',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1235','کلاردشت','کلاردشت','27',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1236','سرخرود','سرخرود','27',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1237','محمودآباد','محمودآباد-2','27',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1238','سورک','سورک','27',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1239','نکا','نکا','27',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1240','ایزدشهر','ایزدشهر','27',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1241','بلده','بلده','27',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1242','چمستان','چمستان','27',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1243','رویان','رویان','27',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1244','نور','نور','27',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1245','پول','پول','27',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1246','کجور','کجور','27',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1247','نوشهر','نوشهر','27',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1248','آشتیان','آشتیان','28',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1249','داودآباد','داودآباد','28',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1250','ساروق','ساروق','28',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1251','کارچان','کارچان','28',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1252','تفرش','تفرش','28',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1253','خمین','خمین','28',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1254','قورچی باشی','قورچی-باشی','28',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1255','جاورسیان','جاورسیان','28',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1256','خنداب','خنداب','28',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1257','دلیجان','دلیجان','28',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1258','نراق','نراق','28',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1259','پرندک','پرندک','28',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1260','خشکرود','خشکرود','28',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1261','رازقان','رازقان','28',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1262','زاویه','زاویه','28',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1263','مامونیه','مامونیه','28',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1264','آوه','آوه','28',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1265','ساوه','ساوه','28',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1266','غرق آباد','غرق-آباد','28',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1267','نوبران','نوبران','28',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1268','آستانه','آستانه','28',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1269','توره','توره','28',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1270','شازند','شازند','28',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1271','شهباز','شهباز','28',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1272','مهاجران','مهاجران','28',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1273','هندودر','هندودر','28',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1274','خنجین','خنجین','28',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1275','فرمهین','فرمهین','28',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1276','کمیجان','کمیجان','28',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1277','میلاجرد','میلاجرد','28',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1278','محلات','محلات','28',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1279','نیمور','نیمور','28',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1280','ابوموسی','ابوموسی','29',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1281','بستک','بستک','29',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1282','جناح','جناح','29',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1283','سردشت','سردشت','29',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1284','گوهران','گوهران','29',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1285','تازیان پایین','تازیان-پایین','29',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1286','تخت','تخت','29',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1287','فین','فین','29',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1288','قلعه قاضی','قلعه-قاضی','29',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1289','بندرلنگه','بندرلنگه','29',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1290','چارک','چارک','29',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1291','کنگ','کنگ','29',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1292','کیش','کیش','29',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1293','لمزان','لمزان','29',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1294','پارسیان','پارسیان','29',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1295','دشتی','دشتی','29',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1296','کوشکنار','کوشکنار','29',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1297','بندرجاسک','بندرجاسک','29',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1298','حاجی اباد','حاجی-اباد','29',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1299','سرگز','سرگز','29',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1300','فارغان','فارغان','29',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1301','خمیر','خمیر','29',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1302','رویدر','رویدر','29',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1303','بیکاء','بیکا','29',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1304','دهبارز','دهبارز','29',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1305','زیارتعلی','زیارتعلی','29',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1306','سیریک','سیریک','29',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1307','کوهستک','کوهستک','29',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1308','گروک','گروک','29',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1309','درگهان','درگهان','29',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1310','سوزا','سوزا','29',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1311','قشم','قشم','29',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1312','هرمز','هرمز','29',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1313','تیرور','تیرور','29',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1314','سندرک','سندرک','29',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1315','میناب','میناب','29',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1316','هشتبندی','هشتبندی','29',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1317','آجین','آجین','30',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1318','اسدآباد','اسدآباد','30',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1319','بهار','بهار','30',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1320','صالح آباد','صالح-آباد','30',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1321','لالجین','لالجین','30',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1322','مهاجران','مهاجران','30',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1323','تویسرکان','تویسرکان','30',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1324','سرکان','سرکان','30',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1325','فرسفج','فرسفج','30',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1326','دمق','دمق','30',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1327','رزن','رزن','30',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1328','قروه درجزین','قروه-درجزین','30',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1329','فامنین','فامنین','30',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1330','شیرین سو','شیرین-سو','30',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1331','کبودرآهنگ','کبودرآهنگ','30',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1332','گل تپه','گل-تپه','30',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1333','ازندریان','ازندریان','30',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1334','جوکار','جوکار','30',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1335','زنگنه','زنگنه','30',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1336','سامن','سامن','30',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1337','ملایر','ملایر','30',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1338','برزول','برزول','30',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1339','فیروزان','فیروزان','30',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1340','گیان','گیان','30',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1341','نهاوند','نهاوند','30',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1342','جورقان','جورقان','30',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1343','قهاوند','قهاوند','30',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1344','مریانج','مریانج','30',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1345','ابرکوه','ابرکوه','31',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1346','مهردشت','مهردشت','31',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1347','احمدآباد','احمدآباد','31',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1348','اردکان','اردکان-2','31',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1349','عقدا','عقدا','31',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1350','اشکذر','اشکذر','31',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1351','خضرآباد','خضرآباد','31',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1352','بافق','بافق','31',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1353','بهاباد','بهاباد','31',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1354','تفت','تفت','31',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1355','نیر','نیر','31',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1356','مروست','مروست','31',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1357','هرات','هرات','31',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1358','مهریز','مهریز','31',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1359','بفروییه','بفروییه','31',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1360','میبد','میبد','31',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1361','ندوشن','ندوشن','31',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1362','حمیدیا','حمیدیا','31',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1363','زارچ','زارچ','31',NULL,NULL);
INSERT INTO `tbl_cities` VALUES ('1364','شاهدیه','شاهدیه','31',NULL,NULL);
UNLOCK TABLES;

-- Table structure for table `tbl_color_palettes`

DROP TABLE IF EXISTS `tbl_color_palettes`;
CREATE TABLE `tbl_color_palettes` (
  `id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(255) NOT NULL,
  `settings` text,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=6 DEFAULT CHARSET=utf8mb3;

-- Dumping data for table `tbl_color_palettes`

LOCK TABLES `tbl_color_palettes` WRITE;
INSERT INTO `tbl_color_palettes` VALUES ('1','سبز','{\"colors\":{\"HEADER\":\"rgb(54, 99, 41)\",\"BUTTONS\":\"rgb(74, 119, 61)\",\"ICONS\":\"rgb(154, 199, 141)\",\"ICONS_ON_BUTTONS\":\"rgb(154, 199, 141)\",\"REGISTER_BUTTON\":\"rgb(99, 41, 54)\",\"SEARCH_BACKGROUND\":\"rgb(108, 197, 81)\",\"FOOTER\":\"rgb(73, 128, 57)\",\"COPYRIGHT\":\"rgb(54, 99, 41)\",\"PROFILE_INTRO\":\"rgb(106, 191, 164)\"}}');
INSERT INTO `tbl_color_palettes` VALUES ('2','آبی','{\"colors\":{\"HEADER\":\"rgb(46, 63, 110)\",\"BUTTONS\":\"rgb(56, 79, 149)\",\"ICONS\":\"rgb(77, 183, 254)\",\"ICONS_ON_BUTTONS\":\"rgb(77, 183, 254)\",\"REGISTER_BUTTON\":\"rgb(77, 183, 254)\",\"SEARCH_BACKGROUND\":\"rgb(97, 127, 217)\",\"FOOTER\":\"#325096\",\"COPYRIGHT\":\"rgb(37, 57, 102)\",\"PROFILE_INTRO\":\"rgb(77, 183, 254)\"}}');
INSERT INTO `tbl_color_palettes` VALUES ('3','جگری','{\"colors\":{\"HEADER\":\"rgb(128, 44, 62)\",\"BUTTONS\":\"rgb(177, 71, 94)\",\"ICONS\":\"rgb(228, 144, 162)\",\"ICONS_ON_BUTTONS\":\"rgb(255, 248, 250)\",\"REGISTER_BUTTON\":\"rgb(33, 200, 154)\",\"SEARCH_BACKGROUND\":\"rgb(255, 87, 124)\",\"FOOTER\":\"rgb(138, 54, 72)\",\"COPYRIGHT\":\"rgb(108, 24, 42)\",\"PROFILE_INTRO\":\"rgb(208, 66, 99)\"}}');
INSERT INTO `tbl_color_palettes` VALUES ('4','نیلی','{\"colors\":{\"HEADER\":\"rgb(44, 97, 128)\",\"BUTTONS\":\"rgb(44, 97, 128)\",\"ICONS\":\"rgb(174, 201, 216)\",\"ICONS_ON_BUTTONS\":\"rgb(251, 251, 251)\",\"REGISTER_BUTTON\":\"rgb(108, 152, 178)\",\"SEARCH_BACKGROUND\":\"rgb(87, 193, 255)\",\"FOOTER\":\"rgb(57, 110, 140)\",\"COPYRIGHT\":\"rgb(30, 67, 89)\",\"PROFILE_INTRO\":\"rgb(59, 142, 191)\"}}');
INSERT INTO `tbl_color_palettes` VALUES ('5','بنفش','{\"colors\":{\"HEADER\":\"rgb(95, 34, 99)\",\"BUTTONS\":\"rgb(118, 57, 122)\",\"ICONS\":\"rgb(198, 137, 202)\",\"ICONS_ON_BUTTONS\":\"rgb(198, 137, 202)\",\"REGISTER_BUTTON\":\"rgb(37, 102, 98)\",\"SEARCH_BACKGROUND\":\"rgb(190, 68, 198)\",\"FOOTER\":\"rgb(118, 57, 122)\",\"COPYRIGHT\":\"rgb(48, 0, 52)\",\"PROFILE_INTRO\":\"rgb(180, 77, 187)\"}}');
UNLOCK TABLES;

-- Table structure for table `tbl_comments`

DROP TABLE IF EXISTS `tbl_comments`;
CREATE TABLE `tbl_comments` (
  `id` int NOT NULL AUTO_INCREMENT,
  `type` varchar(10) DEFAULT 'ads',
  `post_id` int NOT NULL,
  `user_id` int NOT NULL,
  `text` text NOT NULL,
  `parent_id` int NOT NULL DEFAULT '0',
  `status` smallint NOT NULL DEFAULT '0' COMMENT '0:not_accepted;1:rejected;2:accepted;3:spam',
  `created_at` datetime NOT NULL,
  `ip` varchar(100) NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

-- Dumping data for table `tbl_comments`

LOCK TABLES `tbl_comments` WRITE;
UNLOCK TABLES;

-- Table structure for table `tbl_coupons`

DROP TABLE IF EXISTS `tbl_coupons`;
CREATE TABLE `tbl_coupons` (
  `id` int NOT NULL AUTO_INCREMENT,
  `title` varchar(255) DEFAULT NULL,
  `code` varchar(255) NOT NULL,
  `type` varchar(100) NOT NULL,
  `discount` varchar(255) DEFAULT NULL,
  `description` text,
  `status` tinyint(1) NOT NULL DEFAULT '1',
  `updated_at` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `created_at` timestamp NOT NULL DEFAULT '0000-00-00 00:00:00',
  `expires_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`),
  UNIQUE KEY `code` (`code`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

-- Dumping data for table `tbl_coupons`

LOCK TABLES `tbl_coupons` WRITE;
UNLOCK TABLES;

-- Table structure for table `tbl_custom_field_options`

DROP TABLE IF EXISTS `tbl_custom_field_options`;
CREATE TABLE `tbl_custom_field_options` (
  `id` int NOT NULL AUTO_INCREMENT,
  `custom_field_id` int NOT NULL,
  `option_key` varchar(255) NOT NULL,
  `option_value` varchar(255) DEFAULT NULL,
  `selected` smallint NOT NULL DEFAULT '0',
  `sort` int NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `custom_field_id` (`custom_field_id`),
  CONSTRAINT `tbl_custom_field_options_ibfk_1` FOREIGN KEY (`custom_field_id`) REFERENCES `tbl_custom_fields` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=260 DEFAULT CHARSET=utf8mb3;

-- Dumping data for table `tbl_custom_field_options`

LOCK TABLES `tbl_custom_field_options` WRITE;
INSERT INTO `tbl_custom_field_options` VALUES ('1','3',1,'یک','0','2');
INSERT INTO `tbl_custom_field_options` VALUES ('2','3',2,'دو','0','3');
INSERT INTO `tbl_custom_field_options` VALUES ('3','3',3,'سه','0','4');
INSERT INTO `tbl_custom_field_options` VALUES ('5','4','sale','فروشی','1','1');
INSERT INTO `tbl_custom_field_options` VALUES ('7','5','yes','بلی','0','2');
INSERT INTO `tbl_custom_field_options` VALUES ('8','5','no','خیر','1','1');
INSERT INTO `tbl_custom_field_options` VALUES ('30','8',1,'یک','0','2');
INSERT INTO `tbl_custom_field_options` VALUES ('31','8',2,'دو','0','3');
INSERT INTO `tbl_custom_field_options` VALUES ('32','8',3,'سه','0','4');
INSERT INTO `tbl_custom_field_options` VALUES ('33','8',4,'چهار','0','5');
INSERT INTO `tbl_custom_field_options` VALUES ('34','8','5+','پنج یا بیشتر','0','6');
INSERT INTO `tbl_custom_field_options` VALUES ('35','9','sell','ارائه','1','1');
INSERT INTO `tbl_custom_field_options` VALUES ('36','9','request','درخواستی','0','2');
INSERT INTO `tbl_custom_field_options` VALUES ('37','10','yes','بلی','0','2');
INSERT INTO `tbl_custom_field_options` VALUES ('38','10','no','خیر','1','1');
INSERT INTO `tbl_custom_field_options` VALUES ('39','8','none','بدون اتاق','1','1');
INSERT INTO `tbl_custom_field_options` VALUES ('40','3','none','بدون اتاق','1','1');
INSERT INTO `tbl_custom_field_options` VALUES ('41','3',4,'چهار','0','5');
INSERT INTO `tbl_custom_field_options` VALUES ('42','3','5+','پنج یا بیشتر','0','6');
INSERT INTO `tbl_custom_field_options` VALUES ('43','4','request','درخواستی','0','2');
INSERT INTO `tbl_custom_field_options` VALUES ('44','13','none','بدون اتاق','1','1');
INSERT INTO `tbl_custom_field_options` VALUES ('45','13',1,'یک','0','2');
INSERT INTO `tbl_custom_field_options` VALUES ('46','13',2,'دو','0','3');
INSERT INTO `tbl_custom_field_options` VALUES ('47','13',3,'سه','0','4');
INSERT INTO `tbl_custom_field_options` VALUES ('48','13',4,'چهار','0','5');
INSERT INTO `tbl_custom_field_options` VALUES ('49','13','5+','پنج یا بیشتر','0','6');
INSERT INTO `tbl_custom_field_options` VALUES ('50','14','sell','فروشی','1','1');
INSERT INTO `tbl_custom_field_options` VALUES ('51','14','request','درخواستی','0','2');
INSERT INTO `tbl_custom_field_options` VALUES ('52','15','no','خیر','1','1');
INSERT INTO `tbl_custom_field_options` VALUES ('53','15','yes','بلی','0','2');
INSERT INTO `tbl_custom_field_options` VALUES ('54','16','no','ندارد','1','1');
INSERT INTO `tbl_custom_field_options` VALUES ('55','16','yes','دارد','0','2');
INSERT INTO `tbl_custom_field_options` VALUES ('56','19','sell','ارائه','1','1');
INSERT INTO `tbl_custom_field_options` VALUES ('57','19','request','درخواستی','0','2');
INSERT INTO `tbl_custom_field_options` VALUES ('58','20','no','خیر','1','1');
INSERT INTO `tbl_custom_field_options` VALUES ('59','20','yes','بله','0','2');
INSERT INTO `tbl_custom_field_options` VALUES ('60','21','none','بدون اتاق','1','1');
INSERT INTO `tbl_custom_field_options` VALUES ('61','21',1,'یک','0','2');
INSERT INTO `tbl_custom_field_options` VALUES ('62','21',2,'دو','0','3');
INSERT INTO `tbl_custom_field_options` VALUES ('63','21',3,'سه','0','4');
INSERT INTO `tbl_custom_field_options` VALUES ('64','21',4,'چهار','0','5');
INSERT INTO `tbl_custom_field_options` VALUES ('65','21','5+','پنج یا بیشتر','0','6');
INSERT INTO `tbl_custom_field_options` VALUES ('66','23','mvm','ام وی ام :: MVM','1','1');
INSERT INTO `tbl_custom_field_options` VALUES ('67','23','benz','بنز :: Mercedes Benz','0','2');
INSERT INTO `tbl_custom_field_options` VALUES ('68','23','bmw','بی ام و :: BMW','0','3');
INSERT INTO `tbl_custom_field_options` VALUES ('69','23','pride-sandogh','پراید صندوق دار :: Pride','0','4');
INSERT INTO `tbl_custom_field_options` VALUES ('70','23','pride-hback','پراید هاچ بک :: Pride','0','5');
INSERT INTO `tbl_custom_field_options` VALUES ('71','23','peugeot-206','پژو 206 :: peugeot 206','0','6');
INSERT INTO `tbl_custom_field_options` VALUES ('72','23','peugeot-206-sandogh','پژو 206 صندوق دار :: peugeot 206','0','7');
INSERT INTO `tbl_custom_field_options` VALUES ('73','23','peugeot-207','پژو 207 :: peugeot 207','0','8');
INSERT INTO `tbl_custom_field_options` VALUES ('74','23','peugeot-405','پژو 405 :: peugeot 405','0','9');
INSERT INTO `tbl_custom_field_options` VALUES ('75','23','peugeot-pars','پژو پارس :: peugeot Pars','0','10');
INSERT INTO `tbl_custom_field_options` VALUES ('76','23','peugeot-roa','پژو روآ/آردی :: ROA/RD','0','11');
INSERT INTO `tbl_custom_field_options` VALUES ('77','23','peykan','پیکان :: Peykan','0','12');
INSERT INTO `tbl_custom_field_options` VALUES ('78','23','tondar90','تندر 90 :: Tondar 90','0','13');
INSERT INTO `tbl_custom_field_options` VALUES ('79','23','toyota','تویوتا :: Toyota','0','14');
INSERT INTO `tbl_custom_field_options` VALUES ('80','23','tiba','تیبا :: Tiba','0','15');
INSERT INTO `tbl_custom_field_options` VALUES ('81','23','daewo','دوو :: Daewo','0','16');
INSERT INTO `tbl_custom_field_options` VALUES ('82','23','renault','رنو :: Renault','0','17');
INSERT INTO `tbl_custom_field_options` VALUES ('83','23','citroen-xantia','زانتیا :: Citroen Xantia','0','18');
INSERT INTO `tbl_custom_field_options` VALUES ('84','23','samand','سمند :: Samand','0','19');
INSERT INTO `tbl_custom_field_options` VALUES ('85','23','kia','کیا :: Kia','0','20');
INSERT INTO `tbl_custom_field_options` VALUES ('86','23','gol','گل :: Gol','0','21');
INSERT INTO `tbl_custom_field_options` VALUES ('87','23','lifan','لیفان :: Lifan','0','22');
INSERT INTO `tbl_custom_field_options` VALUES ('88','23','mazda','مزدا :: Mazda','0','23');
INSERT INTO `tbl_custom_field_options` VALUES ('89','23','nissan','نیسان :: Nissan','0','24');
INSERT INTO `tbl_custom_field_options` VALUES ('90','23','vanet','وانت','0','25');
INSERT INTO `tbl_custom_field_options` VALUES ('91','23','hyundai-azera','هیوندای آزرا :: Hyundai Azera','0','26');
INSERT INTO `tbl_custom_field_options` VALUES ('92','23','hyundai-sonata','هیوندای سوناتا :: Hyundai Sonata','0','27');
INSERT INTO `tbl_custom_field_options` VALUES ('93','23','hyundai','هیوندای (غیره) :: Hyundai','0','28');
INSERT INTO `tbl_custom_field_options` VALUES ('94','23','other','سایر','0','29');
INSERT INTO `tbl_custom_field_options` VALUES ('101','24',1397,1397,'0','5');
INSERT INTO `tbl_custom_field_options` VALUES ('102','24',1396,1396,'0','6');
INSERT INTO `tbl_custom_field_options` VALUES ('103','24',1395,1395,'0','7');
INSERT INTO `tbl_custom_field_options` VALUES ('104','24',1394,1394,'0','8');
INSERT INTO `tbl_custom_field_options` VALUES ('105','24',1393,1393,'0','9');
INSERT INTO `tbl_custom_field_options` VALUES ('106','24',1392,1392,'0','10');
INSERT INTO `tbl_custom_field_options` VALUES ('107','24',1391,1391,'0','11');
INSERT INTO `tbl_custom_field_options` VALUES ('108','24',1390,1390,'0','12');
INSERT INTO `tbl_custom_field_options` VALUES ('109','24',1389,1389,'0','13');
INSERT INTO `tbl_custom_field_options` VALUES ('110','24',1388,1388,'0','14');
INSERT INTO `tbl_custom_field_options` VALUES ('111','24',1387,1387,'0','15');
INSERT INTO `tbl_custom_field_options` VALUES ('112','24',1386,1386,'0','16');
INSERT INTO `tbl_custom_field_options` VALUES ('113','24',1385,1385,'0','17');
INSERT INTO `tbl_custom_field_options` VALUES ('114','24',1384,1384,'0','18');
INSERT INTO `tbl_custom_field_options` VALUES ('115','24',1383,1383,'0','19');
INSERT INTO `tbl_custom_field_options` VALUES ('116','24',1382,1382,'0','20');
INSERT INTO `tbl_custom_field_options` VALUES ('117','24',1381,1381,'0','21');
INSERT INTO `tbl_custom_field_options` VALUES ('118','24',1380,1380,'0','22');
INSERT INTO `tbl_custom_field_options` VALUES ('119','24',1379,1379,'0','23');
INSERT INTO `tbl_custom_field_options` VALUES ('120','24',1378,1378,'0','24');
INSERT INTO `tbl_custom_field_options` VALUES ('121','24',1377,1377,'0','25');
INSERT INTO `tbl_custom_field_options` VALUES ('122','24',1376,1376,'0','26');
INSERT INTO `tbl_custom_field_options` VALUES ('123','24',1375,1375,'0','27');
INSERT INTO `tbl_custom_field_options` VALUES ('124','24',1374,1374,'0','28');
INSERT INTO `tbl_custom_field_options` VALUES ('125','24',1373,1373,'0','29');
INSERT INTO `tbl_custom_field_options` VALUES ('126','24',1372,1372,'0','30');
INSERT INTO `tbl_custom_field_options` VALUES ('127','24',1371,1371,'0','31');
INSERT INTO `tbl_custom_field_options` VALUES ('128','24',1370,1370,'0','32');
INSERT INTO `tbl_custom_field_options` VALUES ('129','24',1369,1369,'0','33');
INSERT INTO `tbl_custom_field_options` VALUES ('130','24',1368,1368,'0','34');
INSERT INTO `tbl_custom_field_options` VALUES ('131','24',1367,1367,'0','35');
INSERT INTO `tbl_custom_field_options` VALUES ('132','24',1366,1366,'0','36');
INSERT INTO `tbl_custom_field_options` VALUES ('133','24',1365,1365,'0','37');
INSERT INTO `tbl_custom_field_options` VALUES ('134','26','sell','فروشی','1','1');
INSERT INTO `tbl_custom_field_options` VALUES ('135','26','rent','اجاره ای','0','2');
INSERT INTO `tbl_custom_field_options` VALUES ('136','26','request','درخواستی','0','3');
INSERT INTO `tbl_custom_field_options` VALUES ('137','28','sell','فروشی','1','1');
INSERT INTO `tbl_custom_field_options` VALUES ('138','28','rent','اجاره ای','0','2');
INSERT INTO `tbl_custom_field_options` VALUES ('139','28','request','درخواستی','0','3');
INSERT INTO `tbl_custom_field_options` VALUES ('140','30','sell','فروشی','1','1');
INSERT INTO `tbl_custom_field_options` VALUES ('141','30','rent','اجاره ای','0','2');
INSERT INTO `tbl_custom_field_options` VALUES ('142','30','request','درخواستی','0','3');
INSERT INTO `tbl_custom_field_options` VALUES ('143','32',1397,1397,'1','5');
INSERT INTO `tbl_custom_field_options` VALUES ('144','32',1396,1396,'0','6');
INSERT INTO `tbl_custom_field_options` VALUES ('145','34','sell','فروشی','1','1');
INSERT INTO `tbl_custom_field_options` VALUES ('146','34','rent','اجاره ای','0','2');
INSERT INTO `tbl_custom_field_options` VALUES ('147','34','request','درخواستی','0','3');
INSERT INTO `tbl_custom_field_options` VALUES ('148','32',1395,1395,'0','7');
INSERT INTO `tbl_custom_field_options` VALUES ('149','32',1394,1394,'0','8');
INSERT INTO `tbl_custom_field_options` VALUES ('150','32',1393,1393,'0','9');
INSERT INTO `tbl_custom_field_options` VALUES ('151','32',1392,1392,'0','10');
INSERT INTO `tbl_custom_field_options` VALUES ('152','32',1391,1391,'0','11');
INSERT INTO `tbl_custom_field_options` VALUES ('153','32',1390,1390,'0','12');
INSERT INTO `tbl_custom_field_options` VALUES ('154','32',1389,1389,'0','13');
INSERT INTO `tbl_custom_field_options` VALUES ('155','32',1388,1388,'0','14');
INSERT INTO `tbl_custom_field_options` VALUES ('156','32',1387,1387,'0','15');
INSERT INTO `tbl_custom_field_options` VALUES ('157','32',1386,1386,'0','16');
INSERT INTO `tbl_custom_field_options` VALUES ('158','32',1385,1385,'0','17');
INSERT INTO `tbl_custom_field_options` VALUES ('159','32',1384,1384,'0','18');
INSERT INTO `tbl_custom_field_options` VALUES ('160','32',1383,1383,'0','19');
INSERT INTO `tbl_custom_field_options` VALUES ('161','32',1382,1382,'0','20');
INSERT INTO `tbl_custom_field_options` VALUES ('162','32',1381,1381,'0','21');
INSERT INTO `tbl_custom_field_options` VALUES ('163','32',1380,1380,'0','22');
INSERT INTO `tbl_custom_field_options` VALUES ('164','32',1379,1379,'0','23');
INSERT INTO `tbl_custom_field_options` VALUES ('165','32',1378,1378,'0','24');
INSERT INTO `tbl_custom_field_options` VALUES ('166','32',1377,1377,'0','25');
INSERT INTO `tbl_custom_field_options` VALUES ('167','32',1376,1376,'0','26');
INSERT INTO `tbl_custom_field_options` VALUES ('168','32',1375,1375,'0','27');
INSERT INTO `tbl_custom_field_options` VALUES ('169','32',1374,1374,'0','28');
INSERT INTO `tbl_custom_field_options` VALUES ('170','32',1373,1373,'0','29');
INSERT INTO `tbl_custom_field_options` VALUES ('171','32',1372,1372,'0','30');
INSERT INTO `tbl_custom_field_options` VALUES ('172','32',1371,1371,'0','31');
INSERT INTO `tbl_custom_field_options` VALUES ('173','32',1370,1370,'0','32');
INSERT INTO `tbl_custom_field_options` VALUES ('174','32',1369,1369,'0','33');
INSERT INTO `tbl_custom_field_options` VALUES ('175','32',1368,1368,'0','34');
INSERT INTO `tbl_custom_field_options` VALUES ('176','32',1367,1367,'0','35');
INSERT INTO `tbl_custom_field_options` VALUES ('177','32',1366,1366,'0','36');
INSERT INTO `tbl_custom_field_options` VALUES ('178','32',1365,1365,'0','37');
INSERT INTO `tbl_custom_field_options` VALUES ('179','36','sell','فروشی','1','1');
INSERT INTO `tbl_custom_field_options` VALUES ('180','36','rent','اجاره ای','0','2');
INSERT INTO `tbl_custom_field_options` VALUES ('181','36','request','درخواستی','0','3');
INSERT INTO `tbl_custom_field_options` VALUES ('182','44','sell','فروشی','1','1');
INSERT INTO `tbl_custom_field_options` VALUES ('183','44','request','درخواستی','0','2');
INSERT INTO `tbl_custom_field_options` VALUES ('184','45','acer','ایسر :: Acer','1','1');
INSERT INTO `tbl_custom_field_options` VALUES ('185','45','apple','اپل :: Apple','0','2');
INSERT INTO `tbl_custom_field_options` VALUES ('186','45','asus','ایسوس :: Asus','0','3');
INSERT INTO `tbl_custom_field_options` VALUES ('187','45','compaq','کامپک :: Compaq','0','4');
INSERT INTO `tbl_custom_field_options` VALUES ('188','45','dell','دل :: Dell','0','5');
INSERT INTO `tbl_custom_field_options` VALUES ('189','45','fujitsu','فوجیتسو :: Fujitsu','0','6');
INSERT INTO `tbl_custom_field_options` VALUES ('190','45','gigabyte','گیگابایت :: Gigabyte','0','7');
INSERT INTO `tbl_custom_field_options` VALUES ('191','45','hp','اچ پی :: HP','0','8');
INSERT INTO `tbl_custom_field_options` VALUES ('192','45','lenovo','لنوو :: Lenovo','0','9');
INSERT INTO `tbl_custom_field_options` VALUES ('193','45','msi','ام اس آی :: MSI','0','10');
INSERT INTO `tbl_custom_field_options` VALUES ('194','45','samsung','سامسونگ :: Samsung','0','11');
INSERT INTO `tbl_custom_field_options` VALUES ('195','45','sony','سونی :: Sony','0','12');
INSERT INTO `tbl_custom_field_options` VALUES ('196','45','toshiba','توشیبا :: Toshiba','0','13');
INSERT INTO `tbl_custom_field_options` VALUES ('197','45','suzuki','سوزوکی :: Suzuki','0','14');
INSERT INTO `tbl_custom_field_options` VALUES ('198','45','razer','ریزر :: Razer','0','15');
INSERT INTO `tbl_custom_field_options` VALUES ('199','45','alienware','آلین ور :: Alienware','0','16');
INSERT INTO `tbl_custom_field_options` VALUES ('200','45','other','غیره','0','17');
INSERT INTO `tbl_custom_field_options` VALUES ('201','47','samsung','سامسونگ :: Acer','1','1');
INSERT INTO `tbl_custom_field_options` VALUES ('202','47','apple','اپل :: Apple','0','2');
INSERT INTO `tbl_custom_field_options` VALUES ('205','47','htc','اچ تی سی :: HTC','0','3');
INSERT INTO `tbl_custom_field_options` VALUES ('206','47','sony-erricson','سونی اریکسون :: Sony Erricson','0','4');
INSERT INTO `tbl_custom_field_options` VALUES ('207','47','nokia','نوکیا :: Nokia','0','5');
INSERT INTO `tbl_custom_field_options` VALUES ('208','47','sony','سونی :: Sony','0','6');
INSERT INTO `tbl_custom_field_options` VALUES ('209','47','lg','ال جی :: LG','0','7');
INSERT INTO `tbl_custom_field_options` VALUES ('210','47','motorola','موتورولا :: Motorolla','0','8');
INSERT INTO `tbl_custom_field_options` VALUES ('211','47','huawei','هوآوی :: Huwaei','0','9');
INSERT INTO `tbl_custom_field_options` VALUES ('212','47','blackberry','بلک بری :: BlackBerry','0','10');
INSERT INTO `tbl_custom_field_options` VALUES ('213','47','zte','زد تی ای :: ZTE','0','11');
INSERT INTO `tbl_custom_field_options` VALUES ('214','47','acer','ایسر :: Acer','0','12');
INSERT INTO `tbl_custom_field_options` VALUES ('215','47','asus','ایسوس :: Asus','0','13');
INSERT INTO `tbl_custom_field_options` VALUES ('216','47','dell','دل :: Dell','0','14');
INSERT INTO `tbl_custom_field_options` VALUES ('217','47','lenovo','لنوو :: Lenovo','0','15');
INSERT INTO `tbl_custom_field_options` VALUES ('218','47','amazon','آمازون :: Amazon','0','16');
INSERT INTO `tbl_custom_field_options` VALUES ('219','47','farassoo','فراسو :: Farassoo','0','17');
INSERT INTO `tbl_custom_field_options` VALUES ('220','47','viewsonic','ویو سونیک :: ViewSonic','0','18');
INSERT INTO `tbl_custom_field_options` VALUES ('221','47','msi','ام اس آی :: MSI','0','19');
INSERT INTO `tbl_custom_field_options` VALUES ('222','47','other','غیره','0','20');
INSERT INTO `tbl_custom_field_options` VALUES ('223','48','mci','همراه اول','1','1');
INSERT INTO `tbl_custom_field_options` VALUES ('224','48','irancell','ایرانسل','0','2');
INSERT INTO `tbl_custom_field_options` VALUES ('225','48','raitel','رایتل','0','3');
INSERT INTO `tbl_custom_field_options` VALUES ('226','46','سامسونگ :: Acer','samsung','1','1');
INSERT INTO `tbl_custom_field_options` VALUES ('227','46','اپل :: Apple','apple','0','2');
INSERT INTO `tbl_custom_field_options` VALUES ('228','46','htc','اچ تی سی :: HTC','0','3');
INSERT INTO `tbl_custom_field_options` VALUES ('229','46','sony-erricson','سونی اریکسون :: Sony Erricson','0','4');
INSERT INTO `tbl_custom_field_options` VALUES ('230','46','nokia','نوکیا :: Nokia','0','5');
INSERT INTO `tbl_custom_field_options` VALUES ('231','46','sony','سونی :: Sony','0','6');
INSERT INTO `tbl_custom_field_options` VALUES ('232','46','lg','ال جی :: LG','0','7');
INSERT INTO `tbl_custom_field_options` VALUES ('233','46','motorola','موتورولا :: Motorolla','0','8');
INSERT INTO `tbl_custom_field_options` VALUES ('234','46','huawei','هوآوی :: Huwaei','0','9');
INSERT INTO `tbl_custom_field_options` VALUES ('235','46','blackberry','بلک بری :: BlackBerry','0','10');
INSERT INTO `tbl_custom_field_options` VALUES ('236','46','zte','زد تی ای :: ZTE','0','11');
INSERT INTO `tbl_custom_field_options` VALUES ('237','46','acer','ایسر :: Acer','0','12');
INSERT INTO `tbl_custom_field_options` VALUES ('238','46','lenovo','لنوو :: Lenovo','0','13');
INSERT INTO `tbl_custom_field_options` VALUES ('239','46','smart','اسمارت :: Smart','0','14');
INSERT INTO `tbl_custom_field_options` VALUES ('240','46','microsoft','مایکروسافت :: Microsoft','0','15');
INSERT INTO `tbl_custom_field_options` VALUES ('241','46','other','غیره','0','16');
INSERT INTO `tbl_custom_field_options` VALUES ('242','39','sell','فروشی','1','1');
INSERT INTO `tbl_custom_field_options` VALUES ('243','39','request','درخواستی','0','2');
INSERT INTO `tbl_custom_field_options` VALUES ('244','41','male','مردانه','1','1');
INSERT INTO `tbl_custom_field_options` VALUES ('245','41','female','زنانه','0','2');
INSERT INTO `tbl_custom_field_options` VALUES ('246','42','boy','پسرانه','1','1');
INSERT INTO `tbl_custom_field_options` VALUES ('247','42','girl','دخترانه','0','2');
INSERT INTO `tbl_custom_field_options` VALUES ('248','50','sell','فروشی','1','1');
INSERT INTO `tbl_custom_field_options` VALUES ('249','50','request','درخواستی','0','2');
INSERT INTO `tbl_custom_field_options` VALUES ('250','52','sell','ارائه','1','1');
INSERT INTO `tbl_custom_field_options` VALUES ('251','52','request','درخواستی','0','2');
INSERT INTO `tbl_custom_field_options` VALUES ('252','24',1398,1398,'0','4');
INSERT INTO `tbl_custom_field_options` VALUES ('253','24',1399,1399,'0','3');
INSERT INTO `tbl_custom_field_options` VALUES ('254','24',1400,1400,'0','2');
INSERT INTO `tbl_custom_field_options` VALUES ('255','24',1401,1401,'1','1');
INSERT INTO `tbl_custom_field_options` VALUES ('256','32',1398,1398,'0','4');
INSERT INTO `tbl_custom_field_options` VALUES ('257','32',1399,1399,'0','3');
INSERT INTO `tbl_custom_field_options` VALUES ('258','32',1400,1400,'0','2');
INSERT INTO `tbl_custom_field_options` VALUES ('259','32',1401,1401,'0','1');
UNLOCK TABLES;

-- Table structure for table `tbl_custom_fields`

DROP TABLE IF EXISTS `tbl_custom_fields`;
CREATE TABLE `tbl_custom_fields` (
  `id` int NOT NULL AUTO_INCREMENT,
  `category_id` int NOT NULL,
  `subcategory_id` int NOT NULL,
  `type` varchar(100) DEFAULT NULL,
  `field_type` varchar(50) DEFAULT NULL,
  `field_name` varchar(255) DEFAULT NULL,
  `field_value` text,
  `title` varchar(255) DEFAULT NULL,
  `placeholder` varchar(255) DEFAULT NULL,
  `class` varchar(255) DEFAULT NULL,
  `description` varchar(255) DEFAULT NULL,
  `is_required` smallint NOT NULL DEFAULT '0',
  `input_icon` varchar(200) DEFAULT NULL,
  `sort` int NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=54 DEFAULT CHARSET=utf8mb3;

-- Dumping data for table `tbl_custom_fields`

LOCK TABLES `tbl_custom_fields` WRITE;
INSERT INTO `tbl_custom_fields` VALUES ('1','1','7','select','price','price',NULL,'قیمت کل',NULL,'first',NULL,'1',NULL,'1');
INSERT INTO `tbl_custom_fields` VALUES ('2','1','7','text',NULL,'metrage',NULL,'متراژ (مترمربع)',150,'first',NULL,'1',NULL,'2');
INSERT INTO `tbl_custom_fields` VALUES ('3','1','7','select',NULL,'rooms',NULL,'تعداد اتاق',NULL,'last',NULL,'1',NULL,'3');
INSERT INTO `tbl_custom_fields` VALUES ('4','1','7','radio',NULL,'type',NULL,'نوع',NULL,'first',NULL,'1',NULL,'4');
INSERT INTO `tbl_custom_fields` VALUES ('5','1','7','radio',NULL,'country_side',NULL,'حومه شهر',NULL,'last',NULL,'1',NULL,'5');
INSERT INTO `tbl_custom_fields` VALUES ('6','1','12','select','price','mortgage',NULL,'ودیعه',NULL,'first',NULL,'1',NULL,'1');
INSERT INTO `tbl_custom_fields` VALUES ('7','1','12','select','price','rent',NULL,'اجاره ماهیانه',NULL,'first',NULL,'1',NULL,'2');
INSERT INTO `tbl_custom_fields` VALUES ('8','1','12','select',NULL,'rooms',NULL,'تعداد اتاق',NULL,'first',NULL,'1',NULL,'3');
INSERT INTO `tbl_custom_fields` VALUES ('9','1','12','radio',NULL,'type',NULL,'نوع',NULL,'first',NULL,'1',NULL,'4');
INSERT INTO `tbl_custom_fields` VALUES ('10','1','12','radio',NULL,'country_side',NULL,'حومه شهر',NULL,NULL,NULL,'1',NULL,'5');
INSERT INTO `tbl_custom_fields` VALUES ('11','1','16','select','price','price',NULL,'قیمت کل',NULL,'first',NULL,'1',NULL,'1');
INSERT INTO `tbl_custom_fields` VALUES ('12','1','16','text',NULL,'metrage',NULL,'متراژ(مترمربع)',150,'first',NULL,'1',NULL,'2');
INSERT INTO `tbl_custom_fields` VALUES ('13','1','16','select',NULL,'rooms',NULL,'تعداد اتاق',NULL,'last',NULL,'1',NULL,'3');
INSERT INTO `tbl_custom_fields` VALUES ('14','1','16','radio',NULL,'type',NULL,'نوع',NULL,'first',NULL,'1',NULL,'4');
INSERT INTO `tbl_custom_fields` VALUES ('15','1','16','radio',NULL,'country_side',NULL,'حومه شهر',NULL,'last',NULL,'1',NULL,'5');
INSERT INTO `tbl_custom_fields` VALUES ('16','1','16','radio',NULL,'official_document',NULL,'سند اداری',NULL,'first',NULL,'1',NULL,'6');
INSERT INTO `tbl_custom_fields` VALUES ('17','1','20','select','price','mortgage',NULL,'ودیعه',NULL,'first',NULL,'1',NULL,'1');
INSERT INTO `tbl_custom_fields` VALUES ('18','1','20','select','price','rent',NULL,'اجاره ماهیانه',NULL,'first',NULL,'1',NULL,'2');
INSERT INTO `tbl_custom_fields` VALUES ('19','1','20','radio',NULL,'type',NULL,'نوع',NULL,'first',NULL,'1',NULL,'3');
INSERT INTO `tbl_custom_fields` VALUES ('20','1','20','radio',NULL,'country_side',NULL,'حومه شهر',NULL,'last',NULL,'1',NULL,'4');
INSERT INTO `tbl_custom_fields` VALUES ('21','1','20','select',NULL,'rooms',NULL,'تعداد اتاق',NULL,'first bottom-20',NULL,'1',NULL,'5');
INSERT INTO `tbl_custom_fields` VALUES ('22','2','26','select','price','price',NULL,'قیمت کل',NULL,'first',NULL,'1',NULL,'1');
INSERT INTO `tbl_custom_fields` VALUES ('23','2','26','select',NULL,'brand',NULL,'برند',NULL,'first',NULL,'1',NULL,'2');
INSERT INTO `tbl_custom_fields` VALUES ('24','2','26','select',NULL,'year',NULL,'سال',NULL,'last',NULL,'1',NULL,'3');
INSERT INTO `tbl_custom_fields` VALUES ('25','2','26','text',NULL,'usage',NULL,'کارکرد(کیلومتر)',36000,'first bottom-20',NULL,'1',NULL,'4');
INSERT INTO `tbl_custom_fields` VALUES ('26','2','26','radio',NULL,'type',NULL,'نوع',NULL,'last',NULL,'1',NULL,'5');
INSERT INTO `tbl_custom_fields` VALUES ('27','2','30','select','price','price',NULL,'قیمت کل',NULL,'first',NULL,'1',NULL,'1');
INSERT INTO `tbl_custom_fields` VALUES ('28','2','30','radio',NULL,'type',NULL,'نوع',NULL,'last',NULL,'1',NULL,'2');
INSERT INTO `tbl_custom_fields` VALUES ('29','2','31','select','price','price',NULL,'قیمت کل',NULL,'first',NULL,'1',NULL,'1');
INSERT INTO `tbl_custom_fields` VALUES ('30','2','31','radio',NULL,'type',NULL,'نوع',NULL,'last',NULL,'1',NULL,'2');
INSERT INTO `tbl_custom_fields` VALUES ('31','2','32','select','price','price',NULL,'قیمت کل',NULL,'first',NULL,'1',NULL,'1');
INSERT INTO `tbl_custom_fields` VALUES ('32','2','32','select',NULL,'year',NULL,'سال',NULL,'first',NULL,'1',NULL,'2');
INSERT INTO `tbl_custom_fields` VALUES ('33','2','32','text',NULL,'usage',NULL,'کارکرد(کیلومتر)',36000,'last bottom-20',NULL,'1',NULL,'3');
INSERT INTO `tbl_custom_fields` VALUES ('34','2','32','radio',NULL,'type',NULL,'نوع',NULL,'first',NULL,'1',NULL,'4');
INSERT INTO `tbl_custom_fields` VALUES ('35','2','33','select','price','price',NULL,'قیمت کل',NULL,'first',NULL,'1',NULL,'1');
INSERT INTO `tbl_custom_fields` VALUES ('36','2','33','radio',NULL,'type',NULL,'نوع',NULL,'last',NULL,'1',NULL,'2');
INSERT INTO `tbl_custom_fields` VALUES ('37','4','0','select','price','price',NULL,'قیمت کل',NULL,'first',NULL,'1',NULL,'1');
INSERT INTO `tbl_custom_fields` VALUES ('39','4','0','radio',NULL,'type',NULL,'نوع',NULL,'first',NULL,'1',NULL,'2');
INSERT INTO `tbl_custom_fields` VALUES ('40','6','0','select','price','price',NULL,'قیمت کل',NULL,'first bottom-20','','1',NULL,'1');
INSERT INTO `tbl_custom_fields` VALUES ('41','6','98','radio',NULL,'sex',NULL,'نوع',NULL,'first',NULL,'1',NULL,'1');
INSERT INTO `tbl_custom_fields` VALUES ('42','6','107','radio',NULL,'sex_baby',NULL,'نوع',NULL,'first',NULL,'1',NULL,'1');
INSERT INTO `tbl_custom_fields` VALUES ('43','7','0','select','price','price',NULL,'قیمت کل',NULL,'first',NULL,'1',NULL,'1');
INSERT INTO `tbl_custom_fields` VALUES ('44','7','0','radio',NULL,'type',NULL,'نوع',NULL,'first',NULL,'1',NULL,'2');
INSERT INTO `tbl_custom_fields` VALUES ('45','7','113','select',NULL,'brand',NULL,'برند',NULL,'last',NULL,'1',NULL,'1');
INSERT INTO `tbl_custom_fields` VALUES ('46','7','127','select',NULL,'brand',NULL,'برند',NULL,'last',NULL,'1',NULL,'1');
INSERT INTO `tbl_custom_fields` VALUES ('47','7','128','select',NULL,'brand',NULL,'برند',NULL,'last',NULL,'1',NULL,'1');
INSERT INTO `tbl_custom_fields` VALUES ('48','7','130','radio',NULL,'simcart',NULL,'نوع سیمکارت',NULL,'last',NULL,'1',NULL,'1');
INSERT INTO `tbl_custom_fields` VALUES ('49','8','0','select','price','price',NULL,'قیمت کل',NULL,'first',NULL,'1',NULL,'1');
INSERT INTO `tbl_custom_fields` VALUES ('50','8','0','radio',NULL,'type',NULL,'نوع',NULL,'first',NULL,'1',NULL,'2');
INSERT INTO `tbl_custom_fields` VALUES ('51','10','0','select','price','price',NULL,'قیمت کل',NULL,'first',NULL,'1',NULL,'1');
INSERT INTO `tbl_custom_fields` VALUES ('52','10','0','radio',NULL,'type',NULL,'نوع',NULL,'first',NULL,'1',NULL,'2');
INSERT INTO `tbl_custom_fields` VALUES ('53','2','26','link',NULL,'link-1640821042227',NULL,'لینک سایت',NULL,NULL,'ltr','1',NULL,'6');
UNLOCK TABLES;

-- Table structure for table `tbl_favourites`

DROP TABLE IF EXISTS `tbl_favourites`;
CREATE TABLE `tbl_favourites` (
  `id` int NOT NULL AUTO_INCREMENT,
  `ads_id` int unsigned NOT NULL,
  `user_id` int unsigned NOT NULL,
  `created_at` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

-- Dumping data for table `tbl_favourites`

LOCK TABLES `tbl_favourites` WRITE;
UNLOCK TABLES;

-- Table structure for table `tbl_general_settings`

DROP TABLE IF EXISTS `tbl_general_settings`;
CREATE TABLE `tbl_general_settings` (
  `ID` int NOT NULL AUTO_INCREMENT,
  `SETTING` varchar(255) NOT NULL,
  `VALUE` varchar(255) NOT NULL,
  PRIMARY KEY (`ID`)
) ENGINE=InnoDB AUTO_INCREMENT=16 DEFAULT CHARSET=utf8mb3;

-- Dumping data for table `tbl_general_settings`

LOCK TABLES `tbl_general_settings` WRITE;
INSERT INTO `tbl_general_settings` VALUES ('1','IMAGES_MAIN_WIDTH',600);
INSERT INTO `tbl_general_settings` VALUES ('2','IMAGES_MAIN_HEIGHT',400);
INSERT INTO `tbl_general_settings` VALUES ('3','IMAGES_THUMB_WIDTH',182);
INSERT INTO `tbl_general_settings` VALUES ('4','IMAGES_THUMB_HEIGHT',120);
INSERT INTO `tbl_general_settings` VALUES ('5','SLIDER_IMG_WIDTH',1300);
INSERT INTO `tbl_general_settings` VALUES ('6','SLIDER_IMG_HEIGHT',550);
INSERT INTO `tbl_general_settings` VALUES ('7','MAX_SLIDER_SIZE_KB',1000);
INSERT INTO `tbl_general_settings` VALUES ('8','POST_IMG_WIDTH',600);
INSERT INTO `tbl_general_settings` VALUES ('9','POST_IMG_HEIGHT',400);
INSERT INTO `tbl_general_settings` VALUES ('10','MAIL_PER_PAGE',15);
INSERT INTO `tbl_general_settings` VALUES ('11','THUMB_DELIMITER','-thumb');
INSERT INTO `tbl_general_settings` VALUES ('12','IMAGES_LARGE_WIDTH',1200);
INSERT INTO `tbl_general_settings` VALUES ('13','IMAGES_LARGE_HEIGHT',800);
INSERT INTO `tbl_general_settings` VALUES ('14','POST_IMG_THUMB_WIDTH',340);
INSERT INTO `tbl_general_settings` VALUES ('15','POST_IMG_THUMB_HEIGHT',227);
UNLOCK TABLES;

-- Table structure for table `tbl_help`

DROP TABLE IF EXISTS `tbl_help`;
CREATE TABLE `tbl_help` (
  `ID` int NOT NULL AUTO_INCREMENT,
  `PAGE_SLUG` varchar(100) CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL,
  `CONTENT` text CHARACTER SET utf8mb3 COLLATE utf8mb3_general_ci NOT NULL,
  PRIMARY KEY (`ID`),
  KEY `PAGE_SLUG` (`PAGE_SLUG`)
) ENGINE=InnoDB AUTO_INCREMENT=14 DEFAULT CHARSET=utf32;

-- Dumping data for table `tbl_help`

LOCK TABLES `tbl_help` WRITE;
INSERT INTO `tbl_help` VALUES ('1','ads-list','	- در این صفحه می توانید مدیریت کامل بر روی آگهی های ثبت شده داشته باشید. از قسمت \'فیلتر بر اساس زمان\' می توانید انتخاب کنید که آگهی های مربوط به کدام بازه زمانی نمایش داده شوند و از طریق قسمت جستجو می توانید در بین آگهی های در حال نمایش ، جستجو کنید <br/><br/>\r\n	- دقت کنید که اگر به عنوان مثال در قسمت فیلتر زمان ، \'3 ماه قبل\' را انتخاب کرده باشید ، و سپس عمل جستجو را انجام دهید ، جستجو صرفا در آگهی های 3 ماه قبل انجام خواهد شد و سایر آگهی ها مورد جستجو قرار نخواهند گرفت. <br/><br/>\r\n	- برای تغییر وضعیت و یا حذف یک یا چند آگهی ، کافی است با کلیک کردن روی مربع های ستون اول ، آگهی های مورد نظر را انتخاب کنید و با کلیک کردن روی دکمه گزینه ها ، عملیات مورد نظر را انتخاب نمایید <br/><br/>\r\n	- برای مشاهده اطلاعات تکمیلی در مورد هر آگهی ، می توانید روی نام آن کلیک نمایید تا به صفحه جزئیات وارد شوید و یا اینکه روی دکمه ویرایش کلیک نمایید تا به صفحه ویرایش آگهی وارد شوید\r\n');
INSERT INTO `tbl_help` VALUES ('2','bank_order_management','در این صفحه ، صورت حساب هایی که برای پرداخت وجوه به صورت بانکی برای کاربران صادر شده است ، نمایش داده می شود. <br/> دقت کنید که موارد نشان داده شده در این قسمت به معنای این <strong>نیست</strong> که کاربر این مبالغ را واریز نموده است بلکه به این معناست که این صورت حساب ها برای آن ها ایجاد شده و وضعیت آگهی آن ها  <strong>در انتظار پرداخت </strong> است. <br/><br/>\r\n در صورتی که این کاربران تا قبل از منقضی شدن صورت حساب ،  مبلغ مورد نظر را واریز نموده و به هر طریقی ( ایمیل و یا ... ) به شما اطلاع دهند ، می توانید از این قسمت با توجه به شناسه آگهی و کدپیگیری ، صورتحساب کاربر مورد نظر را پیدا کرده و در ستون آخر گزینه \'بلی\' را انتخاب نمایید تا آگهی ویژه آن ها به صورت اتوماتیک فعال شود <br/> <br/>\r\nاما در صورتی که صورت حساب منقضی شود ، آگهی مورد نظر به حالت رایگان درآمده و دیگر نمی توانید از این قسمت آن را تایید نمایید ( با این حال صورت حساب همچنان در این قسمت قابل مشاهده خواهد بود و وضعیت را به حالت منقضی نشان خواهد داد ).\r\n در صورتی که کاربری پس از انقضای صورت حساب ، مبلغ مورد نظر را واریز کرده باشید ، برای فعال سازی آگهی ویژه وی ، باید به قسمت مدیریت آگهی ها بروید و در قسمت ویرایش آگهی ، نوع پلان ویژه درخواستی وی را به صورت دستی وارد نموده و تایید کنید. <br/> <br/>\r\nلازم به ذکر است صورتحساب هایی که از طریق این صفحه تایید شوند ، به عنوان مبالغ واریز شده در صفحه \'پرداخت شده ها\' نمایش داده می شوند و در ستون نحوه پرداخت برای آن ها \'بانکی\' درج خواهد شد. اما صورتحساب های منقضی شده ، حتی پس از پرداخت نیز وارد صفحه \'پرداخت شده ها\' نخواهند شد.\r\n ');
INSERT INTO `tbl_help` VALUES ('3','add_estate','- در این صفحه می توانید اقدام به ثبت یک صفحه جدید نمایید . از آن جایی که این صفحه در قسمت مدیریت سایت قرار دارد هیچ محدودیتی در نحوه ثبت آگهی وجود ندارد . به این معنی که محدودیت های اعمال شده برای پلان های ویژه ( مانند تعداد کلمات کلیدی و تعداد عکس ها و ...) در این قسمت <strong> صادق نمی باشد </strong> و همچنین نیازی به پرداخت هزینه برای ثبت آگهی های ویژه در این قسمت نمی باشد. اما زمان انقضای آگهی با توجه به هر پلان ، به صورت خودکار محاسبه شده و اعمال می گردد<br/><br/>\r\n	<span class=\'label label-important\'> توجه </span> در صورتی که مدیر قصد ثبت یک آگهی <strong>همراه با اعمال محدودیت های مربوطه</strong> را دارد اما نمی خواهد هزینه ای پرداخت شود ، ابتدا باید از طریق ثبت آگهی در قسمت اصلی سایت ، نسبت به ثبت آگهی اقدام نموده و سپس از طریق مدیریت آگهی ها در قسمت مدیریت ، وضعیت آگهی را به حالت <span class=\'label label-success\'> تایید شده </span> تغییر دهد.<br/><br/>\r\n	- در مرحله دوم ثبت آگهی می توانید تصاویر آگهی و همچنین موقعیت آگهی روی نقشه را مشخص نمایید .');
INSERT INTO `tbl_help` VALUES ('4','edit_estate','- در این صفحه می توانید تمامی مشخصات یک آگهی را ویرایش نموده و تغییر دهید . از آن جایی که این صفحه در قسمت مدیریت سایت قرار دارد هیچ محدودیتی در نحوه ویرایش آگهی وجود ندارد . به این معنی که محدودیت های اعمال شده برای پلان های ویژه ( مانند تعداد کلمات کلیدی و تعداد عکس ها و ...) در این قسمت <strong> صادق نمی باشد </strong> و همچنین نیازی به پرداخت هزینه برای تغییر نوع آگهی های ویژه در این قسمت نمی باشد. شما می توانید زمان شروع پلان ویژه آگهی را انتخاب نمایید اما زمان انقضا آن ، با توجه به تنظیمات پلان ویژه به صورت خودکار محاسبه شده و اعمال می گردد. همچنین شما می توانید با کلیک روی دکمه محاسبه تاریخ اتمام ، از زمان اتمام پلان انتخاب شده برای آگهی مطلع وشید. <br/><br/>\n	- برای تغییر تصاویر و موقعیت آگهی ، روی تب \'ویرایش تصاویر و موقعیت آگهی\' کلیک نمایید . <br/><br/>\n	<span class=\'label label-important\'> توجه </span> عملیات ویرایش هر یک از تب ها به صورت جداگانه انجام خواهد شد . به این معنا که در صورتی که روی دکمه ثبت نهایی در تب \'ویراش تصاویر و موقعیت آگهی\' کلیک نمایید ، تغییرات ایجاد شده در تب \'ویرایش اطلاعات آگهی\' اعمال نخواهد شد. <br/><br/>\n\n<span class=\'label label-important\'> توجه مهم </span> در صورتی که قصد اعمال تغییرات در آگهی را ندارید ، از دکمه بازگشت استفاده نمایید و تنها در صورتی از دکمه ویرایش استفاده نمایید که قصد اعمال تغییر در یکی از پارامترهای آگهی را دارید تا از بروز مشکلات احتمالی جلوگیری شود. <br/><br/>\n\n');
INSERT INTO `tbl_help` VALUES ('5','add_category','- برای افزودن آیکون به دسته مورد نظر کافی است روی لینک \'مشاهده آیکون های قابل استفاده\' کلیک نمایید و از صفحه باز شده نام آیکون مورد نظر را کپی کرده و در قسمت آیکون این صفحه ، قرار دهید. مانند : fa-home <br/><br/>\r\n	- با کلیک برروی دکمه رنگی کنار فیلد رنگ ، می توانید رنگ دسته مونظر خود را انتخاب نمایید <br/><br/>');
INSERT INTO `tbl_help` VALUES ('6','settings','	- با کلیک بر روی هر یک از تب های \' تنظیمات کلی سایت \' و \' تنظیم مشخصات فردی سایت \' و \' لوگو و تصاویر \' می توانید تنظیمات قسمت های مختلف سایت را مشاهده کرده و ویرایش نمایید <br/> <br/>\r\n\r\n<span class=\'label label-important\'> توجه : </span> در صورتی که به هر دلیلی می خواهید کاربران فقط امکان ثبت آگهی رایگان داشته باشند (به عنوان مثال هنگامی که هنوز درگاه پرداخت دریافت نکرده اید ) می توانید در تب \' تنظیمات کلی سایت \' و در قسمت \' کاربران بتوانند آگهی ویژه ثبت نمایند؟ \' گزینه \' خیر \' را انتخاب نمایید ( در اینصورت حتما باید یکی از پلان های سایت را به آگهی رایگان اختصاص داده باشید )  \r\n\r\n');
INSERT INTO `tbl_help` VALUES ('7','pages_settings','	- با کلیک بر روی هر یک از تب های \' تنظیمات کلی صفحات سایت \' و \' تنظیمات منوهای کناری سایت \' و \' تنظیمات قسمت انتهایی سایت \' می توانید تنظیمات قسمت های مختلف صفحات سایت را مشاهده کرده و ویرایش نمایید\r\n');
INSERT INTO `tbl_help` VALUES ('8','payment_management','- در این قسمت می توانید مبالغی که به کاربران پرداخت نموده اند را مشاهده نمایید. تاریخچه پرداخت های آنلاین کاربران (پرداخت از طریق درگاه پرداخت تعبیه شده در سایت) به صورت آنی وارد این قسمت خواهد شد . این نوع پرداخت ها در ستون \'نحوه پرداخت\' با کلمه \'آنلاین\' مشخص می شوند.<br/><br/>\r\n	- پرداخت های تایید نشده به صورت برجسته نمایش داده خواهند و در صورتی که پرداخت ها را تایید نمایید از حالت برجسته خارج خواهند شد <br/>\r\n	<span class=\'label label-important\'> توجه : </span> تایید کردن پرداخت های جدید ارتباطی به تایید شدن آگهی ها ندارد. در واقع تایید کردن پرداخت ها به این معناست که شما آن ها را مشاهده نموده اید و در این صورت ، پرداخت های تایید شده توسط شما ، دیگر به حخالت برجسته نمایش داده نخواهند شد <br/><br/>\r\n	- برای تایید و یا حذف گروهی پرداخت ها ، می توانید آن ها را انتخاب نموده و پس از کلیک روی دکمه گزینه ها ، عملیات مورد نظر را انتخاب نمایید .<br/>\r\n	- توصیه می شود که هر از چندگاهی ، صورت حساب های منقضی را حذف نمایید تا کارایی پایگاه داده در حالت بهینه باقی بماند. <br/><br/>\r\n	- پرداخت هایی که کاربران در موعد مقرر توسط فیش های بانکی و یا به صورت کارت به کارت انجام داده باشند و شما آن ها را تایید کرده باشید نیز در این قسمت ظاهر خواهند شد و در ستون \'نحوه پرداخت\' با کلمه \'بانکی\' مشخص خواهند شد . جهت کسب اطلاعات بیشتر در این مورد ، به <a href=\'bank_order_management.php\'> این صفحه </a> بروید و راهنمای صفحه را مطالعه نمایید.<br/><br/>');
INSERT INTO `tbl_help` VALUES ('9','plans_management','- د راین قسمت می توانید پلان های ویژه ای که برای سایت تعریف شده است را مدیریت نموده و در صورت نیاز آن ها را ویرایش نمایید. \'عنوان پلان ویژه\' ، نامی است که شما برای هر پلان در نظر می گیرد و می تواند هر عنوان دلخواهی باشد. اما اهمیت پلان ها را \'تعداد ستاره های\' آن ها مشخص می کند.<br/><br/>\r\n	- جهت کسب اطلاعات بیشتر در مورد پلان ها به صفحه ویرایش پلان ها رفته و راهنما را مطالعه نمایید <br/><br/>');
INSERT INTO `tbl_help` VALUES ('10','edit_plan','- برای هریک از پلان های ویژه تعریف شده ، شما می توانید نوع پلان را انتخاب نمایید. 3 نوع پلان ویژه متفاوت برای این اسکریپت در نظر گرفته شده است: \'آگهی رایگان\' ، \'آگهی متنی\' و \'آگهی ویژه\' <br/><br/>\n    - آگهی های متنی در قسمت اصلی سایت نمایش داده <strong> نمی شوند </strong> بلکه در سایدبارها (منوهای کناری) و به صورت تصادفی نمایش داده می شوند. به همین دلیل ، به دلخواه خود می توانید برای آن ها قیمت کمتری نسبت به سایر پلان های ویژه در نظر بگیرید و یا در صورتی که تشخیص دادید سایت شما نیازی به آگهی متنی ندارد ، می توانید آن را غیرفعال نمایید<br/><br/>\n    <span class=\'label label-important\'> توجه : </span> در بخش \' تنظیمات سایت <i class=\'icon-long-arrow-left\' style=\"position:relative;top:2px\"></i> تنظیمات صفحات سایت <i class=\'icon-long-arrow-left\' style=\"position:relative;top:2px\"></i> تنظیمات سایدبار\' می توانید تعیین نمایید که در منوهای کناری هر صفحه ، چه آیتم هایی نمایش داده شود. اگر از آگهی های متنی در سایت خود استفاده می نمایید به تشخیص خود ، باید منوهای کناری یک یا چند صفحه را به نمایش \'آگهی های متنی\' اختصاص دهید <br/><br/>\n    - برای هر یک از پلان ها می توانید پارامترهایی نظیر تعداد روزها ، حداکثر تعداد تصاویر قابل آپلود ، حداکثر تعداد کلمات کلیدی قابل استفاده و ... را مشخص نمایید <br/><br/>\n    - اولویت پلان ها در موتورهای جستجو را به گونه ای تعیین نمایید که پلان های ضعیف تر ، در اولویت های بالاتر قرار گیرند. لازم به ذکر است که پلان دارای اولویت 1 در صدر لیست جستجوی سایت قرار می گیرد. <br/><br/>\n\n- میتوانید حداکثر تعداد ستاره های مربوط به پلان ها را در بخش \' تنظیمات سایت <i class=\'icon-long-arrow-left\' style=\"position:relative;top:2px\"></i> تنظیمات پرداخت و پلان های ویژه \' تعیین کنید\n <br/><br/>\n\n- تمامی پلان های ویژه ، پس از اتمام مدت زمان مربوط به پلان ، به صورت اتوماتیک به آگهی رایگان تبدیل خواهند شد و پس از به اتمام رسیدن مهلت آگهی رایگان ، به صورت خودکار غیر فعال خواهند شد\n <br/><br/>\n\n - با غیرفعال کردن یک پلان کاربران امکان ثبت آگهی با پلان مورد نظر را نخواهند داشت اما آگهی هایی که از قبل با آن پلان ثبت شده اند به کار خود ادامه خواهند داد\n <br/><br/>\n\n    - سعی کنید ویژگی های مختلف را برای پلان های متفاوت به گونه ای در نظر بگیرید که توازن بین پلان ها کاملا برقر باشد.<br/><br/>');
INSERT INTO `tbl_help` VALUES ('11','backup_management','- با زدن دکمه \'ساخت پشتیان جدید\' یک پشتیبان از پایگاه داده شما به وجود خواهد آمد و نام آن در ابتدای جدول قرار خواهد گرفت . شما می توانید در هر زمانی ، پشتیبان مورد نظر را دانلود نموده و یا با زدن دکمه \'بازگردانی پشتیبان\' پایگاه داده خود را دقیقا به زمان ساخت آن پشتیبان بازگردانید . <br/><br/>\r\n	- توصیه می شود که هر از چندگاهی از اطلاعات پایگاه داده خود پشتیبان تهیه نموده و نسخه ای از آن را در نزد خود نگاه دارید تا در مواقع لزوم بتوان از آن استفاده نمود . ');
INSERT INTO `tbl_help` VALUES ('12','banner_manager','- بنرهای تبلیغاتی از دو فرمت jpg و gif پشتیبانی می کنند. <br/><br/>\r\n\r\n								-   در صورتی که تصویر با فرمت jpg آپلود نمایید ، تصویر مورد نظر به صورت اتوماتیک به ابعاد مناسب تبدیل خواهند شد. اما در صورتی که تصاویر gif آپلود شوند به صورت دست نخورده ذخیره می شوند. بنابراین دقت نمایید که قبل از آپلود تصاویر gif ، ابتدا آن ها را به ابعاد دقیق بنر مورد نظر تبدیل نمایید و سپس آپلود نمایید تا از آشفته شدن قالب سایت جلوگیری شود <br/><br/>\r\n\r\n<span class=\'label label-important\'> توجه : </span> در صورتی که قصد آپلود تصویر دارید، پس از انتخاب تصویر حتما روی دکمه آپلود کلیک نمایید. دکمه ویرایش صرفا برای ذخیره کردن تغییرات اعمال شده روی اطلاعات بنر استفاده می شود. در واقع در صورتی که پس از انتخاب تصویر ، دکمه ویرایش را بزنید تصویر آپلود نخواهد شد بلکه فقط اطلاعات بنر مانند لینک و ... به روز خواهد شد');
INSERT INTO `tbl_help` VALUES ('13','policy_reports','- در صورتی که کاربران آگهی خلاف قوانین و مقرراتی را در سایت مشاهده نموده باشند ، می توانند با کلیک بر روی آیکون شعله قرمز رنگی که روی تمام آگهی ها ظاهر می شود ، آن مورد را گزارش داده و توضیحاتی در مورد آن ارائه دهند. شما به عنوان مدیر سایت می توانید این پیغام ها را در این قسمت مشاهده نموده و در صورت نیاز اقدامات لازم را برای رفع مشکلات آن ها انجام دهید');
UNLOCK TABLES;

-- Table structure for table `tbl_images`

DROP TABLE IF EXISTS `tbl_images`;
CREATE TABLE `tbl_images` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `link_id` bigint NOT NULL,
  `link_type` varchar(255) NOT NULL,
  `path` text,
  `alt` text,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb3;

-- Dumping data for table `tbl_images`

LOCK TABLES `tbl_images` WRITE;
INSERT INTO `tbl_images` VALUES ('1','1','ads','images/estate_images/1/17171044486658ef40236f7.jpg',NULL);
INSERT INTO `tbl_images` VALUES ('2','1','ads','images/estate_images/1/17171044506658ef423c478.jpg',NULL);
UNLOCK TABLES;

-- Table structure for table `tbl_likes`

DROP TABLE IF EXISTS `tbl_likes`;
CREATE TABLE `tbl_likes` (
  `id` int NOT NULL AUTO_INCREMENT,
  `link_id` int NOT NULL,
  `type` varchar(10) NOT NULL,
  `like` int NOT NULL DEFAULT '0',
  `dislike` int NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3;

-- Dumping data for table `tbl_likes`

LOCK TABLES `tbl_likes` WRITE;
INSERT INTO `tbl_likes` VALUES ('1','1','ads','0','0');
UNLOCK TABLES;

-- Table structure for table `tbl_links`

DROP TABLE IF EXISTS `tbl_links`;
CREATE TABLE `tbl_links` (
  `ID` int NOT NULL AUTO_INCREMENT,
  `LINK_TITLE` varchar(255) DEFAULT NULL,
  `LINK_ADDRESS` text,
  PRIMARY KEY (`ID`)
) ENGINE=InnoDB AUTO_INCREMENT=7 DEFAULT CHARSET=utf8mb3;

-- Dumping data for table `tbl_links`

LOCK TABLES `tbl_links` WRITE;
INSERT INTO `tbl_links` VALUES ('1','فروش سایت آماده نیازمندی ها','kodesign.ir/other-works/niazmandiha_scripts/');
INSERT INTO `tbl_links` VALUES ('2','فروش سایت آماده مشاور املاک','kodesign.ir/other-works/amlak_framework/');
INSERT INTO `tbl_links` VALUES ('3','طراحی سایت حرفه ای','kodesign.ir');
INSERT INTO `tbl_links` VALUES ('4','طراحی سایت - کمیل قاسمی','kodesign.ir');
INSERT INTO `tbl_links` VALUES ('5','نت افراز','http://www.netafraz.com/members/aff.php?aff=5002');
INSERT INTO `tbl_links` VALUES ('6','محل درج لینک تبلیغاتی','kodesign.ir');
UNLOCK TABLES;

-- Table structure for table `tbl_mail_box`

DROP TABLE IF EXISTS `tbl_mail_box`;
CREATE TABLE `tbl_mail_box` (
  `ID` int NOT NULL AUTO_INCREMENT,
  `USER_ID` int DEFAULT NULL,
  `TITLE` text,
  `SENDER_NAME` varchar(150) DEFAULT NULL,
  `SENDER_MAIL` varchar(150) DEFAULT NULL,
  `RECIVER_MAIL` text,
  `RECIVER_USER_ID` varchar(150) DEFAULT NULL,
  `FROM` enum('ADMIN','USER','AUTO') NOT NULL DEFAULT 'ADMIN',
  `TO` enum('ADMIN','USER') NOT NULL DEFAULT 'USER',
  `REPLY_TO` int DEFAULT NULL,
  `MESSAGE` text,
  `RES_ID` text,
  `DATE_CREATED` datetime NOT NULL,
  `USERS_VIEWED` text,
  PRIMARY KEY (`ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

-- Dumping data for table `tbl_mail_box`

LOCK TABLES `tbl_mail_box` WRITE;
UNLOCK TABLES;

-- Table structure for table `tbl_menus`

DROP TABLE IF EXISTS `tbl_menus`;
CREATE TABLE `tbl_menus` (
  `id` int NOT NULL AUTO_INCREMENT,
  `rang` int NOT NULL,
  `parent_id` int NOT NULL,
  `name` varchar(256) NOT NULL,
  `deletable` enum('YES','NO') DEFAULT 'NO',
  `page_id` int DEFAULT NULL,
  `url_link` varchar(255) DEFAULT NULL,
  `is_external` smallint NOT NULL DEFAULT '1',
  `url_target` varchar(20) DEFAULT '_self',
  `module_code` varchar(100) DEFAULT NULL,
  `icon` varchar(60) DEFAULT NULL,
  `description` varchar(256) DEFAULT NULL,
  `type` enum('ADMIN','USER') DEFAULT 'USER',
  `page_route` varchar(255) DEFAULT NULL,
  `status` smallint NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=92 DEFAULT CHARSET=utf8mb3;

-- Dumping data for table `tbl_menus`

LOCK TABLES `tbl_menus` WRITE;
INSERT INTO `tbl_menus` VALUES ('1','1','0','خانه','NO',NULL,'index','1',NULL,NULL,'fa-home','','USER',NULL,'1');
INSERT INTO `tbl_menus` VALUES ('3','2','0','ثبت آگهی','NO',NULL,'new','1','_self',NULL,'fa-sitemap','ADD-ITEM','USER',NULL,'1');
INSERT INTO `tbl_menus` VALUES ('4','4','0','تعرفه آگهی ها','NO',NULL,'pricing','1',NULL,NULL,'fa-star','','USER',NULL,'1');
INSERT INTO `tbl_menus` VALUES ('5','5','0','خبرهای سایت','NO',NULL,'blog','1',NULL,NULL,'fa-bullhorn','','USER',NULL,'1');
INSERT INTO `tbl_menus` VALUES ('6','6','0','تماس با ما','YES','1','dsgdsdsg.com','1','_self',NULL,'fa-envelope','','USER',NULL,'1');
INSERT INTO `tbl_menus` VALUES ('9','0','0','پیشخوان','NO',NULL,'index.php','1','_self',NULL,'fa fa-tachometer-alt','','ADMIN','','1');
INSERT INTO `tbl_menus` VALUES ('10','1','0','آگهی ها','NO',NULL,'#','1','_self',NULL,'fa fa-bullhorn','','ADMIN',NULL,'1');
INSERT INTO `tbl_menus` VALUES ('11','2','10','مدیریت آگهی ها','NO',NULL,'ads','1','_self','ADS_MANAGE',NULL,'','ADMIN','ads__list.php','1');
INSERT INTO `tbl_menus` VALUES ('12','3','10','ثبت آگهی جدید','NO',NULL,'ads/create','1','_self','ADD_ADS',NULL,'','ADMIN','ads__create.php','1');
INSERT INTO `tbl_menus` VALUES ('13','10','0','کاربران','NO',NULL,'#','1','_self',NULL,'fa fa-users','','ADMIN',NULL,'1');
INSERT INTO `tbl_menus` VALUES ('14','11','13','مدیریت کاربران','NO',NULL,'users','1','_self','USER_MANAGE','','','ADMIN','users__list.php','1');
INSERT INTO `tbl_menus` VALUES ('15','12','13','افزودن کاربر جدید','NO',NULL,'users/create','1','_self','USER_ADD','','','ADMIN','users__create.php','1');
INSERT INTO `tbl_menus` VALUES ('16','16','0','منطقه ها','NO',NULL,'#','1','_self','LOCATION_MANAGE','fa fa-map-marker-alt','','ADMIN',NULL,'1');
INSERT INTO `tbl_menus` VALUES ('17','17','16','افزودن منطقه جدید','NO',NULL,'locations/create','1','_self','LOCATION_MANAGE','','','ADMIN','locations__create.php','1');
INSERT INTO `tbl_menus` VALUES ('18','18','16','مدیریت استان ها','NO',NULL,'locations/states','1','_self','LOCATION_MANAGE','','','ADMIN','locations__state.php','1');
INSERT INTO `tbl_menus` VALUES ('19','19','16','مدیریت شهرها','NO',NULL,'locations/cities','1','_self','LOCATION_MANAGE','','','ADMIN','locations__city.php','1');
INSERT INTO `tbl_menus` VALUES ('20','5','0','دسته بندی ها','NO',NULL,'#','1','_self','CATEGORY_MANAGE','fa fa-align-right','','ADMIN',NULL,'1');
INSERT INTO `tbl_menus` VALUES ('21','6','20','مدیریت دسته ها','NO',NULL,'category','1','_self','CATEGORY_MANAGE','','','ADMIN','categories__list.php','1');
INSERT INTO `tbl_menus` VALUES ('22','7','20','مدیریت زیردسته ها','NO',NULL,'subcategory','1','_self','CATEGORY_MANAGE','','','ADMIN','subcategories__list.php','1');
INSERT INTO `tbl_menus` VALUES ('24','20','0','مطالب سایت','NO',NULL,'#','1','_self','POST_MANAGE','fa fa-pencil-alt','','ADMIN',NULL,'1');
INSERT INTO `tbl_menus` VALUES ('25','21','24','مدیریت مطالب','NO',NULL,'posts','1','_self','POST_MANAGE','','','ADMIN','posts__list.php','1');
INSERT INTO `tbl_menus` VALUES ('26','22','24','ارسال مطلب جدید','NO',NULL,'posts/create','1','_self','POST_MANAGE','','','ADMIN','posts__create.php','1');
INSERT INTO `tbl_menus` VALUES ('27','24','0','تنظیمات سایت','NO',NULL,'#','1','_self','SETTING_MANAGE','fa fa-cogs','','ADMIN',NULL,'1');
INSERT INTO `tbl_menus` VALUES ('28','25','27','تنظیمات کلی','NO',NULL,'settings/main','1','_self','SETTING_MANAGE','','','ADMIN','settings__main.php','1');
INSERT INTO `tbl_menus` VALUES ('29','26','27','تنظیمات صفحه ها','NO',NULL,'settings/pages','1','_self','SETTING_MANAGE','','','ADMIN','settings__pages.php','1');
INSERT INTO `tbl_menus` VALUES ('30','27','0','پرداختی ها','NO',NULL,'#','1','_self','PAYMENT_VIEW','fa fa-file-invoice-dollar','','ADMIN',NULL,'1');
INSERT INTO `tbl_menus` VALUES ('31','28','30','پرداختی های آنلاین','NO',NULL,'orders/online','1','_self','PAYMENT_VIEW','','','ADMIN','orders__online.php','1');
INSERT INTO `tbl_menus` VALUES ('32','29','30','صورتحساب های ایجاد شده برای پرداخت توسط فیش بانکی','NO',NULL,'orders/bacs','1','_self','PAYMENT_VIEW','','','ADMIN','orders__bacs.php','1');
INSERT INTO `tbl_menus` VALUES ('33','30','0','صندوق پیام ها','NO',NULL,'#','1','_self','MAIL_MANAGE','fa fa-envelope','','ADMIN',NULL,'1');
INSERT INTO `tbl_menus` VALUES ('34','31','33','ایمیل ها','NO',NULL,'mailbox/email','1','_self','MAIL_MANAGE','','','ADMIN','mailbox__email.php','1');
INSERT INTO `tbl_menus` VALUES ('35','33','0','منو و برگه های سایت','NO',NULL,'#','1','_self',NULL,'fa fa-clone','','ADMIN',NULL,'1');
INSERT INTO `tbl_menus` VALUES ('37','34','35','مدیریت منوها','NO',NULL,'menu','1','_self','MENU_MANAGE','','','ADMIN','menus__list.php','1');
INSERT INTO `tbl_menus` VALUES ('38','35','35','اولویت بندی منوها','NO',NULL,'menu/sort','1','_self','MENU_MANAGE','','','ADMIN','menus__sort.php','1');
INSERT INTO `tbl_menus` VALUES ('39','43','0','مدیریت پلان های ویژه','NO',NULL,'plans','1','_self','PLAN_MANAGE','fa fa-star','','ADMIN','plans__list.php','1');
INSERT INTO `tbl_menus` VALUES ('41','45','0','مدیریت لینک ها','NO',NULL,'links','1','_self','LINK_MANAGE','fa fa-share-alt','','ADMIN','links__list.php','1');
INSERT INTO `tbl_menus` VALUES ('42','46','0','پشتیبان گیری','NO',NULL,'backup','1','_self','BACKUP_MANAGE','fa fa-cloud-download-alt','','ADMIN','backup__list.php','1');
INSERT INTO `tbl_menus` VALUES ('43','47','0','نقشه سایت','NO',NULL,'sitemap','1','_self','SITEMAP_MANAGE','fa fa-sitemap','','ADMIN','sitemaps__list.php','1');
INSERT INTO `tbl_menus` VALUES ('44','38','63','بنرهای تبلیغاتی','NO',NULL,'banner/adv','1','_self','BANNER_MANAGE','','','ADMIN','banners__adv.php','1');
INSERT INTO `tbl_menus` VALUES ('45','48','10','گزارش های خلاف قوانین سایت','NO',NULL,'ads/report','1','_self','POLICY_MANAGE','','','ADMIN','ads__reports.php','1');
INSERT INTO `tbl_menus` VALUES ('46','49','0','آمارهای بازدید سایت','NO',NULL,'statistics','1','_self','STATS_VIEW','fa fa-chart-bar','','ADMIN','statistics.php','1');
INSERT INTO `tbl_menus` VALUES ('49','36','35','مدیریت برگه ها','NO',NULL,'pages','1','_self','PAGE_MANAGE','','','ADMIN','pages__list.php','1');
INSERT INTO `tbl_menus` VALUES ('52','32','33','پیامک ها','NO',NULL,'mailbox/sms','1','_self','MAIL_MANAGE','','','ADMIN','mailbox__sms.php','1');
INSERT INTO `tbl_menus` VALUES ('53','23','24','دسته بندی مطالب','NO',NULL,'posts/categories','1','_self','POST_MANAGE','','','ADMIN','posts__categories.php','1');
INSERT INTO `tbl_menus` VALUES ('54','44','0','ایمیل های انقضای آگهی ها','NO',NULL,'expire/email','1','_self','EXPIRY_EMAILS','fa fa-clock','','ADMIN','expire__emails.php','1');
INSERT INTO `tbl_menus` VALUES ('55','13','13','بانک ایمیل کاربران','NO',NULL,'users/database/email','1','_self','USER_MANAGE','','','ADMIN','users__database_email.php','1');
INSERT INTO `tbl_menus` VALUES ('56','14','13','بانک تلفن کاربران','NO',NULL,'users/database/phone','1','_self','USER_MANAGE','','','ADMIN','users__database_phone.php','1');
INSERT INTO `tbl_menus` VALUES ('57','9','20','اولویت بندی دسته ها','NO',NULL,'category/sort','1','_self','CATEGORY_MANAGE ','','','ADMIN','categories__sort.php','1');
INSERT INTO `tbl_menus` VALUES ('59','40','0','سیستم همکاری در فروش','NO',NULL,'','1','_self','WITHDRAWAL_MANAGE','fa fa-hands-helping','','ADMIN',NULL,'1');
INSERT INTO `tbl_menus` VALUES ('60','41','59','درخواست های برداشت وجه','NO',NULL,'withdraw','1','_self','WITHDRAWAL_MANAGE','','','ADMIN','withdraws__list.php','1');
INSERT INTO `tbl_menus` VALUES ('61','42','59','بنرهای همکاری در فروش','NO',NULL,'banner/affiliate','1','_self','BANNER_MANAGE','','','ADMIN','banners__affiliate.php','1');
INSERT INTO `tbl_menus` VALUES ('62','39','63','اسلایدرها','NO',NULL,'banner/slider','1','_self','BANNER_MANAGE','','','ADMIN','banners__slider.php','1');
INSERT INTO `tbl_menus` VALUES ('63','37','0','بنرها و اسلایدر','NO',NULL,'#','1','_self','BANNER_MANAGE','fa fa-images','','ADMIN',NULL,'1');
INSERT INTO `tbl_menus` VALUES ('64','15','13','سطوح دسترسی','NO',NULL,'users/roles','1','_self','ACCESS-LEVEL_MANAGE','','','ADMIN','users__roles.php','1');
INSERT INTO `tbl_menus` VALUES ('65','4','10','دیدگاه ها','NO',NULL,'ads/comments','1','_self','ADS_MANAGE','','','ADMIN','comments__list_ads.php','1');
INSERT INTO `tbl_menus` VALUES ('66','5','0','کوپن ها','NO',NULL,'#','1','_self','COUPON_MANAGE','fa fa-tag','','ADMIN',NULL,'1');
INSERT INTO `tbl_menus` VALUES ('67','1','66','مدیریت کوپن ها','NO',NULL,'coupons','1','_self','COUPON_MANAGE',NULL,'','ADMIN','coupons__list.php','1');
INSERT INTO `tbl_menus` VALUES ('68','2','66','افزودن کوپن','NO',NULL,'coupons/create','1','_self','COUPON_MANAGE',NULL,'','ADMIN','coupons__create.php','1');
INSERT INTO `tbl_menus` VALUES ('69','5','10','آگهی های کانال تلگرام','NO',NULL,'ads/telegrambox','1','_self','TELEGRAM_MANAGE','','','ADMIN','telegrambox__ads.php','1');
INSERT INTO `tbl_menus` VALUES ('70','23','24','پست های کانال تلگرام','NO',NULL,'posts/telegrambox','1','_self','TELEGRAM_MANAGE','','','ADMIN','telegrambox__posts.php','1');
INSERT INTO `tbl_menus` VALUES ('71','8','20','افزودن','NO',NULL,'category/create','1','_self','CATEGORY_MANAGE','','','ADMIN','categories__create.php','1');
INSERT INTO `tbl_menus` VALUES ('86','9','20','فیلدهای اختصاصی','NO',NULL,'category/custom-fields','1','_self','CATEGORY_MANAGE ','','','ADMIN','categories__custom_fields.php','1');
INSERT INTO `tbl_menus` VALUES ('87','30','30','گزارش پرداخت ها','NO',NULL,'orders/report','1','_self','PAYMENT_VIEW','','','ADMIN','orders__report.php','1');
INSERT INTO `tbl_menus` VALUES ('88','40','63','اسلایدر اپلیکیشن','NO',NULL,'banner/application-slider','1','_self','BANNER_MANAGE','','','ADMIN','banners__application_slider.php','1');
INSERT INTO `tbl_menus` VALUES ('89','26','24','دیدگاه ها','NO',NULL,'posts/comments','1','_self','POST_MANAGE','','','ADMIN','comments__list_post.php','1');
INSERT INTO `tbl_menus` VALUES ('90','50','0','پشتیبانی','NO',NULL,'support','1','_self','STATS_VIEW','fa fa-headset','support-menu','ADMIN','support.php','1');
UNLOCK TABLES;

-- Table structure for table `tbl_modules`

DROP TABLE IF EXISTS `tbl_modules`;
CREATE TABLE `tbl_modules` (
  `id` int NOT NULL AUTO_INCREMENT,
  `module_code` varchar(255) NOT NULL,
  `module_name` varchar(255) NOT NULL,
  `hide` smallint NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=28 DEFAULT CHARSET=utf8mb3;

-- Dumping data for table `tbl_modules`

LOCK TABLES `tbl_modules` WRITE;
INSERT INTO `tbl_modules` VALUES ('1','ADS_MANAGE','مشاهده و ویرایش آگهی ها','1');
INSERT INTO `tbl_modules` VALUES ('2','ADS_DELETE','حذف آگهی','1');
INSERT INTO `tbl_modules` VALUES ('3','ADD_ADS','ثبت آگهی بدون محدودیت','1');
INSERT INTO `tbl_modules` VALUES ('4','CATEGORY_MANAGE','مدیریت، حذف و افزودن دسته و زیر دسته','1');
INSERT INTO `tbl_modules` VALUES ('5','USER_MANAGE','مشاهده و ویرایش اطلاعات کاربران','1');
INSERT INTO `tbl_modules` VALUES ('6','USER_DELETE_CHANGE-STATUS','حذف و تغییر سطح دسترسی و وضعیت کاربران','1');
INSERT INTO `tbl_modules` VALUES ('7','USER_ADD','افزودن کاربر با سطح دسترسی دلخواه','1');
INSERT INTO `tbl_modules` VALUES ('8','LOCATION_MANAGE','ویرایش، حذف و اضافه کردن مناطق','1');
INSERT INTO `tbl_modules` VALUES ('9','POST_MANAGE','ویرایش، حذف و اضافه کردن خبرها','1');
INSERT INTO `tbl_modules` VALUES ('10','SETTING_MANAGE','دسترسی به تنظیمات سایت','1');
INSERT INTO `tbl_modules` VALUES ('11','PAYMENT_VIEW','مشاهده پرداختی ها','1');
INSERT INTO `tbl_modules` VALUES ('12','PAYMENT_CHANGE','ویرایش و تغییر وضعیت پرداختی ها','1');
INSERT INTO `tbl_modules` VALUES ('13','MAIL_MANAGE','مدیریت و ارسال ایمیل و پیامک','1');
INSERT INTO `tbl_modules` VALUES ('14','MENU_MANAGE','مدیریت ، ویرایش و افزودن منو','1');
INSERT INTO `tbl_modules` VALUES ('15','PAGE_MANAGE','ویرایش، حذف و اضافه کردن برگه ها','1');
INSERT INTO `tbl_modules` VALUES ('16','BANNER_MANAGE','مدیریت بنرها و اسلایدر','1');
INSERT INTO `tbl_modules` VALUES ('17','PLAN_MANAGE','مدیریت پلان های ویژه','1');
INSERT INTO `tbl_modules` VALUES ('18','EXPIRY_EMAILS','ارسال ایمیل های انقضای آگهی ها','1');
INSERT INTO `tbl_modules` VALUES ('19','LINK_MANAGE','مدیریت لینک ها','1');
INSERT INTO `tbl_modules` VALUES ('20','BACKUP_MANAGE','پشتیبان گیری','1');
INSERT INTO `tbl_modules` VALUES ('21','SITEMAP_MANAGE','نقشه سایت','1');
INSERT INTO `tbl_modules` VALUES ('22','POLICY_MANAGE','مدیریت گزارش های خلاف قوانین','1');
INSERT INTO `tbl_modules` VALUES ('23','STATS_VIEW','مشاهده آمارهای سایت','1');
INSERT INTO `tbl_modules` VALUES ('24','WITHDRAWAL_MANAGE','مدیریت درخواست های برداشت وجه','1');
INSERT INTO `tbl_modules` VALUES ('25','ACCESS-LEVEL_MANAGE','تنظیم سطوح دسترسی ','2');
INSERT INTO `tbl_modules` VALUES ('26','COUPON_MANAGE','مدیریت کوپن های تخفیف','1');
INSERT INTO `tbl_modules` VALUES ('27','TELEGRAM_MANAGE','مدیریت ارسالی های تلگرام','1');
UNLOCK TABLES;

-- Table structure for table `tbl_notifications`

DROP TABLE IF EXISTS `tbl_notifications`;
CREATE TABLE `tbl_notifications` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `type` varchar(50) NOT NULL,
  `slug` varchar(255) NOT NULL,
  `notifiable` varchar(255) NOT NULL,
  `notifiable_id` bigint unsigned NOT NULL,
  `data` text,
  `read_at` timestamp NULL DEFAULT NULL,
  `created_at` timestamp NULL DEFAULT NULL,
  `updated_at` timestamp NULL DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb3;

-- Dumping data for table `tbl_notifications`

LOCK TABLES `tbl_notifications` WRITE;
UNLOCK TABLES;

-- Table structure for table `tbl_order_item_metas`

DROP TABLE IF EXISTS `tbl_order_item_metas`;
CREATE TABLE `tbl_order_item_metas` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `order_item_id` bigint NOT NULL,
  `meta_key` varchar(255) DEFAULT NULL,
  `meta_value` longtext,
  PRIMARY KEY (`id`),
  KEY `order_item_id` (`order_item_id`),
  CONSTRAINT `tbl_order_item_metas_ibfk_1` FOREIGN KEY (`order_item_id`) REFERENCES `tbl_order_items` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

-- Dumping data for table `tbl_order_item_metas`

LOCK TABLES `tbl_order_item_metas` WRITE;
UNLOCK TABLES;

-- Table structure for table `tbl_order_items`

DROP TABLE IF EXISTS `tbl_order_items`;
CREATE TABLE `tbl_order_items` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `order_id` bigint NOT NULL,
  `name` text NOT NULL,
  `type` varchar(200) NOT NULL,
  PRIMARY KEY (`id`),
  KEY `order_id` (`order_id`),
  CONSTRAINT `tbl_order_items_ibfk_1` FOREIGN KEY (`order_id`) REFERENCES `tbl_orders` (`id`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

-- Dumping data for table `tbl_order_items`

LOCK TABLES `tbl_order_items` WRITE;
UNLOCK TABLES;

-- Table structure for table `tbl_orders`

DROP TABLE IF EXISTS `tbl_orders`;
CREATE TABLE `tbl_orders` (
  `id` bigint NOT NULL AUTO_INCREMENT,
  `reversal_request` int DEFAULT NULL COMMENT '999:connection err',
  `user_id` int NOT NULL,
  `ads_id` int NOT NULL,
  `new_plan_id` int NOT NULL DEFAULT '0',
  `nature` varchar(255) DEFAULT 'add-new',
  `period` int NOT NULL DEFAULT '1',
  `price` int NOT NULL,
  `res_code` int DEFAULT NULL,
  `sale_order_id` varchar(50) DEFAULT NULL,
  `sale_refrence_id` varchar(50) DEFAULT NULL,
  `ref_id` varchar(50) DEFAULT NULL,
  `done` tinyint(1) NOT NULL DEFAULT '1' COMMENT '1=false;2=true',
  `setteled` tinyint(1) NOT NULL DEFAULT '1' COMMENT '1:false;2:true',
  `kind` varchar(50) DEFAULT NULL,
  `date_created` datetime NOT NULL,
  `comment` varchar(100) DEFAULT NULL,
  `seen` smallint NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

-- Dumping data for table `tbl_orders`

LOCK TABLES `tbl_orders` WRITE;
UNLOCK TABLES;

-- Table structure for table `tbl_page_widgets`

DROP TABLE IF EXISTS `tbl_page_widgets`;
CREATE TABLE `tbl_page_widgets` (
  `id` int NOT NULL AUTO_INCREMENT,
  `UUID` varchar(255) NOT NULL,
  `page_id` int NOT NULL,
  `widget` varchar(255) NOT NULL,
  `options` longtext,
  `sort` int NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=MyISAM AUTO_INCREMENT=438 DEFAULT CHARSET=utf8mb3;

-- Dumping data for table `tbl_page_widgets`

LOCK TABLES `tbl_page_widgets` WRITE;
INSERT INTO `tbl_page_widgets` VALUES ('436','1619124167392.3','130','blog-search','{\"widget_title\":\"\\u062c\\u0633\\u062a\\u062c\\u0648 \\u062f\\u0631 \\u0645\\u0637\\u0627\\u0644\\u0628\",\"input_placeholder\":\"\\u062c\\u0633\\u062a\\u062c\\u0648 ...\"}','1');
INSERT INTO `tbl_page_widgets` VALUES ('435',1613910668246,'101','latest-ads','{\"widget_title\":\"\\u062a\\u0627\\u0632\\u0647 \\u062a\\u0631\\u06cc\\u0646 \\u0622\\u06af\\u0647\\u06cc \\u0647\\u0627\",\"count\":\"5\"}','1');
INSERT INTO `tbl_page_widgets` VALUES ('431','1614187556932.7','6','banners','{\"widget_title\":\"\\u0628\\u0646\\u0631\\u0647\\u0627\\u06cc \\u062a\\u0628\\u0644\\u06cc\\u063a\\u0627\\u062a\\u06cc\",\"count\":0}','1');
INSERT INTO `tbl_page_widgets` VALUES ('432',1613910193207,'101','blog-search','{\"widget_title\":\"\\u062c\\u0633\\u062a\\u062c\\u0648 \\u062f\\u0631 \\u0645\\u0637\\u0627\\u0644\\u0628\",\"input_placeholder\":\"\\u062c\\u0633\\u062a\\u062c\\u0648 ...\"}','1');
INSERT INTO `tbl_page_widgets` VALUES ('433','1613910197016.9','101','blog-categories','{\"widget_title\":\"\\u06af\\u0631\\u0648\\u0647 \\u0628\\u0646\\u062f\\u06cc \\u0645\\u0637\\u0627\\u0644\\u0628\",\"show_post_count\":\"NO\"}','1');
INSERT INTO `tbl_page_widgets` VALUES ('434','1613910205867.2','101','latest-posts','{\"widget_title\":\"\\u062a\\u0627\\u0632\\u0647 \\u062a\\u0631\\u06cc\\u0646 \\u0645\\u0637\\u0627\\u0644\\u0628\",\"count\":10}','1');
INSERT INTO `tbl_page_widgets` VALUES ('294','1614031902948.9','92','banners','{\"widget_title\":\"\\u06af\\u0631\\u0648\\u0647 \\u0647\\u0627\",\"count\":0}','1');
INSERT INTO `tbl_page_widgets` VALUES ('293','1614018265311.1','92','ads-categories','{\"widget_title\":\"\\u06af\\u0631\\u0648\\u0647 \\u0647\\u0627\",\"count\":0}','1');
INSERT INTO `tbl_page_widgets` VALUES ('292','1614030979367.4','92','locations','{\"widget_title\":\"\\u0627\\u0633\\u062a\\u0627\\u0646 \\u0647\\u0627\"}','1');
INSERT INTO `tbl_page_widgets` VALUES ('429','1613851221696.8','6','latest-posts','{\"widget_title\":\"\\u062a\\u0627\\u0632\\u0647 \\u062a\\u0631\\u06cc\\u0646 \\u0645\\u0637\\u0627\\u0644\\u0628\",\"count\":10}','1');
INSERT INTO `tbl_page_widgets` VALUES ('430','1613851223661.5','6','site-links','{\"widget_title\":\"\\u0644\\u06cc\\u0646\\u06a9 \\u0647\\u0627\\u06cc \\u0633\\u0627\\u06cc\\u062a\",\"links_count\":6}','1');
INSERT INTO `tbl_page_widgets` VALUES ('437','1614199885326.2','127','banners-for-categories','{\"widget_title\":\"\\u0628\\u0646\\u0631\\u0647\\u0627\\u06cc \\u062a\\u0628\\u0644\\u06cc\\u063a\\u0627\\u062a\\u06cc\",\"count\":0}','1');
INSERT INTO `tbl_page_widgets` VALUES ('380',1614201682238,'128','banners-for-categories','{\"widget_title\":\"\\u0628\\u0646\\u0631\\u0647\\u0627\\u06cc \\u0633\\u0627\\u06cc\\u062f\\u0628\\u0627\\u0631\",\"count\":\"0\"}','1');
INSERT INTO `tbl_page_widgets` VALUES ('381','1614202370657.3','129','banners-for-categories','{\"widget_title\":\"\\u0628\\u0646\\u0631\\u0647\\u0627\\u06cc \\u0633\\u0627\\u06cc\\u062f\\u0628\\u0627\\u0631\",\"count\":0}','1');
INSERT INTO `tbl_page_widgets` VALUES ('428','1613851218261.3','6','blog-categories','{\"widget_title\":\"\\u06af\\u0631\\u0648\\u0647 \\u0628\\u0646\\u062f\\u06cc \\u0645\\u0637\\u0627\\u0644\\u0628\",\"show_post_count\":\"YES\"}','1');
INSERT INTO `tbl_page_widgets` VALUES ('427','1613850628219.5','6','blog-search','{\"widget_title\":\"\\u062c\\u0633\\u062a\\u062c\\u0648 \\u062f\\u0631 \\u0645\\u0637\\u0627\\u0644\\u0628\",\"input_placeholder\":\"\\u062c\\u0633\\u062a\\u062c\\u0648 ...\"}','1');
UNLOCK TABLES;

-- Table structure for table `tbl_pages`

DROP TABLE IF EXISTS `tbl_pages`;
CREATE TABLE `tbl_pages` (
  `ID` int NOT NULL AUTO_INCREMENT,
  `TITLE` varchar(255) NOT NULL,
  `SLUG` varchar(100) NOT NULL,
  `BODY` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci NOT NULL,
  `DATE_CREATED` datetime NOT NULL,
  `IS_CONTACT` tinyint(1) NOT NULL DEFAULT '1',
  `IS_ACTIVE` tinyint(1) NOT NULL DEFAULT '2',
  `META_KEYWORDS` text,
  `META_DESCRIPTION` text,
  `DEFAULT_TITLE` varchar(255) DEFAULT NULL,
  `META_TITLE` varchar(255) DEFAULT NULL,
  `IS_DELETABLE` tinyint(1) NOT NULL DEFAULT '1',
  `EDIT_TITLE` tinyint(1) NOT NULL DEFAULT '1',
  `EDIT_SLUG` tinyint(1) NOT NULL DEFAULT '1',
  `EDIT_BODY` tinyint(1) NOT NULL DEFAULT '1',
  `SITEMAP` tinyint(1) NOT NULL DEFAULT '1',
  `is_admin` tinyint(1) NOT NULL DEFAULT '0',
  `parent_id` int NOT NULL DEFAULT '0',
  `route` varchar(255) DEFAULT NULL,
  `path` varchar(255) DEFAULT NULL,
  `options` text,
  `settings` longtext,
  `has_menu` tinyint(1) NOT NULL DEFAULT '1',
  `is_public` smallint DEFAULT '2',
  `is_editable` smallint NOT NULL DEFAULT '2',
  `has_widget_area` smallint NOT NULL DEFAULT '1',
  `edit_seo_fields` smallint NOT NULL DEFAULT '2',
  PRIMARY KEY (`ID`,`SLUG`)
) ENGINE=InnoDB AUTO_INCREMENT=142 DEFAULT CHARSET=utf8mb3;

-- Dumping data for table `tbl_pages`

LOCK TABLES `tbl_pages` WRITE;
INSERT INTO `tbl_pages` VALUES ('1','تماس با ما','contact-us','<p>جهت کسب اطلاعات بیشتر در مورد روند ثبت آگهی ها و رفع مشکلات و ابهامات خود ، با ما در تماس باشید</p>\r\n','2014-10-16 00:00:00','2','2','','','تماس با ما | {%site_title%}','','0','0','0','1','1','0','0',NULL,NULL,'{\r\n\"controller\": \"includes/core/pages/pages/contact_controller.php\",\r\n\"content\": \"includes/theme/pages/pages/contact/main.php\",\r\n\"has_map\": true,\r\n\"js_validation\": true,\r\n\"js_files\": [\r\n\"public/theme/js/pages/contact.js\"\r\n],\r\n\"css_files\": [\r\n\"public/theme/css/pages/contact.css\"\r\n]\r\n}','[{\"key\":\"show-map\",\"type\":\"boolean\",\"name\":\"\\u0646\\u0645\\u0627\\u06cc\\u0634 \\u0646\\u0642\\u0634\\u0647\",\"value\":\"YES\"}]','1','2','2','1','2');
INSERT INTO `tbl_pages` VALUES ('2','قوانین و شرایط استفاده','terms','<p>شما می توانید متن این قسمت را از طریق بخش برگه ها به دلخواه خود تغییر دهید</p>\n','2017-02-25 15:36:56','1','2','','قوانین و مقررات','قوانین و شرایط استفاده از {%site_title%}','','0','0','0','1','1','0','0',NULL,NULL,NULL,NULL,'1','2','2','1','2');
INSERT INTO `tbl_pages` VALUES ('3','ثبت آگهی','new','','2017-11-16 00:00:00','1','2','ثبت آگهی جدید در وب سایت','ثبت آگهی، ثبت آگهی رایگان، ثبت همه چیز','ثبت آگهی در {%site_title%}','','0','0','0','0','0','0','0',NULL,NULL,'{\r\n\"url\": \"new\",\r\n\"controller\": \"includes/core/pages/submit/submit_controller.php\",\r\n\"content\": \"includes/theme/pages/submit/main.php\",\r\n\"has_upload\": true,\r\n\"has_map\": true,\r\n\"js_validation\": true,\r\n\"has_coupon\": true,\r\n\"has_modal\": true,\r\n\"show_floating_button\": false,\r\n\"js_files\": [\r\n  \"public/lib/select2-master/dist/js/select2.min.js\", \"public/theme/js/pages/submit/submit.min.js\",\r\n\"public/lib/jquery.countdown/dist/jquery.countdown.min.js\",\r\n\"public/core/js/scripts/activation.min.js\"\r\n],\r\n\"css_files\": [\r\n  \"public/lib/select2-master/dist/css/select2.min.css\"\r\n]\r\n}','','1','1','2','1','2');
INSERT INTO `tbl_pages` VALUES ('4','ورود','login','','2017-11-16 00:00:00','1','2','','','ورود -\n ثبت نام |\n {%site_title%}','','0','0','0','0','0','0','0',NULL,NULL,'{\r\n\"url\": \"auth/login\",\r\n\"controller\": \"includes/core/pages/auth/login_controller.php\",\r\n\"content\": \"includes/theme/pages/auth/login.php\",\r\n\"show_footer\": false,\r\n\"js_validation\": true,\r\n\"show_floating_button\": false,\r\n\"show_apllication\": false,\r\n\"js_files\": [\r\n\"public/theme/js/pages/auth/login.js\"\r\n]\r\n}',NULL,'1','1','2','1','2');
INSERT INTO `tbl_pages` VALUES ('5','تعرفه آگهی ها','pricing','','2017-11-16 00:00:00','1','2','','','تعرفه آگهی ها | {%site_title%}','','0','0','0','0','0','0','0',NULL,NULL,'{\r\n\"url\": \"pricing\",\r\n\"controller\": \"includes/core/pages/pages/pricing_controller.php\",\r\n\"content\": \"includes/theme/pages/pages/pricing.php\",\r\n\"css_files\": [\r\n\"public/theme/css/pages/pricing.css\"\r\n]\r\n}','[{\"key\":\"order-button-text\",\"type\":\"text\",\"name\":\"\\u0645\\u062a\\u0646 \\u062f\\u06a9\\u0645\\u0647 \\u0633\\u0641\\u0627\\u0631\\u0634 \\u067e\\u0644\\u0627\\u0646 \\u0647\\u0627\",\"description\":\"\\u062f\\u0631 \\u0635\\u0648\\u0631\\u062a \\u062e\\u0627\\u0644\\u06cc \\u0628\\u0648\\u062f\\u0646\\u060c \\u062f\\u06a9\\u0645\\u0647 \\u0646\\u0645\\u0627\\u06cc\\u0634 \\u062f\\u0627\\u062f\\u0647 \\u0646\\u062e\\u0648\\u0627\\u0647\\u062f \\u0634\\u062f\",\"value\":\"\\u0633\\u0641\\u0627\\u0631\\u0634 \\u062f\\u0647\\u06cc\\u062f\"},{\"key\":\"description\",\"type\":\"textarea\",\"name\":\"\\u062a\\u0648\\u0636\\u06cc\\u062d\\u0627\\u062a \\u062a\\u06a9\\u0645\\u06cc\\u0644\\u06cc\",\"value\":\"<p>\\u0634\\u0645\\u0627 \\u0628\\u0647 \\u0639\\u0646\\u0648\\u0627\\u0646 \\u0645\\u062f\\u06cc\\u0631 \\u0633\\u0627\\u06cc\\u062a \\u0645\\u06cc \\u062a\\u0648\\u0627\\u0646\\u06cc\\u062f \\u062a\\u0645\\u0627\\u0645 \\u0648\\u06cc\\u0698\\u06af\\u06cc \\u0647\\u0627\\u06cc \\u067e\\u0644\\u0627\\u0646 \\u0647\\u0627\\u06cc \\u062a\\u0639\\u0631\\u06cc\\u0641 \\u0634\\u062f\\u0647 \\u0627\\u0632 \\u062c\\u0645\\u0644\\u0647 \\u0642\\u06cc\\u0645\\u062a \\u060c \\u062a\\u0639\\u062f\\u0627\\u062f \\u0631\\u0648\\u0632\\u0647\\u0627 \\u060c \\u0627\\u0648\\u0644\\u0648\\u06cc\\u062a \\u062f\\u0631 \\u0645\\u0648\\u062a\\u0648\\u0631 \\u062c\\u0633\\u062a\\u062c\\u0648 \\u0648 ... \\u0631\\u0627 \\u0627\\u0632 \\u0637\\u0631\\u06cc\\u0642 \\u0642\\u0633\\u0645\\u062a \\u0645\\u062f\\u06cc\\u0631\\u06cc\\u062a \\u0628\\u0647 \\u062f\\u0644\\u062e\\u0648\\u0627\\u0647 \\u062e\\u0648\\u062f \\u062a\\u063a\\u06cc\\u06cc\\u0631 \\u062f\\u0647\\u06cc\\u062f. \\u0647\\u0645\\u0686\\u0646\\u06cc\\u0646 \\u0645\\u06cc \\u062a\\u0648\\u0627\\u0646\\u06cc\\u062f \\u0627\\u06cc\\u0646 \\u0645\\u062a\\u0646 \\u0631\\u0627 \\u0646\\u06cc\\u0632 \\u0628\\u0647 \\u062f\\u0644\\u062e\\u0648\\u0627\\u0647 \\u062e\\u0648\\u062f \\u062a\\u063a\\u06cc\\u06cc\\u0631 \\u062f\\u0627\\u062f\\u0647 \\u062a\\u0648\\u0636\\u06cc\\u062d\\u0627\\u062a\\u06cc \\u062f\\u0631 \\u0645\\u0648\\u0631\\u062f \\u067e\\u0644\\u0627\\u0646 \\u0647\\u0627 \\u0648 ... \\u0631\\u0627 \\u062f\\u0631 \\u0627\\u06cc\\u0646 \\u0642\\u0633\\u0645\\u062a \\u0627\\u0631\\u0627\\u0626\\u0647 \\u062f\\u0647\\u06cc\\u062f \\u0648 \\u06cc\\u0627 \\u0627\\u06cc\\u0646\\u06a9\\u0647 \\u06a9\\u0644\\u0627 \\u0627\\u06cc\\u0646 \\u0642\\u0633\\u0645\\u062a \\u0631\\u0627 \\u062d\\u0630\\u0641 \\u0646\\u0645\\u0627\\u06cc\\u06cc\\u062f !!!<\\/p>\\r\\n\",\"description\":\"\\u0627\\u06cc\\u0646 \\u0645\\u062a\\u0646 \\u062f\\u0631 \\u0627\\u0646\\u062a\\u0647\\u0627\\u06cc \\u0635\\u0641\\u062d\\u0647 \\u0646\\u0645\\u0627\\u06cc\\u0634 \\u062f\\u0627\\u062f\\u0647 \\u062e\\u0648\\u0627\\u0647\\u062f \\u0634\\u062f\"}]','1','1','2','1','2');
INSERT INTO `tbl_pages` VALUES ('6','بلاگ','blog','','2017-11-16 00:00:00','1','2','','','خبرهای سایت | {%site_title%}','','0','0','0','0','0','0','0',NULL,NULL,'{\r\n\"url\": \"blog\",\r\n\"controller\": \"includes/core/pages/blog/list_controller.php\",\r\n\"content\": \"includes/theme/pages/blog/list.php\"\r\n}','[{\"key\":\"item-per-page\",\"type\":\"number\",\"name\":\"\\u062a\\u0639\\u062f\\u0627\\u062f \\u0622\\u06cc\\u062a\\u0645 \\u0647\\u0627 \\u062f\\u0631 \\u0647\\u0631 \\u0635\\u0641\\u062d\\u0647\",\"value\":\"10\"},{\"key\":\"enable-widget-area\",\"type\":\"boolean\",\"name\":\"\\u0641\\u0639\\u0627\\u0644 \\u0633\\u0627\\u0632\\u06cc \\u0646\\u0627\\u062d\\u06cc\\u0647 \\u0627\\u0628\\u0632\\u0627\\u0631\\u06a9\\u06cc \\u0635\\u0641\\u062d\\u0647\",\"value\":\"YES\"},{\"key\":\"show-banners\",\"type\":\"boolean\",\"name\":\"\\u0646\\u0645\\u0627\\u06cc\\u0634 \\u0628\\u0646\\u0631\\u0647\\u0627\\u06cc \\u062a\\u0628\\u0644\\u06cc\\u063a\\u0627\\u062a\\u06cc\",\"value\":\"NO\"}]','1','1','2','2','2');
INSERT INTO `tbl_pages` VALUES ('7','تمام گروه ها','all-categories','','2017-11-16 00:00:00','1','2','','','همه گروه ها | {%site_title%}','','0','0','0','0','0','0','0',NULL,NULL,'{\r\n\"url\": \"all-categories\",\r\n\"controller\": \"includes/core/pages/pages/all_categories_controller.php\",\r\n\"content\": \"includes/theme/pages/pages/all_categories.php\",\r\n\"css_files\": [\r\n \"public/theme/css/pages/categories.css\"\r\n]\r\n}','','1','1','2','1','2');
INSERT INTO `tbl_pages` VALUES ('8','پیشخوان','dashboard','','2019-03-06 00:00:00','1','2',NULL,NULL,'پیشخوان','','0','0','0','0','0','1','0',NULL,'index.php','',NULL,'1','1','2','1','2');
INSERT INTO `tbl_pages` VALUES ('9','مدیریت آگهی ها','ads-list','','2019-03-06 00:00:00','1','2',NULL,NULL,'مدیریت آگهی ها','','0','0','0','0','0','1','0','ads','ads__list.php','{\n\"minimize_sidebar\": true,\n\"icon\": \"fa fa-bullhorn\"\n}',NULL,'1','1','2','1','2');
INSERT INTO `tbl_pages` VALUES ('10','ثبت آگهی جدید','ads-create','','2019-03-06 00:00:00','1','2',NULL,NULL,'ثبت آگهی جدید','','0','0','0','0','0','1','9','ads','ads__create.php','{\n\"minimize_sidebar\": true,\n\"icon\": \"fa fa-edit\"\n}',NULL,'1','1','2','1','2');
INSERT INTO `tbl_pages` VALUES ('11','ویرایش آگهی','ads-edit','','2019-03-06 00:00:00','1','2',NULL,NULL,'ویرایش آگهی','','0','0','0','0','0','1','9','ads','ads__edit.php','{\n\"module_code\": \"ADS_MANAGE\",\n\"related_menu_route\": \"ads__list.php\",\n\"minimize_sidebar\": true,\n\"icon\": \"fa fa-edit\"\n}',NULL,'0','1','2','1','2');
INSERT INTO `tbl_pages` VALUES ('12','مدیریت دیدگاه ها','comments-list-ads','','2019-03-06 00:00:00','1','2',NULL,NULL,'مدیریت دیدگاه ها','','0','0','0','0','0','1','0','ads/comments','comments__list_ads.php','{\n\"minimize_sidebar\": true,\n\"icon\": \"fa fa-comments\"\n}',NULL,'1','1','2','1','2');
INSERT INTO `tbl_pages` VALUES ('13','ویرایش دیدگاه','comments-edit','','2019-03-06 00:00:00','1','2',NULL,NULL,'ویرایش دیدگاه','','0','0','0','0','0','1','12','comments','comments__edit.php','{\n\"module_code\": \"ADS_MANAGE\",\n\"related_menu_route\": \"comments__list_ads.php\",\n\"icon\": \"fa fa-comment-dots\"\n}',NULL,'0','1','2','1','2');
INSERT INTO `tbl_pages` VALUES ('14','آگهی های کانال تلگرام','telegrambox-ads','','2019-03-06 00:00:00','1','2',NULL,NULL,'آگهی های کانال تلگرام','','0','0','0','0','0','1','0','ads/telegrambox','telegrambox__ads.php','{\n\"minimize_sidebar\": true,\n\"icon\": \"fa fa-paper-plane\"\n}',NULL,'1','1','2','1','2');
INSERT INTO `tbl_pages` VALUES ('15','مدیریت دسته ها','categories-list','','2019-03-06 00:00:00','1','2',NULL,NULL,'مدیریت دسته ها','','0','0','0','0','0','1','0','category','categories__list.php','{\n\"icon\": \"fa fa-align-right\"\n}',NULL,'1','1','2','1','2');
INSERT INTO `tbl_pages` VALUES ('16','افزودن دسته','categories-create','','2019-03-06 00:00:00','1','2',NULL,NULL,'افزودن دسته','','0','0','0','0','0','1','15','ads','categories__create.php','{\n\"minimize_sidebar\": true,\n\"icon\": \"fa fa-align-right\"\n}',NULL,'1','1','2','1','2');
INSERT INTO `tbl_pages` VALUES ('17','ویرایش دسته','categories-edit','','2019-03-06 00:00:00','1','2',NULL,NULL,'ویرایش دسته','','0','0','0','0','0','1','15','category','categories__edit.php','{\n\"minimize_sidebar\": true,\n\"module_code\": \"CATEGORY_MANAGE\",\n\"related_menu_route\": \"categories__list.php\",\n\"icon\": \"fa fa-sitemap\"\n}',NULL,'0','1','2','1','2');
INSERT INTO `tbl_pages` VALUES ('18','مدیریت زیردسته ها','subcategories-list','','2019-03-06 00:00:00','1','2',NULL,NULL,'مدیریت زیردسته ها','','0','0','0','0','0','1','0','subcategory','subcategories__list.php','{\n\"icon\": \"fa fa-align-right\"\n}',NULL,'1','1','2','1','2');
INSERT INTO `tbl_pages` VALUES ('19','اولویت بندی دسته ها','categories-sort','','2019-03-06 00:00:00','1','2',NULL,NULL,'اولویت بندی دسته ها','','0','0','0','0','0','1','0','category/sort','categories__sort.php','{\n\"icon\": \"fa fa-align-justify\"\n}',NULL,'1','1','2','1','2');
INSERT INTO `tbl_pages` VALUES ('20','فیلدهای اختصاصی','custom-fields','','2019-03-06 00:00:00','1','2',NULL,NULL,'فیلدهای اختصاصی','','0','0','0','0','0','1','0','category/custom-fields','categories__custom_fields.php','{\n\"icon\": \"fa fa-cog\"\n}',NULL,'1','1','2','1','2');
INSERT INTO `tbl_pages` VALUES ('21','مدیریت کوپن ها','coupons-list','','2019-03-06 00:00:00','1','2',NULL,NULL,'مدیریت کوپن ها','','0','0','0','0','0','1','0','coupons','coupons__list.php','{\n\"minimize_sidebar\": true,\n\"icon\": \"fa fa-tags\"\n}',NULL,'1','1','2','1','2');
INSERT INTO `tbl_pages` VALUES ('22','افزودن کوپن','coupons-create','','2019-03-06 00:00:00','1','2',NULL,NULL,'افزودن کوپن','','0','0','0','0','0','1','15','coupons/create','coupons__create.php','{\n\"minimize_sidebar\": true,\n\"icon\": \"fa fa-tag\"\n}',NULL,'1','1','2','1','2');
INSERT INTO `tbl_pages` VALUES ('23','ویرایش کوپن','coupons-edit','','2019-03-06 00:00:00','1','2',NULL,NULL,'ویرایش کوپن','','0','0','0','0','0','1','21','coupons','coupons__edit.php','{\n\"minimize_sidebar\": true,\n\"module_code\": \"COUPON_MANAGE\",\n\"related_menu_route\": \"coupons__list.php\",\n\"icon\": \"fa fa-tag\"\n}',NULL,'0','1','2','1','2');
INSERT INTO `tbl_pages` VALUES ('24','مدیریت کاربران','users-list','','2019-03-06 00:00:00','1','2',NULL,NULL,'مدیریت کاربران','','0','0','0','0','0','1','0','users','users__list.php','{\"minimize_sidebar\": true,\r\n\"icon\": \"flaticon-users-1\"\r\n}',NULL,'1','1','2','1','2');
INSERT INTO `tbl_pages` VALUES ('25','ویرایش مشخصات کاربر','users-edit','','2019-03-06 00:00:00','1','2',NULL,NULL,'ویرایش مشخصات کاربر','','0','0','0','0','0','1','24','users','users__edit.php','{\"minimize_sidebar\": true,\r\n\"module_code\": \"USER_MANAGE\",\r\n\"related_menu_route\": \"users__list.php\",\r\n\"icon\": \"fa fa-user\"\r\n}',NULL,'0','1','2','1','2');
INSERT INTO `tbl_pages` VALUES ('26','پروفایل کاربر','users-profile','','2019-03-06 00:00:00','1','2',NULL,NULL,'پروفایل کاربر','','0','0','0','0','0','1','24','users','users__profile.php','{\"minimize_sidebar\": true,\r\n\"module_code\": \"USER_MANAGE\",\r\n\"related_menu_route\": \"users__list.php\",\r\n\"icon\": \"fa fa-user\"\r\n}',NULL,'0','1','1','1','2');
INSERT INTO `tbl_pages` VALUES ('27','افزودن کاربر','users-create','','2019-03-06 00:00:00','1','2',NULL,NULL,'افزودن کاربر','','0','0','0','0','0','1','24','users/create','users__create.php','{\n\"minimize_sidebar\": true,\n\"icon\": \"fa fa-user-plus\"\n}',NULL,'1','1','2','1','2');
INSERT INTO `tbl_pages` VALUES ('28','بانک ایمیل کاربران','users-database-email','','2019-03-06 00:00:00','1','2',NULL,NULL,'بانک ایمیل کاربران','','0','0','0','0','0','1','0','users/database/email','users__database_email.php','{\n\"icon\": \"fa fa-envelope\"\n}',NULL,'1','1','2','1','2');
INSERT INTO `tbl_pages` VALUES ('29','بانک تلفن کاربران','users-database-phone','','2019-03-06 00:00:00','1','2',NULL,NULL,'بانک تلفن کاربران','','0','0','0','0','0','1','0','users/database/phone','users__database_phone.php','{\n\n\"icon\": \"fa fa-phone-volume\"\n\n}',NULL,'1','1','2','1','2');
INSERT INTO `tbl_pages` VALUES ('30','تعیین سطوح دسترسی','users-roles','','2019-03-06 00:00:00','1','2',NULL,NULL,'تعیین سطوح دسترسی','','0','0','0','0','0','1','0','users/roles','users__roles.php','{\n\"icon\": \"fa fa-user-alt-slash\"\n}',NULL,'1','1','2','1','2');
INSERT INTO `tbl_pages` VALUES ('31','مدیریت استان ها','locations-state','','2019-03-06 00:00:00','1','2',NULL,NULL,'مدیریت استان ها','','0','0','0','0','0','1','0','locations/states','locations__state.php','{\n\"icon\": \"fa fa-map-marker-alt\"\n}',NULL,'1','1','2','1','2');
INSERT INTO `tbl_pages` VALUES ('32','مدیریت شهرها','locations-city','','2019-03-06 00:00:00','1','2',NULL,NULL,'مدیریت شهرها','','0','0','0','0','0','1','0','locations/cities','locations__city.php','{\n\"icon\": \"fa fa-map-marker-alt\"\n}',NULL,'1','1','2','1','2');
INSERT INTO `tbl_pages` VALUES ('33','افزودن منطقه','locations-create','','2019-03-06 00:00:00','1','2',NULL,NULL,'افزودن منطقه','','0','0','0','0','0','1','0','locations/create','locations__create.php','{\n\"minimize_sidebar\": true,\n\"icon\": \"fa fa-map-marker-alt\"\n}',NULL,'1','1','2','1','2');
INSERT INTO `tbl_pages` VALUES ('34','ویرایش منطقه','locations-edit','','2019-03-06 00:00:00','1','2',NULL,NULL,'ویرایش منطقه','','0','0','0','0','0','1','33','locations','locations__edit.php','{\n\"module_code\": \"LOCATION_MANAGE\",\n\"related_menu_route\": \"locations__state.php\",\n\"icon\": \"fa fa-map-marker-alt\"\n}',NULL,'0','1','2','1','2');
INSERT INTO `tbl_pages` VALUES ('35','مدیریت پست ها و مطالب','posts-list','','2019-03-06 00:00:00','1','2',NULL,NULL,'مدیریت پست ها و مطالب','','0','0','0','0','0','1','0','posts','posts__list.php','{\n\"minimize_sidebar\": true,\n\"icon\": \"flaticon-edit\"\n}',NULL,'1','1','2','1','2');
INSERT INTO `tbl_pages` VALUES ('36','افزودن پست جدید','posts-create','','2019-03-06 00:00:00','1','2',NULL,NULL,'افزودن پست جدید','','0','0','0','0','0','1','0','posts/create','posts__create.php','{\n\"minimize_sidebar\": true,\n\"icon\": \"flaticon-edit-1\"\n}',NULL,'1','1','2','1','2');
INSERT INTO `tbl_pages` VALUES ('37','ویرایش پست','posts-edit','','2019-03-06 00:00:00','1','2',NULL,NULL,'ویرایش پست','','0','0','0','0','0','1','35','users','posts__profile.php','{\r\n\"module_code\": \"POST_MANAGE\",\r\n\"related_menu_route\": \"posts__list.php\",\r\n\"icon\": \"flaticon-edit-1\",\r\n\"minimize_sidebar\": true\r\n}',NULL,'0','1','2','1','2');
INSERT INTO `tbl_pages` VALUES ('38','دسته بندی پست ها','posts-categories','','2019-03-06 00:00:00','1','2',NULL,NULL,'دسته بندی پست ها','','0','0','0','0','0','1','0','posts/categories','posts__categories.php','{\n\"icon\": \"flaticon-list\"\n}',NULL,'1','1','2','1','2');
INSERT INTO `tbl_pages` VALUES ('39','افزودن دسته بندی پست ها','posts-categories--create','','2019-03-06 00:00:00','1','2',NULL,NULL,'افزودن دسته بندی پست ها','','0','0','0','0','0','1','38','posts/categories/create','posts__categories_create.php','{\n\"module_code\": \"POST_MANAGE\",\n\"related_menu_route\": \"posts__categories.php\",\n\"icon\": \"flaticon-list\"\n}',NULL,'0','1','2','1','2');
INSERT INTO `tbl_pages` VALUES ('40','ویرایش دسته بندی پست ها','posts-categories--edit','','2019-03-06 00:00:00','1','2',NULL,NULL,'ویرایش دسته بندی پست ها','','0','0','0','0','0','1','38','posts/categories','posts__categories_edit.php','{\n\"module_code\": \"POST_MANAGE\",\n\"related_menu_route\": \"posts__categories.php\",\n\"icon\": \"flaticon-list\"\n}',NULL,'0','1','2','1','2');
INSERT INTO `tbl_pages` VALUES ('41','پست های کانال تلگرام','telegrambox-posts','','2019-03-06 00:00:00','1','2',NULL,NULL,'پست های کانال تلگرام','','0','0','0','0','0','1','0','posts/telegrambox','telegrambox__posts.php','{\n\"minimize_sidebar\": true,\n\"icon\": \"fa fa-paper-plane\"\n}',NULL,'1','1','2','1','2');
INSERT INTO `tbl_pages` VALUES ('42','تنظیمات عمومی سایت','settings-main','','2019-03-06 00:00:00','1','2',NULL,NULL,'تنظیمات عمومی سایت','','0','0','0','0','0','1','0','settings/main','settings__main.php','{\"minimize_sidebar\": true,\r\n\"icon\": \"flaticon-share\"\r\n}',NULL,'1','1','2','1','2');
INSERT INTO `tbl_pages` VALUES ('43','تنظیمات مشخصات فردی سایت','settings-main--personal','','2019-03-06 00:00:00','1','2',NULL,NULL,'تنظیمات مشخصات فردی سایت','','0','0','0','0','0','1','42','settings/main/personal','settings__main--personal.php','{\"minimize_sidebar\": true,\r\n\"module_code\": \"SETTING_MANAGE\",\r\n\"related_menu_route\": \"settings__main.php\",\r\n\"icon\": \"fa fa-user-circle\"\r\n}',NULL,'0','1','2','1','2');
INSERT INTO `tbl_pages` VALUES ('44','تنظیمات لوگو و تصاویر','settings-main--images','','2019-03-06 00:00:00','1','2',NULL,NULL,'تنظیمات لوگو و تصاویر','','0','0','0','0','0','1','42','settings/main/images','settings__main--images.php','{\"minimize_sidebar\": true,\r\n\"module_code\": \"SETTING_MANAGE\",\r\n\"related_menu_route\": \"settings__main.php\",\r\n\"icon\": \"fa fa-camera\"\r\n}',NULL,'0','1','2','1','2');
INSERT INTO `tbl_pages` VALUES ('45','تنظیمات پرداخت و پلان های ویژه','settings-main--payment','','2019-03-06 00:00:00','1','2',NULL,NULL,'تنظیمات پرداخت و پلان های ویژه','','0','0','0','0','0','1','42','settings/main/payment','settings__main--payment.php','{\"minimize_sidebar\": true,\r\n\"module_code\": \"SETTING_MANAGE\",\r\n\"related_menu_route\": \"settings__main.php\",\r\n\"icon\": \"fa fa-hand-holding-usd\"\r\n}',NULL,'0','1','2','1','2');
INSERT INTO `tbl_pages` VALUES ('46','تنظیمات همکاری در فروش','settings-main--affiliate','','2019-03-06 00:00:00','1','2',NULL,NULL,'تنظیمات همکاری در فروش','','0','0','0','0','0','1','42','settings/main/affiliate','settings__main--affiliate.php','{\"minimize_sidebar\": true,\r\n\"module_code\": \"SETTING_MANAGE\",\r\n\"related_menu_route\": \"settings__main.php\",\r\n\"icon\": \"fa fa-hands-helping\"\r\n}',NULL,'0','1','2','1','2');
INSERT INTO `tbl_pages` VALUES ('47','تنظیمات اپلیکیشن','settings-main--application','','2019-03-06 00:00:00','1','2',NULL,NULL,'تنظیمات اپلیکیشن','','0','0','0','0','0','1','42','settings/main/application','settings__main--application.php','{\"minimize_sidebar\": true,\r\n\"module_code\": \"SETTING_MANAGE\",\r\n\"related_menu_route\": \"settings__main.php\",\r\n\"icon\": \"socicon-apple\"\r\n}',NULL,'0','1','2','1','2');
INSERT INTO `tbl_pages` VALUES ('48','تنظیمات حالت تعمیر','settings-main--maintenance','','2019-03-06 00:00:00','1','2',NULL,NULL,'تنظیمات حالت تعمیر','','0','0','0','0','0','1','42','settings/main/maintenance','settings__main--maintenance.php','{\"minimize_sidebar\": true,\r\n\"module_code\": \"SETTING_MANAGE\",\r\n\"related_menu_route\": \"settings__main.php\",\r\n\"icon\": \"fa fa-wrench\"\r\n}',NULL,'0','1','2','1','2');
INSERT INTO `tbl_pages` VALUES ('49','تنظیمات عمومی صفحه ها','settings-pages','','2019-03-06 00:00:00','1','2',NULL,NULL,'تنظیمات عمومی صفحه ها','','0','0','0','0','0','1','0','settings/pages','settings__pages.php','{\"minimize_sidebar\": true,\r\n\"icon\": \"fa fa-toolbox\"\r\n}',NULL,'1','1','2','1','2');
INSERT INTO `tbl_pages` VALUES ('50','تنظیمات سایدبارها','settings-pages--sidebars','','2019-03-06 00:00:00','1','2',NULL,NULL,'تنظیمات سایدبارها','','0','0','0','0','0','1','49','settings/pages/sidebars','settings__pages--sidebars.php','{\"minimize_sidebar\": true,\r\n\"module_code\": \"SETTING_MANAGE\",\r\n\"related_menu_route\": \"settings__pages.php\",\r\n\"icon\": \"fa fa-list-ul\"\r\n}',NULL,'0','1','2','1','2');
INSERT INTO `tbl_pages` VALUES ('51','تنظیمات فوتر','settings-pages--footer','','2019-03-06 00:00:00','1','2',NULL,NULL,'تنظیمات فوتر','','0','0','0','0','0','1','49','settings/pages/footer','settings__pages--footer.php','{\"minimize_sidebar\": true,\r\n\"module_code\": \"SETTING_MANAGE\",\r\n\"related_menu_route\": \"settings__pages.php\",\r\n\"icon\": \"fa fa-ellipsis-h\"\r\n}',NULL,'0','1','2','1','2');
INSERT INTO `tbl_pages` VALUES ('52','تنظیمات هدر','settings-pages--header','','2019-03-06 00:00:00','1','2',NULL,NULL,'تنظیمات هدر','','0','0','0','0','0','1','49','settings/pages/header','settings__pages--header.php','{\"minimize_sidebar\": true,\r\n\"module_code\": \"SETTING_MANAGE\",\r\n\"related_menu_route\": \"settings__pages.php\",\r\n\"icon\": \"fa fa-sitemap\"\r\n}',NULL,'0','1','2','1','2');
INSERT INTO `tbl_pages` VALUES ('53','تنظیمات پاپ آپ','settings-pages--popup','','2019-03-06 00:00:00','1','2',NULL,NULL,'تنظیمات پاپ آپ','','0','0','0','0','0','1','49','settings/pages/popup','settings__pages--popup.php','{\"minimize_sidebar\": true,\r\n\"module_code\": \"SETTING_MANAGE\",\r\n\"related_menu_route\": \"settings__pages.php\",\r\n\"icon\": \"fa fa-comment-alt\"\r\n}',NULL,'0','1','2','1','2');
INSERT INTO `tbl_pages` VALUES ('54','مدیریت صورتحساب های آنلاین','orders-online','','2019-03-06 00:00:00','1','2',NULL,NULL,'مدیریت صورتحساب های آنلاین','','0','0','0','0','0','1','0','orders/online','orders__online.php','{\n\"minimize_sidebar\": true,\n\"icon\": \"fa fa-clipboard-list\"\n}',NULL,'1','1','2','1','2');
INSERT INTO `tbl_pages` VALUES ('55','صورتحساب های ایجاد شده برای پرداخت توسط فیش بانکی','orders-bacs','','2019-03-06 00:00:00','1','2',NULL,NULL,'صورتحساب های ایجاد شده برای پرداخت توسط فیش بانکی','','0','0','0','0','0','1','0','orders/bacs','orders__bacs.php','{\n\"minimize_sidebar\": true,\n\"icon\": \"fa fa-clipboard-list\"\n}',NULL,'1','1','2','1','2');
INSERT INTO `tbl_pages` VALUES ('56','مشاهده صورتحساب','orders-view','','2019-03-06 00:00:00','1','2',NULL,NULL,'مشاهده صورتحساب','','0','0','0','0','0','1','55','orders/online','orders__view.php','{\n\"module_code\": \"USER_MANAGE\",\n\"related_menu_route\": \"orders__online.php\",\n\"icon\": \"fa fa-clipboard-list\"\n}',NULL,'0','1','2','1','2');
INSERT INTO `tbl_pages` VALUES ('57','مدیریت منوها','menus-list','','2019-03-06 00:00:00','1','2',NULL,NULL,'مدیریت منوها','','0','0','0','0','0','1','0','menu','menus__list.php','{\n\"icon\": \"fa fa-clone\"\n}',NULL,'1','1','2','1','2');
INSERT INTO `tbl_pages` VALUES ('58','افزودن منو','menus-create','','2019-03-06 00:00:00','1','2',NULL,NULL,'افزودن منو','','0','0','0','0','0','1','57','menus/create','menus__create.php','{\n\"module_code\": \"MENU_MANAGE\",\n\"related_menu_route\": \"menus__list.php\",\n\"icon\": \"fa fa-clone\"\n}',NULL,'0','1','2','1','2');
INSERT INTO `tbl_pages` VALUES ('59','ویرایش منو','menus-edit','','2019-03-06 00:00:00','1','2',NULL,NULL,'ویرایش منو','','0','0','0','0','0','1','57','menus','menus__edit.php','{\n\"module_code\": \"MENU_MANAGE\",\n\"related_menu_route\": \"menus__list.php\",\n\"icon\": \"fa fa-clone\"\n}',NULL,'0','1','2','1','2');
INSERT INTO `tbl_pages` VALUES ('60','اولویت بندی منوها','menus-sort','','2019-03-06 00:00:00','1','2',NULL,NULL,'اولویت بندی منوها','','0','0','0','0','0','1','0','menu/sort','menus__sort.php','{\n\"icon\": \"la la-sort\"\n}',NULL,'1','1','2','1','2');
INSERT INTO `tbl_pages` VALUES ('61','مدیریت برگه ها','pages-list','','2019-03-06 00:00:00','1','2',NULL,NULL,'مدیریت برگه ها','','0','0','0','0','0','1','0','pages','pages__list.php','{\r\n\"icon\": \"fa fa-clone\"\r\n}',NULL,'1','1','2','1','2');
INSERT INTO `tbl_pages` VALUES ('62','ویرایش برگه','pages-edit','','2019-03-06 00:00:00','1','2',NULL,NULL,'ویرایش برگه','','0','0','0','0','0','1','61','pages','pages__edit.php','{\r\n\"module_code\": \"PAGE_MANAGE\",\r\n\"related_menu_route\": \"pages__list.php\",\r\n\"icon\": \"fa fa-clone\"\r\n}',NULL,'0','1','2','1','2');
INSERT INTO `tbl_pages` VALUES ('64','افزودن برگه','pages-create','','2019-03-06 00:00:00','1','2',NULL,NULL,'افزودن برگه','','0','0','0','0','0','1','61','pages/create','pages__create.php','{\r\n\"module_code\": \"PAGE_MANAGE\",\r\n\"related_menu_route\": \"pages__list.php\",\r\n\"icon\": \"fa fa-clone\"\r\n}',NULL,'0','1','2','1','2');
INSERT INTO `tbl_pages` VALUES ('66','مدیریت بنرهای تبلیغاتی','banners-adv','','2019-03-06 00:00:00','1','2',NULL,NULL,'مدیریت بنرهای تبلیغاتی','','0','0','0','0','0','1','0','banner/adv','banners__adv.php','{\"minimize_sidebar\": true,\r\n\"icon\": \"fa fa-images\"\r\n}',NULL,'1','1','2','1','2');
INSERT INTO `tbl_pages` VALUES ('67','مدیریت اسلایدرها','banners-slider','','2019-03-06 00:00:00','1','2',NULL,NULL,'مدیریت اسلایدرها','','0','0','0','0','0','1','0','banner/slider','banners__slider.php','{\"minimize_sidebar\": true,\r\n\"icon\": \"fa fa-images\"\r\n}',NULL,'1','1','2','1','2');
INSERT INTO `tbl_pages` VALUES ('68','مدیریت اسلایدهای اپلیکیشن','banners-application-slider','','2019-03-06 00:00:00','1','2',NULL,NULL,'مدیریت اسلایدهای اپلیکیشن','','0','0','0','0','0','1','0','banner/application-slider','banners__application_slider.php','{\"minimize_sidebar\": true,\r\n\"icon\": \"fa fa-images\"\r\n}',NULL,'1','1','2','1','2');
INSERT INTO `tbl_pages` VALUES ('69','مدیریت درخواست های برداشت وجه','withdrawal-list','','2019-03-06 00:00:00','1','2',NULL,NULL,'مدیریت درخواست های برداشت وجه','','0','0','0','0','0','1','0','withdraw','withdraws__list.php','{\r\n\"icon\": \"fa fa-hands-helping\"\r\n}',NULL,'1','1','2','1','2');
INSERT INTO `tbl_pages` VALUES ('70','مدیریت بنرهای بازاریابی سایت','banners-affiliate','','2019-03-06 00:00:00','1','2',NULL,NULL,'مدیریت بنرهای بازاریابی سایت','','0','0','0','0','0','1','0','banner/affiliate','banners__affiliate.php','{\"minimize_sidebar\": true,\r\n\"icon\": \"fa fa-hands-helping\"\r\n}',NULL,'1','1','2','1','2');
INSERT INTO `tbl_pages` VALUES ('71','مدیریت پلان ها','plans-list','','2019-03-06 00:00:00','1','2',NULL,NULL,'مدیریت پلان ها','','0','0','0','0','0','1','0','plans','plans__list.php','{\r\n\"icon\": \"fa fa-star\"\r\n}',NULL,'1','1','2','1','2');
INSERT INTO `tbl_pages` VALUES ('72','افزودن پلان','plans-create','','2019-03-06 00:00:00','1','2',NULL,NULL,'افزودن پلان','','0','0','0','0','0','1','71','plans/create','plans__create.php','{\r\n\"module_code\": \"PLAN_MANAGE\",\r\n\"related_menu_route\": \"plans__list.php\",\r\n\"icon\": \"fa fa-star\"\r\n}',NULL,'0','1','2','1','2');
INSERT INTO `tbl_pages` VALUES ('73','ویرایش پلان','plans-edit','','2019-03-06 00:00:00','1','2',NULL,NULL,'ویرایش پلان','','0','0','0','0','0','1','71','plans/edit','plans__edit.php','{\r\n\"module_code\": \"PLAN_MANAGE\",\r\n\"related_menu_route\": \"plans__list.php\",\r\n\"icon\": \"fa fa-star\"\r\n}',NULL,'0','1','2','1','2');
INSERT INTO `tbl_pages` VALUES ('74','ارسال ایمیل های انقضای آگهی ها','expired-email','','2019-03-06 00:00:00','1','2',NULL,NULL,'ارسال ایمیل های انقضای آگهی ها','','0','0','0','0','0','1','0','expire/email','expire__emails.php','{\r\n\"icon\": \"fa fa-clock\"\r\n}',NULL,'1','1','2','1','2');
INSERT INTO `tbl_pages` VALUES ('75','مدیریت لینک های سایت','links-list','','2019-03-06 00:00:00','1','2',NULL,NULL,'مدیریت لینک های سایت','','0','0','0','0','0','1','0','links','links__list.php','{\r\n\"icon\": \"fa fa-share-alt\"\r\n}',NULL,'1','1','2','1','2');
INSERT INTO `tbl_pages` VALUES ('76','پشتیبان گیری از پایگاه داده','backup-list','','2019-03-06 00:00:00','1','2',NULL,NULL,'پشتیبان گیری از پایگاه داده','','0','0','0','0','0','1','0','backup','backup__list.php','{\r\n\"icon\": \"fa fa-cloud-download-alt\"\r\n}',NULL,'1','1','2','1','2');
INSERT INTO `tbl_pages` VALUES ('77','به روز رسانی نقشه سایت','sitemap-list','','2019-03-06 00:00:00','1','2',NULL,NULL,'به روز رسانی نقشه سایت','','0','0','0','0','0','1','0','sitemap','sitemaps__list.php','{\r\n\"icon\": \"fa fa-sitemap\"\r\n}',NULL,'1','1','2','1','2');
INSERT INTO `tbl_pages` VALUES ('78','نقشه سایت برای آگهی ها','sitemap-ads','','2019-03-06 00:00:00','1','2',NULL,NULL,'نقشه سایت برای آگهی ها','','0','0','0','0','0','1','77','sitemap/ads','sitemaps__ads.php','{\r\n\"module_code\": \"SITEMAP_MANAGE\",\r\n\"related_menu_route\": \"sitemaps__list.php\",\r\n\"icon\": \"fa fa-bullhorn\"\r\n}',NULL,'0','1','2','1','2');
INSERT INTO `tbl_pages` VALUES ('79','نقشه سایت برای پست ها','sitemap-post','','2019-03-06 00:00:00','1','2',NULL,NULL,'نقشه سایت برای پست ها','','0','0','0','0','0','1','77','sitemap/post','sitemaps__post.php','{\r\n\"module_code\": \"SITEMAP_MANAGE\",\r\n\"related_menu_route\": \"sitemaps__list.php\",\r\n\"icon\": \"fa fa-pencil-alt\"\r\n}',NULL,'0','1','2','1','2');
INSERT INTO `tbl_pages` VALUES ('80','مدیریت گزارش های خلاف قوانین','ads-report','','2019-03-06 00:00:00','1','2',NULL,NULL,'مدیریت گزارش های خلاف قوانین','','0','0','0','0','0','1','0','ads/report','ads__reports.php','{\r\n\"minimize_sidebar\": true,\r\n\"icon\": \"fa fa-exclamation-triangle\"\r\n}',NULL,'1','1','2','1','2');
INSERT INTO `tbl_pages` VALUES ('81','گزارشات پرداخت','orders-report','','2019-03-06 00:00:00','1','2',NULL,NULL,'گزارشات پرداخت','','0','0','0','0','0','1','0','orders/report','orders__report.php','{\r\n\"minimize_sidebar\": true\r\n}',NULL,'1','1','2','1','2');
INSERT INTO `tbl_pages` VALUES ('82','آمار بازدید','statistics','','2019-03-06 00:00:00','1','2',NULL,NULL,'آمار بازدید','','0','0','0','0','0','1','0','statistics','statistics.php','{\r\n\"minimize_sidebar\": true\r\n}','','1','1','2','1','2');
INSERT INTO `tbl_pages` VALUES ('83','مدیریت ایمیل ها','mailbox-email','','2019-03-06 00:00:00','1','2',NULL,NULL,'مدیریت ایمیل ها','','0','0','0','0','0','1','0','mailbox/email','mailbox__email.php','{\r\n\"minimize_sidebar\": true\r\n}',NULL,'1','1','2','1','2');
INSERT INTO `tbl_pages` VALUES ('84','صندوق پیامک ها','mailbox-sms','','2019-03-06 00:00:00','1','2',NULL,NULL,'صندوق پیامک ها','','0','0','0','0','0','1','0','mailbox/sms','mailbox__sms.php','{\r\n\"minimize_sidebar\": true\r\n}',NULL,'1','1','2','1','2');
INSERT INTO `tbl_pages` VALUES ('85','شرح عملکرد کاربر','users-history','','2019-03-06 00:00:00','1','2',NULL,NULL,'شرح عملکرد کاربر','','0','0','0','0','0','1','24','users','users__history.php','{\"minimize_sidebar\": true,\r\n\"module_code\": \"USER_MANAGE\",\r\n\"related_menu_route\": \"users__list.php\",\r\n\"icon\": \"fa flaticon-graphic-2\"\r\n}',NULL,'0','1','2','1','2');
INSERT INTO `tbl_pages` VALUES ('86','صندوق پیام های کاربر','users-messagebox','','2019-03-06 00:00:00','1','2',NULL,NULL,'صندوق پیام های کاربر','','0','0','0','0','0','1','24','users','users__messagebox.php','{\"minimize_sidebar\": true,\r\n\"module_code\": \"USER_MANAGE\",\r\n\"related_menu_route\": \"users__list.php\",\r\n\"icon\": \"flaticon-envelope\"\r\n}',NULL,'0','1','2','1','2');
INSERT INTO `tbl_pages` VALUES ('87','محدودیت نسخه دمو (پیش نمایش)','restrict-demo','','2019-03-06 00:00:00','1','2',NULL,NULL,'محدودیت نسخه دمو (پیش نمایش)','','0','0','0','0','0','1','0','restrict/demo','restrict__demo.php','',NULL,'0','1','2','1','2');
INSERT INTO `tbl_pages` VALUES ('88','خطای 404','restrict-404','','2020-12-27 00:00:00','1','2',NULL,NULL,'خطای 404','','0','0','0','0','0','1','0',404,'restrict__404.php','',NULL,'0','1','2','1','2');
INSERT INTO `tbl_pages` VALUES ('89','مدیریت دیدگاه ها','comments-list-post','','2020-07-17 00:00:00','1','2',NULL,NULL,'مدیریت دیدگاه ها','','0','0','0','0','0','1','0','posts/comments','comments__list_post.php','{\r\n\"minimize_sidebar\": true,\r\n\"icon\": \"fa fa-comments\"\r\n}',NULL,'1','1','2','1','2');
INSERT INTO `tbl_pages` VALUES ('90','ویرایش دیدگاه','comments-edit-post','','2019-03-06 00:00:00','1','2',NULL,NULL,'ویرایش دیدگاه','','0','0','0','0','0','1','89','comments','comments__edit.php','{\r\n\"module_code\": \"POST_MANAGE\",\r\n\"related_menu_route\": \"comments__list_post.php\",\r\n\"icon\": \"fa fa-comment-dots\"\r\n}',NULL,'0','1','2','1','2');
INSERT INTO `tbl_pages` VALUES ('92','جستجو','list','','2020-08-16 00:00:00','1','2',NULL,NULL,'جستجو',NULL,'0','0','0','0','0','0','0',NULL,NULL,'{\r\n\"url\": \"search\",\r\n\"controller\": \"includes/core/pages/list/controller.php\",\r\n\"content\": \"includes/theme/pages/list/main.php\"\r\n}','[{\"key\":\"item-per-page\",\"type\":\"number\",\"name\":\"\\u062a\\u0639\\u062f\\u0627\\u062f \\u0622\\u06cc\\u062a\\u0645 \\u0647\\u0627 \\u062f\\u0631 \\u0647\\u0631 \\u0635\\u0641\\u062d\\u0647\",\"value\":\"32\"},{\"key\":\"enable-widget-area\",\"type\":\"boolean\",\"name\":\"\\u0641\\u0639\\u0627\\u0644 \\u0633\\u0627\\u0632\\u06cc \\u0646\\u0627\\u062d\\u06cc\\u0647 \\u0627\\u0628\\u0632\\u0627\\u0631\\u06a9\\u06cc \\u0635\\u0641\\u062d\\u0647\",\"value\":\"NO\"},{\"key\":\"show-banners\",\"type\":\"boolean\",\"name\":\"\\u0646\\u0645\\u0627\\u06cc\\u0634 \\u0628\\u0646\\u0631\\u0647\\u0627\\u06cc \\u062a\\u0628\\u0644\\u06cc\\u063a\\u0627\\u062a\\u06cc\",\"value\":\"NO\"}]','1','1','2','2','1');
INSERT INTO `tbl_pages` VALUES ('93','ثبت نام','register','','2020-11-16 00:00:00','1','2','','',' ثبت نام |\r\n {%site_title%}','','0','0','0','0','0','0','0',NULL,NULL,'{\r\n\"url\": \"auth/register\",\r\n\"controller\": \"includes/core/pages/auth/register_controller.php\",\r\n\"content\": \"includes/theme/pages/auth/register.php\",\r\n\"show_footer\": false,\r\n\"js_validation\": true,\r\n\"show_floating_button\": false,\r\n\"show_apllication\": false,\r\n\"js_files\": [\r\n\"public/theme/js/pages/auth/register.js\"\r\n]\r\n}','[{\"key\":\"show-referer-field\",\"type\":\"boolean\",\"name\":\"\\u0646\\u0645\\u0627\\u06cc\\u0634 \\u0641\\u06cc\\u0644\\u062f \\u06a9\\u062f \\u0645\\u0639\\u0631\\u0641\",\"value\":\"NO\"}]','1','1','2','1','2');
INSERT INTO `tbl_pages` VALUES ('94','فراموشی رمز عبور','forgot-pass','','2020-11-16 00:00:00','1','2','','',' فراموشی رمز عبور |\r\n {%site_title%}','','0','0','0','0','0','0','0',NULL,NULL,'{\r\n\"controller\": \"includes/core/pages/auth/forgot_password_controller.php\",\r\n\"content\": \"includes/theme/pages/auth/forgot_password.php\",\r\n\"show_footer\": false,\r\n\"js_validation\": true,\r\n\"show_floating_button\": false,\r\n\"show_apllication\": false,\r\n\"js_files\": [\r\n\"public/theme/js/pages/auth/forgot_password.js\"\r\n]\r\n}',NULL,'1','1','1','1','2');
INSERT INTO `tbl_pages` VALUES ('95','تایید بازیابی رمزعبور','forgot-pass/verify','','2020-11-16 00:00:00','1','2','','',' تایید بازیابی رمزعبور |\r\n {%site_title%}','','0','0','0','0','0','0','0',NULL,NULL,'{\r\n\"controller\": \"includes/core/pages/auth/forgot_password_verify_controller.php\",\r\n\"content\": \"includes/theme/pages/auth/forgot_password_verify.php\",\r\n\"show_footer\": false,\r\n\"js_validation\": true,\r\n\"show_floating_button\": false,\r\n\"show_apllication\": false,\r\n\"js_files\": [\r\n\"public/theme/js/pages/auth/auth.js\"\r\n]\r\n}',NULL,'1','1','1','1','2');
INSERT INTO `tbl_pages` VALUES ('96','بازیابی رمزعبور','reset-pass','','2020-11-16 00:00:00','1','2','','',' بازیابی رمزعبور |\r\n {%site_title%}','','0','0','0','0','0','0','0',NULL,NULL,'{\r\n\"controller\": \"includes/core/pages/auth/reset_password_controller.php\",\r\n\"content\": \"includes/theme/pages/auth/reset_password.php\",\r\n\"show_footer\": false,\r\n\"js_validation\": true,\r\n\"show_apllication\": false,\r\n\"js_files\": [\r\n\"public/theme/js/pages/auth/auth.js\"\r\n]\r\n}',NULL,'1','1','1','1','2');
INSERT INTO `tbl_pages` VALUES ('97','فعال سازی حساب کاربری با ایمیل','activation','','2020-11-16 00:00:00','1','2','','',' فعال سازی حساب کاربری با ایمیل |\r\n {%site_title%}','','0','0','0','0','0','0','0',NULL,NULL,'{\r\n\"controller\": \"includes/core/pages/auth/activation.php\"\r\n}',NULL,'1','1','1','1','2');
INSERT INTO `tbl_pages` VALUES ('98','فعال سازی حساب کاربری','activate-email','','2020-11-16 00:00:00','1','2','','',' فعال سازی حساب کاربری |\r\n {%site_title%}','','0','0','0','0','0','0','0',NULL,NULL,'{\r\n\"controller\": \"includes/core/pages/auth/activate_email_controller.php\",\r\n\"content\": \"includes/theme/pages/auth/activate_email.php\",\r\n\"redirect_to_activation\": false,\r\n\"show_footer\": false,\r\n\"js_validation\": true,\r\n\"show_apllication\": false,\r\n\"show_floating_button\": false,\r\n\"js_files\": [\r\n\"public/lib/jquery.countdown/dist/jquery.countdown.min.js\",\r\n\"public/core/js/scripts/activation.min.js\",\r\n\"public/theme/js/pages/auth/activate_email.js\"\r\n]\r\n}',NULL,'1','1','1','1','2');
INSERT INTO `tbl_pages` VALUES ('99','فعال سازی حساب کاربری','activate-sms','','2020-11-16 00:00:00','1','2','','',' فعال سازی حساب کاربری |\r\n {%site_title%}','','0','0','0','0','0','0','0',NULL,NULL,'{\r\n\"controller\": \"includes/core/pages/auth/activate_sms_controller.php\",\r\n\"content\": \"includes/theme/pages/auth/activate_sms.php\",\r\n\"redirect_to_activation\": false,\r\n\"show_footer\": false,\r\n\"js_validation\": true,\r\n\"show_apllication\": false,\r\n\"show_floating_button\": false,\r\n\"js_files\": [\r\n\"public/lib/jquery.countdown/dist/jquery.countdown.min.js\",\r\n\"public/core/js/scripts/activation.min.js\",\r\n\"public/theme/js/pages/auth/activate_sms.js\"\r\n]\r\n}',NULL,'1','1','1','1','2');
INSERT INTO `tbl_pages` VALUES ('100','خانه','index','','2020-08-16 00:00:00','1','2','','','خانه','','0','0','0','0','0','0','0',NULL,NULL,'{\r\n\"url\": \"/\",\r\n\"controller\": \"includes/core/pages/main/controller.php\",\r\n\"content\": \"includes/theme/pages/main/main.php\",\r\n\"set_base\": false\r\n}','[{\"key\":\"top-title\",\"type\":\"text\",\"name\":\"\\u0639\\u0646\\u0648\\u0627\\u0646 \\u0628\\u0627\\u0644\\u0627\\u06cc \\u0635\\u0641\\u062d\\u0647\",\"value\":\"\\u0628\\u0647\\u062a\\u0631\\u06cc\\u0646 \\u0645\\u06a9\\u0627\\u0646 \\u0647\\u0627 \\u0631\\u0627 \\u062f\\u0631 \\u0634\\u0647\\u0631 \\u067e\\u06cc\\u062f\\u0627 \\u06a9\\u0646\\u06cc\\u062f\"},{\"key\":\"top-subtitle\",\"type\":\"text\",\"name\":\"\\u0632\\u06cc\\u0631\\u0639\\u0646\\u0648\\u0627\\u0646 \\u0628\\u0627\\u0644\\u0627\\u06cc \\u0635\\u0641\\u062d\\u0647\",\"value\":\"\\u0627\\u06cc\\u0646 \\u0632\\u06cc\\u0631\\u0639\\u0646\\u0648\\u0627\\u0646 \\u0635\\u0641\\u062d\\u0647 \\u0627\\u0635\\u0644\\u06cc \\u0627\\u0633\\u062a\"},{\"key\":\"show-category\",\"type\":\"boolean\",\"name\":\"\\u0646\\u0645\\u0627\\u06cc\\u0634 \\u062f\\u0633\\u062a\\u0647 \\u0628\\u0646\\u062f\\u06cc \\u0647\\u0627 \\u062f\\u0631 \\u0628\\u0627\\u0644\\u0627\\u06cc \\u0635\\u0641\\u062d\\u0647\",\"value\":\"YES\"},{\"key\":\"latest-ads-count\",\"type\":\"number\",\"name\":\"\\u062d\\u062f\\u0627\\u06a9\\u062b\\u0631 \\u062a\\u0639\\u062f\\u0627\\u062f \\u062a\\u0627\\u0632\\u0647 \\u062a\\u0631\\u06cc\\u0646 \\u0622\\u06af\\u0647\\u06cc \\u0647\\u0627\",\"value\":\"20\"},{\"key\":\"show-banners\",\"type\":\"boolean\",\"name\":\"\\u0646\\u0645\\u0627\\u06cc\\u0634 \\u0628\\u0646\\u0631\\u0647\\u0627\\u06cc \\u062a\\u0628\\u0644\\u06cc\\u063a\\u0627\\u062a\\u06cc\",\"value\":\"NO\"},{\"key\":\"show-banner-slider\",\"type\":\"boolean\",\"name\":\"\\u0646\\u0645\\u0627\\u06cc\\u0634 \\u0627\\u0633\\u0644\\u0627\\u06cc\\u062f\\u0631 \\u0628\\u0646\\u0631\\u0647\\u0627\\u06cc \\u062a\\u0628\\u0644\\u06cc\\u063a\\u0627\\u062a\\u06cc\",\"value\":\"NO\"},{\"key\":\"hero-background-type\",\"type\":\"select\",\"name\":\"\\u0646\\u0648\\u0639 \\u067e\\u0633 \\u0632\\u0645\\u06cc\\u0646\\u0647 \\u0642\\u0633\\u0645\\u062a \\u062c\\u0633\\u062a\\u062c\\u0648\",\"value\":\"PICTURE\",\"options\":{\"PICTURE\":\"\\u062a\\u0635\\u0648\\u06cc\\u0631 \\u062b\\u0627\\u0628\\u062a\",\"COLOR\":\"\\u0631\\u0646\\u06af \\u062b\\u0627\\u0628\\u062a\"},\"description\":\"\\u062f\\u0631 \\u0635\\u0648\\u0631\\u062a \\u0627\\u0646\\u062a\\u062e\\u0627\\u0628 \\u06af\\u0632\\u06cc\\u0646\\u0647 \\u062a\\u0635\\u0648\\u06cc\\u0631 \\u062b\\u0627\\u0628\\u062a\\u060c \\u0628\\u0627\\u06cc\\u062f \\u062a\\u0635\\u0648\\u06cc\\u0631 \\u0645\\u062f\\u0646\\u0638\\u0631 \\u0631\\u0627 \\u062f\\u0631 \\u0628\\u062e\\u0634 \\u062a\\u0646\\u0638\\u06cc\\u0645\\u0627\\u062a \\u0644\\u0648\\u06af\\u0648 \\u0648 \\u062a\\u0635\\u0627\\u0648\\u06cc\\u0631 \\u0633\\u0627\\u06cc\\u062a\\u060c \\u0622\\u067e\\u0644\\u0648\\u062f \\u0646\\u0645\\u0627\\u06cc\\u06cc\\u062f\"},{\"key\":\"show-application-part\",\"type\":\"boolean\",\"name\":\"\\u0646\\u0645\\u0627\\u06cc\\u0634 \\u0628\\u062e\\u0634 \\u062f\\u0627\\u0646\\u0644\\u0648\\u062f \\u0627\\u067e\\u0644\\u06cc\\u06a9\\u06cc\\u0634\\u0646 \\u0647\\u0627 \\u062f\\u0631 \\u0627\\u0646\\u062a\\u0647\\u0627\\u06cc \\u0635\\u0641\\u062d\\u0647\",\"value\":\"YES\"}]','1','1','2','1','2');
INSERT INTO `tbl_pages` VALUES ('101','پست بلاگ','blog-single','','2017-11-16 00:00:00','1','2',NULL,NULL,'',NULL,'0','0','0','0','0','0','0',NULL,NULL,'{\r\n\"controller\": \"includes/core/pages/blog/single_controller.php\",\r\n\"content\": \"includes/theme/pages/blog/single.php\",\r\n\"js_validation\": true,\r\n\"js_files\": [\r\n\"public/theme/js/pages/blog/single.js\"\r\n]\r\n}','[{\"key\":\"show-share\",\"type\":\"boolean\",\"name\":\"\\u0646\\u0645\\u0627\\u06cc\\u0634 \\u062f\\u06a9\\u0645\\u0647 \\u0627\\u0634\\u062a\\u0631\\u0627\\u06a9 \\u06af\\u0630\\u0627\\u0631\\u06cc\",\"value\":\"YES\"},{\"key\":\"show-prev-next-posts\",\"type\":\"boolean\",\"name\":\"\\u0646\\u0645\\u0627\\u06cc\\u0634 \\u0644\\u06cc\\u0646\\u06a9 \\u067e\\u0633\\u062a \\u0647\\u0627\\u06cc \\u0642\\u0628\\u0644 \\u0648 \\u0628\\u0639\\u062f\",\"value\":\"YES\"},{\"key\":\"show-comments\",\"type\":\"boolean\",\"name\":\"\\u0641\\u0639\\u0627\\u0644 \\u0633\\u0627\\u0632\\u06cc \\u0628\\u062e\\u0634 \\u062f\\u06cc\\u062f\\u06af\\u0627\\u0647 \\u0647\\u0627\",\"value\":\"YES\"},{\"key\":\"enable-widget-area\",\"type\":\"boolean\",\"name\":\"\\u0641\\u0639\\u0627\\u0644 \\u0633\\u0627\\u0632\\u06cc \\u0646\\u0627\\u062d\\u06cc\\u0647 \\u0627\\u0628\\u0632\\u0627\\u0631\\u06a9\\u06cc \\u0635\\u0641\\u062d\\u0647\",\"value\":\"YES\"},{\"key\":\"enable-voting\",\"type\":\"boolean\",\"name\":\"\\u0641\\u0639\\u0627\\u0644 \\u0633\\u0627\\u0632\\u06cc \\u0628\\u062e\\u0634 \\u0644\\u0627\\u06cc\\u06a9 \\u0648 \\u062f\\u06cc\\u0633\\u0644\\u0627\\u06cc\\u06a9\",\"value\":\"YES\"},{\"key\":\"show-banners\",\"type\":\"boolean\",\"name\":\"\\u0646\\u0645\\u0627\\u06cc\\u0634 \\u0628\\u0646\\u0631\\u0647\\u0627\\u06cc \\u062a\\u0628\\u0644\\u06cc\\u063a\\u0627\\u062a\\u06cc\",\"value\":\"NO\"}]','1','1','2','2','1');
INSERT INTO `tbl_pages` VALUES ('102','آگهی','ads-single','','2020-11-16 00:00:00','1','2',NULL,NULL,'',NULL,'0','0','0','0','0','0','0',NULL,NULL,'{\r\n\"controller\": \"includes/core/pages/single/controller.php\",\r\n\"content\": \"includes/theme/pages/single/main.php\",\r\n\"js_validation\": true,\r\n\"has_modal\": true,\r\n\"has_map\": true,\r\n\"js_files\": [\r\n\"public/theme/js/pages/single.js\"\r\n]\r\n}','[{\"key\":\"enable-voting\",\"type\":\"boolean\",\"name\":\"\\u0641\\u0639\\u0627\\u0644 \\u0633\\u0627\\u0632\\u06cc \\u0628\\u062e\\u0634 \\u0644\\u0627\\u06cc\\u06a9 \\u0648 \\u062f\\u06cc\\u0633\\u0644\\u0627\\u06cc\\u06a9\",\"value\":\"YES\"},{\"key\":\"show-share\",\"type\":\"boolean\",\"name\":\"\\u0646\\u0645\\u0627\\u06cc\\u0634 \\u062f\\u06a9\\u0645\\u0647 \\u0627\\u0634\\u062a\\u0631\\u0627\\u06a9 \\u06af\\u0630\\u0627\\u0631\\u06cc\",\"value\":\"YES\"},{\"key\":\"show-comments\",\"type\":\"boolean\",\"name\":\"\\u0641\\u0639\\u0627\\u0644 \\u0633\\u0627\\u0632\\u06cc \\u0628\\u062e\\u0634 \\u062f\\u06cc\\u062f\\u06af\\u0627\\u0647 \\u0647\\u0627\",\"value\":\"YES\"},{\"key\":\"enable-report\",\"type\":\"boolean\",\"name\":\"\\u0641\\u0639\\u0627\\u0644 \\u0633\\u0627\\u0632\\u06cc \\u06af\\u0632\\u0627\\u0631\\u0634 \\u062f\\u0647\\u06cc \\u0628\\u0631\\u0627\\u06cc \\u0622\\u06af\\u0647\\u06cc\",\"value\":\"YES\"},{\"key\":\"related-items-count\",\"type\":\"text\",\"name\":\"\\u062a\\u0639\\u062f\\u0627\\u062f \\u0622\\u06af\\u0647\\u06cc \\u0647\\u0627\\u06cc \\u0645\\u0631\\u062a\\u0628\\u0637\",\"value\":\"6\",\"description\":\"\\u0645\\u0642\\u062f\\u0627\\u0631 \\u0635\\u0641\\u0631 \\u0628\\u0647 \\u0645\\u0639\\u0646\\u0627\\u06cc \\u0639\\u062f\\u0645 \\u0646\\u0645\\u0627\\u06cc\\u0634 \\u0622\\u06af\\u0647\\u06cc \\u0647\\u0627\\u06cc \\u0645\\u0631\\u062a\\u0628\\u0637 \\u0627\\u0633\\u062a\"},{\"key\":\"show-banners\",\"type\":\"boolean\",\"name\":\"\\u0646\\u0645\\u0627\\u06cc\\u0634 \\u0628\\u0646\\u0631\\u0647\\u0627\\u06cc \\u062a\\u0628\\u0644\\u06cc\\u063a\\u0627\\u062a\\u06cc\",\"value\":\"NO\"}]','1','1','2','1','1');
INSERT INTO `tbl_pages` VALUES ('103','پیشخوان کاربری','account-dashboard','','2020-11-16 00:00:00','1','2','','',' پیشخوان |\r\n {%site_title%}','','0','0','0','0','0','0','0',NULL,NULL,'{\r\n\"controller\": \"includes/core/pages/account/dashboard_controller.php\",\r\n\"content\": \"includes/theme/pages/account/dashboard.php\",\r\n\"account_page\": true,\r\n\"js_files\": [\r\n\"public/theme/js/pages/account/dashboard.js\"\r\n]\r\n}',NULL,'1','1','1','1','2');
INSERT INTO `tbl_pages` VALUES ('104','آگهی های من','account-my-listing','','2020-11-16 00:00:00','1','2','','',' آگهی های من |\r\n {%site_title%}','','0','0','0','0','0','0','0',NULL,NULL,'{\r\n\"controller\": \"includes/core/pages/account/items/listing_controller.php\",\r\n\"content\": \"includes/theme/pages/account/items/listing.php\",\r\n\"account_page\": true,\r\n\"has_modal\": true,\r\n\"load_toastr\": true,\r\n\"js_files\": [\r\n\"public/theme/js/pages/account/items/listing.js\"\r\n]\r\n}',NULL,'1','1','1','1','2');
INSERT INTO `tbl_pages` VALUES ('105','پسندیده ها','account-favourites','','2020-11-16 00:00:00','1','2','','',' پسندیده ها |\r\n {%site_title%}','','0','0','0','0','0','0','0',NULL,NULL,'{\r\n\"controller\": \"includes/core/pages/account/favourites_controller.php\",\r\n\"content\": \"includes/theme/pages/account/favourites.php\",\r\n\"account_page\": true\r\n}',NULL,'1','1','1','1','2');
INSERT INTO `tbl_pages` VALUES ('106','دیدگاه ها','account-comments','','2020-11-16 00:00:00','1','2','','',' دیدگاه های من |\r\n {%site_title%}','','0','0','0','0','0','0','0',NULL,NULL,'{\r\n\"controller\": \"includes/core/pages/account/comments_controller.php\",\r\n\"content\": \"includes/theme/pages/account/comments.php\",\r\n\"account_page\": true\r\n}',NULL,'1','1','1','1','2');
INSERT INTO `tbl_pages` VALUES ('107','ویرایش پروفایل','account-profile-edit','','2020-11-16 00:00:00','1','2','','',' ویرایش پروفایل |\r\n {%site_title%}','','0','0','0','0','0','0','0',NULL,NULL,'{\r\n\"controller\": \"includes/core/pages/account/profile/edit_controller.php\",\r\n\"content\": \"includes/theme/pages/account/profile/edit.php\",\r\n\"account_page\": true,\r\n\"has_modal\": true,\r\n\"js_validation\": true,\r\n\"js_files\": [\r\n\"public/theme/js/pages/account/profile/edit.js\"\r\n]\r\n}',NULL,'1','1','1','1','2');
INSERT INTO `tbl_pages` VALUES ('108','تغییر رمز عبور','account-profile-change-password','','2020-11-16 00:00:00','1','2','','',' تغییر رمز عبور |\r\n {%site_title%}','','0','0','0','0','0','0','0',NULL,NULL,'{\r\n\"controller\": \"includes/core/pages/account/profile/change_password_controller.php\",\r\n\"content\": \"includes/theme/pages/account/profile/change_password.php\",\r\n\"account_page\": true,\r\n\"parent_page\": \"account-profile-edit\",\r\n\"js_validation\": true,\r\n\"js_files\": [\r\n\"public/theme/js/pages/account/profile/change_password.js\"\r\n]\r\n}',NULL,'1','1','1','1','2');
INSERT INTO `tbl_pages` VALUES ('109','ثبت و تایید آدرس ایمیل','account-profile-submit-email','','2020-11-16 00:00:00','1','2','','',' ثبت و تایید آدرس ایمیل |\r\n {%site_title%}','','0','0','0','0','0','0','0',NULL,NULL,'{\r\n\"controller\": \"includes/core/pages/account/profile/submit_email_controller.php\",\r\n\"content\": \"includes/theme/pages/account/profile/submit_email.php\",\r\n\"account_page\": true,\r\n\"parent_page\": \"account-profile-edit\",\r\n\"js_validation\": true,\r\n\"has_modal\": true,\r\n\"js_files\": [\r\n\"public/lib/jquery.countdown/dist/jquery.countdown.min.js\",\r\n\"public/core/js/scripts/activation.min.js\",\r\n\"public/theme/js/pages/account/profile/submit_email.js\"\r\n]\r\n}',NULL,'1','1','1','1','2');
INSERT INTO `tbl_pages` VALUES ('110','ثبت و تایید شماره موبایل','account-profile-submit-mobile','','2020-11-16 00:00:00','1','2','','',' ثبت و تایید شماره موبایل |\r\n {%site_title%}','','0','0','0','0','0','0','0',NULL,NULL,'{\r\n\"controller\": \"includes/core/pages/account/profile/submit_mobile_controller.php\",\r\n\"content\": \"includes/theme/pages/account/profile/submit_mobile.php\",\r\n\"account_page\": true,\r\n\"parent_page\": \"account-profile-edit\",\r\n\"js_validation\": true,\r\n\"has_modal\": true,\r\n\"js_files\": [\r\n\"public/lib/jquery.countdown/dist/jquery.countdown.min.js\",\r\n\"public/core/js/scripts/activation.min.js\",\r\n\"public/theme/js/pages/account/profile/submit_mobile.js\"\r\n]\r\n}',NULL,'1','1','1','1','2');
INSERT INTO `tbl_pages` VALUES ('111','تصویر آواتار','account-profile-avatar','','2020-11-16 00:00:00','1','2','','',' تغییر تصویر آواتار |\r\n {%site_title%}','','0','0','0','0','0','0','0',NULL,NULL,'{\r\n\"controller\": \"includes/core/pages/account/profile/avatar_controller.php\",\r\n\"content\": \"includes/theme/pages/account/profile/avatar.php\",\r\n\"account_page\": true,\r\n\"parent_page\": \"account-profile-edit\",\r\n\"has_upload\": true,\r\n\"js_files\": [\r\n\"public/theme/js/pages/account/profile/avatar.js\"\r\n]\r\n}',NULL,'1','1','1','1','2');
INSERT INTO `tbl_pages` VALUES ('112','تاریخچه پرداخت ها','account-payments-history','','2020-11-16 00:00:00','1','2','','',' تاریخچه پرداخت ها |\r\n {%site_title%}','','0','0','0','0','0','0','0',NULL,NULL,'{\r\n\"controller\": \"includes/core/pages/account/payments/list_controller.php\",\r\n\"content\": \"includes/theme/pages/account/payments/list.php\",\r\n\"account_page\": true\r\n}',NULL,'1','1','1','1','2');
INSERT INTO `tbl_pages` VALUES ('113','مشاهده اطلاعات پرداخت','account-payments-invoice','','2020-11-16 00:00:00','1','2','','',' مشاهده اطلاعات پرداخت |\r\n {%site_title%}','','0','0','0','0','0','0','0',NULL,NULL,'{\r\n\"controller\": \"includes/core/pages/account/payments/invoice_controller.php\",\r\n\"content\": \"includes/theme/pages/account/payments/invoice.php\",\r\n\"account_page\": true,\r\n\"css_files\": [\r\n\"public/theme/css/pages/account/payments/invoice.css\"\r\n]\r\n}',NULL,'1','1','1','1','2');
INSERT INTO `tbl_pages` VALUES ('114','بنرهای سیستم همکاری در فروش','account-affiliate-banners','','2020-11-16 00:00:00','1','2','','',' بنرهای سیستم همکاری در فروش |\r\n {%site_title%}','','0','0','0','0','0','0','0',NULL,NULL,'{\r\n\"url\": \"account/affiliate-banners\",\r\n\"controller\": \"includes/core/pages/account/affiliate/banners_controller.php\",\r\n\"content\": \"includes/theme/pages/account/affiliate/banners.php\",\r\n\"account_page\": true\r\n}','[{\"key\":\"first_description\",\"type\":\"textarea\",\"name\":\"\\u0645\\u062a\\u0646 \\u0628\\u062e\\u0634 \\u0627\\u0648\\u0644 \\u0635\\u0641\\u062d\\u0647\",\"value\":\"<p>\\u062f\\u0631 \\u0627\\u06cc\\u0646 \\u0628\\u062e\\u0634 \\u0634\\u0645\\u0627 \\u0642\\u0627\\u062f\\u0631 \\u0647\\u0633\\u062a\\u06cc\\u062f \\u0628\\u0627 \\u0627\\u0633\\u062a\\u0641\\u0627\\u062f\\u0647 \\u0627\\u0632 \\u0644\\u06cc\\u0646\\u06a9 \\u0627\\u062e\\u062a\\u0635\\u0627\\u0635\\u06cc \\u0628\\u0627\\u0632\\u0627\\u0631\\u06cc\\u0627\\u0628\\u06cc \\u062e\\u0648\\u062f \\u0646\\u0633\\u0628\\u062a \\u0628\\u0647 \\u06a9\\u0633\\u0628 \\u062f\\u0631\\u0622\\u0645\\u062f \\u0627\\u0632 \\u0646\\u06cc\\u0627\\u0632\\u0645\\u0646\\u062f\\u06cc \\u0647\\u0627\\u06cc \\u06a9\\u062f\\u06cc\\u0632\\u0627\\u06cc\\u0646 \\u0627\\u0642\\u062f\\u0627\\u0645 \\u0641\\u0631\\u0645\\u0627\\u06cc\\u06cc\\u062f.<br \\/>\\r\\n\\u0634\\u0645\\u0627 \\u0645\\u06cc \\u062a\\u0648\\u0627\\u0646\\u06cc\\u062f \\u0628\\u0627 \\u0644\\u06cc\\u0646\\u06a9 \\u0627\\u062e\\u062a\\u0635\\u0627\\u0635\\u06cc \\u062e\\u0648\\u062f \\u062f\\u06cc\\u06af\\u0631\\u0627\\u0646 \\u0631\\u0627 \\u0628\\u0647 \\u0633\\u0627\\u06cc\\u062a \\u0645\\u0627 \\u0647\\u062f\\u0627\\u06cc\\u062a \\u06a9\\u0646\\u06cc\\u062f \\u0648 \\u0627\\u06af\\u0631 \\u06a9\\u0627\\u0631\\u0628\\u0631 \\u0647\\u062f\\u0627\\u06cc\\u062a \\u0634\\u062f\\u0647 \\u0627\\u0642\\u062f\\u0627\\u0645 \\u0628\\u0647 \\u062b\\u0628\\u062a \\u0622\\u06af\\u0647\\u06cc \\u0648\\u06cc\\u0698\\u0647 \\u0627\\u0632 \\u0633\\u0627\\u06cc\\u062a \\u0645\\u0627 \\u0646\\u0645\\u0627\\u06cc\\u062f \\u0648 \\u0633\\u0641\\u0627\\u0631\\u0634 \\u062e\\u0648\\u062f \\u0631\\u0627 \\u067e\\u0631\\u062f\\u0627\\u062e\\u062a \\u0646\\u0645\\u0627\\u06cc\\u062f \\u062d\\u0642 \\u0628\\u0627\\u0632\\u0627\\u0631\\u06cc\\u0627\\u0628\\u06cc \\u0634\\u0645\\u0627 \\u0628\\u0647 \\u062d\\u0633\\u0627\\u0628\\u062a\\u0627\\u0646 \\u0645\\u0646\\u0638\\u0648\\u0631 \\u062e\\u0648\\u0627\\u0647\\u062f \\u06af\\u0634\\u062a.<br \\/>\\r\\n\\u0648 \\u0645\\u0647\\u0645 \\u062a\\u0631 \\u0627\\u06cc\\u0646\\u06a9\\u0647 \\u0627\\u06cc\\u0646 \\u062d\\u0642 \\u0628\\u0627\\u0632\\u0627\\u0631\\u06cc\\u0627\\u0628\\u06cc \\u0641\\u0642\\u0637 \\u0628\\u0631\\u0627\\u06cc \\u06cc\\u06a9 \\u0628\\u0627\\u0631 \\u0646\\u062e\\u0648\\u0627\\u0647\\u062f \\u0628\\u0648\\u062f \\u060c \\u0628\\u0644\\u06a9\\u0647 \\u0628\\u0627 \\u0647\\u0631 \\u0628\\u0627\\u0631 \\u062b\\u0628\\u062a \\u0622\\u06af\\u0647\\u06cc \\u0648\\u06cc\\u0698\\u0647 \\u062a\\u0648\\u0633\\u0637 \\u0634\\u062e\\u0635 \\u0645\\u0648\\u0631\\u062f \\u0646\\u0638\\u0631 \\u062f\\u0631 \\u0647\\u0631 \\u0632\\u0645\\u0627\\u0646\\u06cc \\u067e\\u0633 \\u0627\\u0632 \\u0622\\u0646 \\u0646\\u06cc\\u0632 \\u060c \\u062d\\u0642 \\u0628\\u0627\\u0632\\u0627\\u0631\\u06cc\\u0627\\u0628\\u06cc \\u0628\\u0631\\u0627\\u06cc \\u0634\\u0645\\u0627 \\u0645\\u0646\\u0638\\u0648\\u0631 \\u062e\\u0648\\u0627\\u0647\\u062f \\u0634\\u062f ... \\u0628\\u0647 \\u0647\\u0645\\u06cc\\u0646 \\u0633\\u0627\\u062f\\u06af\\u06cc \\u06a9\\u0633\\u0628 \\u062f\\u0631\\u0622\\u0645\\u062f \\u06a9\\u0646\\u06cc\\u062f !!<\\/p>\\r\\n\",\"description\":\"\"},{\"key\":\"second_description\",\"type\":\"textarea\",\"name\":\"\\u0645\\u062a\\u0646 \\u0628\\u062e\\u0634 \\u062f\\u0648\\u0645 \\u0635\\u0641\\u062d\\u0647\",\"value\":\"<p>\\u0628\\u0627 \\u062a\\u0648\\u062c\\u0647 \\u0628\\u0647 \\u0627\\u06cc\\u0646\\u06a9\\u0647 \\u062a\\u0628\\u0644\\u06cc\\u063a\\u0627\\u062a \\u06af\\u0631\\u0627\\u0641\\u06cc\\u06a9\\u06cc \\u0628\\u0627\\u0632\\u062e\\u0648\\u0631\\u062f \\u0628\\u06cc\\u0634\\u062a\\u0631\\u06cc \\u062f\\u0627\\u0631\\u0646\\u062f \\u0634\\u0645\\u0627 \\u0645\\u06cc \\u062a\\u0648\\u0627\\u0646\\u06cc\\u062f \\u0628\\u0627 \\u0627\\u0633\\u062a\\u0641\\u0627\\u062f\\u0647 \\u0627\\u0632 \\u062f\\u0631\\u062c \\u0628\\u0646\\u0631 \\u0645\\u0646\\u0627\\u0633\\u0628 \\u062f\\u0631 \\u062c\\u0627\\u06cc\\u06cc \\u0645\\u0646\\u0627\\u0633\\u0628 \\u0627\\u0632 \\u0648\\u0628\\u0644\\u0627\\u06af \\u06cc\\u0627 \\u0648\\u0628\\u0633\\u0627\\u06cc\\u062a \\u062e\\u0648\\u062f \\u06a9\\u0627\\u0631\\u0628\\u0631 \\u0628\\u06cc\\u0634\\u062a\\u0631\\u06cc \\u0628\\u0647 \\u0646\\u06cc\\u0627\\u0632\\u0645\\u0646\\u062f\\u06cc \\u0647\\u0627\\u06cc \\u06a9\\u062f\\u06cc\\u0632\\u0627\\u06cc\\u0646 \\u0647\\u062f\\u0627\\u06cc\\u062a \\u06a9\\u0646\\u06cc\\u062f \\u06a9\\u0647 \\u0628\\u0647 \\u062a\\u0628\\u0639 \\u062f\\u0631\\u0622\\u0645\\u062f \\u0634\\u0645\\u0627 \\u0646\\u06cc\\u0632 \\u0627\\u0641\\u0632\\u0627\\u06cc\\u0634 \\u067e\\u06cc\\u062f\\u0627 \\u062e\\u0648\\u0627\\u0647\\u062f \\u0646\\u0645\\u0648\\u062f<br \\/>\\r\\n\\u062a\\u0648\\u062c\\u0647 \\u062f\\u0627\\u0634\\u062a\\u0647 \\u0628\\u0627\\u0634\\u06cc\\u062f \\u06a9\\u0647 \\u0627\\u06cc\\u0646 \\u0633\\u06cc\\u0633\\u062a\\u0645 \\u06a9\\u0627\\u0645\\u0644\\u0627 \\u0645\\u0646\\u0635\\u0641\\u0627\\u0646\\u0647 \\u0628\\u0648\\u062f\\u0647 \\u0648 \\u0628\\u0647 \\u0647\\u0645\\u0627\\u0646 \\u0627\\u0646\\u062f\\u0627\\u0632\\u0647 \\u0627\\u06cc \\u06a9\\u0647 \\u0633\\u0627\\u06cc\\u062a \\u0634\\u0645\\u0627 \\u062a\\u0627\\u062b\\u06cc\\u0631 \\u06af\\u0630\\u0627\\u0631 \\u0628\\u0627\\u0634\\u062f \\u062f\\u0631\\u0622\\u0645\\u062f \\u06a9\\u0633\\u0628 \\u062e\\u0648\\u0627\\u0647\\u06cc\\u062f \\u0646\\u0645\\u0648\\u062f (\\u0646\\u0647 \\u06a9\\u0645\\u062a\\u0631 \\u0648 \\u0646\\u0647 \\u0628\\u06cc\\u0634\\u062a\\u0631)<\\/p>\\r\\n\",\"description\":\"\"}]','1','1','2','1','1');
INSERT INTO `tbl_pages` VALUES ('115','درآمدهای من','account-affiliate-history','','2020-11-16 00:00:00','1','2','','',' درآمدهای من |\r\n {%site_title%}','','0','0','0','0','0','0','0',NULL,NULL,'{\r\n\"controller\": \"includes/core/pages/account/affiliate/history_controller.php\",\r\n\"content\": \"includes/theme/pages/account/affiliate/history.php\",\r\n\"account_page\": true,\r\n\"parent_page\": \"account-affiliate-banners\"\r\n}',NULL,'1','1','1','1','2');
INSERT INTO `tbl_pages` VALUES ('116','ویرایش آگهی کاربر','account-item-edit','','2020-11-16 00:00:00','1','2','','',' ویرایش آگهی |\r\n {%site_title%}','','0','0','0','0','0','0','0',NULL,NULL,'{\r\n\"controller\": \"includes/core/pages/account/items/edit_controller.php\",\r\n\"content\": \"includes/theme/pages/account/items/edit/main.php\",\r\n\"account_page\": true,\r\n\"has_upload\": true,\r\n\"has_map\": true,\r\n\"js_validation\": true,\r\n\"has_modal\": true,\r\n\"show_floating_button\": false,\r\n\"js_files\": [\r\n\"public/lib/select2-master/dist/js/select2.min.js\", \"public/theme/js/pages/account/items/edit.js\"\r\n],\r\n\"css_files\": [\r\n  \"public/lib/select2-master/dist/css/select2.min.css\"\r\n]\r\n}',NULL,'1','1','1','1','2');
INSERT INTO `tbl_pages` VALUES ('117','تغییر پلان ویژه','account-item-change-plan','','2020-11-16 00:00:00','1','2','','',' ارتقا-تغییر پلان ویژه |\r\n {%site_title%}','','0','0','0','0','0','0','0',NULL,NULL,'{\r\n\"controller\": \"includes/core/pages/account/items/change_plan_controller.php\",\r\n\"content\": \"includes/theme/pages/account/items/change_plan.php\",\r\n\"account_page\": true,\r\n\"js_validation\": true,\r\n\"has_coupon\": true,\r\n\"js_files\": [\r\n\"public/theme/js/pages/account/items/change_plan.js\"\r\n]\r\n}',NULL,'1','1','1','1','2');
INSERT INTO `tbl_pages` VALUES ('118','تمدید آگهی','account-item-extend','','2020-11-16 00:00:00','1','2','','',' تمدید آگهی |\r\n {%site_title%}','','0','0','0','0','0','0','0',NULL,NULL,'{\r\n\"controller\": \"includes/core/pages/account/items/extend_controller.php\",\r\n\"content\": \"includes/theme/pages/account/items/extend.php\",\r\n\"account_page\": true,\r\n\"js_validation\": true,\r\n\"js_files\": [\r\n\"public/theme/js/pages/account/items/change_plan.js\"\r\n]\r\n}',NULL,'1','1','1','1','2');
INSERT INTO `tbl_pages` VALUES ('119','پرداخت صورتحساب','account-item-pay','','2020-11-16 00:00:00','1','2','','',' پرداخت صورتحساب |\r\n {%site_title%}','','0','0','0','0','0','0','0',NULL,NULL,'{\r\n\"controller\": \"includes/core/pages/account/items/pay_controller.php\",\r\n\"content\": \"includes/theme/pages/account/items/pay.php\",\r\n\"account_page\": true,\r\n\"js_validation\": true,\r\n\"has_coupon\": true,\r\n\"js_files\": [\r\n\"public/theme/js/pages/account/items/change_plan.js\"\r\n]\r\n}',NULL,'1','1','1','1','2');
INSERT INTO `tbl_pages` VALUES ('120','پروسه -- عملیات های آگهی','account-item-actions','','2020-11-16 00:00:00','1','2','','','پروسه -- عملیات های آگهی','','0','0','0','0','0','0','0',NULL,NULL,'{\r\n\"controller\": \"includes/core/pages/account/items/actions_controller.php\",\r\n\"process_page\": true\r\n}',NULL,'1','1','1','1','1');
INSERT INTO `tbl_pages` VALUES ('121','صندوق ایمیل ها','account-messages-email','','2020-11-16 00:00:00','1','2','','',' صندوق ایمیل ها |\r\n {%site_title%}','','0','0','0','0','0','0','0',NULL,NULL,'{\r\n\"controller\": \"includes/core/pages/account/messages/email_controller.php\",\r\n\"content\": \"includes/theme/pages/account/messages.php\",\r\n\"account_page\": true,\r\n\"has_modal\": true,\r\n\"js_files\": [\r\n\"public/theme/js/pages/account/messages.js\"\r\n]\r\n}',NULL,'1','1','1','1','2');
INSERT INTO `tbl_pages` VALUES ('122','صندوق پیامک ها','account-messages-sms','','2020-11-16 00:00:00','1','2','','',' صندوق پیامک ها |\r\n {%site_title%}','','0','0','0','0','0','0','0',NULL,NULL,'{\r\n\"controller\": \"includes/core/pages/account/messages/sms_controller.php\",\r\n\"content\": \"includes/theme/pages/account/messages.php\",\r\n\"parent_page\": \"account-messages-email\",\r\n\"account_page\": true,\r\n\"has_modal\": true,\r\n\"js_files\": [\r\n\"public/theme/js/pages/account/messages.js\"\r\n]\r\n}',NULL,'1','1','1','1','2');
INSERT INTO `tbl_pages` VALUES ('123',404,'page-404','','2020-08-16 00:00:00','1','2',NULL,NULL,'صفحه مورد نظر یافت نشد  |\r\n {%site_title%}','','0','0','0','0','0','0','0',NULL,NULL,'{\r\n\"controller\": \"includes/core/pages/pages/404_controller.php\",\r\n\"content\": \"includes/theme/pages/pages/404.php\",\r\n\"show_footer\": false\r\n}',NULL,'1','1','1','1','2');
INSERT INTO `tbl_pages` VALUES ('124','برچسب آگهی','ads-list-tag','','2020-08-16 00:00:00','1','2',NULL,NULL,'',NULL,'0','0','0','0','0','0','0',NULL,NULL,'{\r\n\"controller\": \"includes/core/pages/ads/tag_controller.php\",\r\n\"content\": \"includes/theme/pages/ads/tag.php\"\r\n}','[{\"key\":\"item-per-page\",\"type\":\"number\",\"name\":\"\\u062a\\u0639\\u062f\\u0627\\u062f \\u0622\\u06cc\\u062a\\u0645 \\u0647\\u0627 \\u062f\\u0631 \\u0647\\u0631 \\u0635\\u0641\\u062d\\u0647\",\"value\":\"32\"}]','1','1','2','1','1');
INSERT INTO `tbl_pages` VALUES ('125','برچسب بلاگ','blog-tag','','2020-12-18 00:00:00','1','2','','','','','0','0','0','0','0','0','0',NULL,NULL,'{\r\n\"controller\": \"includes/core/pages/blog/tag_controller.php\",\r\n\"content\": \"includes/theme/pages/blog/tag.php\"\r\n}','[{\"key\":\"item-per-page\",\"type\":\"number\",\"name\":\"\\u062a\\u0639\\u062f\\u0627\\u062f \\u0622\\u06cc\\u062a\\u0645 \\u0647\\u0627 \\u062f\\u0631 \\u0647\\u0631 \\u0635\\u0641\\u062d\\u0647\",\"value\":\"10\"}]','1','1','1','1','2');
INSERT INTO `tbl_pages` VALUES ('126','بازگشت از درگاه','callback','','2020-08-16 00:00:00','1','2',NULL,NULL,'بازگشت از درگاه  |\r\n {%site_title%}','','0','0','0','0','0','0','0',NULL,NULL,'{\r\n\"controller\": \"includes/core/pages/pages/callback_controller.php\",\r\n\"content\": \"includes/theme/pages/pages/callback.php\",\r\n\"css_files\": [\r\n\"public/theme/css/pages/callback.css\",\r\n\"public/theme/css/pages/account/payments/invoice.css\"\r\n]\r\n}',NULL,'1','1','1','1','2');
INSERT INTO `tbl_pages` VALUES ('127','آگهی های دسته category','ads-list-category','','2020-08-16 00:00:00','1','2',NULL,NULL,'',NULL,'0','0','0','0','0','0','0',NULL,NULL,'{\r\n\"controller\": \"includes/core/pages/ads/category_controller.php\",\r\n\"content\": \"includes/theme/pages/ads/category.php\"\r\n}','[{\"key\":\"item-per-page\",\"type\":\"number\",\"name\":\"\\u062a\\u0639\\u062f\\u0627\\u062f \\u0622\\u06cc\\u062a\\u0645 \\u0647\\u0627 \\u062f\\u0631 \\u0647\\u0631 \\u0635\\u0641\\u062d\\u0647\",\"value\":\"32\"},{\"key\":\"enable-widget-area\",\"type\":\"boolean\",\"name\":\"\\u0641\\u0639\\u0627\\u0644 \\u0633\\u0627\\u0632\\u06cc \\u0646\\u0627\\u062d\\u06cc\\u0647 \\u0627\\u0628\\u0632\\u0627\\u0631\\u06a9\\u06cc \\u0635\\u0641\\u062d\\u0647\",\"value\":\"YES\"},{\"key\":\"show-description\",\"type\":\"boolean\",\"name\":\"\\u0646\\u0645\\u0627\\u06cc\\u0634 \\u062a\\u0648\\u0636\\u06cc\\u062d\\u0627\\u062a \\u062f\\u0633\\u062a\\u0647 \\u062f\\u0631 \\u0627\\u0646\\u062a\\u0647\\u0627\\u06cc \\u0635\\u0641\\u062d\\u0647\",\"value\":\"YES\"},{\"key\":\"show-banners\",\"type\":\"boolean\",\"name\":\"\\u0646\\u0645\\u0627\\u06cc\\u0634 \\u0628\\u0646\\u0631\\u0647\\u0627\\u06cc \\u062a\\u0628\\u0644\\u06cc\\u063a\\u0627\\u062a\\u06cc\",\"value\":\"YES\"},{\"key\":\"show-banner-slider\",\"type\":\"boolean\",\"name\":\"\\u0646\\u0645\\u0627\\u06cc\\u0634 \\u0627\\u0633\\u0644\\u0627\\u06cc\\u062f\\u0631 \\u0628\\u0646\\u0631\\u0647\\u0627\\u06cc \\u062a\\u0628\\u0644\\u06cc\\u063a\\u0627\\u062a\\u06cc\",\"value\":\"YES\"}]','1','1','2','2','1');
INSERT INTO `tbl_pages` VALUES ('128','آگهی های زیردسته subcategory','ads-list-subcategory','','2020-08-16 00:00:00','1','2',NULL,NULL,'',NULL,'0','0','0','0','0','0','0',NULL,NULL,'{\r\n\"controller\": \"includes/core/pages/ads/subcategory_controller.php\",\r\n\"content\": \"includes/theme/pages/ads/subcategory.php\"\r\n}','[{\"key\":\"item-per-page\",\"type\":\"number\",\"name\":\"\\u062a\\u0639\\u062f\\u0627\\u062f \\u0622\\u06cc\\u062a\\u0645 \\u0647\\u0627 \\u062f\\u0631 \\u0647\\u0631 \\u0635\\u0641\\u062d\\u0647\",\"value\":\"32\"},{\"key\":\"enable-widget-area\",\"type\":\"boolean\",\"name\":\"\\u0641\\u0639\\u0627\\u0644 \\u0633\\u0627\\u0632\\u06cc \\u0646\\u0627\\u062d\\u06cc\\u0647 \\u0627\\u0628\\u0632\\u0627\\u0631\\u06a9\\u06cc \\u0635\\u0641\\u062d\\u0647\",\"value\":\"NO\"},{\"key\":\"show-description\",\"type\":\"boolean\",\"name\":\"\\u0646\\u0645\\u0627\\u06cc\\u0634 \\u062a\\u0648\\u0636\\u06cc\\u062d\\u0627\\u062a \\u062f\\u0633\\u062a\\u0647 \\u062f\\u0631 \\u0627\\u0646\\u062a\\u0647\\u0627\\u06cc \\u0635\\u0641\\u062d\\u0647\",\"value\":\"NO\"},{\"key\":\"show-banners\",\"type\":\"boolean\",\"name\":\"\\u0646\\u0645\\u0627\\u06cc\\u0634 \\u0628\\u0646\\u0631\\u0647\\u0627\\u06cc \\u062a\\u0628\\u0644\\u06cc\\u063a\\u0627\\u062a\\u06cc\",\"value\":\"YES\"},{\"key\":\"show-banner-slider\",\"type\":\"boolean\",\"name\":\"نمایش اسلایدر بنرهای تبلیغاتی\", \"value\":\"YES\"}]','1','1','2','2','1');
INSERT INTO `tbl_pages` VALUES ('129','آگهی های زیردسته دوم subsidiary ','ads-list-subsidiary','','2020-08-16 00:00:00','1','2',NULL,NULL,'',NULL,'0','0','0','0','0','0','0',NULL,NULL,'{\r\n\"controller\": \"includes/core/pages/ads/subsidiary_controller.php\",\r\n\"content\": \"includes/theme/pages/ads/subsidiary.php\"\r\n}','[{\"key\":\"item-per-page\",\"type\":\"number\",\"name\":\"\\u062a\\u0639\\u062f\\u0627\\u062f \\u0622\\u06cc\\u062a\\u0645 \\u0647\\u0627 \\u062f\\u0631 \\u0647\\u0631 \\u0635\\u0641\\u062d\\u0647\",\"value\":\"32\"},{\"key\":\"enable-widget-area\",\"type\":\"boolean\",\"name\":\"\\u0641\\u0639\\u0627\\u0644 \\u0633\\u0627\\u0632\\u06cc \\u0646\\u0627\\u062d\\u06cc\\u0647 \\u0627\\u0628\\u0632\\u0627\\u0631\\u06a9\\u06cc \\u0635\\u0641\\u062d\\u0647\",\"value\":\"NO\"},{\"key\":\"show-description\",\"type\":\"boolean\",\"name\":\"\\u0646\\u0645\\u0627\\u06cc\\u0634 \\u062a\\u0648\\u0636\\u06cc\\u062d\\u0627\\u062a \\u062f\\u0633\\u062a\\u0647 \\u062f\\u0631 \\u0627\\u0646\\u062a\\u0647\\u0627\\u06cc \\u0635\\u0641\\u062d\\u0647\",\"value\":\"NO\"},{\"key\":\"show-banners\",\"type\":\"boolean\",\"name\":\"\\u0646\\u0645\\u0627\\u06cc\\u0634 \\u0628\\u0646\\u0631\\u0647\\u0627\\u06cc \\u062a\\u0628\\u0644\\u06cc\\u063a\\u0627\\u062a\\u06cc\",\"value\":\"YES\"},{\"key\":\"show-banner-slider\",\"type\":\"boolean\",\"name\":\"\\u0646\\u0645\\u0627\\u06cc\\u0634 \\u0627\\u0633\\u0644\\u0627\\u06cc\\u062f\\u0631 \\u0628\\u0646\\u0631\\u0647\\u0627\\u06cc \\u062a\\u0628\\u0644\\u06cc\\u063a\\u0627\\u062a\\u06cc\",\"value\":\"YES\"}]','1','1','2','2','1');
INSERT INTO `tbl_pages` VALUES ('130','آگهی های استان','ads-list-state','','2020-08-16 00:00:00','1','2',NULL,NULL,'',NULL,'0','0','0','0','0','0','0',NULL,NULL,'{\r\n\"controller\": \"includes/core/pages/ads/state_controller.php\",\r\n\"content\": \"includes/theme/pages/ads/state.php\"\r\n}','[{\"key\":\"item-per-page\",\"type\":\"number\",\"name\":\"\\u062a\\u0639\\u062f\\u0627\\u062f \\u0622\\u06cc\\u062a\\u0645 \\u0647\\u0627 \\u062f\\u0631 \\u0647\\u0631 \\u0635\\u0641\\u062d\\u0647\",\"value\":\"10\"},{\"key\":\"enable-widget-area\",\"type\":\"boolean\",\"name\":\"\\u0641\\u0639\\u0627\\u0644 \\u0633\\u0627\\u0632\\u06cc \\u0646\\u0627\\u062d\\u06cc\\u0647 \\u0627\\u0628\\u0632\\u0627\\u0631\\u06a9\\u06cc \\u0635\\u0641\\u062d\\u0647\",\"value\":\"NO\"},{\"key\":\"show-banners\",\"type\":\"boolean\",\"name\":\"\\u0646\\u0645\\u0627\\u06cc\\u0634 \\u0628\\u0646\\u0631\\u0647\\u0627\\u06cc \\u062a\\u0628\\u0644\\u06cc\\u063a\\u0627\\u062a\\u06cc\",\"value\":\"NO\"},{\"key\":\"show-banner-slider\",\"type\":\"boolean\",\"name\":\"\\u0646\\u0645\\u0627\\u06cc\\u0634 \\u0627\\u0633\\u0644\\u0627\\u06cc\\u062f\\u0631 \\u0628\\u0646\\u0631\\u0647\\u0627\\u06cc \\u062a\\u0628\\u0644\\u06cc\\u063a\\u0627\\u062a\\u06cc\",\"value\":\"NO\"}]','1','1','2','2','1');
INSERT INTO `tbl_pages` VALUES ('131','آگهی های شهر','ads-list-city','','2020-08-16 00:00:00','1','2',NULL,NULL,'',NULL,'0','0','0','0','0','0','0',NULL,NULL,'{\r\n\"controller\": \"includes/core/pages/ads/city_controller.php\",\r\n\"content\": \"includes/theme/pages/ads/city.php\"\r\n}','[{\"key\":\"item-per-page\",\"type\":\"number\",\"name\":\"\\u062a\\u0639\\u062f\\u0627\\u062f \\u0622\\u06cc\\u062a\\u0645 \\u0647\\u0627 \\u062f\\u0631 \\u0647\\u0631 \\u0635\\u0641\\u062d\\u0647\",\"value\":\"10\"},{\"key\":\"enable-widget-area\",\"type\":\"boolean\",\"name\":\"\\u0641\\u0639\\u0627\\u0644 \\u0633\\u0627\\u0632\\u06cc \\u0646\\u0627\\u062d\\u06cc\\u0647 \\u0627\\u0628\\u0632\\u0627\\u0631\\u06a9\\u06cc \\u0635\\u0641\\u062d\\u0647\",\"value\":\"NO\"},{\"key\":\"show-banners\",\"type\":\"boolean\",\"name\":\"\\u0646\\u0645\\u0627\\u06cc\\u0634 \\u0628\\u0646\\u0631\\u0647\\u0627\\u06cc \\u062a\\u0628\\u0644\\u06cc\\u063a\\u0627\\u062a\\u06cc\",\"value\":\"NO\"},{\"key\":\"show-banner-slider\",\"type\":\"boolean\",\"name\":\"\\u0646\\u0645\\u0627\\u06cc\\u0634 \\u0627\\u0633\\u0644\\u0627\\u06cc\\u062f\\u0631 \\u0628\\u0646\\u0631\\u0647\\u0627\\u06cc \\u062a\\u0628\\u0644\\u06cc\\u063a\\u0627\\u062a\\u06cc\",\"value\":\"NO\"}]','1','1','2','2','1');
INSERT INTO `tbl_pages` VALUES ('132','نمایش پروفایل کاربر','profile-view','','2020-08-16 00:00:00','1','2',NULL,NULL,'پروفایل کاربر |\r\n {%site_title%}',NULL,'0','0','0','0','0','0','0',NULL,NULL,'{\r\n\"controller\": \"includes/core/pages/pages/profile_controller.php\",\r\n\"content\": \"includes/theme/pages/pages/profile/main.php\",\r\n\"js_validation\": true,\r\n\"js_files\": [\r\n\"public/theme/js/pages/profile.js\"\r\n]\r\n}','[{\"key\":\"item-per-page\",\"type\":\"number\",\"name\":\"\\u062a\\u0639\\u062f\\u0627\\u062f \\u0622\\u06cc\\u062a\\u0645 \\u0647\\u0627 \\u062f\\u0631 \\u0647\\u0631 \\u0635\\u0641\\u062d\\u0647\",\"value\":\"10\"},{\"key\":\"enable-send-email\",\"type\":\"boolean\",\"name\":\"\\u0646\\u0645\\u0627\\u06cc\\u0634 \\u0641\\u0631\\u0645 \\u0627\\u0631\\u0633\\u0627\\u0644 \\u0627\\u06cc\\u0645\\u06cc\\u0644\",\"value\":\"YES\"}]','1','1','2','2','1');
INSERT INTO `tbl_pages` VALUES ('133','پروسه -- عملیات های خارجی','external-actions','','2020-12-29 00:00:00','1','2','','','پروسه -- عملیات های خارجی','','0','0','0','0','0','0','0',NULL,NULL,'',NULL,'1','1','1','1','1');
INSERT INTO `tbl_pages` VALUES ('135',403,'page-403','','2020-12-29 00:00:00','1','2',NULL,NULL,'دسترسی غیرمجاز  |\r\n {%site_title%}','','0','0','0','0','0','0','0',NULL,NULL,'{\r\n\"controller\": \"includes/core/pages/pages/403_controller.php\",\r\n\"content\": \"includes/theme/pages/pages/403.php\",\r\n\"show_footer\": false\r\n}',NULL,'1','1','1','1','2');
INSERT INTO `tbl_pages` VALUES ('136','لیست rss','rss-list','','2020-12-29 00:00:00','1','2','','','خبرخوان RSS  |\r\n {%site_title%}','','0','0','0','0','0','0','0',NULL,NULL,'{\"url\":\"rss\",\"controller\":\"includes\\/core\\/pages\\/pages\\/rss\\/list_controller.php\",\"content\":\"includes\\/theme\\/pages\\/pages\\/rss\\/list.php\",\"css_files\":[\"public\\/theme\\/css\\/pages\\/rss.css\"],\"settings\":[{\"key\":\"body\",\"type\":\"textarea\",\"name\":\"\\u062a\\u0648\\u0636\\u06cc\\u062d\\u0627\\u062a RSS\",\"value\":\"<p>RSS&nbsp;\\u0686\\u06cc\\u0633\\u062a\\u061f<\\/p>\\r\\n\\r\\n<p>\\u0645\\u062e\\u0641\\u0641 Rich Site Summary \\u0628\\u0647 \\u0645\\u0639\\u0646\\u06cc &quot; \\u0686\\u06a9\\u06cc\\u062f\\u0647 \\u0633\\u0627\\u06cc\\u062a &quot; \\u06cc\\u0627 &quot; \\u0645\\u062e\\u062a\\u0635\\u0631 \\u0648 \\u0645\\u0641\\u06cc\\u062f \\u0633\\u0627\\u06cc\\u062a &quot; \\u0627\\u0633\\u062a \\u0648 \\u0628\\u0647 \\u0634\\u0645\\u0627 \\u0627\\u0645\\u06a9\\u0627\\u0646 \\u0645\\u06cc&zwnj;\\u062f\\u0647\\u062f \\u062a\\u0627 \\u0627\\u0632 \\u0622\\u062e\\u0631\\u06cc\\u0646 \\u062e\\u0628\\u0631\\u0647\\u0627 \\u0648 \\u0639\\u0646\\u0627\\u0648\\u06cc\\u0646 \\u0633\\u0627\\u06cc\\u062a \\u0648 \\u06cc\\u0627 \\u0648\\u0628\\u0644\\u0627\\u06af\\u0647\\u0627\\u06cc \\u0645\\u0648\\u0631\\u062f \\u0639\\u0644\\u0627\\u0642\\u0647 \\u062e\\u0648\\u062f \\u0628\\u0627 \\u062e\\u0628\\u0631 \\u0628\\u0627\\u0634\\u06cc\\u062f\\u060c \\u0628\\u062f\\u0648\\u0646 \\u0622\\u0646\\u06a9\\u0647 \\u0646\\u06cc\\u0627\\u0632\\u06cc \\u062f\\u0627\\u0634\\u062a\\u0647 \\u0628\\u0627\\u0634\\u06cc\\u062f \\u0628\\u0647 \\u0622\\u0646\\u0647\\u0627 \\u0633\\u0631 \\u0628\\u0632\\u0646\\u06cc\\u062f.<\\/p>\\r\\n\\r\\n<p>\\u06a9\\u0627\\u0631\\u0628\\u0631\\u062f\\u0647\\u0627\\u06cc \\u0627\\u0635\\u0644\\u06cc RSS \\u062f\\u0648 \\u0645\\u0648\\u0631\\u062f \\u0632\\u06cc\\u0631 \\u0647\\u0633\\u062a\\u0646\\u062f: - \\u0646\\u0645\\u0627\\u06cc\\u0634 \\u062a\\u0627\\u0632\\u0647&zwnj;\\u062a\\u0631\\u06cc\\u0646 \\u0639\\u0646\\u0627\\u0648\\u06cc\\u0646 \\u0648\\u0628&zwnj;\\u0633\\u0627\\u06cc\\u062a&zwnj;\\u0647\\u0627\\u06cc \\u062f\\u06cc\\u06af\\u0631 \\u062f\\u0631 \\u0648\\u0628&zwnj;\\u0633\\u0627\\u06cc\\u062a \\u062e\\u0648\\u062f \\u0648 \\u06cc\\u0627 \\u0628\\u0627\\u0644\\u0639\\u06a9\\u0633 ( \\u0627\\u0634\\u062a\\u0631\\u0627\\u06a9 \\u0645\\u0637\\u0627\\u0644\\u0628 \\u062c\\u062f\\u06cc\\u062f) - \\u062f\\u0631\\u06cc\\u0627\\u0641\\u062a \\u062c\\u062f\\u06cc\\u062f\\u062a\\u0631\\u06cc\\u0646 \\u0645\\u0637\\u0627\\u0644\\u0628 \\u0633\\u0627\\u06cc\\u062a&zwnj;\\u0647\\u0627\\u06cc \\u0645\\u0648\\u0631\\u062f \\u0639\\u0644\\u0627\\u0642\\u0647 \\u0628\\u0627 \\u0627\\u0633\\u062a\\u0641\\u0627\\u062f\\u0647 \\u0627\\u0632 \\u0646\\u0631\\u0645&zwnj;\\u0627\\u0641\\u0632\\u0627\\u0631\\u0647\\u0627\\u06cc \\u0648\\u06cc\\u0698\\u0647 ( \\u0648\\u0628\\u06af\\u0631\\u062f\\u06cc \\u0628\\u0627 \\u06a9\\u0627\\u0631\\u0622\\u06cc\\u06cc \\u0628\\u06cc\\u0634\\u062a\\u0631)<\\/p>\\r\\n\\r\\n<p>\\u0628\\u062f\\u0648\\u0646 \\u0648\\u062c\\u0648\\u062f RSS \\u0634\\u0645\\u0627 \\u0628\\u0627\\u06cc\\u062f \\u0647\\u0631 \\u0631\\u0648\\u0632 \\u0633\\u0627\\u06cc\\u062a \\u0647\\u0627\\u06cc \\u0645\\u0648\\u0631\\u062f \\u0639\\u0644\\u0627\\u0642\\u0647 \\u062e\\u0648\\u062f \\u0631\\u0627 \\u0631\\u0627 \\u0686\\u06a9 \\u06a9\\u0646\\u06cc\\u062f \\u062a\\u0627 \\u0628\\u062a\\u0648\\u0627\\u0646\\u06cc\\u062f \\u0627\\u0632 \\u062a\\u0627\\u0632\\u0647 \\u0647\\u0627\\u06cc \\u0622\\u0646\\u0647\\u0627 \\u0628\\u0627 \\u062e\\u0628\\u0631 \\u0634\\u0648\\u06cc\\u062f. \\u0627\\u0645\\u0627 \\u0628\\u0627 \\u0627\\u06cc\\u0646 \\u062a\\u06a9\\u0646\\u0648\\u0644\\u0648\\u0698\\u06cc \\u060c \\u0634\\u0645\\u0627 \\u060c RSS \\u0686\\u0646\\u062f\\u06cc\\u0646 \\u0633\\u0627\\u06cc\\u062a \\u0631\\u0627 \\u062f\\u0631 \\u06cc\\u06a9 \\u0628\\u0631\\u0646\\u0627\\u0645\\u0647 RSS aggregator \\u06cc\\u0627 (RSS \\u062e\\u0648\\u0627\\u0646) \\u062f\\u0631 \\u06a9\\u0646\\u0627\\u0631 \\u0647\\u0645 \\u0645\\u06cc \\u0628\\u06cc\\u0646\\u06cc\\u0646\\u062f \\u0648 \\u062a\\u0627\\u06cc\\u062a\\u0644 \\u0646\\u0648\\u0634\\u062a\\u0647 \\u0647\\u0627\\u06cc \\u0627\\u062e\\u06cc\\u0631 \\u0633\\u0627\\u06cc\\u062a \\u0647\\u0627 \\u0631\\u0627 \\u0628\\u062f\\u0648\\u0646 \\u0645\\u0631\\u0627\\u062c\\u0639\\u0647 \\u0628\\u0647 \\u0622\\u0646\\u0647\\u0627 \\u0645\\u0634\\u0627\\u0647\\u062f\\u0647 \\u0645\\u06cc\\u06a9\\u0646\\u06cc\\u062f.<\\/p>\\r\\n\\r\\n<p>RSS Reader \\u0686\\u06cc\\u0633\\u062a\\u061f RSS Reader \\u06cc\\u06a9 \\u0646\\u0631\\u0645&zwnj;\\u0627\\u0641\\u0632\\u0627\\u0631 RSS\\u062e\\u0648\\u0627\\u0646 \\u0627\\u0644\\u06a9\\u062a\\u0631\\u0648\\u0646\\u06cc\\u06a9\\u06cc \\u0627\\u0633\\u062a. \\u0627\\u06a9\\u0646\\u0648\\u0646 \\u0646\\u0631\\u0645&zwnj;\\u0627\\u0641\\u0632\\u0627\\u0631\\u0647\\u0627\\u06cc \\u0628\\u0633\\u06cc\\u0627\\u0631\\u06cc \\u062f\\u0631 \\u0627\\u06cc\\u0646 \\u0632\\u0645\\u06cc\\u0646\\u0647 \\u0648\\u062c\\u0648\\u062f \\u062f\\u0627\\u0631\\u0646\\u062f \\u06a9\\u0647 \\u0645\\u06cc&zwnj;\\u062a\\u0648\\u0627\\u0646 \\u0628\\u0627 \\u062f\\u0627\\u0646\\u0644\\u0648\\u062f \\u0622\\u0646\\u0647\\u0627 RSS \\u062e\\u0648\\u0627\\u0646\\u062f. \\u0627\\u0645\\u0627 \\u0628\\u0647 \\u062a\\u0627\\u0632\\u06af\\u06cc \\u0645\\u0631\\u0648\\u0631\\u06af\\u0631\\u0647\\u0627\\u06cc \\u0627\\u06cc\\u0646\\u062a\\u0631\\u0646\\u062a\\u06cc \\u0646\\u06cc\\u0632 \\u0628\\u0647 \\u0633\\u06cc\\u0633\\u062a\\u0645 RSS\\u062e\\u0648\\u0627\\u0646\\u06cc \\u0627\\u0644\\u06a9\\u062a\\u0631\\u0648\\u0646\\u06cc\\u06a9\\u06cc \\u0645\\u062c\\u0647\\u0632 \\u0634\\u062f\\u0647&zwnj;\\u0627\\u0646\\u062f. \\u0627\\u0632 \\u0646\\u0631\\u0645 \\u0627\\u0641\\u0632\\u0627\\u0631 \\u0647\\u0627\\u06cc RSS \\u062e\\u0648\\u0627\\u0646 \\u0645\\u06cc\\u062a\\u0648\\u0627\\u0646 \\u0628\\u0647 Thunderbird \\u0648 Google Reader \\u0627\\u0634\\u0627\\u0631\\u0647 \\u06a9\\u0631\\u062f.<\\/p>\\r\\n\\r\\n<p>\\u0645\\u0646\\u0628\\u0639 : \\u0648\\u06cc\\u06a9\\u06cc\\u067e\\u062f\\u06cc\\u0627<\\/p>\\r\\n\"}]}','[{\"key\":\"body\",\"type\":\"textarea\",\"name\":\"\\u062a\\u0648\\u0636\\u06cc\\u062d\\u0627\\u062a RSS\",\"value\":\"<h3>RSS&nbsp;\\u0686\\u06cc\\u0633\\u062a\\u061f<\\/h3>\\r\\n\\r\\n<p>\\u0645\\u062e\\u0641\\u0641 Rich Site Summary \\u0628\\u0647 \\u0645\\u0639\\u0646\\u06cc &quot; \\u0686\\u06a9\\u06cc\\u062f\\u0647 \\u0633\\u0627\\u06cc\\u062a &quot; \\u06cc\\u0627 &quot; \\u0645\\u062e\\u062a\\u0635\\u0631 \\u0648 \\u0645\\u0641\\u06cc\\u062f \\u0633\\u0627\\u06cc\\u062a &quot; \\u0627\\u0633\\u062a \\u0648 \\u0628\\u0647 \\u0634\\u0645\\u0627 \\u0627\\u0645\\u06a9\\u0627\\u0646 \\u0645\\u06cc&zwnj;\\u062f\\u0647\\u062f \\u062a\\u0627 \\u0627\\u0632 \\u0622\\u062e\\u0631\\u06cc\\u0646 \\u062e\\u0628\\u0631\\u0647\\u0627 \\u0648 \\u0639\\u0646\\u0627\\u0648\\u06cc\\u0646 \\u0633\\u0627\\u06cc\\u062a \\u0648 \\u06cc\\u0627 \\u0648\\u0628\\u0644\\u0627\\u06af\\u0647\\u0627\\u06cc \\u0645\\u0648\\u0631\\u062f \\u0639\\u0644\\u0627\\u0642\\u0647 \\u062e\\u0648\\u062f \\u0628\\u0627 \\u062e\\u0628\\u0631 \\u0628\\u0627\\u0634\\u06cc\\u062f\\u060c \\u0628\\u062f\\u0648\\u0646 \\u0622\\u0646\\u06a9\\u0647 \\u0646\\u06cc\\u0627\\u0632\\u06cc \\u062f\\u0627\\u0634\\u062a\\u0647 \\u0628\\u0627\\u0634\\u06cc\\u062f \\u0628\\u0647 \\u0622\\u0646\\u0647\\u0627 \\u0633\\u0631 \\u0628\\u0632\\u0646\\u06cc\\u062f.<\\/p>\\r\\n\\r\\n<p>\\u06a9\\u0627\\u0631\\u0628\\u0631\\u062f\\u0647\\u0627\\u06cc \\u0627\\u0635\\u0644\\u06cc RSS \\u062f\\u0648 \\u0645\\u0648\\u0631\\u062f \\u0632\\u06cc\\u0631 \\u0647\\u0633\\u062a\\u0646\\u062f: - \\u0646\\u0645\\u0627\\u06cc\\u0634 \\u062a\\u0627\\u0632\\u0647&zwnj;\\u062a\\u0631\\u06cc\\u0646 \\u0639\\u0646\\u0627\\u0648\\u06cc\\u0646 \\u0648\\u0628&zwnj;\\u0633\\u0627\\u06cc\\u062a&zwnj;\\u0647\\u0627\\u06cc \\u062f\\u06cc\\u06af\\u0631 \\u062f\\u0631 \\u0648\\u0628&zwnj;\\u0633\\u0627\\u06cc\\u062a \\u062e\\u0648\\u062f \\u0648 \\u06cc\\u0627 \\u0628\\u0627\\u0644\\u0639\\u06a9\\u0633 ( \\u0627\\u0634\\u062a\\u0631\\u0627\\u06a9 \\u0645\\u0637\\u0627\\u0644\\u0628 \\u062c\\u062f\\u06cc\\u062f) - \\u062f\\u0631\\u06cc\\u0627\\u0641\\u062a \\u062c\\u062f\\u06cc\\u062f\\u062a\\u0631\\u06cc\\u0646 \\u0645\\u0637\\u0627\\u0644\\u0628 \\u0633\\u0627\\u06cc\\u062a&zwnj;\\u0647\\u0627\\u06cc \\u0645\\u0648\\u0631\\u062f \\u0639\\u0644\\u0627\\u0642\\u0647 \\u0628\\u0627 \\u0627\\u0633\\u062a\\u0641\\u0627\\u062f\\u0647 \\u0627\\u0632 \\u0646\\u0631\\u0645&zwnj;\\u0627\\u0641\\u0632\\u0627\\u0631\\u0647\\u0627\\u06cc \\u0648\\u06cc\\u0698\\u0647 ( \\u0648\\u0628\\u06af\\u0631\\u062f\\u06cc \\u0628\\u0627 \\u06a9\\u0627\\u0631\\u0622\\u06cc\\u06cc \\u0628\\u06cc\\u0634\\u062a\\u0631)<\\/p>\\r\\n\\r\\n<p>\\u0628\\u062f\\u0648\\u0646 \\u0648\\u062c\\u0648\\u062f RSS \\u0634\\u0645\\u0627 \\u0628\\u0627\\u06cc\\u062f \\u0647\\u0631 \\u0631\\u0648\\u0632 \\u0633\\u0627\\u06cc\\u062a \\u0647\\u0627\\u06cc \\u0645\\u0648\\u0631\\u062f \\u0639\\u0644\\u0627\\u0642\\u0647 \\u062e\\u0648\\u062f \\u0631\\u0627 \\u0631\\u0627 \\u0686\\u06a9 \\u06a9\\u0646\\u06cc\\u062f \\u062a\\u0627 \\u0628\\u062a\\u0648\\u0627\\u0646\\u06cc\\u062f \\u0627\\u0632 \\u062a\\u0627\\u0632\\u0647 \\u0647\\u0627\\u06cc \\u0622\\u0646\\u0647\\u0627 \\u0628\\u0627 \\u062e\\u0628\\u0631 \\u0634\\u0648\\u06cc\\u062f. \\u0627\\u0645\\u0627 \\u0628\\u0627 \\u0627\\u06cc\\u0646 \\u062a\\u06a9\\u0646\\u0648\\u0644\\u0648\\u0698\\u06cc \\u060c \\u0634\\u0645\\u0627 \\u060c RSS \\u0686\\u0646\\u062f\\u06cc\\u0646 \\u0633\\u0627\\u06cc\\u062a \\u0631\\u0627 \\u062f\\u0631 \\u06cc\\u06a9 \\u0628\\u0631\\u0646\\u0627\\u0645\\u0647 RSS aggregator \\u06cc\\u0627 (RSS \\u062e\\u0648\\u0627\\u0646) \\u062f\\u0631 \\u06a9\\u0646\\u0627\\u0631 \\u0647\\u0645 \\u0645\\u06cc \\u0628\\u06cc\\u0646\\u06cc\\u0646\\u062f \\u0648 \\u062a\\u0627\\u06cc\\u062a\\u0644 \\u0646\\u0648\\u0634\\u062a\\u0647 \\u0647\\u0627\\u06cc \\u0627\\u062e\\u06cc\\u0631 \\u0633\\u0627\\u06cc\\u062a \\u0647\\u0627 \\u0631\\u0627 \\u0628\\u062f\\u0648\\u0646 \\u0645\\u0631\\u0627\\u062c\\u0639\\u0647 \\u0628\\u0647 \\u0622\\u0646\\u0647\\u0627 \\u0645\\u0634\\u0627\\u0647\\u062f\\u0647 \\u0645\\u06cc\\u06a9\\u0646\\u06cc\\u062f.<\\/p>\\r\\n\\r\\n<p>RSS Reader \\u0686\\u06cc\\u0633\\u062a\\u061f RSS Reader \\u06cc\\u06a9 \\u0646\\u0631\\u0645&zwnj;\\u0627\\u0641\\u0632\\u0627\\u0631 RSS\\u062e\\u0648\\u0627\\u0646 \\u0627\\u0644\\u06a9\\u062a\\u0631\\u0648\\u0646\\u06cc\\u06a9\\u06cc \\u0627\\u0633\\u062a. \\u0627\\u06a9\\u0646\\u0648\\u0646 \\u0646\\u0631\\u0645&zwnj;\\u0627\\u0641\\u0632\\u0627\\u0631\\u0647\\u0627\\u06cc \\u0628\\u0633\\u06cc\\u0627\\u0631\\u06cc \\u062f\\u0631 \\u0627\\u06cc\\u0646 \\u0632\\u0645\\u06cc\\u0646\\u0647 \\u0648\\u062c\\u0648\\u062f \\u062f\\u0627\\u0631\\u0646\\u062f \\u06a9\\u0647 \\u0645\\u06cc&zwnj;\\u062a\\u0648\\u0627\\u0646 \\u0628\\u0627 \\u062f\\u0627\\u0646\\u0644\\u0648\\u062f \\u0622\\u0646\\u0647\\u0627 RSS \\u062e\\u0648\\u0627\\u0646\\u062f. \\u0627\\u0645\\u0627 \\u0628\\u0647 \\u062a\\u0627\\u0632\\u06af\\u06cc \\u0645\\u0631\\u0648\\u0631\\u06af\\u0631\\u0647\\u0627\\u06cc \\u0627\\u06cc\\u0646\\u062a\\u0631\\u0646\\u062a\\u06cc \\u0646\\u06cc\\u0632 \\u0628\\u0647 \\u0633\\u06cc\\u0633\\u062a\\u0645 RSS\\u062e\\u0648\\u0627\\u0646\\u06cc \\u0627\\u0644\\u06a9\\u062a\\u0631\\u0648\\u0646\\u06cc\\u06a9\\u06cc \\u0645\\u062c\\u0647\\u0632 \\u0634\\u062f\\u0647&zwnj;\\u0627\\u0646\\u062f. \\u0627\\u0632 \\u0646\\u0631\\u0645 \\u0627\\u0641\\u0632\\u0627\\u0631 \\u0647\\u0627\\u06cc RSS \\u062e\\u0648\\u0627\\u0646 \\u0645\\u06cc\\u062a\\u0648\\u0627\\u0646 \\u0628\\u0647 Thunderbird \\u0648 Google Reader \\u0627\\u0634\\u0627\\u0631\\u0647 \\u06a9\\u0631\\u062f.<\\/p>\\r\\n\\r\\n<p>\\u0645\\u0646\\u0628\\u0639 : \\u0648\\u06cc\\u06a9\\u06cc\\u067e\\u062f\\u06cc\\u0627<\\/p>\\r\\n\"}]','1','1','2','1','2');
INSERT INTO `tbl_pages` VALUES ('137','محتوای RSS','rss-content','','2020-11-16 00:00:00','1','2','','','محتوای RSS','','0','0','0','0','0','0','0',NULL,NULL,'{\r\n\"controller\": \"includes/core/pages/pages/rss/content_controller.php\",\r\n\"process_page\": true\r\n}',NULL,'1','1','1','1','2');
INSERT INTO `tbl_pages` VALUES ('138','پروسه -- عملیات های ajax','ajax-actions','','2020-12-29 00:00:00','1','2','','','پروسه -- عملیات های ajax','','0','0','0','0','0','0','0',NULL,NULL,'',NULL,'1','1','1','1','1');
INSERT INTO `tbl_pages` VALUES ('139','پشتیبانی','support','','2019-03-06 00:00:00','1','2',NULL,NULL,'پشتیبانی','','0','0','0','0','0','1','0','support','support.php','',NULL,'1','1','2','1','2');
INSERT INTO `tbl_pages` VALUES ('140','تنظیمات رنگ ها و استایل','settings-pages--styles','','2019-03-06 00:00:00','1','2',NULL,NULL,'تنظیمات هدر','','0','0','0','0','0','1','49','settings/pages/styles','settings__pages--styles.php','{\"minimize_sidebar\": true,\r\n\"module_code\": \"SETTING_MANAGE\",\r\n\"related_menu_route\": \"settings__pages.php\",\r\n\"icon\": \"fa fa-paint-brush\"\r\n}',NULL,'0','1','2','1','2');
INSERT INTO `tbl_pages` VALUES ('141','demo-restrict','page-demo-restrict','','2020-12-29 00:00:00','1','2',NULL,NULL,'دسترسی غیرمجاز  |\r\n {%site_title%}','','0','0','0','0','0','0','0',NULL,NULL,'{\r\n\"controller\": \"includes/core/pages/pages/demo_restrict_controller.php\",\r\n\"content\": \"includes/theme/pages/pages/demo_restrict.php\",\r\n\"show_footer\": false\r\n}',NULL,'1','1','1','1','2');
UNLOCK TABLES;

-- Table structure for table `tbl_plans`

DROP TABLE IF EXISTS `tbl_plans`;
CREATE TABLE `tbl_plans` (
  `ID` smallint NOT NULL AUTO_INCREMENT,
  `PLAN_TITLE` varchar(255) NOT NULL,
  `PLAN_DAYS` bigint DEFAULT NULL,
  `PLAN_PRICE` bigint DEFAULT NULL,
  `PLAN_UPDATE_TIMES` mediumint NOT NULL DEFAULT '0',
  `IS_SLIDER` smallint NOT NULL DEFAULT '1',
  `IS_SIDE_SLIDER` tinyint NOT NULL DEFAULT '1',
  `IS_TEXT` tinyint NOT NULL DEFAULT '1',
  `IS_FREE` smallint NOT NULL DEFAULT '1',
  `HAS_LINK` tinyint NOT NULL DEFAULT '1',
  `MAX_IMG_COUNT` tinyint NOT NULL DEFAULT '3',
  `MAX_KEYWORD_COUNT` tinyint NOT NULL DEFAULT '5',
  `MAX_EDIT_COUNT` tinyint NOT NULL DEFAULT '1',
  `PLAN_PRIORITY` int DEFAULT NULL,
  `PLAN_STARS` int NOT NULL DEFAULT '0',
  `HAS_TELEGRAM` smallint NOT NULL DEFAULT '1',
  `DISCOUNT_FOR_3_PERIOD` smallint NOT NULL DEFAULT '0',
  `DISCOUNT_FOR_6_PERIOD` smallint NOT NULL DEFAULT '0',
  `DISCOUNT_FOR_12_PERIOD` smallint NOT NULL DEFAULT '0',
  `IS_DELETABLE` smallint NOT NULL DEFAULT '1',
  `IS_ENABLE` smallint NOT NULL DEFAULT '1',
  `COLOR` varchar(255) DEFAULT '#6DB6FD',
  `RIBBON_TEXT` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`ID`)
) ENGINE=InnoDB AUTO_INCREMENT=8 DEFAULT CHARSET=utf8mb3;

-- Dumping data for table `tbl_plans`

LOCK TABLES `tbl_plans` WRITE;
INSERT INTO `tbl_plans` VALUES ('1','آگهی رایگان','365','0','10','1','1','1','2','1','3','5','1','6','0','1','0','0','0','0','1','#9F9F9F','');
INSERT INTO `tbl_plans` VALUES ('3','1 ستاره','30','1000','5','1','1','1','1','1','5','5','1','5','1','1','1','2','3','1','1','#AAC323',NULL);
INSERT INTO `tbl_plans` VALUES ('4','2 ستاره','30','6000','8','1','1','1','1','2','5','3','1','4','2','2','0','10','0','1','1','#D76F2C',NULL);
INSERT INTO `tbl_plans` VALUES ('5','3 ستاره','7','7000','12','1','1','1','1','1','3','5','1','3','3','1','0','0','0','1','1','#6DB6FD',NULL);
INSERT INTO `tbl_plans` VALUES ('6','4 ستاره','60','10000','15','2','2','1','1','1','3','5','1','2','4','2','0','0','0','1','1','#5ECFB1','فوری');
INSERT INTO `tbl_plans` VALUES ('7','5 ستاره','70','32535','30','2','2','1','1','2','6','10','1','1','5','2','0','0','0','1','1','#E22692','ویژه');
UNLOCK TABLES;

-- Table structure for table `tbl_policy_report`

DROP TABLE IF EXISTS `tbl_policy_report`;
CREATE TABLE `tbl_policy_report` (
  `ID` int NOT NULL AUTO_INCREMENT,
  `ADS_ID` bigint unsigned NOT NULL,
  `REPORT` text NOT NULL,
  `DATE_CREATED` datetime NOT NULL,
  `USER_ID` int DEFAULT NULL,
  `IP` varchar(50) DEFAULT NULL,
  PRIMARY KEY (`ID`),
  KEY `ADS_ID` (`ADS_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

-- Dumping data for table `tbl_policy_report`

LOCK TABLES `tbl_policy_report` WRITE;
UNLOCK TABLES;

-- Table structure for table `tbl_post_categories`

DROP TABLE IF EXISTS `tbl_post_categories`;
CREATE TABLE `tbl_post_categories` (
  `ID` int NOT NULL AUTO_INCREMENT,
  `CATEGORY_NAME` varchar(200) CHARACTER SET utf8mb3 COLLATE utf8mb3_persian_ci DEFAULT NULL,
  `CATEGORY_SLUG` varchar(200) NOT NULL,
  `META_DESCRIPTION` text,
  `META_KEYWORDS` text,
  PRIMARY KEY (`ID`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb3;

-- Dumping data for table `tbl_post_categories`

LOCK TABLES `tbl_post_categories` WRITE;
INSERT INTO `tbl_post_categories` VALUES ('1','اخبار','اخبار',NULL,NULL);
INSERT INTO `tbl_post_categories` VALUES ('2','اطلاعیه ها','اطلاعیه-ها',NULL,NULL);
UNLOCK TABLES;

-- Table structure for table `tbl_posts`

DROP TABLE IF EXISTS `tbl_posts`;
CREATE TABLE `tbl_posts` (
  `ID` int NOT NULL AUTO_INCREMENT,
  `user_id` bigint NOT NULL,
  `TITLE` varchar(255) NOT NULL,
  `SLUG` varchar(255) NOT NULL,
  `POST_TEXT` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_0900_ai_ci,
  `CATEGORY_ID` int DEFAULT NULL,
  `DATE_CREATED` datetime DEFAULT NULL,
  `DATE_UPDATED` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `IS_ACTIVE` tinyint NOT NULL DEFAULT '2',
  `POST_META_DESCRIPTION` text,
  `POST_META_KEYWORDS` text,
  `TELEGRAMED` tinyint(1) NOT NULL DEFAULT '0',
  `short_description` text,
  `views` bigint NOT NULL DEFAULT '0',
  `featured_image_id` bigint DEFAULT NULL,
  PRIMARY KEY (`ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

-- Dumping data for table `tbl_posts`

LOCK TABLES `tbl_posts` WRITE;
UNLOCK TABLES;

-- Table structure for table `tbl_settings`

DROP TABLE IF EXISTS `tbl_settings`;
CREATE TABLE `tbl_settings` (
  `ID` int NOT NULL AUTO_INCREMENT,
  `SETTING` varchar(255) NOT NULL,
  `VALUE` text NOT NULL,
  PRIMARY KEY (`ID`)
) ENGINE=InnoDB AUTO_INCREMENT=269 DEFAULT CHARSET=utf8mb3;

-- Dumping data for table `tbl_settings`

LOCK TABLES `tbl_settings` WRITE;
INSERT INTO `tbl_settings` VALUES ('7','MAX_IMG_SIZE_KB',3000);
INSERT INTO `tbl_settings` VALUES ('8','TOTAL_STARS',5);
INSERT INTO `tbl_settings` VALUES ('11','SITE_TITLE','عنوان سایت شما');
INSERT INTO `tbl_settings` VALUES ('12','TEL1','09112002371');
INSERT INTO `tbl_settings` VALUES ('13','TEL2','09114899693 ');
INSERT INTO `tbl_settings` VALUES ('14','EMAIL','site@mail.com');
INSERT INTO `tbl_settings` VALUES ('15','ADDRESS','<p>شما می توانید آدرس خود را در این قسمت وارد نمایید.&nbsp;شما می توانید آدرس خود را در این قسمت وارد نمایید.&nbsp;شما می توانید آدرس خود را در این قسمت وارد نمایید</p>\r\n');
INSERT INTO `tbl_settings` VALUES ('16','ABOUT_US','<p>شما می توانید در این قسمت توضیحات دلخواه خود را وارد نمایید.شما می توانید در این قسمت توضیحات دلخواه خود را وارد نمایید.</p>\r\n\r\n<p>ادامه توضیحات در این قسمت قرار می گیرد.ادامه توضیحات در این قسمت قرار می گیرد.ادامه توضیحات در این قسمت قرار می گیرد.ادامه توضیحات در این قسمت قرار می گیرد.</p>\r\n');
INSERT INTO `tbl_settings` VALUES ('18','LONGITUDE','51.05923800000005');
INSERT INTO `tbl_settings` VALUES ('19','LATTITUDE','35.664669');
INSERT INTO `tbl_settings` VALUES ('22','EXPIRE_DAYS',5);
INSERT INTO `tbl_settings` VALUES ('23','FACEBOOK_URL','http://www.facebook.com/kodesign');
INSERT INTO `tbl_settings` VALUES ('24','TWITTER_URL','http://www.twitter.com/kodesign');
INSERT INTO `tbl_settings` VALUES ('25','GOOGLEPLUS_URL','http://www.googleplus.com/kodesign');
INSERT INTO `tbl_settings` VALUES ('26','LINKEDIN_URL','http://www.linkedin.com/kodesign');
INSERT INTO `tbl_settings` VALUES ('27','INSTAGRAM_URL','http://www.instagram.com/kodesign');
INSERT INTO `tbl_settings` VALUES ('28','PINTEREST_URL','http://www.pinterest.com/kodesign');
INSERT INTO `tbl_settings` VALUES ('29','SEO_DESCRIPTION','فروش نسخه نهایی اسکریپت نیازمندی ها و طراحی سایت نیازمندی ها با کیفیت عالی و قیمت مناسب ، همراه با پلان های کسب درآمد و قسمت مدیریت بسیار کارآمد + پیش نمایش زنده برای مشاهده توسط شما ');
INSERT INTO `tbl_settings` VALUES ('30','SEO_KEYWORDS','اسکریپت نیازمندی ها,نسخه نهایی، سایت درج آگهی,آگهی نامه,درج آگهی رایگان');
INSERT INTO `tbl_settings` VALUES ('31','SEO_TITLE','نیازمندی ها|اسکریپت نیازمندی ها|قالب آگهی|اسکریپت آگهی');
INSERT INTO `tbl_settings` VALUES ('33','MAIL_HOST','');
INSERT INTO `tbl_settings` VALUES ('34','MAIL_PORT','');
INSERT INTO `tbl_settings` VALUES ('35','MAIL_USERNAME','admin');
INSERT INTO `tbl_settings` VALUES ('36','MAIL_PASSWORD',123456);
INSERT INTO `tbl_settings` VALUES ('37','USER_MAX_FREE_ADS',5);
INSERT INTO `tbl_settings` VALUES ('43','SITE_URL','niazmandi-v10.test');
INSERT INTO `tbl_settings` VALUES ('45','FOOTER_CONTENT_1','STATISTICS');
INSERT INTO `tbl_settings` VALUES ('46','FOOTER_CONTENT_2','LINKS');
INSERT INTO `tbl_settings` VALUES ('47','FOOTER_CONTENT_3','CONTACT');
INSERT INTO `tbl_settings` VALUES ('48','FOOTER_CONTENT_4','NEWS');
INSERT INTO `tbl_settings` VALUES ('49','COPYRIGHT_TEXT','طراحی و توسعه توسط<a href=http://www.kodesign.ir target=_blank> کدیزاین</a>');
INSERT INTO `tbl_settings` VALUES ('51','BANK_EXPIRE_DAYS',3);
INSERT INTO `tbl_settings` VALUES ('52','BANK_PAYMENT_ADMIN_DESC','توضیحات این قسمت را در بخش مدیریت تغییر دهید');
INSERT INTO `tbl_settings` VALUES ('53','CAN_ADD_SPECIAL_ADS','YES');
INSERT INTO `tbl_settings` VALUES ('54','SMS_SEND_URL','http://ippanel.com/class/sms/webservice/send_url.php');
INSERT INTO `tbl_settings` VALUES ('56','SMS_CREDIT_URL','http://ippanel.com/class/sms/webservice/send_url.php');
INSERT INTO `tbl_settings` VALUES ('57','SITE_SMS_NUMBER','');
INSERT INTO `tbl_settings` VALUES ('58','SMS_USERNAME','');
INSERT INTO `tbl_settings` VALUES ('59','SMS_PASSWORD','');
INSERT INTO `tbl_settings` VALUES ('60','SEND_EMAIL_AFTER_PAYMENT','YES');
INSERT INTO `tbl_settings` VALUES ('61','SEND_SMS_AFTER_PAYMENT','YES');
INSERT INTO `tbl_settings` VALUES ('62','SEND_EMAIL_AFTER_FREE_SUBMIT','YES');
INSERT INTO `tbl_settings` VALUES ('63','SEND_EMAIL_AFTER_REGISTER','YES');
INSERT INTO `tbl_settings` VALUES ('64','COLOR_SCHEME',2);
INSERT INTO `tbl_settings` VALUES ('66','SMS_METHOD','REST');
INSERT INTO `tbl_settings` VALUES ('67','SEND_SMS_AFTER_REGISTER','NO');
INSERT INTO `tbl_settings` VALUES ('68','REGISTER_NEEDS_ACTIVATE','NO');
INSERT INTO `tbl_settings` VALUES ('73','SEND_EMAIL_AFTER_VERIFY_ADS','YES');
INSERT INTO `tbl_settings` VALUES ('74','SEND_SMS_AFTER_VERIFY_ADS','YES');
INSERT INTO `tbl_settings` VALUES ('75','DEMO_MODE','OFF');
INSERT INTO `tbl_settings` VALUES ('76','MAINTENANCE_MODE','OFF');
INSERT INTO `tbl_settings` VALUES ('77','REOPEN_DATE','2016-11-29 15:42:10');
INSERT INTO `tbl_settings` VALUES ('78','ADMIN_COPYRIGHT','<script> document.write(new Date().getFullYear()) </script> © Designed & Developed By <a href=http://kodesign.ir target=_blank> Kodesign.ir </a>');
INSERT INTO `tbl_settings` VALUES ('79','USER_COPYRIGHT','شما می توانید متن قسمت کپی رایت را به دلخواه خود تغییر دهید');
INSERT INTO `tbl_settings` VALUES ('80','GOOGLE_ANALYSIS','');
INSERT INTO `tbl_settings` VALUES ('81','SHOW_TODAY_HITS','YES');
INSERT INTO `tbl_settings` VALUES ('82','SHOW_WEEKLY_HITS','YES');
INSERT INTO `tbl_settings` VALUES ('83','SHOW_MONTHLY_HITS','YES');
INSERT INTO `tbl_settings` VALUES ('84','SHOW_YEARLY_HITS','NO');
INSERT INTO `tbl_settings` VALUES ('85','SHOW_TOTAL_HITS','YES');
INSERT INTO `tbl_settings` VALUES ('86','SHOW_TOTAL_ADS','YES');
INSERT INTO `tbl_settings` VALUES ('87','SHOW_SPECIALS_ADS','NO');
INSERT INTO `tbl_settings` VALUES ('88','LOGIN_AFTER_REGISTER','YES');
INSERT INTO `tbl_settings` VALUES ('89','HEADER_TYPE','ALT_HEADER_1');
INSERT INTO `tbl_settings` VALUES ('94','TOP_MARQUEE','');
INSERT INTO `tbl_settings` VALUES ('95','MELLAT_TERMINALID','');
INSERT INTO `tbl_settings` VALUES ('96','MELLAT_USERNAME','test');
INSERT INTO `tbl_settings` VALUES ('97','MELLAT_PASSWORD','test');
INSERT INTO `tbl_settings` VALUES ('99','SHOW_BANKFISH_GATEWAY','YES');
INSERT INTO `tbl_settings` VALUES ('100','SHOW_PARSPAL_GATEWAY','NO');
INSERT INTO `tbl_settings` VALUES ('101','SHOW_MELLAT_GATEWAY','YES');
INSERT INTO `tbl_settings` VALUES ('102','SHOW_PAYLINE_GATEWAY','YES');
INSERT INTO `tbl_settings` VALUES ('103','DEFAULT_GATEWAY','IDPAY');
INSERT INTO `tbl_settings` VALUES ('104','PAYLINE_API_KEY','');
INSERT INTO `tbl_settings` VALUES ('106','REGISTER_VERIFICATION_METHOD','ALL');
INSERT INTO `tbl_settings` VALUES ('120','ZARINPAL_MERCHANT_ID','');
INSERT INTO `tbl_settings` VALUES ('121','SHOW_ZARINPAL_GATEWAY','YES');
INSERT INTO `tbl_settings` VALUES ('125','SHOW_ADS_VIEWS','YES');
INSERT INTO `tbl_settings` VALUES ('127','ADD_WATERMARK','YES');
INSERT INTO `tbl_settings` VALUES ('128','WATERMARK_OPACITY','0.7');
INSERT INTO `tbl_settings` VALUES ('129','ADD_THUMB_WATERMARK','NO');
INSERT INTO `tbl_settings` VALUES ('130','SHOW_STICKY_MENU','YES');
INSERT INTO `tbl_settings` VALUES ('134','PARSIAN_PINCODE','');
INSERT INTO `tbl_settings` VALUES ('135','SHOW_PARSIAN_GATEWAY','YES');
INSERT INTO `tbl_settings` VALUES ('136','ENABLE_REFERAL_SYSTEM','YES');
INSERT INTO `tbl_settings` VALUES ('137','COMMISION_RATIO','0.2');
INSERT INTO `tbl_settings` VALUES ('138','SEND_EMAIL_AFTER_WITHDRAWAL_REQUEST','YES');
INSERT INTO `tbl_settings` VALUES ('139','SEND_EMAIL_AFTER_WITHDRAWAL_SETTLEMENT','YES');
INSERT INTO `tbl_settings` VALUES ('140','SHOW_MAIN_SLIDER','NO');
INSERT INTO `tbl_settings` VALUES ('141','EMAIL2','info@site.com');
INSERT INTO `tbl_settings` VALUES ('142','MIN_AFFILIATE_WITHDRAWAL_COST',5000);
INSERT INTO `tbl_settings` VALUES ('147','APPLY_AFFILIATE_ON_BANK_METHOD','YES');
INSERT INTO `tbl_settings` VALUES ('148','CONTENT_ADS_BANNER_CODES','');
INSERT INTO `tbl_settings` VALUES ('149','SIDEBAR_ADS_BANNER_CODES','');
INSERT INTO `tbl_settings` VALUES ('150','FOOTER_MAX_LINKS',6);
INSERT INTO `tbl_settings` VALUES ('151','FOOTER_MAX_POSTS',3);
INSERT INTO `tbl_settings` VALUES ('152','RSS_POSTS_LIMIT',50);
INSERT INTO `tbl_settings` VALUES ('153','SHOW_CREATED_TIME_ON_ADS','YES');
INSERT INTO `tbl_settings` VALUES ('154','CURRENCY',' تومان');
INSERT INTO `tbl_settings` VALUES ('156','MAINTENANCE_COPYRIGHT','طراحی و توسعه توسط <a href=\"http://kodesign.ir\">کدیزاین</a> ');
INSERT INTO `tbl_settings` VALUES ('157','MAINTENANCE_TEXT','<p>با عرض پوزش ، سایت موقتا در دست تعمیر می باشد به زودی با ویژگی های جدید باز می گردیم</p>\r\n');
INSERT INTO `tbl_settings` VALUES ('158','TELL_OTHERS','لطفا در هنگام تماس بگویید که از سایت ما تماس گرفته اید');
INSERT INTO `tbl_settings` VALUES ('159','RULES','متن این قسمت را در بخش تنظیمات اپلیکیشن در قسمت مدیریت سایت تغییر دهید...');
INSERT INTO `tbl_settings` VALUES ('160','TELEGRAM_URL','');
INSERT INTO `tbl_settings` VALUES ('161','GOOGLE_MAP_API_KEY','');
INSERT INTO `tbl_settings` VALUES ('162','ANDROID_APK_URL','');
INSERT INTO `tbl_settings` VALUES ('163','DEFAULT_LONG','51.423055999999974');
INSERT INTO `tbl_settings` VALUES ('164','DEFAULT_LAT','35.696111');
INSERT INTO `tbl_settings` VALUES ('165','APP_PAYMENT_GATEWAY','IdPay');
INSERT INTO `tbl_settings` VALUES ('167','IS_SSL','YES');
INSERT INTO `tbl_settings` VALUES ('168','ADMIN_PANEL_NOT_FILTERED_ADS_COUNT',50);
INSERT INTO `tbl_settings` VALUES ('172','ITEM_COUNTS_IN_SITEMAP',1000);
INSERT INTO `tbl_settings` VALUES ('175','ANDROID_DOWNLOADS_COUNT',0);
INSERT INTO `tbl_settings` VALUES ('176','COUNT_ITEM_VIEW_IN_APPLICATION','YES');
INSERT INTO `tbl_settings` VALUES ('177','APP_TOTAL_NOTIFICATIONS',2);
INSERT INTO `tbl_settings` VALUES ('178','APP_NOTIFICATION_ID_1','');
INSERT INTO `tbl_settings` VALUES ('179','APP_NOTIFICATION_TITLE_1','');
INSERT INTO `tbl_settings` VALUES ('180','APP_NOTIFICATION_MESSAGE_1','');
INSERT INTO `tbl_settings` VALUES ('181','APP_NOTIFICATION_ID_2','');
INSERT INTO `tbl_settings` VALUES ('182','APP_NOTIFICATION_TITLE_2','');
INSERT INTO `tbl_settings` VALUES ('183','APP_NOTIFICATION_MESSAGE_2','');
INSERT INTO `tbl_settings` VALUES ('184','SUBMIT__ENABLE_FULL_ADDRESS_FIELD','NO');
INSERT INTO `tbl_settings` VALUES ('185','SUBMIT__ENABLE_DISCOUNT_FIELD','YES');
INSERT INTO `tbl_settings` VALUES ('186','SUBMIT__ENABLE_LOCATION_PICKER','YES');
INSERT INTO `tbl_settings` VALUES ('187','RECAPTCHA_SITE_KEY','6Ld_uO0pAAAAABwALsiX78b5mqsdVDLOsyr3x7YR');
INSERT INTO `tbl_settings` VALUES ('188','RECAPTCHA_SECRET_KEY','6Ld_uO0pAAAAACIhrr0-QOnHxxTQKpax90UsGe37');
INSERT INTO `tbl_settings` VALUES ('192','IS_DEVELOPMENT','YES');
INSERT INTO `tbl_settings` VALUES ('194','LATEST_APPLICATION_VERSION',1);
INSERT INTO `tbl_settings` VALUES ('195','EDIT_IN_APP_NEEDS_APPROVE','YES');
INSERT INTO `tbl_settings` VALUES ('196','APP_ITEMS_DEFAULT_SORT','LATEST');
INSERT INTO `tbl_settings` VALUES ('197','APP_HAS_TAGS','NO');
INSERT INTO `tbl_settings` VALUES ('198','APP_CAN_ADD_SPECIAL_ADS','YES');
INSERT INTO `tbl_settings` VALUES ('200','IS_LTR','NO');
INSERT INTO `tbl_settings` VALUES ('201','SITE_LANGUAGE_SIGN','fa');
INSERT INTO `tbl_settings` VALUES ('202','SITE_DATE_TYPE','shamsi');
INSERT INTO `tbl_settings` VALUES ('203','REGISTER_BEFORE_SUBMIT','NO');
INSERT INTO `tbl_settings` VALUES ('204','SITE_AUTHOR','https://kodesign.ir');
INSERT INTO `tbl_settings` VALUES ('205','SITE_VERSION','VERSION-9');
INSERT INTO `tbl_settings` VALUES ('206','TELEGRAM_BOT_TOKEN','');
INSERT INTO `tbl_settings` VALUES ('207','TELEGRAM_CHANNEL','');
INSERT INTO `tbl_settings` VALUES ('208','AUTH_TOKEN_RESEND_PERIOD',59);
INSERT INTO `tbl_settings` VALUES ('209','LOCATIONS_SORT_ORDER','ALPHABETIC');
INSERT INTO `tbl_settings` VALUES ('211','POPUP__ENABLE','NO');
INSERT INTO `tbl_settings` VALUES ('212','POPUP__SHOW_PERIOD','SESSION');
INSERT INTO `tbl_settings` VALUES ('213','POPUP__LINK','');
INSERT INTO `tbl_settings` VALUES ('214','POPUP__IMAGE','1617950838.jpg');
INSERT INTO `tbl_settings` VALUES ('215','IMAGES__CROP_MODE','DYNAMIC');
INSERT INTO `tbl_settings` VALUES ('216','APP__ENABLE_AFFILIATE','NO');
INSERT INTO `tbl_settings` VALUES ('217','FULL_DATE_ON_SITEMAP','NO');
INSERT INTO `tbl_settings` VALUES ('218','CAPTCHA_TYPE','GOOGLE_RECAPTCHA');
INSERT INTO `tbl_settings` VALUES ('220','IOS_APK_URL','');
INSERT INTO `tbl_settings` VALUES ('221','LATEST_APPLICATION_VERSION_IOS',1);
INSERT INTO `tbl_settings` VALUES ('223','RANDOM_CODE_TYPE','NUMERIC');
INSERT INTO `tbl_settings` VALUES ('224','MAP__SOURCE','NESHAN');
INSERT INTO `tbl_settings` VALUES ('225','MAP__CEDAR_API_TOKEN','');
INSERT INTO `tbl_settings` VALUES ('226','APP__ENABLE_MAP','YES');
INSERT INTO `tbl_settings` VALUES ('227','APP__ENABLE_SLIDER','NO');
INSERT INTO `tbl_settings` VALUES ('228','CARBON_DATE','2017-02-05');
INSERT INTO `tbl_settings` VALUES ('229','SMS__ENABLE_UNIQUE_SEND','YES');
INSERT INTO `tbl_settings` VALUES ('230','SMS__UNIQUE_API_KEY','');
INSERT INTO `tbl_settings` VALUES ('231','SMS__UNIQUE_SECRET_KEY','');
INSERT INTO `tbl_settings` VALUES ('232','SMS__UNIQUE_URL','');
INSERT INTO `tbl_settings` VALUES ('233','SMS_TEMPLATE_ID__REGISTER_CONFIRM','');
INSERT INTO `tbl_settings` VALUES ('234','SMS_TEMPLATE_ID__FORGOT_PASSWORD','');
INSERT INTO `tbl_settings` VALUES ('235','SMS_TEMPLATE_ID__ACTIVATION_WITH_PASSWORD','');
INSERT INTO `tbl_settings` VALUES ('236','SMS_TEMPLATE_ID__WELCOME','');
INSERT INTO `tbl_settings` VALUES ('237','ADS_LIST__SHOW_PRICE','YES');
INSERT INTO `tbl_settings` VALUES ('238','IS_MULTILINGUAL','NO');
INSERT INTO `tbl_settings` VALUES ('239','MULTILINGUAL_LANGUAGES','{\"fa\":\"kodesign.ir\",\"en\":\"en.kodesign.ir\"}');
INSERT INTO `tbl_settings` VALUES ('240','SITE__REMEMBER_LOCATION','NO');
INSERT INTO `tbl_settings` VALUES ('241','ENABLE_PAYPAL','NO');
INSERT INTO `tbl_settings` VALUES ('242','SHOW_PAYPAL_GATEWAY','NO');
INSERT INTO `tbl_settings` VALUES ('243','PAYPAL__CLIENT_ID','');
INSERT INTO `tbl_settings` VALUES ('244','PAYPAL__CLIENT_SECRET','');
INSERT INTO `tbl_settings` VALUES ('245','PAYPAL__CURRENCY','EUR');
INSERT INTO `tbl_settings` VALUES ('246','PAYPAL__SANDBOX','YES');
INSERT INTO `tbl_settings` VALUES ('247','BLOG__ORDER','DATE_CREATED');
INSERT INTO `tbl_settings` VALUES ('248','CURRENCY_EXHIBITIVE',' تومان');
INSERT INTO `tbl_settings` VALUES ('249','MAP__NESHAN_API_TOKEN','');
INSERT INTO `tbl_settings` VALUES ('250','MAP__NESHAN_SERVICES_TOKEN','');
INSERT INTO `tbl_settings` VALUES ('251','VITRIN_ITEMS_COUNT',6);
INSERT INTO `tbl_settings` VALUES ('252','FOOTER_CUSTOM_CODE','');
INSERT INTO `tbl_settings` VALUES ('253','ENABLE_SUPPORT_FUNCTIONALITY','YES');
INSERT INTO `tbl_settings` VALUES ('254','SUPPORT_START_DATE','2021-10-14 18:05:36');
INSERT INTO `tbl_settings` VALUES ('255','SUPPORT_END_DATE','2022-04-14 18:05:36');
INSERT INTO `tbl_settings` VALUES ('256','APP__ENABLE_VITRIN','YES');
INSERT INTO `tbl_settings` VALUES ('257','APP__SAFETY_PURCHASE','متن این بخش را در  تنظیمات اپلیکیشن در قسمت مدیریت سایت تغییر دهید');
INSERT INTO `tbl_settings` VALUES ('258','SUPPORT__PURCHASE_CODE','');
INSERT INTO `tbl_settings` VALUES ('259','PAGINATION__TYPE','FULL');
INSERT INTO `tbl_settings` VALUES ('260','PAGINATION__SIMPLE_EXTRA_INFO','YES');
INSERT INTO `tbl_settings` VALUES ('266','TEMPLATE__SEARCH_BACKGROUND_IMAGE','search-background.png');
INSERT INTO `tbl_settings` VALUES ('267','IDPAY__API_KEY','');
INSERT INTO `tbl_settings` VALUES ('268','SHOW_IDPAY_GATEWAY','YES');
UNLOCK TABLES;

-- Table structure for table `tbl_sms_box`

DROP TABLE IF EXISTS `tbl_sms_box`;
CREATE TABLE `tbl_sms_box` (
  `ID` int NOT NULL AUTO_INCREMENT,
  `USER_ID` int DEFAULT NULL,
  `TITLE` text,
  `SENDER_NAME` varchar(150) DEFAULT NULL,
  `SENDER_NUMBER` varchar(50) DEFAULT NULL,
  `RECIVER_NUMBER` text,
  `RECIVER_USER_ID` varchar(150) DEFAULT NULL,
  `FROM` enum('ADMIN','USER','AUTO') NOT NULL DEFAULT 'ADMIN',
  `TO` enum('ADMIN','USER') NOT NULL DEFAULT 'USER',
  `REPLY_TO` int DEFAULT NULL,
  `MESSAGE` text,
  `RES_ID` text,
  `DATE_CREATED` datetime NOT NULL,
  `USERS_VIEWED` text,
  PRIMARY KEY (`ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

-- Dumping data for table `tbl_sms_box`

LOCK TABLES `tbl_sms_box` WRITE;
UNLOCK TABLES;

-- Table structure for table `tbl_specials`

DROP TABLE IF EXISTS `tbl_specials`;
CREATE TABLE `tbl_specials` (
  `ID` bigint NOT NULL AUTO_INCREMENT,
  `ADS_ID` bigint unsigned NOT NULL,
  `ADS_TYPE` smallint DEFAULT NULL,
  `FROM_DATE` datetime DEFAULT NULL,
  `FROM_UPDATED_DATE` datetime NOT NULL,
  `UPDATE_COUNT` mediumint NOT NULL DEFAULT '0',
  `TO_DATE` datetime DEFAULT NULL,
  `IS_PAID` tinyint DEFAULT '1',
  `IS_SHOWN` tinyint NOT NULL DEFAULT '1',
  `FIRST_EXPIRE_EMAIL` tinyint DEFAULT '1',
  `SECOND_EXPIRE_EMAIL` tinyint DEFAULT '1',
  `THIRD_EXPIRE_EMAIL` tinyint DEFAULT '1',
  `IS_REJECTED` smallint NOT NULL DEFAULT '1',
  `IS_EXPIRED` smallint NOT NULL DEFAULT '1',
  PRIMARY KEY (`ID`),
  KEY `IS_SHOWN` (`IS_SHOWN`),
  KEY `ADS_ID` (`ADS_ID`),
  KEY `ADS_TYPE` (`ADS_TYPE`),
  KEY `IS_EXPIRED` (`IS_EXPIRED`),
  CONSTRAINT `tbl_specials_ibfk_1` FOREIGN KEY (`ADS_ID`) REFERENCES `tbl_ads` (`ID`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb3;

-- Dumping data for table `tbl_specials`

LOCK TABLES `tbl_specials` WRITE;
INSERT INTO `tbl_specials` VALUES ('1','1','4','2024-05-31 00:57:33','2024-05-31 00:32:01','1','2024-06-30 00:57:33','2','2','1','1','1','1','1');
UNLOCK TABLES;

-- Table structure for table `tbl_states`

DROP TABLE IF EXISTS `tbl_states`;
CREATE TABLE `tbl_states` (
  `ID` int NOT NULL AUTO_INCREMENT,
  `STATE_NAME` varchar(255) NOT NULL,
  `SLUG` varchar(255) DEFAULT NULL,
  `STATE_ID` int DEFAULT '0',
  `IS_COUNTRY` tinyint(1) NOT NULL DEFAULT '1',
  `latitude` varchar(200) DEFAULT NULL,
  `longitude` varchar(200) DEFAULT NULL,
  PRIMARY KEY (`ID`),
  KEY `SLUG` (`SLUG`)
) ENGINE=InnoDB AUTO_INCREMENT=32 DEFAULT CHARSET=utf8mb3;

-- Dumping data for table `tbl_states`

LOCK TABLES `tbl_states` WRITE;
INSERT INTO `tbl_states` VALUES ('1','آذربایجان شرقی','آذربایجان-شرقی','0','1','37.9035733','46.268210899999985');
INSERT INTO `tbl_states` VALUES ('2','آذربایجان غربی','آذربایجان-غربی','0','1','37.45500619999999',45);
INSERT INTO `tbl_states` VALUES ('3','اردبیل','اردبیل','0','1','38.4853276','47.89112090000003');
INSERT INTO `tbl_states` VALUES ('4','اصفهان','اصفهان','0','1','33.2771073','52.3613378');
INSERT INTO `tbl_states` VALUES ('5','البرز','البرز','0','1','35.9960467','50.92892459999996');
INSERT INTO `tbl_states` VALUES ('6','ایلام','ایلام','0','1','33.6349736','46.41528100000005');
INSERT INTO `tbl_states` VALUES ('7','بوشهر','بوشهر','0','1','28.9233837','50.82031400000005');
INSERT INTO `tbl_states` VALUES ('8','تهران','تهران','0','1','35.7248416','51.38165300000003');
INSERT INTO `tbl_states` VALUES ('9','چهار محال و بختیاری','چهار-محال-و-بختیاری','0','1','31.9970419','50.66138490000003');
INSERT INTO `tbl_states` VALUES ('10','خراسان جنوبی','خراسان-جنوبی','0','1','32.5175643','59.10417580000001');
INSERT INTO `tbl_states` VALUES ('11','خراسان رضوی','خراسان-رضوی','0','1','35.1020253','59.10417580000001');
INSERT INTO `tbl_states` VALUES ('12','خراسان شمالی','خراسان-شمالی','0','1','37.4710353','57.101318799999945');
INSERT INTO `tbl_states` VALUES ('13','خوزستان','خوزستان','0','1','31.4360149','49.04131200000006');
INSERT INTO `tbl_states` VALUES ('14','زنجان','زنجان','0','1','36.6830045','48.50872090000007');
INSERT INTO `tbl_states` VALUES ('15','سمنان','سمنان','0','1','35.578797','53.37981079999997');
INSERT INTO `tbl_states` VALUES ('16','سیستان و بلوچستان','سیستان-و-بلوچستان','0','1','27.52999059999999','60.58206759999996');
INSERT INTO `tbl_states` VALUES ('17','فارس ','فارس','0','1','35.6891975','51.388973599999986');
INSERT INTO `tbl_states` VALUES ('18','قزوین','قزوین','0','1','36.2736589','49.99823600000002');
INSERT INTO `tbl_states` VALUES ('19','قم','قم','0','1','34.6399443','50.87594190000004');
INSERT INTO `tbl_states` VALUES ('20','کردستان','کردستان','0','1','35.9553579','47.136212500000056');
INSERT INTO `tbl_states` VALUES ('21','کرمان','کرمان','0','1','30.28393789999999','57.08336280000003');
INSERT INTO `tbl_states` VALUES ('22','کرمانشاه','کرمانشاه','0','1','34.3276924','47.07776850000005');
INSERT INTO `tbl_states` VALUES ('23','کهکیلویه و بویراحمد','کهکیلویه-و-بویراحمد','0','1','30.724586','50.845632300000034');
INSERT INTO `tbl_states` VALUES ('24','گلستان','گلستان','0','1','37.2898123','55.13758340000004');
INSERT INTO `tbl_states` VALUES ('25','گیلان','گیلان','0','1','37.2809455','49.59241339999994');
INSERT INTO `tbl_states` VALUES ('26','لرستان','لرستان','0','1','33.58183939999999','48.39881860000003');
INSERT INTO `tbl_states` VALUES ('27','مازندران','مازندران','0','1','36.2262393','52.53186040000003');
INSERT INTO `tbl_states` VALUES ('28','مرکزی','مرکزی','0','1','34.612305','49.85472660000005');
INSERT INTO `tbl_states` VALUES ('29','هرمزگان','هرمزگان','0','1','27.138723','55.13758340000004');
INSERT INTO `tbl_states` VALUES ('30','همدان','همدان','0','1','34.7988575','48.515022499999986');
INSERT INTO `tbl_states` VALUES ('31','یزد','یزد','0','1','31.8974232','54.35685620000004');
UNLOCK TABLES;

-- Table structure for table `tbl_stats`

DROP TABLE IF EXISTS `tbl_stats`;
CREATE TABLE `tbl_stats` (
  `ID` int NOT NULL AUTO_INCREMENT,
  `DATE` varchar(40) NOT NULL,
  `HITS` int NOT NULL,
  `UNIQUE_HITS` int NOT NULL,
  `SHAMSI_DATE` varchar(40) DEFAULT NULL,
  PRIMARY KEY (`ID`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb3;

-- Dumping data for table `tbl_stats`

LOCK TABLES `tbl_stats` WRITE;
INSERT INTO `tbl_stats` VALUES ('1','2024-05-30','39','34','1403-03-10');
INSERT INTO `tbl_stats` VALUES ('2','2024-05-31','17','16','1403-03-11');
UNLOCK TABLES;

-- Table structure for table `tbl_subcategories`

DROP TABLE IF EXISTS `tbl_subcategories`;
CREATE TABLE `tbl_subcategories` (
  `ID` int NOT NULL AUTO_INCREMENT,
  `SUBCATEGORY_NAME` varchar(255) CHARACTER SET utf8mb3 COLLATE utf8mb3_persian_ci NOT NULL,
  `SUBCATEGORY_SLUG` varchar(255) NOT NULL,
  `CATEGORY_ID` int NOT NULL,
  `PARENT` int DEFAULT '0',
  `SUBCATEGORY_DESCRIPTION` text,
  `SUBCATEGORY_KEYWORDS` text,
  `SUBCATEGORY_EXTRA_DESCRIPTION` text,
  `ICON` varchar(50) DEFAULT NULL,
  `ICON_APP` varchar(50) DEFAULT NULL,
  `image` text,
  `COLOR` varchar(20) DEFAULT NULL,
  `rang` int NOT NULL DEFAULT '0',
  `enable` tinyint(1) NOT NULL DEFAULT '1',
  `SUBCATEGORY_SEO_TITLE` varchar(255) DEFAULT NULL,
  PRIMARY KEY (`ID`),
  KEY `CATEGORY_ID` (`CATEGORY_ID`),
  KEY `SUBCATEGORY_SLUG` (`SUBCATEGORY_SLUG`)
) ENGINE=InnoDB AUTO_INCREMENT=205 DEFAULT CHARSET=utf8mb3;

-- Dumping data for table `tbl_subcategories`

LOCK TABLES `tbl_subcategories` WRITE;
INSERT INTO `tbl_subcategories` VALUES ('1','خدمات املاک','خدمات-املاک','1','0','','','','','','5a4a72e33f32f1514828510.png','e74d3c','5','1',NULL);
INSERT INTO `tbl_subcategories` VALUES ('2','آژانس املاک','آژانس-املاک','1','1','','','','','','5a4a73bdb54861514828729.png','e74d3c','0','1',NULL);
INSERT INTO `tbl_subcategories` VALUES ('3','مشارکت در ساخت','مشارکت-در-ساخت','1','1','','','','','','5a4a740b2ae991514828808.png','e74d3c','0','1',NULL);
INSERT INTO `tbl_subcategories` VALUES ('4','امور مالی و حقوقی','امور-مالی-و-حقوقی','1','1','','','','','','5a4a751522c411514829074.png','e74d3c','0','1',NULL);
INSERT INTO `tbl_subcategories` VALUES ('5','پیش فروش','پیش-فروش','1','1','','','','','','5a4a7539627be1514829107.png','e74d3c','0','1',NULL);
INSERT INTO `tbl_subcategories` VALUES ('6','متفرقه','متفرقه-1-2-3','1','1','','','','','','5a4a7577b1b251514829173.png','e74d3c','0','1',NULL);
INSERT INTO `tbl_subcategories` VALUES ('7','فروش مسکونی','فروش-مسکونی','1','0','','','','','','5a4a789d299be1514829978.png','e74d3c','1','1',NULL);
INSERT INTO `tbl_subcategories` VALUES ('8','آپارتمان','آپارتمان-1','1','7','','','','','','5a4b905943a4c1514901591.png','e74d3c','0','1',NULL);
INSERT INTO `tbl_subcategories` VALUES ('9','خانه و ویلا','خانه-و-ویلا-1','1','7','','','','','','5a4b8f65525851514901347.png','e74d3c','0','1',NULL);
INSERT INTO `tbl_subcategories` VALUES ('10','زمین و کلنگی','زمین-و-کلنگی','1','7','','','','','','5a4b8eb7a98081514901172.png','e74d3c','0','1',NULL);
INSERT INTO `tbl_subcategories` VALUES ('11','متفرقه','متفرقه-1-2-3-4','1','7','','','','','','5a4b901c2ee2f1514901530.png','e74d3c','0','1',NULL);
INSERT INTO `tbl_subcategories` VALUES ('12','اجاره مسکونی','اجاره-مسکونی','1','0','','','','','','5a4a78a6abdf11514829988.png','e74d3c','2','1',NULL);
INSERT INTO `tbl_subcategories` VALUES ('13','آپارتمان','آپارتمان','1','12','','','','','','5a4b91db5e6fa1514901977.png','e74d3c','0','1',NULL);
INSERT INTO `tbl_subcategories` VALUES ('14','خانه و ویلا','خانه-و-ویلا','1','12','','','','','','5a4b92293864b1514902053.png','e74d3c','0','1',NULL);
INSERT INTO `tbl_subcategories` VALUES ('15','متفرقه','متفرقه-1-2-3-4-5','1','12','','','','','','5a4b925c7a5161514902106.png','e74d3c','0','1',NULL);
INSERT INTO `tbl_subcategories` VALUES ('16','فروش اداری و تجاری','فروش-اداری-و-تجاری','1','0','','','','','','5a4a71c9c49821514828230.png','e74d3c','3','1',NULL);
INSERT INTO `tbl_subcategories` VALUES ('17','دفترکار،اتاق اداری و مطب','دفترکاراتاق-اداری-و-مطب-1','1','16','','','','','','5a4b93811aa9e1514902399.png','e74d3c','0','1',NULL);
INSERT INTO `tbl_subcategories` VALUES ('18','مغازه و غرفه','مغازه-و-غرفه-1','1','16','','','','','','5a4b939a22c0f1514902424.png','e74d3c','0','1',NULL);
INSERT INTO `tbl_subcategories` VALUES ('19','صنعتی، کشاورزی و تجاری','صنعتی-کشاورزی-و-تجاری-1','1','16','','','','','','5a4b9390ba9341514902414.png','e74d3c','0','1',NULL);
INSERT INTO `tbl_subcategories` VALUES ('20','اجاره اداری و تجاری','اجاره-اداری-و-تجاری','1','0','','','','','','5a4a71d4c90ed1514828239.png','e74d3c','4','1',NULL);
INSERT INTO `tbl_subcategories` VALUES ('21','دفترکار،اتاق اداری و مطب','دفترکاراتاق-اداری-و-مطب','1','20','','','','','','5a4b93d8926ed1514902487.png','e74d3c','0','1',NULL);
INSERT INTO `tbl_subcategories` VALUES ('22','مغازه و غرفه','مغازه-و-غرفه','1','20','','','','','','5a4b93cfd6a551514902478.png','e74d3c','0','1',NULL);
INSERT INTO `tbl_subcategories` VALUES ('23','صنعتی، کشاورزی و تجاری','صنعتی-کشاورزی-و-تجاری','1','20','','','','','','5a4b93e3001f11514902497.png','e74d3c','0','1',NULL);
INSERT INTO `tbl_subcategories` VALUES ('24','متفرقه','متفرقه-1-2-3-4-5-6','1','20','','','','','','5a4b9434f1fb51514902579.png','e74d3c','0','1',NULL);
INSERT INTO `tbl_subcategories` VALUES ('25','متفرقه','متفرقه-1-2','1','0','','','','','','5a4a73438d7201514828593.png','e74d3c','6','1',NULL);
INSERT INTO `tbl_subcategories` VALUES ('26','خودرو','خودرو','2','0','','','','','','5a4b9766a97231514903394.png','F1C40F','1','1','');
INSERT INTO `tbl_subcategories` VALUES ('27','سواری','سواری','2','26','','','<p>این یک تست دیگر است</p>\r\n','','','5a4b996adde8d1514903913.png','F1C40F','0','1','');
INSERT INTO `tbl_subcategories` VALUES ('28','سنگین','سنگین','2','26','','','','','','5a4b9958c45731514903893.png','F1C40F','0','1',NULL);
INSERT INTO `tbl_subcategories` VALUES ('29','متفرقه','متفرقه-1-2-3-4-5-6-7-8','2','26','','','','','','5a4b997864daa1514903926.png','f1c40f','0','1',NULL);
INSERT INTO `tbl_subcategories` VALUES ('30','قطعات یدکی و لوازم جانبی','قطعات-یدکی-و-لوازم-جانبی','2','0','','','','','','5a4b97d36914a1514903506.png','f1c40f','2','1',NULL);
INSERT INTO `tbl_subcategories` VALUES ('31','قایق و لوازم جانبی','قایق-و-لوازم-جانبی','2','0','','','','','','5a4b975a6c5fc1514903384.png','f1c40f','3','1',NULL);
INSERT INTO `tbl_subcategories` VALUES ('32','موتورسیکلت و لوازم جانبی','موتورسیکلت-و-لوازم-جانبی','2','0','','','','','','5a4b978818b981514903430.png','f1c40f','4','1',NULL);
INSERT INTO `tbl_subcategories` VALUES ('33','متفرقه','متفرقه-1-2-3-4-5-6-7','2','0','','','','','','5a4b973a3e31f1514903352.png','f1c40f','5','1',NULL);
INSERT INTO `tbl_subcategories` VALUES ('34','اداری و مدیریت','اداری-و-مدیریت','3','0','','','','','','5a4cab38108761514974006.png','0078c1','1','1',NULL);
INSERT INTO `tbl_subcategories` VALUES ('35','معماری و ساختمانی','معماری-و-ساختمانی','3','0','','','','','','5a4cabcc2f1cb1514974155.png','0078c1','2','1',NULL);
INSERT INTO `tbl_subcategories` VALUES ('36','رایانه و فناوری اطلاعات','رایانه-و-فناوری-اطلاعات','3','0','','','','','','5a4cab6f5ecdd1514974061.png','0078c1','3','1',NULL);
INSERT INTO `tbl_subcategories` VALUES ('37','مالی و حسابداری و حقوقی','مالی-و-حسابداری-و-حقوقی','3','0','','','','','','5a4cab913cda81514974095.png','0078c1','4','1',NULL);
INSERT INTO `tbl_subcategories` VALUES ('38','بازایابی و فروش','بازایابی-و-فروش','3','0','','','','','','5a4cab4121cb71514974015.png','0078c1','5','1',NULL);
INSERT INTO `tbl_subcategories` VALUES ('39','صنعتی و فنی و مهندسی','صنعتی-و-فنی-و-مهندسی','3','0','','','','','','5a4cab8a5a3761514974088.png','0078c1','6','1',NULL);
INSERT INTO `tbl_subcategories` VALUES ('40','آموزشی','آموزشی','3','0','','','','','','5a4cab29ef1471514973992.png','0078c1','7','1',NULL);
INSERT INTO `tbl_subcategories` VALUES ('41','حمل و نقل','حمل-و-نقل','3','0','','','','','','5a4cab535c52c1514974033.png','0078c1','8','1',NULL);
INSERT INTO `tbl_subcategories` VALUES ('42','درمانی و زیبایی','درمانی-و-زیبایی','3','0','','','','','','5a4cab62db7a41514974049.png','0078c1','9','1',NULL);
INSERT INTO `tbl_subcategories` VALUES ('43','هنری و رسانه','هنری-و-رسانه','3','0','','','','','','5a4caaffdf6fa1514973950.png','0078c1','10','1',NULL);
INSERT INTO `tbl_subcategories` VALUES ('44','خدمات فروشگاه و رستوران','خدمات-فروشگاه-و-رستوران','3','0','','','','','','5a4cab5a546e21514974040.png','0078c1','11','1',NULL);
INSERT INTO `tbl_subcategories` VALUES ('45','سرایداری و نظافت','سرایداری-و-نظافت','3','0','','','','','','5a4cab81936b71514974080.png','0078c1','12','1',NULL);
INSERT INTO `tbl_subcategories` VALUES ('46','متفرقه','متفرقه','3','0','','','','','','5a4cab9a4c9b51514974105.png','0078c1','13','1',NULL);
INSERT INTO `tbl_subcategories` VALUES ('47','ساختمان و حیاط','ساختمان-و-حیاط','4','0','','','','','','5a4c96fa4e60a1514968824.png','31bf31','3','1',NULL);
INSERT INTO `tbl_subcategories` VALUES ('48','سرویس بهداشتی و سونا','سرویس-بهداشتی-و-سونا','4','47','','','','','','5a4c998b9791e1514969482.png','31bf31','0','1',NULL);
INSERT INTO `tbl_subcategories` VALUES ('49','سیستم گرمایشی سرمایشی و گاز','سیستم-گرمایشی-سرمایشی-و-گاز','4','47','','','','','','5a4c9991971f31514969488.png','31bf31','0','1',NULL);
INSERT INTO `tbl_subcategories` VALUES ('50','آشپزخانه','آشپزخانه','4','47','','','','','','5a4c997009e9c1514969454.png','31bf31','0','1',NULL);
INSERT INTO `tbl_subcategories` VALUES ('51','حیاط و ایوان','حیاط-و-ایوان','4','47','','','','','','5a4c998458ad31514969474.png','31bf31','0','1',NULL);
INSERT INTO `tbl_subcategories` VALUES ('52','ابزار باغبانی','ابزار-باغبانی','4','47','','','','','','5a4c997aa132a1514969464.png','31bf31','0','1',NULL);
INSERT INTO `tbl_subcategories` VALUES ('53','متفرقه','متفرقه-1-2-3-4-5-6-7-8-9-10-11-12-13-14-15-16-17-18-19-20-21-22-23','4','47','','','','','','5a4c9999cd9441514969496.png','31bf31','0','1',NULL);
INSERT INTO `tbl_subcategories` VALUES ('54','وسایل و تزئینات خانه','وسایل-و-تزیینات-خانه','4','0','','','','','','5a4c96eb9a6bc1514968800.png','31bf31','1','1',NULL);
INSERT INTO `tbl_subcategories` VALUES ('55','تزئینی و آثار هنری','تزیینی-و-آثار-هنری','4','54','','','','','','5a4c9b809424b1514969983.png','31bf31','0','1',NULL);
INSERT INTO `tbl_subcategories` VALUES ('56','لوازم روشنایی','لوازم-روشنایی','4','54','','','','','','5a4c9b33c2a201514969905.png','31bf31','0','1',NULL);
INSERT INTO `tbl_subcategories` VALUES ('57','میز و صندلی','میز-و-صندلی','4','54','','','','','','5a4c9b465f3ce1514969923.png','31bf31','0','1',NULL);
INSERT INTO `tbl_subcategories` VALUES ('58','فرش و گلیم','فرش-و-گلیم','4','54','','','','','','5a4c9b2b6691a1514969897.png','31bf31','0','1',NULL);
INSERT INTO `tbl_subcategories` VALUES ('59','کمد و بوفه','کمد-و-بوفه','4','54','','','','','','5a4c9cf7207cf1514970357.png','31bf31','0','1',NULL);
INSERT INTO `tbl_subcategories` VALUES ('60','پرده و رومیزی','پرده-و-رومیزی','4','54','','','','','','5a4c9ce75f1c21514970342.png','31bf31','0','1',NULL);
INSERT INTO `tbl_subcategories` VALUES ('61','تخت و اتاق خواب','تخت-و-اتاق-خواب','4','54','','','','','','5a4c9ceeb4e111514970349.png','31bf31','0','1',NULL);
INSERT INTO `tbl_subcategories` VALUES ('62','مبلمان و صندلی راحتی','مبلمان-و-صندلی-راحتی','4','54','','','','','','5a4c9cfd9d1b71514970364.png','31bf31','0','1',NULL);
INSERT INTO `tbl_subcategories` VALUES ('63','میزتلویزیون و وسایل سیستم پخش','میزتلویزیون-و-وسایل-سیستم-پخش','4','54','','','','','','5a4c9cda8dd7e1514970328.png','31bf31','0','1',NULL);
INSERT INTO `tbl_subcategories` VALUES ('64','متفرقه','متفرقه-1-2-3-4-5-6-7-8-9-10-11-12-13-14-15-16-17-18-19-20-21-22-23-24','4','54','','','','','','5a4c9d09ed75f1514970376.png','31bf31','0','1',NULL);
INSERT INTO `tbl_subcategories` VALUES ('65','وسایل آشپزخانه','وسایل-آشپزخانه','4','0','','','','','','5a4c96ffdbd721514968830.png','31bf31','2','1',NULL);
INSERT INTO `tbl_subcategories` VALUES ('66','ماشین ظرفشویی','ماشین-ظرفشویی','4','65','','','','','','5a4c9e3a35b281514970680.png','31bf31','0','1',NULL);
INSERT INTO `tbl_subcategories` VALUES ('67','یخچال و فریزر','یخچال-و-فریزر','4','65','','','','','','5a4c9e77669251514970742.png','31bf31','0','1',NULL);
INSERT INTO `tbl_subcategories` VALUES ('68','وسایل آشپزی و غذاخوری','وسایل-آشپزی-و-غذاخوری','4','65','','','','','','5a4c9e3327a161514970672.png','31bf31','0','1',NULL);
INSERT INTO `tbl_subcategories` VALUES ('69','مایکروویو و گاز','مایکروویو-و-گاز','4','65','','','','','','5a4c9e4b47a491514970697.png','31bf31','0','1',NULL);
INSERT INTO `tbl_subcategories` VALUES ('70','ماشین لباسشویی و خشک کننده','ماشین-لباسشویی-و-خشک-کننده','4','65','','','','','','5a4c9e428f90a1514970689.png','31bf31','0','1',NULL);
INSERT INTO `tbl_subcategories` VALUES ('71','متفرقه','متفرقه-1-2-3-4-5-6-7-8-9-10-11-12-13-14-15-16-17-18-19-20-21-22-23-24-25','4','65','','','','','','5a4c9e52b4dca1514970705.png','31bf31','0','1',NULL);
INSERT INTO `tbl_subcategories` VALUES ('72','ابزار','ابزار','4','0','','','','','','5a4c96f35b7ba1514968817.png','31bf31','4','1',NULL);
INSERT INTO `tbl_subcategories` VALUES ('73','نظافت و خیاطی و اتو','نظافت-و-خیاطی-و-اتو','4','72','','','','','','5a4c9efc462d41514970874.png','31bf31','0','1',NULL);
INSERT INTO `tbl_subcategories` VALUES ('74','تعمیرات','تعمیرات','4','72','','','','','','5a4c9f09438a81514970887.png','31bf31','0','1',NULL);
INSERT INTO `tbl_subcategories` VALUES ('75','متفرقه','متفرقه-1-2-3-4-5-6-7-8-9-10-11-12-13-14-15-16-17-18-19-20-21-22-23-24-25-26','4','72','','','','','','5a4c9f0faeb771514970894.png','31bf31','0','1',NULL);
INSERT INTO `tbl_subcategories` VALUES ('76','موتور و ماشین','موتور-و-ماشین','5','0','','','','','','5a4ca4530e4d01514972241.png','0078C1','1','1',NULL);
INSERT INTO `tbl_subcategories` VALUES ('77','پذیرایی/مراسم','پذیراییمراسم','5','0','','','','','','5a4ca435951cd1514972212.png','0078c1','5','1',NULL);
INSERT INTO `tbl_subcategories` VALUES ('78','خدمات رایانه ای و موبایل','خدمات-رایانه-ای-و-موبایل','5','0','','','','','','5a4ca44c704e01514972233.png','0078c1','2','1',NULL);
INSERT INTO `tbl_subcategories` VALUES ('79','فروش دامنه و سایت','فروش-دامنه-و-سایت','5','78','','','','','','5a4ca466ed2ec1514972260.png','0078c1','0','1',NULL);
INSERT INTO `tbl_subcategories` VALUES ('80','خدمات پهنای باند اینترنت','خدمات-پهنای-باند-اینترنت','5','78','','','','','','5a4ca47d4b3461514972284.png','0078c1','0','1',NULL);
INSERT INTO `tbl_subcategories` VALUES ('81','خدمات نرم افزار و سخت افزار','خدمات-نرم-افزار-و-سخت-افزار','5','78','','','','','','5a4ca47638a671514972276.png','0078c1','0','1',NULL);
INSERT INTO `tbl_subcategories` VALUES ('82','تعمیرات نرم افزار و سخت افزار گوشی موبایل','تعمیرات-نرم-افزار-و-سخت-افزار-گوشی-موبایل','5','78','','','','','','5a4ca4859f18e1514972292.png','0078c1','0','1',NULL);
INSERT INTO `tbl_subcategories` VALUES ('83','مالی/حسابداری/بیمه','مالیحسابداریبیمه','5','0','','','','','','5a4ca6b1ef7061514972848.png','0078c1','6','1',NULL);
INSERT INTO `tbl_subcategories` VALUES ('84','حمل و نقل','حمل-و-نقل-1','5','0','','','','','','5a4ca6c6995cd1514972869.png','0078c1','3','1',NULL);
INSERT INTO `tbl_subcategories` VALUES ('85','پیشه و مهارت','پیشه-و-مهارت','5','0','','','','','','5a4ca6cdd9aee1514972876.png','0078c1','7','1',NULL);
INSERT INTO `tbl_subcategories` VALUES ('86','آرایشگری و زیبایی','آرایشگری-و-زیبایی','5','0','','','','','','5a4ca6e673da31514972900.png','0078c1','8','1',NULL);
INSERT INTO `tbl_subcategories` VALUES ('87','سرگرمی','سرگرمی','5','0','','','','','','5a4ca6ba952df1514972857.png','0078c1','9','1',NULL);
INSERT INTO `tbl_subcategories` VALUES ('88','نظافت','نظافت','5','0','','','','','','5a4ca6a39d4bc1514972834.png','0078c1','10','1',NULL);
INSERT INTO `tbl_subcategories` VALUES ('89','باغبانی و درختکاری','باغبانی-و-درختکاری','5','0','','','','','','5a4ca6d4205b51514972882.png','0078c1','11','1',NULL);
INSERT INTO `tbl_subcategories` VALUES ('90','آموزشی','آموزشی-1-2','5','0','','','','','','5a4ca6df9c9ed1514972894.png','0078C1','4','1',NULL);
INSERT INTO `tbl_subcategories` VALUES ('91','زبان خارجی','زبان-خارجی','5','90','','','','','','5a4ca84577c4f1514973252.png','0078c1','0','1',NULL);
INSERT INTO `tbl_subcategories` VALUES ('92','دروس مدرسه و دانشگاه','دروس-مدرسه-و-دانشگاه','5','90','','','','','','5a4ca83c9cfc11514973243.png','0078c1','0','1',NULL);
INSERT INTO `tbl_subcategories` VALUES ('93','نرم افزار','نرم-افزار','5','90','','','','','','5a4ca85bb9c5a1514973274.png','0078c1','0','1',NULL);
INSERT INTO `tbl_subcategories` VALUES ('94','هنری','هنری','5','90','','','','','','5a4ca8361bf0b1514973236.png','0078c1','0','1',NULL);
INSERT INTO `tbl_subcategories` VALUES ('95','ورزشی','ورزشی','5','90','','','','','','5a4ca863d36db1514973282.png','0078c1','0','1',NULL);
INSERT INTO `tbl_subcategories` VALUES ('96','مشاوره تحصیلی','مشاوره-تحصیلی','5','90','','','','','','5a4ca8560299d1514973268.png','0078c1','0','1',NULL);
INSERT INTO `tbl_subcategories` VALUES ('97','متفرقه','متفرقه-1-2-3-4-5-6-7-8-9-10-11-12-13-14-15-16-17-18-19-20-21-22-23-24-25-26-27-28-29','5','90','','','','','','5a4ca84b77f481514973258.png','0078c1','0','1',NULL);
INSERT INTO `tbl_subcategories` VALUES ('98','کیف، کفش، لباس','کیف-کفش-لباس','6','0','','','','','','5a4ba595870451514907028.png','14b8cf','1','1',NULL);
INSERT INTO `tbl_subcategories` VALUES ('99','کیف/کفش/کمربند','کیف-کفش-کمربند','6','98','','','','','','5a4ba583a8c2f1514907010.png','14b8cf','0','1',NULL);
INSERT INTO `tbl_subcategories` VALUES ('100','لباس','لباس','6','98','','','','','','5a4ba55fc84c01514906974.png','14b8cf','0','1',NULL);
INSERT INTO `tbl_subcategories` VALUES ('101','متفرقه','متفرقه-1-2-3-4-5-6-7-8-9-10','6','98','','','','','','5a4ba5d5648721514907091.png','14b8cf','0','1',NULL);
INSERT INTO `tbl_subcategories` VALUES ('102','تزئینی','تزیینی','6','0','','','','','','5a4ba2ed625eb1514906347.png','14b8cf','3','1',NULL);
INSERT INTO `tbl_subcategories` VALUES ('103','ساعت','ساعت','6','102','','','','','','5a4ba6cedcdfe1514907341.png','14b8cf','0','1',NULL);
INSERT INTO `tbl_subcategories` VALUES ('104','جواهرات','جواهرات','6','102','','','','','','5a4ba6deaa3861514907357.png','14b8cf','0','1',NULL);
INSERT INTO `tbl_subcategories` VALUES ('105','بدلیجات','بدلیجات','6','102','','','','','','5a4ba7058f54a1514907394.png','14b8cf','0','1',NULL);
INSERT INTO `tbl_subcategories` VALUES ('106','متفرقه','متفرقه-1-2-3-4-5-6-7-8-9-10-11','6','102','','','','','','5a4ba73b336621514907449.png','14b8cf','0','1',NULL);
INSERT INTO `tbl_subcategories` VALUES ('107','کفش و لباس بچه','کفش-و-لباس-بچه','6','0','','','','','','5a4ba2e5b86c11514906340.png','14b8cf','5','1',NULL);
INSERT INTO `tbl_subcategories` VALUES ('108','وسایل بچه و اسباب بازی','وسایل-بچه-و-اسباب-بازی','6','0','','','','','','5a4ba2c0a0cca1514906302.png','14b8cf','4','1',NULL);
INSERT INTO `tbl_subcategories` VALUES ('109','آرایشی، بهداشتی و درمانی','آرایشی-بهداشتی-و-درمانی','6','0','','','','','','5a4ba2f948e801514906358.png','14b8cf','2','1',NULL);
INSERT INTO `tbl_subcategories` VALUES ('110','متفرقه','متفرقه-1-2-3-4-5-6-7-8-9','6','0','','','','','','5a4ba3465878d1514906437.png','14b8cf','6','1',NULL);
INSERT INTO `tbl_subcategories` VALUES ('111','رایانه','رایانه','7','0','','','','','','5a4bda8ea9ede1514920589.png','7ba48a','1','1',NULL);
INSERT INTO `tbl_subcategories` VALUES ('112','رایانه رومیزی','رایانه-رومیزی','7','111','','','','','','5a4bdaff0699f1514920701.png','7ba48a','0','1',NULL);
INSERT INTO `tbl_subcategories` VALUES ('113','رایانه همراه','رایانه-همراه','7','111','','','','','','5a4bdb05d72b11514920708.png','7ba48a','0','1',NULL);
INSERT INTO `tbl_subcategories` VALUES ('114','پرینتر/اسکنر/کپی/فکس','پرینتراسکنرکپیفکس','7','111','','','','','','5a4bdaef4c7ce1514920685.png','7ba48a','0','1',NULL);
INSERT INTO `tbl_subcategories` VALUES ('115','قطعات و لوازم جانبی','قطعات-و-لوازم-جانبی','7','111','','','','','','5a4bdb0bcfbc61514920714.png','7ba48a','0','1',NULL);
INSERT INTO `tbl_subcategories` VALUES ('116','مودم و تجهیزات شبکه','مودم-و-تجهیزات-شبکه','7','111','','','','','','5a4bdb21c61f91514920736.png','7ba48a','0','1',NULL);
INSERT INTO `tbl_subcategories` VALUES ('117','متفرقه','متفرقه-1-2-3-4-5-6-7-8-9-10-11-12-13-14-15-16-17-18-19','7','111','','','','','','5a4bdb14a87b41514920723.png','7ba48a','0','1',NULL);
INSERT INTO `tbl_subcategories` VALUES ('118','صوتی و تصویری','صوتی-و-تصویری','7','0','','','','','','5a4bdd9a1ff151514921366.png','7ba48a','3','1',NULL);
INSERT INTO `tbl_subcategories` VALUES ('119','فیلم و موسیقی','فیلم-و-موسیقی','7','118','','','','','','5a4bddd98b3481514921430.png','7ba48a','0','1',NULL);
INSERT INTO `tbl_subcategories` VALUES ('120','دوربین عکاسی و فیلمبرداری','دوربین-عکاسی-و-فیلمبرداری','7','118','','','','','','5a4bddecaa34b1514921451.png','7ba48a','0','1',NULL);
INSERT INTO `tbl_subcategories` VALUES ('121','پخش کننده همراه','پخش-کننده-همراه','7','118','','','','','','5a4bde28e88091514921511.png','7ba48a','0','1',NULL);
INSERT INTO `tbl_subcategories` VALUES ('122','سیستم صوتی خانگی','سیستم-صوتی-خانگی','7','118','','','','','','5a4bdde0a27131514921439.png','7ba48a','0','1',NULL);
INSERT INTO `tbl_subcategories` VALUES ('123','ویدئو و پخش کننده DVD','ویدیو-و-پخش-کننده','7','118','','','','','','5a4bde0aa9c9e1514921480.png','7ba48a','0','1',NULL);
INSERT INTO `tbl_subcategories` VALUES ('124','تلویزیون و پروژکتور','تلویزیون-و-پروژکتور','7','118','','','','','','5a4bddf4e720f1514921459.png','7ba48a','0','1',NULL);
INSERT INTO `tbl_subcategories` VALUES ('125','متفرقه','متفرقه-1-2-3-4-5-6-7-8-9-10-11-12-13-14-15-16-17-18-19-20','7','118','','','','','','5a4bddcdbbe1a1514921420.png','7ba48a','0','1',NULL);
INSERT INTO `tbl_subcategories` VALUES ('126','موبایل و تبلت','موبایل-و-تبلت','7','0','','','','','','5a4bdf73dc9df1514921842.png','7ba48a','2','1',NULL);
INSERT INTO `tbl_subcategories` VALUES ('127','گوشی موبایل','گوشی-موبایل','7','126','','','','','','5a4bdfa5a3d121514921891.png','7ba48a','0','1',NULL);
INSERT INTO `tbl_subcategories` VALUES ('128','تبلت','تبلت','7','126','','','','','','5a4bdf92b41601514921872.png','7ba48a','0','1',NULL);
INSERT INTO `tbl_subcategories` VALUES ('129','لوازم جانبی موبایل و تبلت','لوازم-جانبی-موبایل-و-تبلت','7','126','','','','','','5a4bdfac4c3f11514921898.png','7ba48a','0','1',NULL);
INSERT INTO `tbl_subcategories` VALUES ('130','سیم کارت','سیم-کارت','7','126','','','','','','5a4bdf9bd2e5c1514921881.png','7ba48a','0','1',NULL);
INSERT INTO `tbl_subcategories` VALUES ('131','متفرقه','متفرقه-1-2-3-4-5-6-7-8-9-10-11-12-13-14-15-16-17-18-19-20-21','7','126','','','','','','5a4bdfc1f01111514921920.png','7ba48a','0','1',NULL);
INSERT INTO `tbl_subcategories` VALUES ('132','کنسول، بازی های ویدئویی و آنلاین','کنسول-بازی-های-ویدیویی-و-آنلاین','7','0','','','','','','5a4bdffb0d9301514921977.png','7ba48a','4','1',NULL);
INSERT INTO `tbl_subcategories` VALUES ('133','دستگاه تلفن','دستگاه-تلفن','7','0','','','','','','5a4be02ca02f81514922027.png','7ba48a','5','1',NULL);
INSERT INTO `tbl_subcategories` VALUES ('134','متفرقه','متفرقه-1-2-3-4-5-6-7-8-9-10-11-12-13-14-15-16-17-18-19-20-21-22','7','0','','','','','','5a4be0f45dd7a1514922226.png','7ba48a','6','1',NULL);
INSERT INTO `tbl_subcategories` VALUES ('135','بلیط','بلیط','8','0','','','','','','5a4bbcc6c283b1514912965.png','ff9900','1','1',NULL);
INSERT INTO `tbl_subcategories` VALUES ('136','کنسرت','کنسرت','8','135','','','','','','5a4bbd4f9ce651514913102.png','ff9900','0','1',NULL);
INSERT INTO `tbl_subcategories` VALUES ('137','تئاتر و سینما','تیاتر-و-سینما','8','135','','','','','','5a4bbd2e0a8021514913068.png','ff9900','0','1',NULL);
INSERT INTO `tbl_subcategories` VALUES ('138','کارت هدیه و تخفیف','کارت-هدیه-و-تخفیف','8','135','','','','','','5a4bbd463b51e1514913092.png','ff9900','0','1',NULL);
INSERT INTO `tbl_subcategories` VALUES ('139','ورزشی','ورزشی-1','8','135','','','','','','5a4bbcfcb885f1514913019.png','ff9900','0','1',NULL);
INSERT INTO `tbl_subcategories` VALUES ('140','اتوبوس، مترو و قطار','اتوبوس-مترو-و-قطار','8','135','','','','','','5a4bbd11223061514913039.png','ff9900','0','1',NULL);
INSERT INTO `tbl_subcategories` VALUES ('141','اماکن و مسابقات ورزشی','اماکن-و-مسابقات-ورزشی','8','135','','','','','','5a4bbd211c5701514913055.png','ff9900','0','1',NULL);
INSERT INTO `tbl_subcategories` VALUES ('142','متفرقه','متفرقه-1-2-3-4-5-6-7-8-9-10-11-12-13','8','135','','','','','','5a4bbd5bd1c661514913114.png','ff9900','0','1',NULL);
INSERT INTO `tbl_subcategories` VALUES ('143','کتاب و مجله','کتاب-و-مجله','8','0','','','','','','5a4bbf59161551514913623.png','ff9900','5','1',NULL);
INSERT INTO `tbl_subcategories` VALUES ('144','آموزشی','آموزشی-1','8','143','','','','','','5a4bbfbec1d2b1514913725.png','ff9900','0','1',NULL);
INSERT INTO `tbl_subcategories` VALUES ('145','تاریخی','تاریخی','8','143','','','','','','5a4bbfab720041514913706.png','ff9900','0','1',NULL);
INSERT INTO `tbl_subcategories` VALUES ('146','ادبی','ادبی','8','143','','','','','','5a4bbfb671baa1514913716.png','ff9900','0','1',NULL);
INSERT INTO `tbl_subcategories` VALUES ('147','مذهبی','مذهبی','8','143','','','','','','5a4bbfc944b8b1514913735.png','ff9900','0','1',NULL);
INSERT INTO `tbl_subcategories` VALUES ('148','مجلات','مجلات','8','143','','','','','','5a4bbf8edd7bf1514913677.png','ff9900','0','1',NULL);
INSERT INTO `tbl_subcategories` VALUES ('149','متفرقه','متفرقه-1-2-3-4-5-6-7-8-9-10-11-12-13-14','8','143','','','','','','5a4bbf9fe30a01514913694.png','ff9900','0','1',NULL);
INSERT INTO `tbl_subcategories` VALUES ('151','دوچرخه/اسکیت/اسکوتر','دوچرخهاسکیتاسکوتر','8','0','','','','','','5a4bc136aa7991514914100.png','ff9900','6','1',NULL);
INSERT INTO `tbl_subcategories` VALUES ('152','حیوانات','حیوانات','8','0','','','','','','5a4bc40c77adc1514914827.png','ff9900','9','1',NULL);
INSERT INTO `tbl_subcategories` VALUES ('153','گربه','گربه','8','152','','','','','','5a4bc44eb04461514914893.png','ff9900','0','1',NULL);
INSERT INTO `tbl_subcategories` VALUES ('154','موشی و خرگوش','موشی-و-خرگوش','8','152','','','','','','5a4bc47f7eae51514914942.png','ff9900','0','1',NULL);
INSERT INTO `tbl_subcategories` VALUES ('155','خزنده','خزنده','8','152','','','','','','5a4bc46096ba71514914911.png','ff9900','0','1',NULL);
INSERT INTO `tbl_subcategories` VALUES ('156','پرنده','پرنده','8','152','','','','','','5a4bc4753b09b1514914931.png','ff9900','0','1',NULL);
INSERT INTO `tbl_subcategories` VALUES ('157','ماهی','ماهی','8','152','','','','','','5a4bc43fd2c9b1514914878.png','ff9900','0','1',NULL);
INSERT INTO `tbl_subcategories` VALUES ('158','لوازم جانبی','لوازم-جانبی','8','152','','','','','','5a4bc446c3a6e1514914885.png','ff9900','0','1',NULL);
INSERT INTO `tbl_subcategories` VALUES ('159','حیوانات مزرعه','حیوانات-مزرعه','8','152','','','','','','5a4bc46ccaf371514914923.png','ff9900','0','1',NULL);
INSERT INTO `tbl_subcategories` VALUES ('160','متفرقه','متفرقه-1-2-3-4-5-6-7-8-9-10-11-12-13-14-15','8','152','','','','','','5a4bc4353e9aa1514914867.png','ff9900','0','1',NULL);
INSERT INTO `tbl_subcategories` VALUES ('161','کلکسیون و سرگرمی','کلکسیون-و-سرگرمی','8','0','','','','','','5a4bd105aedcb1514918148.png','ff9900','8','1',NULL);
INSERT INTO `tbl_subcategories` VALUES ('162','سکه، تمبر و اسکناس','سکه-تمبر-و-اسکناس','8','161','','','','','','5a4bd149f173f1514918215.png','ff9900','0','1',NULL);
INSERT INTO `tbl_subcategories` VALUES ('163','اشیای عتیقه','اشیای-عتیقه','8','161','','','','','','5a4bd130573ee1514918188.png','ff9900','0','1',NULL);
INSERT INTO `tbl_subcategories` VALUES ('164','متفرقه','متفرقه-1-2-3-4-5-6-7-8-9-10-11-12-13-14-15-16','8','161','','','','','','5a4bd1883e3bf1514918278.png','ff9900','0','1',NULL);
INSERT INTO `tbl_subcategories` VALUES ('165','آلات موسیقی','آلات-موسیقی','8','0','','','','','','5a4bd340bc57d1514918719.png','ff9900','2','1',NULL);
INSERT INTO `tbl_subcategories` VALUES ('166','گیتار، بیس و آمپلی فایر','گیتار-بیس-و-آمپلی-فایر','8','165','','','','','','5a4bd3e0498851514918877.png','ff9900','0','1',NULL);
INSERT INTO `tbl_subcategories` VALUES ('167','پیانو/کیبورد/آکاردئون','پیانوکیبوردآکاردیون','8','165','','','','','','5a4bd57fbcfa01514919294.png','ff9900','0','1',NULL);
INSERT INTO `tbl_subcategories` VALUES ('168','سنتی','سنتی','8','165','','','','','','5a4bd63d43d1a1514919483.png','ff9900','0','1',NULL);
INSERT INTO `tbl_subcategories` VALUES ('169','درام و پرکاشن','درام-و-پرکاشن','8','165','','','','','','5a4bd5379b6791514919221.png','ff9900','0','1',NULL);
INSERT INTO `tbl_subcategories` VALUES ('170','سازهای بادی','سازهای-بادی','8','165','','','','','','5a4bd4b0e5fed1514919087.png','ff9900','0','1',NULL);
INSERT INTO `tbl_subcategories` VALUES ('171','ویولن','ویولن','8','165','','','','','','5a4bd395d7a691514918805.png','ff9900','0','1',NULL);
INSERT INTO `tbl_subcategories` VALUES ('172','متفرقه','متفرقه-1-2-3-4-5-6-7-8-9-10-11-12-13-14-15-16-17','8','165','','','','','','5a4bd5ba0eb8d1514919351.png','ff9900','0','1',NULL);
INSERT INTO `tbl_subcategories` VALUES ('173','ورزش و تناسب اندام','ورزش-و-تناسب-اندام','8','0','','','','','','5a4bd808cc1201514919942.png','ff9900','3','1',NULL);
INSERT INTO `tbl_subcategories` VALUES ('174','ورزش های توپی','ورزش-های-توپی','8','173','','','','','','5a4bd85737ba41514920021.png','ff9900','0','1',NULL);
INSERT INTO `tbl_subcategories` VALUES ('175','کوهنوردی و کمپینگ','کوهنوردی-و-کمپینگ','8','173','','','','','','5a4bd87387e601514920050.png','ff9900','0','1',NULL);
INSERT INTO `tbl_subcategories` VALUES ('176','غواصی و ورزش های آبی','غواصی-و-ورزش-های-آبی','8','173','','','','','','5a4bd87cbe4ef1514920059.png','ff9900','0','1',NULL);
INSERT INTO `tbl_subcategories` VALUES ('177','تجهیزات ورزشی ','تجهیزات-ورزشی','8','173','','','','','','5a4bd884494e71514920066.png','ff9900','0','1',NULL);
INSERT INTO `tbl_subcategories` VALUES ('178','ورزش های زمستانی','ورزش-های-زمستانی','8','173','','','','','','5a4bd8439d2261514920001.png','ff9900','0','1',NULL);
INSERT INTO `tbl_subcategories` VALUES ('179','اسب و تجهیزات اسب سواری','اسب-و-تجهیزات-اسب-سواری','8','173','','','','','','5a4bd88a97e551514920073.png','ff9900','0','1',NULL);
INSERT INTO `tbl_subcategories` VALUES ('180','ماهیگیری','ماهیگیری','8','173','','','','','','5a4bd86a069411514920040.png','ff9900','0','1',NULL);
INSERT INTO `tbl_subcategories` VALUES ('181','متفرقه','متفرقه-1-2-3-4-5-6-7-8-9-10-11-12-13-14-15-16-17-18','8','173','','','','','','5a4bd85f956821514920030.png','ff9900','0','1',NULL);
INSERT INTO `tbl_subcategories` VALUES ('182','اسباب بازی','اسباب-بازی','8','0','','','','','','5a4bd9015c5551514920192.png','ff9900','7','1',NULL);
INSERT INTO `tbl_subcategories` VALUES ('183','تور و چارتر','تور-و-چارتر','8','0','','','','','','5a4bd92fd562d1514920238.png','ff9900','4','1',NULL);
INSERT INTO `tbl_subcategories` VALUES ('184','رویداد','رویداد','9','0','','','','','','5a4c9ffdd1db11514971132.png','7d3e2c','1','1',NULL);
INSERT INTO `tbl_subcategories` VALUES ('185','حراج','حراج','9','184','','','','','','5a4ca14b3acc21514971465.png','7d3e2c','0','1',NULL);
INSERT INTO `tbl_subcategories` VALUES ('186','گردهمایی و همایش','گردهمایی-و-همایش','9','184','','','','','','5a4ca13fbda1f1514971453.png','7d3e2c','0','1',NULL);
INSERT INTO `tbl_subcategories` VALUES ('187','موسیقی و تئاتر','موسیقی-و-تیاتر','9','184','','','','','','5a4ca133766431514971442.png','7d3e2c','0','1',NULL);
INSERT INTO `tbl_subcategories` VALUES ('188','ورزشی','ورزشی-1-2','9','184','','','','','','5a4ca151756911514971472.png','7d3e2c','0','1',NULL);
INSERT INTO `tbl_subcategories` VALUES ('190','داوطلبانه','داوطلبانه','9','0','','','','','','5a4ca004f14931514971139.png','7d3e2c','2','1',NULL);
INSERT INTO `tbl_subcategories` VALUES ('191','خیریه و کمک رسانی','خیریه-و-کمک-رسانی','9','190','','','','','','5a4ca1fd397d01514971643.png','7d3e2c','0','1',NULL);
INSERT INTO `tbl_subcategories` VALUES ('192','تحقیقاتی','تحقیقاتی','9','190','','','','','','5a4ca1f7849821514971637.png','7d3e2c','0','1',NULL);
INSERT INTO `tbl_subcategories` VALUES ('193','متفرقه','متفرقه-1-2-3-4-5-6-7-8-9-10-11-12-13-14-15-16-17-18-19-20-21-22-23-24-25-26-27-28','9','190','','','','','','5a4ca1f075e8a1514971631.png','7d3e2c','0','1',NULL);
INSERT INTO `tbl_subcategories` VALUES ('194','متفرقه','متفرقه-1-2-3-4-5-6-7-8-9-10-11-12-13-14-15-16-17-18-19-20-21-22-23-24-25-26-27','9','0','','','','','','5a4c9ff2385601514971120.png','7d3e2c','3','1',NULL);
INSERT INTO `tbl_subcategories` VALUES ('195','تجهیزات و ماشین آلات','تجهیزات-و-ماشین-آلات','10','0','','','','','','5a4ba843814fe1514907714.png','9c59b6','1','1',NULL);
INSERT INTO `tbl_subcategories` VALUES ('196','فروشگاه و مغازه','فروشگاه-و-مغازه','10','195','','','','','','5a4bac5adafb51514908761.png','9c59b6','0','1',NULL);
INSERT INTO `tbl_subcategories` VALUES ('197','آرایشگاه و سالن های زیبایی','آرایشگاه-و-سالن-های-زیبایی','10','195','','','','','','5a4bac45775b71514908740.png','9c59b6','0','1',NULL);
INSERT INTO `tbl_subcategories` VALUES ('198','دفتر کار','دفتر-کار','10','195','','','','','','5a4bacd584b351514908884.png','9c59b6','0','1',NULL);
INSERT INTO `tbl_subcategories` VALUES ('199','کافی شاپ و رستوران','کافی-شاپ-و-رستوران','10','195','','','','','','5a4bac92d8eb41514908817.png','9c59b6','0','1',NULL);
INSERT INTO `tbl_subcategories` VALUES ('200','متفرقه','متفرقه-1-2-3-4-5-6-7-8-9-10-11-12','10','195','','','','','','5a4bad52309c01514909008.png','9C59B6','0','1','');
INSERT INTO `tbl_subcategories` VALUES ('201','عمده فروشی','عمده-فروشی','10','0','','','','','','5a4babc91963b1514908615.png','9C59B6','2','1',NULL);
INSERT INTO `tbl_subcategories` VALUES ('202','متفرقه','متفرقه-1','10','0','','','','','','5a4babd5bbb0e1514908628.png','9C59B6','3','1','');
UNLOCK TABLES;

-- Table structure for table `tbl_tags`

DROP TABLE IF EXISTS `tbl_tags`;
CREATE TABLE `tbl_tags` (
  `TAG_ID` int NOT NULL AUTO_INCREMENT,
  `TAG_NAME` varchar(100) CHARACTER SET utf8mb3 COLLATE utf8mb3_persian_ci NOT NULL,
  `TAG_SLUG` varchar(100) NOT NULL,
  PRIMARY KEY (`TAG_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

-- Dumping data for table `tbl_tags`

LOCK TABLES `tbl_tags` WRITE;
UNLOCK TABLES;

-- Table structure for table `tbl_tags_relation`

DROP TABLE IF EXISTS `tbl_tags_relation`;
CREATE TABLE `tbl_tags_relation` (
  `ID` int NOT NULL AUTO_INCREMENT,
  `LINK_ID` int NOT NULL,
  `TAG_ID` int NOT NULL,
  `TYPE` varchar(50) NOT NULL,
  PRIMARY KEY (`ID`),
  KEY `TAG_ID` (`TAG_ID`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

-- Dumping data for table `tbl_tags_relation`

LOCK TABLES `tbl_tags_relation` WRITE;
UNLOCK TABLES;

-- Table structure for table `tbl_telegram_box`

DROP TABLE IF EXISTS `tbl_telegram_box`;
CREATE TABLE `tbl_telegram_box` (
  `id` int NOT NULL AUTO_INCREMENT,
  `message_id` int NOT NULL,
  `post_id` int NOT NULL,
  `type` enum('ads','post') NOT NULL DEFAULT 'ads',
  `created_at` datetime NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

-- Dumping data for table `tbl_telegram_box`

LOCK TABLES `tbl_telegram_box` WRITE;
UNLOCK TABLES;

-- Table structure for table `tbl_user_levels`

DROP TABLE IF EXISTS `tbl_user_levels`;
CREATE TABLE `tbl_user_levels` (
  `id` int NOT NULL AUTO_INCREMENT,
  `rule_code` varchar(255) NOT NULL,
  `rule_name` varchar(255) NOT NULL,
  `access_levels` text NOT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=4 DEFAULT CHARSET=utf8mb3;

-- Dumping data for table `tbl_user_levels`

LOCK TABLES `tbl_user_levels` WRITE;
INSERT INTO `tbl_user_levels` VALUES ('1','SUPER_ADMIN','مدیر ارشد','[\"1\",\"2\",\"3\",\"4\",\"5\",\"6\",\"7\",\"8\",\"9\",\"10\",\"11\",\"12\",\"13\",\"14\",\"15\",\"16\",\"17\",\"18\",\"19\",\"20\",\"21\",\"22\",\"23\",\"24\",\"25\",\"26\",\"27\"]');
INSERT INTO `tbl_user_levels` VALUES ('2','ADMIN','معاون','[\"1\",\"2\",\"5\",\"7\",\"9\",\"10\",\"11\",\"12\",\"13\",\"14\",\"15\",\"16\",\"17\",\"18\",\"19\",\"20\",\"21\",\"22\",\"23\",\"24\"]');
INSERT INTO `tbl_user_levels` VALUES ('3','EDITOR','ویراستار','[\"1\",\"7\",\"21\",\"22\",\"23\",\"24\"]');
UNLOCK TABLES;

-- Table structure for table `tbl_user_metas`

DROP TABLE IF EXISTS `tbl_user_metas`;
CREATE TABLE `tbl_user_metas` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `user_id` int unsigned NOT NULL,
  `meta_key` varchar(255) NOT NULL,
  `meta_value` text,
  PRIMARY KEY (`id`),
  KEY `user_id` (`user_id`),
  CONSTRAINT `tbl_user_metas_ibfk_1` FOREIGN KEY (`user_id`) REFERENCES `tbl_users` (`ID`) ON DELETE CASCADE ON UPDATE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

-- Dumping data for table `tbl_user_metas`

LOCK TABLES `tbl_user_metas` WRITE;
UNLOCK TABLES;

-- Table structure for table `tbl_users`

DROP TABLE IF EXISTS `tbl_users`;
CREATE TABLE `tbl_users` (
  `ID` int unsigned NOT NULL AUTO_INCREMENT,
  `uuid` varchar(36) DEFAULT NULL,
  `NAME` varchar(100) DEFAULT NULL,
  `LAST_NAME` varchar(250) DEFAULT NULL,
  `TEL` varchar(12) DEFAULT NULL,
  `EMAIL` varchar(60) DEFAULT NULL,
  `ADDRESS` text,
  `CREDIT_CARD` varchar(225) DEFAULT NULL,
  `USER_LEVEL` varchar(50) NOT NULL DEFAULT 'USER',
  `USERNAME` varchar(100) NOT NULL,
  `PASSWORD` varchar(32) NOT NULL,
  `IS_ACTIVE` enum('1','2','3') NOT NULL DEFAULT '1',
  `REFERER_ID` varchar(100) DEFAULT NULL,
  `BIOGRAPHY` text,
  `WEBSITE` varchar(100) DEFAULT NULL,
  `USER_DATE_CREATED` datetime DEFAULT NULL,
  `FREE_ADS_COUNT` smallint NOT NULL DEFAULT '0',
  `PHONE` varchar(255) DEFAULT NULL,
  `VERIFIED_EMAIL` varchar(60) DEFAULT NULL,
  `VERIFIED_MOBILE` varchar(12) DEFAULT NULL,
  `profile_views` bigint NOT NULL DEFAULT '0',
  PRIMARY KEY (`ID`),
  UNIQUE KEY `USERNAME` (`USERNAME`),
  UNIQUE KEY `user_uuid` (`uuid`)
) ENGINE=InnoDB AUTO_INCREMENT=3 DEFAULT CHARSET=utf8mb3;

-- Dumping data for table `tbl_users`

LOCK TABLES `tbl_users` WRITE;
INSERT INTO `tbl_users` VALUES ('1','f5673d8f-d375-4cae-99b7-b4a51ba3903c','sirvan',NULL,NULL,'info@kodesign.ir',NULL,NULL,'SUPER_ADMIN','admin','e10adc3949ba59abbe56e057f20f883e',2,NULL,NULL,NULL,NULL,'0',NULL,'info@kodesign.ir',NULL,'0');
INSERT INTO `tbl_users` VALUES ('2','f5673d8f-d375-4cae-99b7-b4a51ba3902c','saf safsa',NULL,NULL,'saftds@fddsg.com',NULL,NULL,'EDITOR','saftds@fddsg.com','e10adc3949ba59abbe56e057f20f883e',2,NULL,NULL,NULL,'2024-05-31 19:25:43','0',NULL,'saftds@fddsg.com',NULL,'0');
UNLOCK TABLES;

-- Table structure for table `tbl_withdrawal_requests`

DROP TABLE IF EXISTS `tbl_withdrawal_requests`;
CREATE TABLE `tbl_withdrawal_requests` (
  `id` int NOT NULL AUTO_INCREMENT,
  `user_id` int NOT NULL,
  `price` int NOT NULL,
  `referal_ids` text NOT NULL,
  `date_created` datetime NOT NULL,
  `status` int NOT NULL COMMENT '1:suspended;2:settled',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb3;

-- Dumping data for table `tbl_withdrawal_requests`

LOCK TABLES `tbl_withdrawal_requests` WRITE;
UNLOCK TABLES;

-- Completed on: 2024-05-31T19:29:07+03:30
