<?php

use Admin\Pagination;
use App\Affiliate;
use App\WithdrawalRequest;

include 'init.php';

$page_slug = 'withdrawal-list';
include 'check_auth.php';


if (isPost() && token()->check()) {
    if (input('request_action') === 'settle') {
        include ('process/withdrawal/_settle.php');
    } else {
        include ('process/withdrawal/_bulk_actions.php');
    }
}
?>
<!DOCTYPE html>

<html lang="<?= setting('SITE_LANGUAGE_SIGN') ?>">
<head>
    <?php include 'includes/head.php'; ?>
</head>

<body class="<?= bodyClass($current_page) ?>">

<div class="m-grid m-grid--hor m-grid--root m-page">

    <?php include 'includes/header.php' ?>

    <!-- begin::Body -->
    <div class="m-grid__item m-grid__item--fluid m-grid m-grid--ver-desktop m-grid--desktop m-body">
        <?php include 'includes/main_menu.php' ?>

        <div class="m-grid__item m-grid__item--fluid m-wrapper">

            <?php include 'includes/subheader.php' ?>

            <!-- END: Subheader -->
            <div class="m-content">
                <div class="m-alert m-alert--icon m-alert--air m-alert--square alert alert-dismissible m--margin-bottom-30" role="alert">
                    <div class="m-alert__icon">
                        <i class="flaticon-exclamation m--font-primary"></i>
                    </div>
                    <div class="m-alert__text">
                        در صورتی که هیچ فیلتری اعمال نشده باشد صرفا <strong><?= setting('ADMIN_PANEL_NOT_FILTERED_ADS_COUNT') ?></strong> مورد آخر
                        <?php if (! isDemoMode()) : ?>
                            (که طی یک ماه اخیر ثبت شده باشند)
                        <?php endif; ?>
                        نمایش داده خواهد شد. برای مشاهده نتایج بیشتر از بخش فیلتر استفاده نمایید
                    </div>
                </div>

                <?php session()->showAlert() ?>

                <div class="m-portlet m-portlet--mobile">
                    <div class="m-portlet__head">

                        <?php include 'includes/portlet_header.php' ?>

                        <div class="m-portlet__head-tools">

                            <ul class="m-portlet__nav">
                                <li class="m-portlet__nav-item">
                                    <div class="m-dropdown m-dropdown--inline m-dropdown--arrow m-dropdown--align-right m-dropdown--align-push" m-dropdown-toggle="hover" aria-expanded="true">
                                        <a href="#" class="m-portlet__nav-link btn btn-lg btn-secondary  m-btn m-btn--icon m-btn--icon-only m-btn--pill  m-dropdown__toggle">
                                            <i class="la la-ellipsis-h m--font-brand"></i>
                                        </a>
                                        <div class="m-dropdown__wrapper">
                                            <span class="m-dropdown__arrow m-dropdown__arrow--right m-dropdown__arrow--adjust"></span>
                                            <div class="m-dropdown__inner">
                                                <div class="m-dropdown__body">
                                                    <div class="m-dropdown__content">

                                                        <form action="" method="post" class="nav-menu-form">
                                                            <?= csrf_field() ?>

                                                            <input type="hidden" name="action">

                                                            <ul class="m-nav">
                                                                <li class="m-nav__section m-nav__section--first">
                                                                    <span class="m-nav__section-text">عملیات ها</span>
                                                                </li>

                                                                <li class="m-nav__item">
                                                                    <a href="javascript:" class="m-nav__link" data-click-to-submit data-action="delete" data-irreversible="true">
                                                                        <i class="m-nav__link-icon fa fa-times"></i>
                                                                        <span class="m-nav__link-text">حذف</span>
                                                                    </a>
                                                                </li>

                                                                <?php if ($current_page->hasHelp()) : ?>
                                                                <li class="m-nav__section">
                                                                    <span class="m-nav__section-text">لینک های مفید</span>
                                                                </li>
                                                                <li class="m-nav__item">
                                                                    <a href="javascript:" class="m-nav__link" data-toggle="modal" data-target="#helpModal">
                                                                        <i class="m-nav__link-icon fa fa-question-circle"></i>
                                                                        <span class="m-nav__link-text">راهنما</span>
                                                                    </a>
                                                                </li>
                                                                <?php endif; ?>

                                                                <li class="m-nav__separator m-nav__separator--fit m--hide"></li>

                                                                <li class="m-nav__item m--hide">
                                                                    <a href="#" class="btn btn-outline-danger m-btn m-btn--pill m-btn--wide btn-sm">Submit</a>
                                                                </li>
                                                            </ul>
                                                        </form>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </li>
                            </ul>
                        </div>
                    </div>
                    <div class="m-portlet__body">

                        <!--begin::Section-->
                        <div class="m-section">

                            <div class="m-section__content">
                                <form class="m-form m-form--fit m--margin-bottom-20">
                                    <div class="row m--margin-bottom-20">
                                        <div class="col-lg-2 m--margin-bottom-10-tablet-and-mobile">
                                            <label for="price">مبلغ درخواست</label>
                                            <input type="text" name="price" id="price" class="form-control m-input" value="<?= input('price') ?>">
                                        </div>


                                        <div class="col-lg-2 m--margin-bottom-10-tablet-and-mobile">
                                            <label for="time">فیلتر زمانی :</label>
                                            <select class="form-control m-bootstrap-select selectpicker" name="time" id="type" data-col-index="2">
                                                <option value="0" <?= inputs()->is_set('time') || input('time') == 0 ? "selected" : false ?> >پیش فرض</option>
                                                <option value="1" <?= activeState(input('time'), 1) ?> > از 1 ماه قبل</option>
                                                <option value="3" <?= activeState(input('time'), 3) ?> > از 3 ماه قبل</option>
                                                <option value="6" <?= activeState(input('time'), 6) ?> > از 6 ماه قبل</option>
                                                <option value="12" <?= activeState(input('time'), 12) ?> >از یک سال قبل</option>
                                                <option value="all" <?= activeState(input('time'), 'all') ?> >همه</option>
                                            </select>
                                        </div>
                                        <div class="col-lg-2 m--margin-bottom-10-tablet-and-mobile">
                                            <label for="status">وضعیت :</label>
                                            <select class="form-control m-bootstrap-select selectpicker" name="status" id="type">
                                                <option value="0">همه</option>
                                                <option value="2" <?= activeState(input('status'), 2) ?> >تسویه شده</option>
                                                <option value="1" <?= activeState(input('status'), 1) ?> >تسویه نشده</option>
                                            </select>
                                        </div>
                                        <div class="col-lg-3 m--margin-bottom-10-tablet-and-mobile">
                                            <label for="user">کاربر ثبت کننده</label>
                                            <select data-remote-load-data data-remote-url="process/ajax_calls.php?action=remote-load-users&type=minimal" name="user" id="user" class="form-control m-input m-select2" dir="rtl">
                                                <?php
                                                $user = null;
                                                if (inputs()->not_empty('user')) {
                                                    $user = $User->findById(input('user'));
                                                }
                                                if ($user) {
                                                    echo "<option value='{$user->USER_ID}'>{$user->username()}</option>";
                                                }
                                                ?>
                                                <option value="0">همه کاربران</option>
                                            </select>
                                        </div>

                                    </div>

                                    <div class="m-separator m-separator--dashed"></div>

                                    <div class="row text-right">
                                        <div class="col-lg-12">
                                            <a href="<?= withdrawalRoute() ?>" class="btn btn-secondary m-btn m-btn--icon">
												<span>
													<i class="la la-close"></i>
													<span>پاک سازی</span>
												</span>
                                            </a>
                                            <button type="submit" class="btn btn-brand m-btn m-btn--icon">
												<span>
													<i class="la la-search"></i>
													<span>فیلتر</span>
												</span>
                                            </button>
                                        </div>
                                    </div>

                                </form>

                                <div class="table-responsive"  style="margin-top: 50px">
                                    <table class="table table-bordered m-table table-hover">
                                        <thead>
                                        <tr>
                                            <th>
                                                <label class="m-checkbox m-checkbox--air m-checkbox--solid">
                                                    <input type="checkbox" data-click-checks-all-rows>
                                                    <span></span>
                                                </label>
                                            </th>
                                            <th>درخواست کننده</th>
                                            <th>مبلغ درخواستی</th>
                                            <th>تاریخ درخواست</th>
                                            <th> وضعیت</th>
                                            <th> عملیات</th>
                                        </tr>
                                        </thead>
                                        <tbody>
                                            <?php
                                            $price = $status = $time = $user = null;
                                            extract($_GET);

                                            $limited_days_for_not_filtered = 30;
//                                            $limited_days_for_not_filtered = 0;
                                            if (isDemoMode()) {
                                                $limited_days_for_not_filtered = 0;
                                            }

                                            $is_filtered = WithdrawalRequest::isFiltered($price, $status, $time, $user);

                                            if ($is_filtered) {
                                                $count = WithdrawalRequest::countFiltered($price, $status, $time, $user);
                                                $sql = WithdrawalRequest::filteredSQL(false, true, $price, $status, $time, $user);
                                            } else {
                                                $count = 0;
                                                $sql = WithdrawalRequest::filteredSQL(false, false, $price, $status, $time, $user, $limited_days_for_not_filtered);

                                            }

                                            $page = inputs()->not_empty('page') ? (int) input('page') : 1;
                                            $per_page = 15;
                                            $total_count = $count;

                                            $pagination = new Pagination($page, $per_page, $total_count);
                                            $pageParameters = array('price' => $price, 'status' => $status, 'time' => $time, 'user' => $user);
                                            $pagination->main_page = $pagination->makePageUrl(withdrawalRoute(), $pageParameters);

                                            if ($is_filtered) {
                                                $pagination->sql = $sql;
                                                $sql = $pagination->correct_sql();
                                            }

                                            $requests = WithdrawalRequest::find_by_sql($sql);

                                            if (! $requests) {
                                                echo "<tr><td colspan='9' class='table-no-record-found'>هیچ رکوردی یافت نشد</td></tr>";
                                            }

                                            if ($requests) :

                                                $WithdrawalRequest = new WithdrawalRequest();
                                                $requests = $WithdrawalRequest->eagerLoad('user', $requests, 'user_id');
                                                $Affiliate = new Affiliate();

                                                foreach ($requests as $request) :
                                                    /* @var WithdrawalRequest $request */
                                            ?>
                                            <tr>
                                                <th scope="row">
                                                    <label class="m-checkbox"><input type="checkbox" class="to-be-checked" value="<?= $request->id ?>"><span></span></label>
                                                </th>
                                                <td>
                                                    <a href="#user-detail-modal-<?= $request->id ?>" role="button" data-toggle="modal">
                                                        <?= $request->user()->publicName() ?>
                                                    </a>
                                                </td>
                                                <td><?= number_format($request->price) ?></td>
                                                <td><?= not_empty($request->date_created > 0) ? miladiToShamsiAdmin($request->date_created, "Y/m/d") : false; ?></td>
                                                <td><?= $request->showStatus() ?></td>
                                                <td class="m-datatable__cell">
                                                    <a href="javascript:"  class="m-portlet__nav-link btn m-btn m-btn--hover-accent m-btn--icon m-btn--icon-only m-btn--pill fire-details-modal" data-id="<?= $request->id ?>" title="مشاهده جزئیات">
                                                        <i class="la la-eye"></i>
                                                    </a>
                                                    <?php if (! $request->settled()) : ?>
                                                    <form class="form-inline" method="POST" action="<?= $request->settleLink() ?>" data-confirm-show data-title="آیا مایل به نشان گذاری این مورد به عنوان پرداخت شده هستید؟ ">
                                                        <?= csrf_field() ?>
                                                        <button type="submit" class="m-portlet__nav-link btn m-btn m-btn--hover-danger m-btn--icon m-btn--icon-only m-btn--pill" title="تایید پرداخت وجه">
                                                            <i class="la la-check"></i>
                                                        </button>
                                                    </form>
                                                    <?php endif; ?>
                                                    <form class="form-inline" method="POST" action="<?= $request->deleteLink() ?>" data-confirm-delete>
                                                        <?= csrf_field() ?>
                                                        <button type="submit" class="m-portlet__nav-link btn m-btn m-btn--hover-danger m-btn--icon m-btn--icon-only m-btn--pill" title="حذف ">
                                                            <i class="la la-trash"></i>
                                                        </button>
                                                    </form>

                                                </td>
                                            </tr>


                                            <div class="modal fade" id="user-detail-modal-<?= $request->id ?>" tabindex="-1" role="dialog" aria-labelledby="user-detail-modal" aria-hidden="true">
                                                <div class="modal-dialog modal-lg" role="document">
                                                    <div class="modal-content">
                                                        <div class="modal-header">
                                                            <h5 class="modal-title" id="addModalLongTitle">مشخصات کاربر درخواست کننده</h5>
                                                            <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                                                                <span aria-hidden="true">&times;</span>
                                                            </button>
                                                        </div>
                                                        <div class="modal-body">
                                                            <div class="col-lg-12">
                                                                <h4>
                                                                شناسه کاربر : <span class=''><?= $request->user()->ID ?></span> <br/><br/>
                                                                نام کاربری : <span class='foreign'><?= $request->user()->username() ?></span> <br/><br/>
                                                                نام : <?= $request->user()->NAME ?> <br/><br/>
                                                                شماره کارت بانکی : <span class='foreign'><?= $request->user()->CREDIT_CARD ?></span>
                                                                </h4>
                                                            </div>
                                                        </div>
                                                        <div class="modal-footer">
                                                            <button type="button" class="btn btn-secondary m-btn m-btn--icon" data-dismiss="modal">
                                                                <span><i class="la la-remove"></i><span>بستن</span></span>
                                                            </button>
                                                            <a href="<?= usersRoute('profile', $request->user_id) ?>" target="_blank" class="btn btn-success m-btn m-btn--icon">
                                                                <span><i class="la la-eye"></i><span>مشاهده سایر مشخصات کاربر</span></span>
                                                            </a>
                                                        </div>
                                                    </div>
                                                </div>
                                            </div>
                                            <?php
                                                endforeach;
                                            endif;
                                            ?>

                                        </tbody>
                                    </table>

                                    <div class="clearfix"></div>
                                    <?php if ($is_filtered) : ?>
                                        <div class="dataTables_wrapper">
                                            <div class="dataTables_paginate paging_full_numbers">
                                                <ul class="pagination">
                                                    <?php $pagination->show_pagination() ?>
                                                </ul>
                                            </div>
                                        </div>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>

                        <!--end::Section-->
                    </div>

                    <!--end::Form-->
                </div>

            </div>
        </div>
    </div>


    <div class="modal fade" id="request-detail-modal" tabindex="-1" role="dialog" aria-labelledby="request-detail-modal" aria-hidden="true">
        <div class="modal-dialog modal-lg" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="addModalLongTitle">مشاهده جزئیات درخواست</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <div class="col-lg-12">
                        <table class="table m-table table-bordered table-hover text-center big-header">
                            <thead>
                            <tr>
                                <th>آگهی ها/پلان ها</th>
                                <th>مبلغ</th>
                                <th>کمیسیون</th>
                                <th>شناسه کاربر پرداخت کننده</th>
                                <th>تاریخ ثبت</th>
                                <th>وضعیت</th>
                            </tr>
                            </thead>
                            <tbody class="modal-table">

                            </tbody>
                        </table>
                    </div>
                </div>
                <div class="modal-footer">
                    <button type="button" class="btn btn-secondary m-btn m-btn--icon" data-dismiss="modal">
                        <span><i class="la la-remove"></i><span>بستن</span></span>
                    </button>
                </div>
            </div>
        </div>
    </div>

    <?php include 'includes/footer.php' ?>
</div>

<?php include 'includes/quick_navs.php' ?>

<?php include 'includes/scripts.php' ?>

<script src="assets/demo/custom/remote-select.js"></script>

<script>
    $('.selectpicker').selectpicker();

    $(".fire-details-modal").click(function (e) {
        e.preventDefault();

        var requestId = $(this).attr("data-id");
        var modalWrapper = $("#request-detail-modal");

        blockScreen();

        $.ajax({
            type: "GET",
            url: "process/ajax_calls.php",
            data: {
                requestId: requestId,
                action: "fetch-withdrawal-details"
            },
            success: function (response) {
                unblockScreen();

                modalWrapper.find(".modal-table").html(response);
                modalWrapper.modal();
            }
        })
    });
</script>
</body>
</html>

