/**
 * @license Copyright (c) 2003-2019, CKSource - Frederico Knabben. All rights reserved.
 * For licensing, see https://ckeditor.com/legal/ckeditor-oss-license
 */

CKEDITOR.editorConfig = function( config ) {
	// Define changes to default configuration here.
	// For complete reference see:
	// https://ckeditor.com/docs/ckeditor4/latest/api/CKEDITOR_config.html

	// The toolbar groups arrangement, optimized for two toolbar rows.
	config.toolbarGroups = [
		{ name: 'clipboard',   groups: [ 'clipboard', 'undo' ] },
		{ name: 'editing',     groups: [ 'find', 'selection', 'spellchecker' ] },
		{ name: 'links' },
		{ name: 'insert', items: [ 'Image', 'Table' ] }, // اضافه کردن دکمه جدول و تصویر به گروه insert
		{ name: 'forms' },
		{ name: 'tools' },
		{ name: 'document',	   groups: [ 'mode', 'document', 'doctools' ] },
		{ name: 'others' },
		'/',
		{ name: 'basicstyles', groups: [ 'basicstyles', 'cleanup' ] },
     	 { name: 'paragraph',   items: [ 'NumberedList', 'BulletedList', 'Blockquote', 'JustifyLeft', 'JustifyCenter', 'JustifyRight' ] }, // اضافه کردن دکمه‌های چینش
		{ name: 'styles', items: [ 'Format', 'Font', 'FontSize' ] }, // اضافه کردن دکمه‌های فونت و اندازه فونت
		{ name: 'colors', items: [ 'TextColor', 'BGColor' ] }, // اضافه کردن دکمه‌های تغییر رنگ متن و پس‌زمینه
		{ name: 'about' }
	];

	// Remove some buttons provided by the standard plugins, which are
	// not needed in the Standard(s) toolbar.
	config.removeButtons = 'Underline,Subscript,Superscript';

	// Set the most common block elements.
	config.format_tags = 'p;h1;h2;h3;pre';

	// Simplify the dialog windows.
	config.removeDialogTabs = 'image:advanced;link:advanced';
	
	config.font_names = 'Arial;Verdana;Tahoma;Times New Roman;Courier New;'; // فونت‌های سفارشی
    config.fontSize_sizes = '8/Small;10/Normal;12/Medium;14/Large;16/Extra Large'; // اندازه‌های فونت

};

 CKEDITOR.editorConfig = function( config ) {
 	config.allowedContent = {
 	//	script: true,
 		$1: {
 			// This will set the default set of elements
 			elements: CKEDITOR.dtd,
 			attributes: true,
 			styles: true,
 			classes: true
 		}
 	};
 };
