<?php
use App\UserLevels;

include 'init.php';
$page_slug = 'users-roles';
include 'check_auth.php';

$UserLevels = new UserLevels();
$modules = $UserLevels->allModules();

$editableRules = array('ADMIN' => 'معاون', 'EDITOR' => 'ویراستار');


if (isPost()) {
    checkDemoMode();

    $adminRules = json_encode(input('ADMIN'));
    $editorRules = json_encode(input('EDITOR'));
    try {
        $UserLevels->updateRules('ADMIN', $adminRules);
        $UserLevels->updateRules('EDITOR', $editorRules);
        session()->success();
    } catch (PDOException $e) {
        session()->error();
    }

    redirect('refer');
}
?>
<!DOCTYPE html>

<html lang="<?= setting('SITE_LANGUAGE_SIGN') ?>">
<head>
    <?php include 'includes/head.php'; ?>
</head>

<body class="<?= bodyClass($current_page) ?>">

<div class="m-grid m-grid--hor m-grid--root m-page">

    <!-- BEGIN: Left Aside -->
    <?php include 'includes/header.php' ?>
    <!-- END: Left Aside -->

    <!-- begin::Body -->
    <div class="m-grid__item m-grid__item--fluid m-grid m-grid--ver-desktop m-grid--desktop m-body">
        <?php include 'includes/main_menu.php' ?>

        <div class="m-grid__item m-grid__item--fluid m-wrapper">

            <?php include 'includes/subheader.php' ?>

            <!-- END: Subheader -->
            <div class="m-content">
                <div class="row">
                    <div class="col-lg-12">

                        <?php session()->showAlert() ?>

                        <form method="post" action="">

                            <?= csrf_field() ?>

                            <!--begin::Portlet-->
                            <div class="m-portlet m-portlet--last m-portlet--head-lg m-portlet--responsive-mobile">
                                <div class="m-portlet__head">
                                    <div class="m-portlet__head-progress">
                                        <!-- here can place a progress bar-->
                                    </div>
                                    <div class="m-portlet__head-wrapper">

                                        <?php include 'includes/portlet_header.php' ?>

                                        <div class="m-portlet__head-tools">
                                            <a href="<?= usersRoute() ?>"
                                               class="btn btn-secondary m-btn m-btn--icon m-btn--wide m-btn--md m--margin-right-10">
                                                <i class="la la-arrow-right"></i>
                                                بازگشت
                                            </a>

                                            <div class="btn-group">
                                                <button type="submit" name="submit_item" id="submit_item"
                                                        class="btn btn-accent m-btn m-btn--icon m-btn--wide m-btn--md">
                                                    <i class="la la-check"></i>
                                                    ذخیره
                                                </button>
                                            </div>

                                            <?php include 'includes/help_button.php' ?>
                                        </div>
                                    </div>
                                </div>
                            </div>

                            <div class="row">
                                <div class="col-lg-12">

                                    <div class="m-portlet m-portlet--last portlet--fancy portlet--accent m-portlet--head-lg m-portlet--responsive-mobile" id="main-fields-wrapper" style="margin-top: 30px">
                                        <div class="m-portlet__body">
                                            <div class="m-portlet__body form-float-input">

                                                <?php foreach ($editableRules as $rule => $rule_name) : ?>
                                                    <div class="form-group m-form__group row">
                                                        <h3 class="m-form__section black">دسترسی های <?= $rule_name ?></h3>
                                                    </div>

                                                    <div class="form-group m-form__group row">
                                                        <?php foreach ($modules as $module) : ?>
                                                            <div class="col-lg-4">
                                                                <label class="m-checkbox m-checkbox-medium m-checkbox--state-success">
                                                                    <input name="<?= $rule ?>[]" type="checkbox" value="<?= $module->id ?>"
                                                                    <?= ($UserLevels->hasAccessTo($module->module_code, $rule)) ? " checked " : null ?>
                                                                    > <?= $module->module_name ?>
                                                                    <span></span>
                                                                </label>
                                                            </div>
                                                        <?php endforeach; ?>
                                                    </div>

                                                <?php endforeach; ?>

                                            </div>
                                        </div>
                                    </div>


                                </div>
                            </div>

                        </form>

                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- end:: Body -->

    <?php include 'includes/footer.php' ?>
</div>

<?php include 'includes/quick_navs.php' ?>

<?php include 'includes/scripts.php' ?>
</body>
</html>

