<?php

use Admin\Ads;
use Admin\User;
use App\Affiliate;
use App\Order;

include 'init.php';

$page_slug = 'users-profile';
include 'check_auth.php';


if (inputs()->not_empty('id')) {
    $userId = input('id');
} else {
    $userId = $loggedUser->USER_ID;
}

$User = new User();
$user = $User->findById($userId);
if (! $user) {
    abort();
}

$Ads = new Ads();
$Affiliate = new Affiliate();
$Order = new Order();

$payments = $Order->userPayments($user->USER_ID);
?>
<!DOCTYPE html>

<html lang="<?= setting('SITE_LANGUAGE_SIGN') ?>">
<head>
    <?php include 'includes/head.php'; ?>
</head>

<body class="<?= bodyClass($current_page) ?>">

<div class="m-grid m-grid--hor m-grid--root m-page">

    <!-- BEGIN: Left Aside -->
    <?php include 'includes/header.php' ?>
    <!-- END: Left Aside -->

    <!-- begin::Body -->
    <div class="m-grid__item m-grid__item--fluid m-grid m-grid--ver-desktop m-grid--desktop m-body">
        <?php include 'includes/main_menu.php' ?>

        <div class="m-grid__item m-grid__item--fluid m-wrapper">

            <?php include 'includes/subheader.php' ?>

            <!-- END: Subheader -->
            <div class="m-content">
                <div class="row">

                    <?php session()->showAlert() ?>

                    <div class="col-xl-3 col-lg-4">
                        <?php include 'includes/user/_sidebar.php' ?>
                    </div>
                    <div class="col-xl-9 col-lg-8">
                        <?php include 'includes/user/profile/_profile.php' ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- end:: Body -->

    <?php include 'includes/footer.php' ?>
</div>

<?php include 'includes/quick_navs.php' ?>

<?php include 'includes/scripts.php' ?>
<?php include 'includes/_validate_js_variables.php' ?>

<!-- plugins -->

<script type="text/javascript" src="vendors/ckeditor/ckeditor.js"></script>
<script type="text/javascript" src="../public/lib/simple-ajax-uploader/SimpleAjaxUploader.min.js"></script>

<script>
    var images_count = "<?php echo $start_images_count ?>";
    var long = "<?php echo setting('DEFAULT_LONG') ?>";
    var lat  = "<?php echo setting('DEFAULT_LAT') ?>";
</script>

<!-- scripts -->
<script src="assets/app/js/custom/pages/category-custom-field.js"></script>
<script src="assets/app/js/custom/pages/upload.js"></script>
<script src="assets/app/js/custom/pages/validate_ads.js"></script>

<script src="assets/demo/custom/locations.min.js"></script>
<script src="assets/demo/custom/remote-select.js"></script>
<script src="vendors/ckeditor/ckeditor.js"></script>

<script>

    startCKEditor('frm_description');
    initiateSelect2();
    initiateSelect2Tags();

    if (isGoogleMaps()) {
        initializeGoogleLocationPicker(
            'location_picker',
            "<?php echo setting('DEFAULT_LAT') ?>",
            "<?php echo setting('DEFAULT_LONG') ?>",
            14
        );
    }

    if (isLeafletMaps() || isNeshanMaps()) {
        initialiseAdvancedLeafletLocationPicker(
            "location_picker",
            "<?php echo setting('DEFAULT_LAT') ?>",
            "<?php echo setting('DEFAULT_LONG') ?>",
            12
        );
    }

</script>
</body>
</html>

