<?php

use Admin\Pagination;
use Admin\User;

include 'init.php';

$page_slug = 'users-list';
include 'check_auth.php';

if (isPost() && token()->check()) {
    include ('process/user/_bulk_actions.php');
}
?>
<!DOCTYPE html>

<html lang="<?= setting('SITE_LANGUAGE_SIGN') ?>">
<head>
    <?php include 'includes/head.php'; ?>
</head>

<body class="<?= bodyClass($current_page) ?>">

<div class="m-grid m-grid--hor m-grid--root m-page">

    <?php include 'includes/header.php' ?>

    <!-- begin::Body -->
    <div class="m-grid__item m-grid__item--fluid m-grid m-grid--ver-desktop m-grid--desktop m-body">
        <?php include 'includes/main_menu.php' ?>

        <div class="m-grid__item m-grid__item--fluid m-wrapper">

            <?php include 'includes/subheader.php' ?>

            <!-- END: Subheader -->
            <div class="m-content">
                <div class="m-alert m-alert--icon m-alert--air m-alert--square alert alert-dismissible m--margin-bottom-30" role="alert">
                    <div class="m-alert__icon">
                        <i class="flaticon-exclamation m--font-primary"></i>
                    </div>
                    <div class="m-alert__text">
                        در صورتی که هیچ فیلتری اعمال نشده باشد صرفا <strong><?= setting('ADMIN_PANEL_NOT_FILTERED_ADS_COUNT') ?></strong> مورد آخر
                        <?php if (! isDemoMode()) : ?>
                            (که طی یک ماه اخیر ثبت شده باشند)
                        <?php endif; ?>
                        نمایش داده خواهد شد. برای مشاهده نتایج بیشتر از بخش فیلتر استفاده نمایید
                    </div>
                </div>

                <?php session()->showAlert() ?>

                <div class="m-portlet m-portlet--mobile">
                    <div class="m-portlet__head">

                        <?php include 'includes/portlet_header.php' ?>

                        <div class="m-portlet__head-tools">
                            <a href="<?= usersRoute('create') ?>" class="btn btn-info m-btn m-btn--custom m-btn--icon m-btn--air portlet-action-button">
                                <span><i class="la la-plus"></i><span>افزودن کاربر جدید</span></span>
                            </a>
                            <ul class="m-portlet__nav">
                                <li class="m-portlet__nav-item">
                                    <div class="m-dropdown m-dropdown--inline m-dropdown--arrow m-dropdown--align-right m-dropdown--align-push" m-dropdown-toggle="hover" aria-expanded="true">
                                        <a href="#" class="m-portlet__nav-link btn btn-lg btn-secondary  m-btn m-btn--icon m-btn--icon-only m-btn--pill  m-dropdown__toggle">
                                            <i class="la la-ellipsis-h m--font-brand"></i>
                                        </a>
                                        <div class="m-dropdown__wrapper">
                                            <span class="m-dropdown__arrow m-dropdown__arrow--right m-dropdown__arrow--adjust"></span>
                                            <div class="m-dropdown__inner">
                                                <div class="m-dropdown__body">
                                                    <div class="m-dropdown__content">

                                                        <form action="" method="post" class="nav-menu-form">
                                                            <?= csrf_field() ?>

                                                            <input type="hidden" name="action">

                                                            <ul class="m-nav">
                                                                <li class="m-nav__section m-nav__section--first">
                                                                    <span class="m-nav__section-text">عملیات ها</span>
                                                                </li>
                                                                <li class="m-nav__item">
                                                                    <a href="javascript:" class="m-nav__link" data-click-to-submit data-action="activate">
                                                                        <i class="m-nav__link-icon fa fa-check"></i>
                                                                        <span class="m-nav__link-text">فعال</span>
                                                                    </a>
                                                                </li>
                                                                <li class="m-nav__item">
                                                                    <a href="javascript:" class="m-nav__link" data-click-to-submit data-action="deactivate">
                                                                        <i class="m-nav__link-icon fa fa-exclamation-circle"></i>
                                                                        <span class="m-nav__link-text">غیرفعال</span>
                                                                    </a>
                                                                </li>
                                                                <li class="m-nav__item">
                                                                    <a href="javascript:" class="m-nav__link" data-click-to-submit data-action="delete" data-irreversible="true">
                                                                        <i class="m-nav__link-icon fa fa-times"></i>
                                                                        <span class="m-nav__link-text">حذف</span>
                                                                    </a>
                                                                </li>

                                                                <?php if ($current_page->hasHelp()) : ?>
                                                                <li class="m-nav__section">
                                                                    <span class="m-nav__section-text">لینک های مفید</span>
                                                                </li>
                                                                <li class="m-nav__item">
                                                                    <a href="javascript:" class="m-nav__link" data-toggle="modal" data-target="#helpModal">
                                                                        <i class="m-nav__link-icon fa fa-question-circle"></i>
                                                                        <span class="m-nav__link-text">راهنما</span>
                                                                    </a>
                                                                </li>
                                                                <?php endif; ?>

                                                                <li class="m-nav__separator m-nav__separator--fit m--hide"></li>

                                                                <li class="m-nav__item m--hide">
                                                                    <a href="#" class="btn btn-outline-danger m-btn m-btn--pill m-btn--wide btn-sm">Submit</a>
                                                                </li>
                                                            </ul>
                                                        </form>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </li>
                            </ul>
                        </div>
                    </div>
                    <div class="m-portlet__body">

                        <!--begin::Section-->
                        <div class="m-section">

                            <div class="m-section__content">
                                <form class="m-form m-form--fit m--margin-bottom-20">
                                    <div class="row m--margin-bottom-20">
                                        <div class="col-lg-1 m--margin-bottom-10-tablet-and-mobile">
                                            <label for="id">شناسه:</label>
                                            <input type="text" name="id" id="id" class="form-control m-input" value="<?= input('id') ?>">
                                        </div>
                                        <div class="col-lg-3 m--margin-bottom-10-tablet-and-mobile">
                                            <label for="username">نام کاربری، ایمیل یا تلفن:</label>
                                            <input type="text" name="username" id="username" class="form-control m-input" value="<?= input('username') ?>">
                                        </div>
                                        <div class="col-lg-2 m--margin-bottom-10-tablet-and-mobile">
                                            <label for="name">نام:</label>
                                            <input type="text" name="name" id="name" class="form-control m-input" value="<?= input('name') ?>">
                                        </div>
                                        <div class="col-lg-2 m--margin-bottom-10-tablet-and-mobile">
                                            <label for="status">وضعیت :</label>
                                            <select class="form-control m-bootstrap-select selectpicker" name="status" id="type">
                                                <option value="0">همه</option>
                                                <option value="2" <?= activeState(input('status'), 2) ?> >فعال</option>
                                                <option value="1" <?= activeState(input('status'), 1) ?> >غیرفعال</option>
                                            </select>
                                        </div>
                                        <div class="col-lg-2 m--margin-bottom-10-tablet-and-mobile">
                                            <label for="time">فیلتر زمانی :</label>
                                            <select class="form-control m-bootstrap-select selectpicker" name="time" id="type" data-col-index="2">
                                                <option value="0" <?= inputs()->is_set('time') || input('time') == 0 ? "selected" : false ?> >پیش فرض</option>
                                                <option value="today" <?= activeState(input('time'), 'today') ?> >امروز</option>
                                                <option value="1" <?= activeState(input('time'), 1) ?> > از 1 ماه قبل</option>
                                                <option value="3" <?= activeState(input('time'), 3) ?> > از 3 ماه قبل</option>
                                                <option value="6" <?= activeState(input('time'), 6) ?> > از 6 ماه قبل</option>
                                                <option value="12" <?= activeState(input('time'), 12) ?> >از یک سال قبل</option>
                                                <option value="all" <?= activeState(input('time'), 'all') ?> >همه  </option>
                                            </select>
                                        </div>


                                    </div>

                                    <div class="m-separator m-separator--dashed"></div>

                                    <div class="row text-right">
                                        <div class="col-lg-12">
                                            <a href="<?= usersRoute() ?>" class="btn btn-secondary m-btn m-btn--icon">
												<span>
													<i class="la la-close"></i>
													<span>پاک سازی</span>
												</span>
                                            </a>
                                            <button type="submit" class="btn btn-brand m-btn m-btn--icon">
												<span>
													<i class="la la-search"></i>
													<span>فیلتر</span>
												</span>
                                            </button>
                                        </div>
                                    </div>

                                </form>

                                <div class="table-responsive"  style="margin-top: 50px">
                                    <table class="table table-bordered m-table table-hover">
                                        <thead>
                                        <tr>
                                            <th>
                                                <label class="m-checkbox m-checkbox--air m-checkbox--solid">
                                                    <input type="checkbox" data-click-checks-all-rows>
                                                    <span></span>
                                                </label>
                                            </th>
                                            <th>شناسه</th>
                                            <th>نام کاربری</th>
                                            <th>نام</th>
                                            <th>ایمیل</th>
                                            <th>تلفن</th>
                                            <th>سطح دسترسی</th>
                                            <th> تاریخ عضویت</th>
                                            <th>وضعیت</th>
                                            <th>عملیات</th>
                                        </tr>
                                        </thead>
                                        <tbody>
                                            <?php
                                            $id = $username = $name = $status = $time = null;
                                            extract($_GET);

                                            $limited_days_for_not_filtered = 30;
//                                            $limited_days_for_not_filtered = 0;
                                            if (isDemoMode()) {
                                                $limited_days_for_not_filtered = 0;
                                            }

                                            $is_filtered = User::is_filtered($id, $username, $name, $status, $time);

                                            if ($is_filtered) {
                                                $count = User::countFiltered($id, $username, $name, $status, $time);
                                                $sql = User::filteredSQL(false, true, $id, $username, $name, $status, $time);
                                            } else {
                                                $count = 0;
                                                $sql = User::filteredSQL(false, false, $id, $username, $name, $status, $time, $limited_days_for_not_filtered);
                                            }

                                            $page = inputs()->not_empty('page') ? (int) input('page') : 1;
                                            $per_page = 15;
                                            $total_count = $count;

                                            $pagination = new Pagination($page, $per_page, $total_count);
                                            $pageParameters = array('id' => $id, 'username' => $username, 'name' => $name, 'status' => $status, 'time' => $time);
                                            $pagination->main_page = $pagination->makePageUrl(usersRoute(), $pageParameters);

                                            if ($is_filtered) {
                                                $pagination->sql = $sql;
                                                $sql = $pagination->correct_sql();
                                            }

                                            $users = User::find_by_sql($sql);

                                            if (! $users) {
                                                echo "<tr><td colspan='9' class='table-no-record-found'>هیچ رکوردی یافت نشد</td></tr>";
                                            }

                                            if ($users) :
                                                foreach ($users as $user) :
                                                    /** @var Admin\User $user */
                                            ?>
                                            <tr>
                                                <th scope="row">
                                                    <label class="m-checkbox"><input type="checkbox" class="to-be-checked" value="<?= $user->ID ?>"><span></span></label>
                                                </th>
                                                <td><?= $user->ID ?></td>
                                                <td><?= $user->username() ?></td>
                                                <td><?= $user->fullName() ?></td>
                                                <td><?= $user->email() ?></td>
                                                <td><?= $user->phone() ?></td>
                                                <td><?php echo $user->roleName() ?></td>
                                                <td><?= not_empty($user->USER_DATE_CREATED) ? miladiToShamsiAdmin($user->USER_DATE_CREATED, "Y/m/d") : null; ?></td>
                                                <td><?= $user->status() ?></td>

                                                <td class="m-datatable__cell">
                                                    <a href="<?= usersRoute('profile', $user->ID) ?>" class="m-portlet__nav-link btn m-btn m-btn--hover-brand m-btn--icon m-btn--icon-only m-btn--pill" title="مشاهده ">
                                                        <i class="la la-eye"></i>
                                                    </a>
                                                    <a href="<?= usersRoute('edit', $user->ID) ?>" class="m-portlet__nav-link btn m-btn m-btn--hover-accent m-btn--icon m-btn--icon-only m-btn--pill" title="ویرایش ">
                                                        <i class="la la-edit"></i>
                                                    </a>
                                                    <form class="form-inline" action="<?= $user->deleteLink() ?>" data-confirm-delete>
                                                        <button type="submit" class="m-portlet__nav-link btn m-btn m-btn--hover-danger m-btn--icon m-btn--icon-only m-btn--pill" title="حذف ">
                                                            <i class="la la-trash"></i>
                                                        </button>
                                                    </form>
                                                </td>
                                            </tr>
                                            <?php
                                                endforeach;
                                            endif;
                                            ?>

                                        </tbody>
                                    </table>

                                    <div class="clearfix"></div>
                                    <?php if ($is_filtered) : ?>
                                        <div class="dataTables_wrapper">
                                            <div class="dataTables_paginate paging_full_numbers">
                                                <ul class="pagination">
                                                    <?php $pagination->show_pagination() ?>
                                                </ul>
                                            </div>
                                        </div>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>

                        <!--end::Section-->
                    </div>

                    <!--end::Form-->
                </div>

            </div>
        </div>
    </div>

    <?php include 'includes/footer.php' ?>
</div>

<?php include 'includes/quick_navs.php' ?>

<?php include 'includes/scripts.php' ?>

<script src="assets/demo/custom/remote-select.js"></script>

<script>
    $('.selectpicker').selectpicker();
</script>
</body>
</html>

