<?php

use Admin\User;

include 'init.php';

$page_slug = 'users-edit';
include 'check_auth.php';


if (inputs()->not_empty('id')) {
    $userId = input('id');
} else {
    $userId = $loggedUser->USER_ID;
}

$User = new User();
$user = $User->findById($userId);
if (! $user) {
    abort();
}

/**
 * Handle User Info Updates
 */
if (isPost()) {
    checkDemoMode();

    include('process/user/_update.php');
}

$user_images_count = ($user->hasAvatar()) ? 1 : 0;
$start_images_count = 1;
$preuploaded_images_names[] = [
    'id' => 1,
    'name' => removeExtension(basename($loggedUser->avatar()))
];
?>
<!DOCTYPE html>

<html lang="<?= setting('SITE_LANGUAGE_SIGN') ?>">
<head>
    <?php include 'includes/head.php'; ?>
</head>

<body class="<?= bodyClass($current_page) ?>">

<div class="m-grid m-grid--hor m-grid--root m-page">

    <!-- BEGIN: Left Aside -->
    <?php include 'includes/header.php' ?>
    <!-- END: Left Aside -->

    <!-- begin::Body -->
    <div class="m-grid__item m-grid__item--fluid m-grid m-grid--ver-desktop m-grid--desktop m-body">
        <?php include 'includes/main_menu.php' ?>

        <div class="m-grid__item m-grid__item--fluid m-wrapper">

            <?php include 'includes/subheader.php' ?>

            <!-- END: Subheader -->
            <div class="m-content">
                <?php session()->showAlert() ?>

                <div class="row">

                    <div class="col-xl-3 col-lg-4">
                        <?php include 'includes/user/_sidebar.php' ?>
                    </div>
                    <div class="col-xl-9 col-lg-8 text-center">
                        <?php include 'includes/user/edit/_main.php' ?>
                    </div>
                </div>
            </div>
        </div>
    </div>
    <!-- end:: Body -->

    <?php include 'includes/footer.php' ?>
</div>

<?php include 'includes/quick_navs.php' ?>

<?php include 'includes/scripts.php' ?>
<?php include 'includes/_validate_js_variables.php' ?>

<script>
    var images_count = 1;
    var preuploaded_images_count = "<?php echo $user_images_count; ?>";
    var form_upload_url = "<?php echo $user->uploadLink() ?>";
    var preuploaded_images_names = <?php echo json_encode($preuploaded_images_names) ?>
</script>

<script type="text/javascript" src="../public/lib/simple-ajax-uploader/SimpleAjaxUploader.min.js"></script>

<!-- scripts -->
<script src="assets/app/js/custom/pages/upload_edit.js"></script>

</body>
</html>

