<?php

use Admin\Pagination;
use Admin\User;

include 'init.php';

$page_slug = 'users-database-email';
include 'check_auth.php';
checkDemoMode();

if (isPost() && token()->check()) {
    $file = "emails.txt";
    $text = fopen($file, "w") or die("Unable to open file!");

    $User = new User();
    $users = $User->allEmailsList();

    foreach ($users as $user) {
        fwrite($text, $user->EMAIL . "\r\n");
    }
    fclose($text);

    header('Content-Description: File Transfer');
    header('Content-Disposition: attachment; filename='.basename($file));
    header('Expires: 0');
    header('Cache-Control: must-revalidate');
    header('Pragma: public');
    header('Content-Length: ' . filesize($file));
    header("Content-Type: text/plain");
    readfile($file);
}
?>
<!DOCTYPE html>

<html lang="<?= setting('SITE_LANGUAGE_SIGN') ?>">
<head>
    <?php include 'includes/head.php'; ?>
</head>

<body class="<?= bodyClass($current_page) ?>">

<div class="m-grid m-grid--hor m-grid--root m-page">

    <?php include 'includes/header.php' ?>

    <!-- begin::Body -->
    <div class="m-grid__item m-grid__item--fluid m-grid m-grid--ver-desktop m-grid--desktop m-body">
        <?php include 'includes/main_menu.php' ?>

        <div class="m-grid__item m-grid__item--fluid m-wrapper">

            <?php include 'includes/subheader.php' ?>

            <!-- END: Subheader -->
            <div class="m-content">

                <?php session()->showAlert() ?>

                <div class="m-portlet m-portlet--mobile">
                    <div class="m-portlet__head">

                        <?php include 'includes/portlet_header.php' ?>

                        <div class="m-portlet__head-tools">
                            <form action="" method="post">
                                <?= csrf_field() ?>

                                <button type="submit" class="btn btn-info m-btn m-btn--custom m-btn--icon m-btn--air portlet-action-button">
                                    <span><i class="la la-cloud-download"></i><span>دریافت بانک ایمیل تمام کاربران</span></span>
                                </button>
                            </form>

                        </div>
                    </div>
                    <div class="m-portlet__body">

                        <!--begin::Section-->
                        <div class="m-section">

                            <div class="m-section__content">

                                <div class="table-responsive"  style="margin-top: 50px">
                                    <table class="table table-bordered m-table table-hover big-header">
                                        <thead>
                                        <tr>
                                            <th>شناسه</th>
                                            <th>ایمیل</th>
                                            <th>نام</th>
                                        </tr>
                                        </thead>
                                        <tbody>
                                            <?php
                                            $User = new User();

                                            $count = $User->countAllEmails();
                                            $sql = $User->allEmailsList(true);

                                            $page = inputs()->not_empty('page') ? (int) input('page') : 1;

                                            $per_page = 15;
                                            $total_count = $count;

                                            $pagination = new Pagination($page, $per_page, $total_count);

                                            $pagination->main_page = $pagination->makePageUrl(usersRoute('email-database'), []);

                                            $pagination->sql = $sql;
                                            $sql = $pagination->correct_sql();

                                            $items = User::find_by_sql($sql);

                                            if (! $items) {
                                                echo "<tr><td colspan='9' class='table-no-record-found'>هیچ رکوردی یافت نشد</td></tr>";
                                            }

                                            if ($items) :
                                                foreach ($items as $user) :
                                                    /** @var Admin\User $user */
                                            ?>
                                            <tr>
                                                <td><?= $user->ID ?></td>
                                                <td><a href="mailto:<?= $user->EMAIL ?>"><?= $user->EMAIL ?></a></td>
                                                <td><?= $user->NAME ?></td>
                                            </tr>
                                            <?php
                                                endforeach;
                                            endif;
                                            ?>

                                        </tbody>
                                    </table>

                                    <div class="clearfix"></div>
                                    <div class="dataTables_wrapper">
                                        <div class="dataTables_paginate paging_full_numbers">
                                            <ul class="pagination">
                                                <?php $pagination->show_pagination() ?>
                                            </ul>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!--end::Section-->
                    </div>

                    <!--end::Form-->
                </div>

            </div>
        </div>
    </div>

    <?php include 'includes/footer.php' ?>
</div>

<?php include 'includes/quick_navs.php' ?>

<?php include 'includes/scripts.php' ?>

<script src="assets/demo/custom/remote-select.js"></script>

<script>
    $('.selectpicker').selectpicker();
</script>
</body>
</html>

