<?php

use Admin\Pagination;
use App\Telegram;
use App\TelegramBox;

include 'init.php';

$page_slug = 'telegrambox-ads';
include 'check_auth.php';

/**
 * Bulk delete messages
 */
if (isPost() && token()->check()) {
    checkDemoMode();

    $checked = input('selected_values');
    if(count($checked)==0){
        redirect('refer');
    }

    try {
        $TelegramBox = new TelegramBox();
        $Telegram = new Telegram();
        foreach ($checked as $check) {
            $message = $TelegramBox->find($check);
            $Telegram->delete($message->message_id);
            $message->delete();
        }

        session()->success();
        redirect('refer');
    } catch (PDOException $e) {
        session()->error();
        redirect('refer');
    }
}
?>
<!DOCTYPE html>

<html lang="<?= setting('SITE_LANGUAGE_SIGN') ?>">
<head>
    <?php include 'includes/head.php'; ?>
</head>

<body class="<?= bodyClass($current_page) ?>">

<div class="m-grid m-grid--hor m-grid--root m-page">

    <?php include 'includes/header.php' ?>

    <!-- begin::Body -->
    <div class="m-grid__item m-grid__item--fluid m-grid m-grid--ver-desktop m-grid--desktop m-body">
        <?php include 'includes/main_menu.php' ?>

        <div class="m-grid__item m-grid__item--fluid m-wrapper">

            <?php include 'includes/subheader.php' ?>

            <!-- END: Subheader -->
            <div class="m-content">
                <div class="m-alert m-alert--icon m-alert--air m-alert--square alert alert-dismissible m--margin-bottom-30" role="alert">
                    <div class="m-alert__icon">
                        <i class="flaticon-exclamation m--font-primary"></i>
                    </div>
                    <div class="m-alert__text">
                        در صورتی که هیچ فیلتری اعمال نشده باشد صرفا <strong><?= setting('ADMIN_PANEL_NOT_FILTERED_ADS_COUNT') ?></strong> مورد آخر
                        <?php if (! isDemoMode()) : ?>
                            (که طی یک ماه اخیر ثبت شده باشند)
                        <?php endif; ?>
                        نمایش داده خواهد شد. برای مشاهده نتایج بیشتر از بخش فیلتر استفاده نمایید
                    </div>
                </div>

                <?php session()->showAlert() ?>

                <div class="m-portlet m-portlet--mobile">
                    <div class="m-portlet__head">

                        <?php include 'includes/portlet_header.php' ?>

                        <div class="m-portlet__head-tools">

                            <ul class="m-portlet__nav">
                                <li class="m-portlet__nav-item">
                                    <div class="m-dropdown m-dropdown--inline m-dropdown--arrow m-dropdown--align-right m-dropdown--align-push" m-dropdown-toggle="hover" aria-expanded="true">
                                        <a href="#" class="m-portlet__nav-link btn btn-lg btn-secondary  m-btn m-btn--icon m-btn--icon-only m-btn--pill  m-dropdown__toggle">
                                            <i class="la la-ellipsis-h m--font-brand"></i>
                                        </a>
                                        <div class="m-dropdown__wrapper">
                                            <span class="m-dropdown__arrow m-dropdown__arrow--right m-dropdown__arrow--adjust"></span>
                                            <div class="m-dropdown__inner">
                                                <div class="m-dropdown__body">
                                                    <div class="m-dropdown__content">

                                                        <form action="" method="post" class="nav-menu-form">
                                                            <?= csrf_field() ?>

                                                            <input type="hidden" name="action">

                                                            <ul class="m-nav">
                                                                <li class="m-nav__section m-nav__section--first">
                                                                    <span class="m-nav__section-text">عملیات ها</span>
                                                                </li>
                                                                <li class="m-nav__item">
                                                                    <a href="javascript:" class="m-nav__link" data-click-to-submit data-action="delete" data-irreversible="true">
                                                                        <i class="m-nav__link-icon fa fa-times"></i>
                                                                        <span class="m-nav__link-text">حذف</span>
                                                                    </a>
                                                                </li>

                                                                <?php if ($current_page->hasHelp()) : ?>
                                                                <li class="m-nav__section">
                                                                    <span class="m-nav__section-text">لینک های مفید</span>
                                                                </li>
                                                                <li class="m-nav__item">
                                                                    <a href="javascript:" class="m-nav__link" data-toggle="modal" data-target="#helpModal">
                                                                        <i class="m-nav__link-icon fa fa-question-circle"></i>
                                                                        <span class="m-nav__link-text">راهنما</span>
                                                                    </a>
                                                                </li>
                                                                <?php endif; ?>

                                                                <li class="m-nav__separator m-nav__separator--fit m--hide"></li>

                                                                <li class="m-nav__item m--hide">
                                                                    <a href="#" class="btn btn-outline-danger m-btn m-btn--pill m-btn--wide btn-sm">Submit</a>
                                                                </li>
                                                            </ul>
                                                        </form>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </li>
                            </ul>
                        </div>
                    </div>
                    <div class="m-portlet__body">

                        <!--begin::Section-->
                        <div class="m-section">

                            <div class="m-section__content">
                                <form class="m-form m-form--fit m--margin-bottom-20">
                                    <div class="row m--margin-bottom-20">
                                        <div class="col-lg-3 m--margin-bottom-10-tablet-and-mobile">
                                            <label for="message_id">شناسه پیام:</label>
                                            <input type="text" name="message_id" id="message_id" class="form-control m-input" value="<?= input('message_id') ?>">
                                        </div>
                                        <div class="col-lg-3 m--margin-bottom-10-tablet-and-mobile">
                                            <label for="post_id">شناسه آگهی:</label>
                                            <input type="text" name="post_id" id="post_id" class="form-control m-input" value="<?= input('post_id') ?>">
                                        </div>
                                        <div class="col-lg-3 m--margin-bottom-10-tablet-and-mobile">
                                            <label for="ads_title">عنوان آگهی:</label>
                                            <input type="text" name="ads_title" id="ads_title" class="form-control m-input" value="<?= input('ads_title') ?>">
                                        </div>

                                        <div class="col-lg-3 m--margin-bottom-10-tablet-and-mobile">
                                            <label for="time">فیلتر زمانی :</label>
                                            <select class="form-control m-bootstrap-select selectpicker" name="time" id="time" data-col-index="2">
                                                <option value="0" <?= inputs()->is_set('time') || input('time') == 0 ? "selected" : false ?> >پیش فرض</option>
                                                <option value="1" <?= activeState(input('time'), 1) ?> > از 1 ماه قبل</option>
                                                <option value="3" <?= activeState(input('time'), 3) ?> > از 3 ماه قبل</option>
                                                <option value="6" <?= activeState(input('time'), 6) ?> > از 6 ماه قبل</option>
                                                <option value="12" <?= activeState(input('time'), 12) ?> >از یک سال قبل</option>
                                                <option value="all" <?= activeState(input('time'), 'all') ?> >همه آگهی ها</option>
                                            </select>
                                        </div>

                                    </div>

                                    <div class="m-separator m-separator--dashed"></div>

                                    <div class="row text-right">
                                        <div class="col-lg-12">
                                            <a href="<?= telegramboxRoute('ads') ?>" class="btn btn-secondary m-btn m-btn--icon">
												<span>
													<i class="la la-close"></i>
													<span>پاک سازی</span>
												</span>
                                            </a>
                                            <button type="submit" class="btn btn-brand m-btn m-btn--icon">
												<span>
													<i class="la la-search"></i>
													<span>فیلتر</span>
												</span>
                                            </button>
                                        </div>
                                    </div>

                                </form>

                                <div class="table-responsive"  style="margin-top: 50px">
                                    <table class="table table-bordered m-table table-hover">
                                        <thead>
                                        <tr>
                                            <th>
                                                <label class="m-checkbox m-checkbox--air m-checkbox--solid">
                                                    <input type="checkbox" data-click-checks-all-rows>
                                                    <span></span>
                                                </label>
                                            </th>
                                            <th>شناسه پیام</th>
                                            <th>شناسه آگهی</th>
                                            <th>عنوان آگهی</th>
                                            <th>تاریخ ارسال</th>
                                            <th>عملیات</th>
                                        </tr>
                                        </thead>
                                        <tbody>
                                            <?php
                                            $message_id = $ads_title = $post_id = $time = null;
                                            extract($_GET);

                                            $limited_days_for_not_filtered = 30;
                                            if (isDemoMode()) {
                                                $limited_days_for_not_filtered = 0;
                                            }

                                            $is_filtered = TelegramBox::is_filtered($message_id, $ads_title, $post_id, $time);

                                            if ($is_filtered) {
                                                $count = TelegramBox::countFiltered('ads', $message_id, $ads_title, $post_id, $time);
                                                $sql = TelegramBox::filteredSQL('ads', false, true, $message_id, $ads_title, $post_id, $time);
                                            } else {
                                                $count = 0;
                                                $sql = TelegramBox::filteredSQL('ads',false, false, $message_id, $ads_title, $post_id, $time, $limited_days_for_not_filtered);
                                            }

                                            $page = inputs()->not_empty('page') ? (int) input('page') : 1;
                                            $per_page = 15;
                                            $total_count = $count;

                                            $pagination = new Pagination($page, $per_page, $total_count);
                                            $pageParameters = array('message_id' => $message_id, 'ads_title' => $ads_title, 'post_id' => $post_id, 'time' => $time);
                                            $pagination->main_page = $pagination->makePageUrl(telegramboxRoute('ads'), $pageParameters);

                                            if ($is_filtered) {
                                                $pagination->sql = $sql;
                                                $sql = $pagination->correct_sql();
                                            }

                                            $messages = TelegramBox::find_by_sql($sql);

                                            if (! $messages) {
                                                echo "<tr><td colspan='9' class='table-no-record-found'>هیچ رکوردی یافت نشد</td></tr>";
                                            }

                                            if ($messages) :
                                                $TelegramBox = new TelegramBox();
                                                $messages = $TelegramBox->eagerLoad('ads', $messages, 'post_id');

                                                /** @var TelegramBox $message */
                                                foreach ($messages as $message) :

                                            ?>
                                            <tr>
                                                <th scope="row">
                                                    <label class="m-checkbox"><input type="checkbox" class="to-be-checked" value="<?= $message->id ?>"><span></span></label>
                                                </th>
                                                <td><?= $message->message_id ?></td>
                                                <td><a href="<?= $message->ads()->shortLink() ?>" target="_blank"><?= $message->post_id ?></a></td>
                                                <td><a href="<?= $message->ads()->shortLink() ?>" target="_blank"><?= limit_word($message->ads()->ADS_TITLE,10) ?></a></td>
                                                <td><?= ($message->created_at > 0 && $message->created_at !== NULL) ? miladiToShamsiAdmin($message->created_at, "Y/m/d") : null ?></td>
                                                <td class="m-datatable__cell">
                                                    <form class="form-inline" action="<?= $message->deleteLink() ?>" data-confirm-delete>
                                                        <button type="submit" class="m-portlet__nav-link btn m-btn m-btn--hover-danger m-btn--icon m-btn--icon-only m-btn--pill" title="حذف">
                                                            <i class="la la-trash"></i>
                                                        </button>
                                                    </form>
                                                </td>
                                            </tr>
                                            <?php
                                                endforeach;
                                            endif;
                                            ?>
                                        </tbody>
                                    </table>

                                    <div class="clearfix"></div>
                                    <?php if ($is_filtered) : ?>
                                        <div class="dataTables_wrapper">
                                            <div class="dataTables_paginate paging_full_numbers">
                                                <ul class="pagination">
                                                    <?php $pagination->show_pagination() ?>
                                                </ul>
                                            </div>
                                        </div>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>

                        <!--end::Section-->
                    </div>

                    <!--end::Form-->
                </div>

            </div>
        </div>
    </div>

    <?php include 'includes/footer.php' ?>
</div>

<?php include 'includes/quick_navs.php' ?>

<?php include 'includes/scripts.php' ?>

<script src="assets/demo/custom/remote-select.js"></script>

<script>
    $('.selectpicker').selectpicker();
</script>
</body>
</html>

