<?php

use App\Visitor;

include 'init.php';

checkDemoMode();

$page_slug = 'support';
$check_access = false;
include 'check_auth.php';

$stats = new Visitor();
?>
<!DOCTYPE html>

<html lang="<?= setting('SITE_LANGUAGE_SIGN') ?>">
<head>
    <?php include 'includes/head.php'; ?>

    <!--begin::Page Vendors Styles -->
    <link rel="stylesheet" href="vendors/persianDatepicker/css/persianDatepicker-default.css"/>
</head>

<body class="<?= bodyClass($current_page) ?>">

    <div class="m-grid m-grid--hor m-grid--root m-page">

        <?php include 'includes/header.php' ?>

        <!-- begin::Body -->
        <div class="m-grid__item m-grid__item--fluid m-grid m-grid--ver-desktop m-grid--desktop m-body">
            <?php include 'includes/main_menu.php' ?>

            <div class="m-grid__item m-grid__item--fluid m-wrapper">
                <?php include 'includes/subheader.php' ?>

                <div class="m-content">

                    <?php include "includes/support/_dates_component.php" ?>

                    <div class="row">
                        <div class="col-md-6 col-xs-12">
                            <div class="m-portlet">
                                <div class="m-portlet__head">
                                    <div class="m-portlet__head-caption">
                                        <div class="m-portlet__head-title">
                                            <h3 class="m-portlet__head-text">
                                                تاریخچه دامنه
                                            </h3>
                                        </div>
                                    </div>
                                </div>
                                <div class="m-portlet__body">
                                    <div id="activities">
                                        <?php include 'includes/support/_activities_component.php'; ?>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <div class="col-md-6 col-xs-12">
                            <div class="m-portlet">
                                <div class="m-portlet__head">
                                    <div class="m-portlet__head-caption">
                                        <div class="m-portlet__head-title">
                                            <h3 class="m-portlet__head-text">
                                                اطلاعیه ها
                                            </h3>
                                        </div>
                                    </div>
                                </div>
                                <div class="m-portlet__body">
                                    <div id="callouts">
                                        <?php include 'includes/support/_callouts_component.php'; ?>
                                    </div>
                                </div>
                            </div>
                        </div>

                    </div>

                </div>

            </div>

        </div>
        <!-- end:: Body -->

        <?php include 'includes/footer.php' ?>
    </div>

    <?php include 'includes/quick_navs.php' ?>

    <?php include 'includes/scripts.php' ?>

    <script>

        var Globe__site_domain = "<?php echo setting('SITE_URL') ?>";
        var Globe__purchase_code = "<?php echo setting('SUPPORT__PURCHASE_CODE') ?>";
        var Globe__update_setting_url = "<?php echo ajaxRoute('update-support-dates') ?>"
        var vue__support_dates = {
            start_date: "<?php echo support()->startDate() ?>",
            end_date: "<?php echo support()->endDate() ?>",
            is_expired: "<?php echo support()->isExpired() ?>",
            days_passed: "<?php echo support()->isExpired() ? support()->daysPassed() : support()->daysLeft() ?>",
            extension_link: "<?php echo support()->extensionLink() ?>",
            support_link: "<?php echo support()->supportLink() ?>"
        }
    </script>

    <script src="assets/vendors/vue/vue.js"></script>
    <script src="assets/vendors/vue/axios.js"></script>
    <script src="assets/app/js/vue/support_dates.js" defer></script>
    <script src="assets/app/js/vue/support_activities.js" defer></script>
    <script src="assets/app/js/vue/support_callouts.js" defer></script>

</body>
</html>

