<?php

use Admin\Pagination;
use App\Category;
use App\SubCategory;

include 'init.php';

$page_slug = 'subcategories-list';
include 'check_auth.php';

if (isPost() && token()->check()) {
    include ('process/categories/_bulk_actions.php');
}

?>
<!DOCTYPE html>

<html lang="<?= setting('SITE_LANGUAGE_SIGN') ?>">
<head>
    <?php include 'includes/head.php'; ?>
</head>

<body class="<?= bodyClass($current_page) ?>">

<div class="m-grid m-grid--hor m-grid--root m-page">

    <?php include 'includes/header.php' ?>

    <!-- begin::Body -->
    <div class="m-grid__item m-grid__item--fluid m-grid m-grid--ver-desktop m-grid--desktop m-body">
        <?php include 'includes/main_menu.php' ?>

        <div class="m-grid__item m-grid__item--fluid m-wrapper">

            <?php include 'includes/subheader.php' ?>

            <!-- END: Subheader -->
            <div class="m-content">
                <div class="m-alert m-alert--icon m-alert--air m-alert--square alert alert-dismissible m--margin-bottom-30" role="alert">
                    <div class="m-alert__icon">
                        <i class="flaticon-exclamation m--font-primary"></i>
                    </div>
                    <div class="m-alert__text">
                        در صورتی که هیچ فیلتری اعمال نشده باشد صرفا <strong><?= setting('ADMIN_PANEL_NOT_FILTERED_ADS_COUNT') ?></strong> مورد آخر
                        <?php if (! isDemoMode()) : ?>
                            (که طی یک ماه اخیر ثبت شده باشند)
                        <?php endif; ?>
                        نمایش داده خواهد شد. برای مشاهده نتایج بیشتر از بخش فیلتر استفاده نمایید
                    </div>
                </div>

                <?php session()->showAlert() ?>

                <div class="m-portlet m-portlet--mobile">
                    <div class="m-portlet__head">

                        <?php include 'includes/portlet_header.php' ?>

                        <div class="m-portlet__head-tools">
                            <a href="<?= categoriesRoute('create') ?>" class="btn btn-info m-btn m-btn--custom m-btn--icon portlet-action-button">
                                <span><i class="la la-plus"></i><span>افزودن دسته جدید</span></span>
                            </a>
                            <ul class="m-portlet__nav">
                                <li class="m-portlet__nav-item">
                                    <div class="m-dropdown m-dropdown--inline m-dropdown--arrow m-dropdown--align-right m-dropdown--align-push" m-dropdown-toggle="hover" aria-expanded="true">
                                        <a href="#" class="m-portlet__nav-link btn btn-lg btn-secondary  m-btn m-btn--icon m-btn--icon-only m-btn--pill  m-dropdown__toggle">
                                            <i class="la la-ellipsis-h m--font-brand"></i>
                                        </a>
                                        <div class="m-dropdown__wrapper">
                                            <span class="m-dropdown__arrow m-dropdown__arrow--right m-dropdown__arrow--adjust"></span>
                                            <div class="m-dropdown__inner">
                                                <div class="m-dropdown__body">
                                                    <div class="m-dropdown__content">

                                                        <form action="" method="post" class="nav-menu-form">
                                                            <?= csrf_field() ?>

                                                            <input type="hidden" name="action">

                                                            <ul class="m-nav">
                                                                <li class="m-nav__section m-nav__section--first">
                                                                    <span class="m-nav__section-text">عملیات ها</span>
                                                                </li>
                                                                <li class="m-nav__item">
                                                                    <a href="javascript:" class="m-nav__link" data-click-to-submit data-action="enable">
                                                                        <i class="m-nav__link-icon fa fa-check-circle"></i>
                                                                        <span class="m-nav__link-text">فعال</span>
                                                                    </a>
                                                                </li>
                                                                <li class="m-nav__item">
                                                                    <a href="javascript:" class="m-nav__link" data-click-to-submit data-action="disable">
                                                                        <i class="m-nav__link-icon fa fa-ban"></i>
                                                                        <span class="m-nav__link-text">غیرفعال</span>
                                                                    </a>
                                                                </li>
                                                                <li class="m-nav__item">
                                                                    <a href="javascript:" class="m-nav__link" data-click-to-submit data-action="delete" data-irreversible="true">
                                                                        <i class="m-nav__link-icon fa fa-times-circle"></i>
                                                                        <span class="m-nav__link-text">حذف</span>
                                                                    </a>
                                                                </li>

                                                                <?php if ($current_page->hasHelp()) : ?>
                                                                    <li class="m-nav__section">
                                                                        <span class="m-nav__section-text">لینک های مفید</span>
                                                                    </li>
                                                                    <li class="m-nav__item">
                                                                        <a href="javascript:" class="m-nav__link" data-toggle="modal" data-target="#helpModal">
                                                                            <i class="m-nav__link-icon fa fa-question-circle"></i>
                                                                            <span class="m-nav__link-text">راهنما</span>
                                                                        </a>
                                                                    </li>
                                                                <?php endif; ?>

                                                                <li class="m-nav__separator m-nav__separator--fit m--hide"></li>

                                                                <li class="m-nav__item m--hide">
                                                                    <a href="#" class="btn btn-outline-danger m-btn m-btn--pill m-btn--wide btn-sm">Submit</a>
                                                                </li>
                                                            </ul>
                                                        </form>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </li>
                            </ul>
                        </div>
                    </div>
                    <div class="m-portlet__body">

                        <!--begin::Section-->
                        <div class="m-section">

                            <div class="m-section__content">
                                <form class="m-form m-form--fit m--margin-bottom-20">
                                    <div class="row m--margin-bottom-20">
                                        <div class="col-lg-2 m--margin-bottom-10-tablet-and-mobile">
                                            <label for="id">شناسه آگهی:</label>
                                            <input type="text" name="id" id="id" class="form-control m-input" value="<?= input('id') ?>">
                                        </div>
                                        <div class="col-lg-3 m--margin-bottom-10-tablet-and-mobile">
                                            <label for="name">عنوان:</label>
                                            <input type="text" name="name" id="name" class="form-control m-input" value="<?= input('name') ?>">
                                        </div>
                                        <div class="col-lg-2 m--margin-bottom-10-tablet-and-mobile">
                                            <label for="category">دسته:</label>
                                            <select class="form-control m-bootstrap-select selectpicker" name="category" id="category">
                                                <option value="0">همه</option>
                                                <?php
                                                $categories = (new Category())->lists(false);
                                                foreach ($categories as $category) {
                                                    echo "<option value='{$category->ID}' " . activeState($category->ID, input('category')) . ">{$category->CATEGORY_NAME}</option>";
                                                }
                                                ?>
                                            </select>
                                        </div>
                                        <div class="col-lg-2 m--margin-bottom-10-tablet-and-mobile">
                                            <label for="status">وضعیت:</label>
                                            <select class="form-control m-bootstrap-select selectpicker" name="status" id="status">
                                                <option value="0">همه</option>
                                                <option value="enable" <?= activeState(input('status'), 'enable') ?>>فعال</option>
                                                <option value="disable" <?= activeState(input('status'), 'disable') ?>>غیرفعال</option>
                                            </select>
                                        </div>

                                    </div>

                                    <div class="m-separator m-separator--dashed"></div>

                                    <div class="row text-right">
                                        <div class="col-lg-12">
                                            <a href="<?= subcategoriesRoute() ?>" class="btn btn-secondary m-btn m-btn--icon">
												<span>
													<i class="la la-close"></i>
													<span>پاک سازی</span>
												</span>
                                            </a>
                                            <button type="submit" class="btn btn-brand m-btn m-btn--icon">
												<span>
													<i class="la la-search"></i>
													<span>فیلتر</span>
												</span>
                                            </button>
                                        </div>
                                    </div>

                                </form>

                                <div class="table-responsive"  style="margin-top: 50px">
                                    <table class="table table-bordered m-table table-hover">
                                        <thead>
                                        <tr>
                                            <th>
                                                <label class="m-checkbox m-checkbox--air m-checkbox--solid">
                                                    <input type="checkbox" data-click-checks-all-rows>
                                                    <span></span>
                                                </label>
                                            </th>
                                            <th>شناسه</th>
                                            <th>نام زیردسته</th>
                                            <th>دسته مادر</th>
                                            <th>زیردسته مادر</th>
                                            <th>وضعیت</th>
                                            <th>عملیات</th>
                                        </tr>
                                        </thead>
                                        <tbody>
                                            <?php
                                            $id = $name = $category = $status = null;
                                            extract($_GET);

                                            $limited_days_for_not_filtered = 30;
//                                            $limited_days_for_not_filtered = 0;
                                            if (isDemoMode()) {
                                                $limited_days_for_not_filtered = 0;
                                            }

                                            $is_filtered = SubCategory::is_filtered($id, $name, $category, $status);

                                            if ($is_filtered) {
                                                $count = SubCategory::countFiltered($id, $name, $category, $status);
                                                $sql = SubCategory::filteredSQL(false, true, $id, $name, $category, $status);
                                            } else {
                                                $count = 0;
                                                $sql = SubCategory::filteredSQL(false, false, $id, $name, $category, $status, $limited_days_for_not_filtered);
                                            }

                                            $page = !empty($_GET['page']) ? (int)$_GET['page'] : 1;
                                            $per_page = 15;
                                            $total_count = $count;

                                            $pagination = new Pagination($page, $per_page, $total_count);
                                            $pageParameters = array('id' => $id, 'name' => $name, 'category' => $category, 'status' => $status);
                                            $pagination->main_page = $pagination->makePageUrl(subcategoriesRoute(), $pageParameters);

                                            if ($is_filtered) {
                                                $pagination->sql = $sql;
                                                $sql = $pagination->correct_sql();
                                            }

                                            $subcategories = SubCategory::find_by_sql($sql);

                                            if (! $subcategories) {
                                                echo "<tr><td colspan='9' class='table-no-record-found'>هیچ رکوردی یافت نشد</td></tr>";
                                            }


                                            if ($subcategories) :
                                            foreach ($subcategories as $subcategory) :
                                                /** @var SubCategory $subcategory */
                                            ?>
                                            <tr>
                                                <th scope="row">
                                                    <label class="m-checkbox"><input type="checkbox" class="to-be-checked" value="<?= $subcategory->ID ?>"><span></span></label>
                                                </th>
                                                <td><?=  $subcategory->ID ?></td>
                                                <td><?= $subcategory->name() ?></td>
                                                <td><?= $subcategory->categoryName() ?></td>
                                                <td><?= $subcategory->parentName() ?></td>
                                                <td><?= $subcategory->status() ?></td>
                                                <td class="m-datatable__cell">
                                                    <a href="<?= $subcategory->editLink() ?>" class="m-portlet__nav-link btn m-btn m-btn--hover-accent m-btn--icon m-btn--icon-only m-btn--pill" title="ویرایش ">
                                                        <i class="la la-edit"></i>
                                                    </a>
                                                    <form class="form-inline" action="<?= $subcategory->deleteLink() ?>" data-confirm-delete>
                                                        <button type="submit" class="m-portlet__nav-link btn m-btn m-btn--hover-danger m-btn--icon m-btn--icon-only m-btn--pill" title="حذف ">
                                                            <i class="la la-trash"></i>
                                                        </button>
                                                    </form>

                                                </td>
                                            </tr>
                                            <?php
                                                endforeach;
                                            endif;
                                            ?>

                                        </tbody>
                                    </table>

                                    <div class="clearfix"></div>
                                    <?php if ($is_filtered) : ?>
                                        <div class="dataTables_wrapper">
                                            <div class="dataTables_paginate paging_full_numbers">
                                                <ul class="pagination">
                                                    <?php $pagination->show_pagination() ?>
                                                </ul>
                                            </div>
                                        </div>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>

                        <!--end::Section-->
                    </div>

                    <!--end::Form-->
                </div>

            </div>
        </div>
    </div>

    <?php include 'includes/footer.php' ?>
</div>

<?php include 'includes/quick_navs.php' ?>

<?php include 'includes/scripts.php' ?>

<script src="assets/demo/custom/remote-select.js"></script>

<script>
    $('.selectpicker').selectpicker();
</script>
</body>
</html>

