<?php

use App\Visitor;

include 'init.php';

$page_slug = 'statistics';
$check_access = false;
include 'check_auth.php';

$stats = new Visitor();
?>
<!DOCTYPE html>

<html lang="<?= setting('SITE_LANGUAGE_SIGN') ?>">
<head>
    <?php include 'includes/head.php'; ?>

    <!--begin::Page Vendors Styles -->
    <link rel="stylesheet" href="vendors/persianDatepicker/css/persianDatepicker-default.css"/>
</head>

<body class="<?= bodyClass($current_page) ?>">

    <div class="m-grid m-grid--hor m-grid--root m-page">

        <?php include 'includes/header.php' ?>

        <!-- begin::Body -->
        <div class="m-grid__item m-grid__item--fluid m-grid m-grid--ver-desktop m-grid--desktop m-body">
            <?php include 'includes/main_menu.php' ?>

            <div class="m-grid__item m-grid__item--fluid m-wrapper">
                <?php include 'includes/subheader.php' ?>

                <div class="m-content">
                    <?php include "includes/statistics/_top.php" ?>
                    <?php include "includes/statistics/_monthly_chart.php" ?>
                </div>


            </div>

        </div>
        <!-- end:: Body -->

        <?php include 'includes/footer.php' ?>
    </div>

    <?php include 'includes/quick_navs.php' ?>

    <?php include 'includes/scripts.php' ?>

    <script>
        var Globe__page_url = "<?php echo statisticsRoues() ?>";
    </script>

    <script src="vendors/chart.js/dist/Chart.bundle.js" type="text/javascript"></script>

    <script src="vendors/persianDatepicker/js/persianDatepicker.min.js"></script>
    <script src="assets/app/js/custom/pages/order-report.js"></script>

    <script>
        initiateDatePickers();

        var days_array = [<?php echo $days_array ?>];
        var hits_array = [<?php echo $hits ?>];
        var unique_hits_array = [<?php echo $unique_hits ?>];

        initiateLineChart('hits-chart', 'بازدیدهای ماهانه', days_array, hits_array, 'success');
        initiateLineChart('unique-hits-chart', 'بازدیدهای یکتای ماهانه', days_array, unique_hits_array, 'warning');
    </script>
</body>
</html>

