<?php

use App\Sitemap;

include 'init.php';

$page_slug = 'sitemap-post';
include 'check_auth.php';

if (input('action') === "generate") {
    $allowed_types = ['post', 'category', 'tag'];
    $requested_sitemap_type = input('type');
    if (! in_array($requested_sitemap_type, $allowed_types)) {
        abort();
    }

    try {
        $Sitemap = new Sitemap();

        switch ($requested_sitemap_type) {
            case 'post' :
                $Sitemap->createPostSitemap();
                break;
            case 'category' :
                $Sitemap->createPostCategorySitemap();
                break;
            case 'tag' :
                $Sitemap->createPostTagSitemap();
                break;
        }

        session()->success('نقشه سایت با موفقیت به روز رسانی شد');
    } catch(Exception $e) {
        session()->error();
    }

    redirect('refer');
}
?>
<!DOCTYPE html>

<html lang="<?= setting('SITE_LANGUAGE_SIGN') ?>">
<head>
    <link rel="stylesheet" type="text/css" href="assets/demo/custom/custom.css"/>
    <?php include 'includes/head.php'; ?>
</head>

<body class="<?= bodyClass($current_page) ?>">

<div class="m-grid m-grid--hor m-grid--root m-page">

    <?php include 'includes/header.php' ?>

    <!-- begin::Body -->
    <div class="m-grid__item m-grid__item--fluid m-grid m-grid--ver-desktop m-grid--desktop m-body">
        <?php include 'includes/main_menu.php' ?>

        <div class="m-grid__item m-grid__item--fluid m-wrapper">

            <?php include 'includes/subheader.php' ?>

            <!-- END: Subheader -->
            <div class="m-content">
                <?php session()->showAlert() ?>

                <div class="m-portlet m-portlet--mobile">
                    <div class="m-portlet__head">

                        <?php include 'includes/portlet_header.php' ?>

                        <div class="m-portlet__head-tools">
                            <a href="<?= sitemapRoutes() ?>" class="btn btn-secondary m-btn m-btn--custom m-btn--icon portlet-action-button">
                                <span><i class="la la-arrow-right"></i><span>بازگشت</span></span>
                            </a>

                            <?php include 'includes/help_button.php' ?>
                        </div>

                    </div>
                    <div class="m-portlet__body">

                        <!--begin::Section-->
                        <div class="m-section">

                            <div class="m-section__content">

                                <div class="row sitemap-section">
                                    <div class="col-lg-4 sitemap-icon">
                                        <i class="fa fa-sitemap"></i> &nbsp;&nbsp;&nbsp;
                                        <i class="fa fa-pencil-alt"></i>
                                    </div>
                                    <div class="col-lg-8 sitemap-description">
                                        با استفاده از دکمه های زیر شما می توانید نقشه سایت خود را با فرمت xml بسازید و آن را در موتورهای جستجوگر مانند گوگل و ... ثبت نمایید <br />
                                        پیشنهاد می شود که نقشه سایت را با استفاده از این قسمت به طور منظم به روزرسانی نمایید. <br/>
                                        <span class='m-badge m-badge--square m-badge--warning'> توجه : </span> نقشه سایت ساخته شده ، به صورت خودکار در ریشه سایت شما قرار می گیرد تا توسط موتورهای جستجو قابل خواندن باشد . <br> برای مشاهده نقشه سایت پس از ساخته شدن <a href="<?= siteroot() ?>sitemap_index.xml" target="_blank"> اینجا کلیک نمایید </a>
                                    </div>
                                </div>

                                <div class="col-lg-12 m-t-40 text-center">
                                    <div style="width: 400px; margin: 0 auto; text-align: right">
                                        <a href="<?= sitemapRoutes('post', 'post') ?>" class="btn btn-info btn-outline btn-lg btn-x-large btn-block">
                                            <i class="fa fa-bullhorn"></i>
                                           نقشه سایت مطالب
                                        </a>
                                        <a href="<?= sitemapRoutes('post', 'category') ?>" class="btn btn-info btn-outline btn-lg btn-x-large btn-block">
                                            <i class="fa fa-align-right"></i>
                                            نقشه سایت دسته بندی مطالب
                                        </a>
                                        <a href="<?= sitemapRoutes('post', 'tag') ?>" class="btn btn-info btn-outline btn-lg btn-x-large btn-block">
                                            <i class="fa fa-tags"></i>
                                            نقشه سایت برچسب مطالب
                                        </a>
                                    </div>
                                </div>

                            </div>
                        </div>

                        <!--end::Section-->
                    </div>

                    <!--end::Form-->
                </div>

            </div>
        </div>
    </div>

    <?php include 'includes/footer.php' ?>
</div>

<?php include 'includes/quick_navs.php' ?>

<?php include 'includes/scripts.php' ?>

</body>
</html>

