<?php

use App\ColorPalette;

include 'init.php';

$page_slug = 'settings-pages--styles';
include 'check_auth.php';

$palettes = (new ColorPalette())->all();

$all_styles = [
    'colors' => [
        'HEADER' => 'رنگ پس زمینه هدر (منوی بالای سایت)',
        'BUTTONS' => 'رنگ عمومی بک گراند (دکمه ها و ...)',
        'ICONS' => 'رنگ عمومی آیکون ها:',
        'ICONS_ON_BUTTONS' => 'رنگ آیکون روی دکمه ها:',
        'REGISTER_BUTTON' => 'رنگ دکمه ثبت آگهی (بالای سایت)',
        'SEARCH_BACKGROUND' => 'رنگ پس زمینه قسمت جستجو صفحه اصلی',
        'FOOTER' => 'رنگ پس زمینه فوتر',
        'COPYRIGHT' => 'رنگ پس زمینه بخش کپی رایت',
        'PROFILE_INTRO' => 'رنگ پس زمینه ابتدای صفحه حساب کاربری'
    ]
];


if (isPost() && token()->check()) {
    include 'process/settings/_update_styles.php';
}
?>
<!DOCTYPE html>

<html lang="<?= setting('SITE_LANGUAGE_SIGN') ?>">
<head>
    <?php include 'includes/head.php'; ?>
    <link rel="stylesheet" href="vendors/bootstrap-colorpicker/dist/bootstrap-colorpicker.css">
</head>

<body class="<?= bodyClass($current_page) ?>">

<div class="m-grid m-grid--hor m-grid--root m-page">

    <!-- BEGIN: Left Aside -->
    <?php include 'includes/header.php' ?>
    <!-- END: Left Aside -->

    <!-- begin::Body -->
    <div class="m-grid__item m-grid__item--fluid m-grid m-grid--ver-desktop m-grid--desktop m-body">
        <?php include 'includes/main_menu.php' ?>

        <div class="m-grid__item m-grid__item--fluid m-wrapper">

            <?php include 'includes/subheader.php' ?>

            <!-- END: Subheader -->
            <div class="m-content">

                <div class="row">

                    <div class="col-lg-12">
                        <?php session()->showAlert() ?>

                        <div class="row">
                            <div class="col-xl-3 col-lg-4">
                                <?php include 'includes/settings/pages/_sidebar.php' ?>
                            </div>
                            <div class="col-xl-9 col-lg-8">
                                <?php include 'includes/settings/pages/_styles.php' ?>
                            </div>
                        </div>
                    </div>

                </div>
            </div>
        </div>
    </div>
    <!-- end:: Body -->

    <?php include 'includes/footer.php' ?>
</div>

<?php include 'includes/quick_navs.php' ?>

<?php include 'includes/scripts.php' ?>

<script src="vendors/garand-sticky/jquery.sticky.js"></script>
<script src="vendors/bootstrap-colorpicker/dist/bootstrap-colorpicker.js"></script>

<script>
    $("#sidebar-menu").sticky({topSpacing:80, widthFromWrapper: false});

    initiateSelect2();
    $('.color-picker').each(function() {
        startColorPicker(this);
    })

</script>

</body>
</html>

