<?php

include 'init.php';

$page_slug = 'settings-pages--popup';
include 'check_auth.php';

if (isPost() && token()->check()) {

    /* move uploaded image to it's real destination */
    $uploaded_images = json_decode(input('uploaded_images'));
    $all_uploaded_images = json_decode(input('all_uploaded_images'));
    $images_root = "../images/popup/";

    if (!empty($uploaded_images) && count($uploaded_images) == 1) {
        $image = data_get($uploaded_images, 0);

        $source = $images_root . $image->name;
        $old_image = $images_root . setting('POPUP__IMAGE');

        if (is_file($source)) {
            $_POST['POPUP__IMAGE'] = $image->name;

            $key = array_search($image->name, $all_uploaded_images);
            if ($key == 0 || $key != false) {
                unset($all_uploaded_images[$key]);
            }

            unlink($old_image);
        }
    }

    /* delete redundant uploaded images */
    foreach ($all_uploaded_images as $image) {
        if (empty($image)) {
            continue;
        }

        $source = $images_root . $image->name;
        if (is_file($source)) {
            unlink($source);
        }
    }

    include 'process/settings/_update.php';
}
?>
<!DOCTYPE html>

<html lang="<?= setting('SITE_LANGUAGE_SIGN') ?>">
<head>
    <?php include 'includes/head.php'; ?>
</head>

<body class="<?= bodyClass($current_page) ?>">

<div class="m-grid m-grid--hor m-grid--root m-page">

    <!-- BEGIN: Left Aside -->
    <?php include 'includes/header.php' ?>
    <!-- END: Left Aside -->

    <!-- begin::Body -->
    <div class="m-grid__item m-grid__item--fluid m-grid m-grid--ver-desktop m-grid--desktop m-body">
        <?php include 'includes/main_menu.php' ?>

        <div class="m-grid__item m-grid__item--fluid m-wrapper">

            <?php include 'includes/subheader.php' ?>

            <!-- END: Subheader -->
            <div class="m-content">

                <div class="row">

                    <div class="col-lg-12">
                        <?php session()->showAlert() ?>

                        <form method="post" action="" id="submit-item-form">

                            <?= csrf_field() ?>

                            <div class="row">
                                <div class="col-xl-3 col-lg-4">
                                    <?php include 'includes/settings/pages/_sidebar.php' ?>
                                </div>
                                <div class="col-xl-9 col-lg-8">
                                    <?php include 'includes/settings/pages/_popup.php' ?>
                                </div>
                            </div>

                        </form>
                    </div>

                </div>
            </div>
        </div>
    </div>
    <!-- end:: Body -->

    <?php include 'includes/footer.php' ?>
    <?php include 'includes/_validate_js_variables.php' ?>
</div>

<?php include 'includes/quick_navs.php' ?>

<?php include 'includes/scripts.php' ?>

<?php
$preuploaded_images_names[] = [
    'id' => 1,
    'name' => removeExtension(basename(setting('POPUP__IMAGE')))
];
?>

<script>
    var images_count = "1";
    var preuploaded_images_count = "1";
    var form_upload_url = 'process/pr_upload_popup_ajax.php';
    var preuploaded_images_names = <?php echo json_encode($preuploaded_images_names) ?>
</script>

<script type="text/javascript" src="../public/lib/simple-ajax-uploader/SimpleAjaxUploader.min.js"></script>
<script src="vendors/garand-sticky/jquery.sticky.js"></script>

<!--scripts-->
<script src="assets/app/js/custom/pages/upload_edit.js"></script>

<script>
    $("#sidebar-menu").sticky({topSpacing: 80, widthFromWrapper: false});
</script>

</body>
</html>

