<?php

include 'init.php';

$page_slug = 'settings-main--maintenance';
include 'check_auth.php';

if (isPost() && token()->check()) {
    $reopen_date = date("Y-m-d H:i:s");

    if (inputs()->not_empty('REOPEN_DATE')) {
        $input_date = en_digits(input('REOPEN_DATE'));

        if (inputs()->not_empty('REOPEN_HOUR') && inputs()->not_empty('REOPEN_MINUTE')){
            $partial_date  = date('Y-m-d', partial_shamsi_to_mi_timestamp($input_date));
            $time  = en_digits(addZeroAtBeginning(input('REOPEN_HOUR')) . ':' . addZeroAtBeginning(input('REOPEN_MINUTE')) . ':00');
            $reopen_date = "{$partial_date} {$time}";
        }else{
            $reopen_date  = date('Y-m-d H:i:s', partial_shamsi_to_mi_timestamp($input_date));
        }
    }

    $_POST['REOPEN_DATE'] = $reopen_date;

    include 'process/settings/_update.php';
}
?>
<!DOCTYPE html>

<html lang="<?= setting('SITE_LANGUAGE_SIGN') ?>">
<head>
    <?php include 'includes/head.php'; ?>
    <link rel="stylesheet" href="vendors/persianDatepicker/css/persianDatepicker-default.css"/>
</head>

<body class="<?= bodyClass($current_page) ?>">

<div class="m-grid m-grid--hor m-grid--root m-page">

    <!-- BEGIN: Left Aside -->
    <?php include 'includes/header.php' ?>
    <!-- END: Left Aside -->

    <!-- begin::Body -->
    <div class="m-grid__item m-grid__item--fluid m-grid m-grid--ver-desktop m-grid--desktop m-body">
        <?php include 'includes/main_menu.php' ?>

        <div class="m-grid__item m-grid__item--fluid m-wrapper">

            <?php include 'includes/subheader.php' ?>

            <!-- END: Subheader -->
            <div class="m-content">

                <div class="row">

                    <div class="col-lg-12">
                        <?php session()->showAlert() ?>

                        <form method="post" action="" id="submit-item-form">

                            <?= csrf_field() ?>

                            <div class="row">
                                <div class="col-xl-3 col-lg-4">
                                    <?php include 'includes/settings/main/_sidebar.php' ?>
                                </div>
                                <div class="col-xl-9 col-lg-8">
                                    <?php include 'includes/settings/main/_maintenance.php' ?>
                                </div>
                            </div>

                        </form>
                    </div>

                </div>
            </div>
        </div>
    </div>
    <!-- end:: Body -->

    <?php include 'includes/footer.php' ?>
</div>

<?php include 'includes/quick_navs.php' ?>

<?php include 'includes/scripts.php' ?>

<script src="vendors/garand-sticky/jquery.sticky.js"></script>
<script src="vendors/persianDatepicker/js/persianDatepicker.min.js"></script>
<script src="vendors/ckeditor/ckeditor.js"></script>

<script>
    $("#sidebar-menu").sticky({topSpacing:80, widthFromWrapper: false});
    initiateDatePickers();
    startCKEditor('MAINTENANCE_TEXT');
</script>

</body>
</html>

