<?php
function submitLink() {
    return siteroot() . 'new';
}
function priceListLink() {
    return siteroot() . 'pricing';
}
function demoPageUrl()
{
    return adminroot() . 'restrict/demo';
}
function pageLink($page_slug)
{
    return siteroot() . "page/{$page_slug}";
}
function iconListLink() {
    return siteroot() . 'help/font-awesome';
}
function contactUsLink()
{
    return pageLink('contact-us');
}
function blogLink() {
    return siteroot() . 'blog';
}

/**
 * Returns the route to ads CRUD
 *
 * @param  string $action :: null|create|edit
 * @param  int $id :: for edit action
 * @return string Route
 */
function adsRoute($action = null, $id = null, $query_strings = [])
{
    if ($action === 'create') {
        return adminroot() . 'ads/create';
    }
    if ($action === 'edit') {
        return adminroot() . "ads/{$id}/edit";
    }
    if ($action === 'delete') {
        return adminroot() . "ads/{$id}/delete";
    }
    if ($action === 'mutate') {
        return adminroot() . "ads/{$id}/mutate";
    }

    if (count($query_strings) > 0) {
        return adminroot() . 'ads?' . http_build_query($query_strings);
    }

    return adminroot() . 'ads';
}

/**
 * Returns the route to comments CRUD
 *
 * @param  string $action :: null|create|edit
 * @param  int $id :: for edit action
 * @param string $type
 * @return String Route
 */
function commentsRoute($action = null, $id = null, $type = 'ads')
{

    if ($action === 'edit') {
        return adminroot() . "comments/{$id}/edit";
    }
    if ($action === 'delete') {
        return adminroot() . "comments/{$id}/delete";
    }

    return adminroot() . "{$type}/comments";
}

/**
 * Returns the route to orders CRUD
 *
 * @param  string $action :: null|view|verify|delete|bank
 * @param  int $id
 * @return String Route
 */
function ordersRoute($action = null, $id = null)
{
    if ($action === 'view') {
        return adminroot() . "orders/{$id}/view";
    }
    if ($action === 'verify') {
        return adminroot() . "orders/{$id}/verify";
    }
    if ($action === 'delete') {
        return adminroot() . "orders/{$id}/delete";
    }
    if ($action === 'bacs') {
        return adminroot() . "orders/bacs";
    }
    if ($action === 'online') {
        return adminroot() . "orders/online";
    }
    if ($action === 'report') {
        return adminroot() . "orders/report";
    }

    return adminroot() . 'orders/online';
}

/**
 * Returns the route to coupons CRUD
 *
 * @param  string $action :: null|create|edit
 * @param  int $id :: for edit action
 * @return String Route
 */
function couponsRoute($action = null, $id = null)
{
    if ($action === 'create') {
        return adminroot() . 'coupons/create';
    }
    if ($action === 'edit') {
        return adminroot() . "coupons/{$id}/edit";
    }
    if ($action === 'delete') {
        return adminroot() . "coupons/{$id}/delete";
    }

    return adminroot() . 'coupons';
}

/**
 * Returns the route to coupons CRUD
 *
 * @param  string $action :: null|create|edit
 * @param  int $id :: for edit action
 * @return String Route
 */
function postsRoute($action = null, $id = null)
{
    if ($action === 'create') {
        return adminroot() . 'posts/create';
    }
    if ($action === 'edit') {
        return adminroot() . "posts/{$id}/edit";
    }
    if ($action === 'delete') {
        return adminroot() . "posts/{$id}/delete";
    }

    return adminroot() . 'posts';
}

/**
 * Returns the route to telegrambox list
 *
 * @param  string $action :: ads|post
 * @param null $id
 * @return String Route
 */
function telegramboxRoute($action, $id = null)
{
    if ($action === 'ads') {
        return adminroot() . 'ads/telegrambox';
    }
    if ($action === 'post') {
        return adminroot() . "posts/telegrambox";
    }
    if ($action === 'delete') {
        return adminroot() . "telegrambox/{$id}/delete";
    }

    return false;
}

/**
 * Returns the route to plans CRUD
 *
 * @param  string $action :: null|create|edit
 * @param  int $id :: for edit action
 * @return String Route
 */
function plansRoute($action = null, $id = null)
{
    if ($action === 'create') {
        return adminroot() . 'plans/create';
    }
    if ($action === 'edit') {
        return adminroot() . "plans/{$id}/edit";
    }
    if ($action === 'delete') {
        return adminroot() . "plans/{$id}/delete";
    }

    return adminroot() . 'plans';
}

/**
 * Returns the route to users CRUD
 *
 * @param  string $action :: null|create|edit|profile|roles
 * @param  int $id :: for edit action
 * @return String Route
 */
function usersRoute($action = null, $id = null, $query_strings = [])
{
    if ($action === 'create') {
        return adminroot() . 'users/create';
    }
    if ($action === 'delete') {
        return adminroot() . "users/{$id}/delete";
    }
    if ($action === 'profile') {
        return adminroot() . "users/{$id}/profile";
    }
    if ($action === 'edit') {
        return adminroot() . "users/{$id}/profile/edit";
    }
    if ($action === 'history') {
        return adminroot() . "users/{$id}/profile/history";
    }
    if ($action === 'messagebox') {
        return adminroot() . "users/{$id}/profile/messagebox";
    }
    if ($action === 'roles') {
        return adminroot() . "users/roles";
    }
    if ($action === 'email-database') {
        return adminroot() . "users/database/email";
    }
    if ($action === 'phone-database') {
        return adminroot() . "users/database/phone";
    }
    if ($action === 'fetch_email') {
        return adminroot() . "users/emails/fetch";
    }
    if ($action === 'fetch_mobile') {
        return adminroot() . "users/mobiles/fetch";
    }
    if ($action === 'upload') {
        return adminroot() . "users/{$id}/upload";
    }

    if (count($query_strings) > 0) {
        return adminroot() . 'users?' . http_build_query($query_strings);
    }

    return adminroot() . 'users';
}


/**
 * Returns the route to plans CRUD
 *
 * @param  string $action :: null|create|edit
 * @param  int $id :: for edit action
 * @return String Route
 */
function postCategoriesRoute($action = null, $id = null)
{
    if ($action === 'create') {
        return adminroot() . 'posts/categories/create';
    }
    if ($action === 'edit') {
        return adminroot() . "posts/categories/{$id}/edit";
    }
    if ($action === 'delete') {
        return adminroot() . "posts/categories/{$id}/delete";
    }

    return adminroot() . 'posts/categories';
}

/**
 * Returns the routes for global ajax requests
 *
 * @param  string $type
 * @return string $yrl
 */
function ajaxRoute($type)
{
    switch ($type) {
        case 'locations':
            return adminroot() . 'ajax/locations';
            break;
        case 'captcha':
            return siteroot() . 'ajax/captcha';
            break;
        case 'update-support-dates':
            return adminroot() . 'ajax/update-support-dates';
            break;
    }

    return false;
}

/**
 * Returns the route to pages CRUD
 *
 * @param null $action
 * @param null $id
 * @return String Route
 */
function pagesRoute($action = null, $id = null)
{
    if ($action === 'create') {
        return adminroot() . "pages/create";
    }
    if ($action === 'edit') {
        return adminroot() . "pages/{$id}/edit";
    }
    if ($action === 'delete') {
        return adminroot() . "pages/{$id}/delete";
    }

    return adminroot() . 'pages';
}

/**
 * Returns the routes for settings
 *
 * @param string $type
 * @param null|string $sub_type
 * @return string
 */
function settingsRoute($type, $sub_type = null)
{
    $url = adminroot() . "settings/{$type}";

    if (not_empty($sub_type)) {
        $url .= "/{$sub_type}";
    }

    return $url;
}

/**
 * Returns the routes for links CRUD
 *
 * @param null $action
 * @param null $id
 * @return string
 */
function linksRoute($action = null, $id = null)
{
    if ($action === 'create') {
        return adminroot() . "links/create";
    }
    if ($action === 'update') {
        return adminroot() . "links/{$id}/edit";
    }
    if ($action === 'delete') {
        return adminroot() . "links/{$id}/delete";
    }

    return adminroot() . "links";
}

/**
 * Returns the routes for categories CRUD
 *
 * @param null $action
 * @param null $id
 * @return string
 */
function categoriesRoute($action = null, $id = null)
{
    if ($action === 'create') {
        return adminroot() . "category/create";
    }
    if ($action === 'edit') {
        return adminroot() . "category/{$id}/edit?type=category";
    }
    if ($action === 'delete') {
        return adminroot() . "category/{$id}/delete";
    }
    if ($action === 'sort') {
        if (! empty($id)) {
            return adminroot() . "category/sort?category_id={$id}";
        }

        return adminroot() . "category/sort";
    }

    if ($action === 'custom-fields') {
        return adminroot() . "category/custom-fields";
    }

    if ($action === 'custom-field-builder') {
        return adminroot() . "category/custom-fields/builder";
    }

    return adminroot() . "category";
}

/**
 * Returns the routes for categories CRUD
 *
 * @param null $action
 * @param null $id
 * @return string
 */
function subcategoriesRoute($action = null, $id = null)
{
    if ($action === 'create') {
        return adminroot() . "category/create";
    }
    if ($action === 'edit') {
        return adminroot() . "category/{$id}/edit?type=subcategory";
    }
    if ($action === 'delete') {
        return adminroot() . "subcategory/{$id}/delete";
    }

    return adminroot() . "subcategory";
}

/**
 * Returns the route to location CRUD
 *
 * @param  string $action :: null|create|edit
 * @param  int $id :: for edit action
 * @param  string $type |null    :: state, city, zone
 * @return String Route
 */
function locationsRoute($action = null, $id = null, $type = null)
{
    if ($action === 'states' || $action === 'state') {
        return adminroot() . "locations/states";
    }
    if ($action === 'cities' || $action === 'city') {
        return adminroot() . "locations/cities";
    }
    if ($action === 'zones' || $action === 'zone') {
        return adminroot() . "locations/zones";
    }
    if ($action === 'create') {
        return adminroot() . 'locations/create';
    }
    if ($action === 'edit') {
        return adminroot() . "locations/{$id}/edit?type={$type}";
    }
    if ($action === 'delete') {
        return adminroot() . "locations/{$id}/delete";
    }

    return adminroot() . 'locations/states';
}


/**
 * Returns the route to location CRUD
 *
 * @param  string $action :: email|sms|edit
 * @return String Route
 */
function mailboxRoute($action = null)
{
    if ($action === 'email') {
        return adminroot() . "mailbox/email";
    }
    if ($action === 'sms') {
        return adminroot() . "mailbox/sms";
    }

    return adminroot() . "mailbox/email";
}

/**
 * Returns the route to menus CRUD
 *
 * @param null $action
 * @param null $id
 * @return String Route
 */
function menusRoute($action = null, $id = null)
{
    if ($action === 'create') {
        return adminroot() . "menu/create";
    }
    if ($action === 'sort') {
        return adminroot() . "menu/sort";
    }
    if ($action === 'edit') {
        return adminroot() . "menu/{$id}/edit";
    }
    if ($action === 'delete') {
        return adminroot() . "menu/{$id}/delete";
    }

    return adminroot() . 'menu';
}


/**
 * Returns the route to menus CRUD
 *
 * @param null $type
 * @param null $action
 * @param null $id
 * @return String Route
 */
function bannersRoute($type = null, $action = null, $id = null)
{
    $url = "";
    if ($type === 'adv') {
        $url = "banner/adv";
    }
    if ($type === 'slider') {
        $url = "banner/slider";
    }
    if ($type === 'affiliate') {
        $url = "banner/affiliate";
    }
    if ($type === 'app-slider') {
        $url = "banner/application-slider";
    }

    if ($action === 'create') {
        $url .= "?do=add";
    }

    if ($action === 'delete') {
        $url .= "?do=delete&id={$id}";
    }

    if ($action === 'update') {
        $url .= "?do=update&id={$id}";
    }

    return adminroot() . $url;
}

/**
 * Returns the Routes for withdrawal requests
 *
 * @param null $action
 * @param null $id
 * @return string
 */
function withdrawalRoute($action = null, $id = null)
{

    if ($action === 'settle') {
        return "withdraw/{$id}/settle";
    }
    if ($action === 'delete') {
        return "withdraw/{$id}/delete";
    }

    return 'withdraw';
}

/**
 * Returns the Routes for expiry messages requests
 *
 * @param string $type
 * @param null $action
 * @return string
 */
function expireMessagesRoute($type = 'email', $action = null)
{
    $url = 'expire/';

    if ($type === 'email') {
        $url .= "email";
    }
    if ($type === 'sms') {
        $url .= "sms";
    }

    if ($action === 'send') {
        $url .= "?do=send";
    }

    return adminroot() . $url;
}

/**
 * Returns the routes for backup CRUD
 *
 * @param $action
 * @param $id
 * @return string
 */
function backupRoute($action = null, $id = null)
{
    if ($action === 'create') {
        return adminroot() . 'backup/create';
    }
    if ($action === 'restore') {
        return adminroot() . "backup/{$id}/restore";
    }
    if ($action === 'delete') {
        return adminroot() . "backup/{$id}/delete";
    }
    if ($action === 'download') {
        return adminroot() . "backup/{$id}/download";
    }

    return adminroot() . 'backup';
}

/**
 * Returns the routes for policy Reports
 *
 * @param null $action
 * @param null $id
 * @return string
 */
function policyReportsRoute($action = null, $id = null)
{
    if ($action === 'delete') {
        return adminroot() . "ads/report/{$id}/delete";
    }

    return adminroot() . "ads/report";
}

/**
 * Returns the routes for sitemap
 *
 * @param null $type
 * @param null $action
 * @return string
 */
function sitemapRoutes($type = null, $action = null)
{
    $url = "";

    if ($type === 'ads') {
        $url .= adminroot() . 'sitemap/ads';
    }
    if ($type === 'post') {
        $url .= adminroot() . 'sitemap/post';
    }
    if ($type === 'main') {
        $url .= adminroot() . 'sitemap/main';
    }

    if (!empty($action)) {
        $url .= "/{$action}/";
    }

    return (! empty($url)) ? $url : adminroot() . 'sitemap';
}

function authRoutes($type = null) {
    $url = "";

    if ($type === 'login') {
        return adminroot() . 'auth/login';
    }

    if ($type === 'logout') {
        return adminroot() . 'auth/logout';
    }

    return $url;
}

function paletteRoutes($type = null, $id = null) {
    $url = "";

    if ($type === 'update') {
        return adminroot() . "palette/{$id}/update";
    }

    return $url;
}

function statisticsRoues() {
    return adminroot() . "statistics";
}

function supportRoute() {
    return adminroot() . "support";
}
