<?php

use Admin\User;
use App\Affiliate;
use App\WithdrawalRequest;

checkDemoMode();

$WithdrawalRequest = new WithdrawalRequest();
$Affiliate = new Affiliate();

/** @var WithdrawalRequest $request */
$request = $WithdrawalRequest->findById(input('id'));
$affiliate_ids = json_decode($request->referal_ids);

try {
    $db->beginTransaction();

    if ($affiliate_ids) {
        $affiliates = $Affiliate->byArrayOfIdsSimple($affiliate_ids, 'id');

        /** @var Affiliate $affiliate */
        foreach ($affiliates AS $affiliate) {
            $affiliate->settle();
        }
    }

    $request->settle();

    $db->commit();

    if (setting('SEND_EMAIL_AFTER_WITHDRAWAL_SETTLEMENT') === "YES") {
        $User = new User();
        $user = $User->findById($request->user_id);

        $WithdrawalRequest->sendWithdrawalSettledEmailToUser($user->EMAIL, $user->NAME, $user->USER_ID);
    }

    session()->success();
} catch (PDOException $e) {
    $db->rollBack();
    session()->error();
}

redirect('refer');