<?php
use App\ImageUpload;

require_once ('../../init.php');

if( ! isCountryAllowed() ) {
    return ajaxErrorResponse(_e('IP_OR_VPN_ERROR', true));
}
if( ! token()->checkForAjax() ) {
    return ajaxErrorResponse(_e('WRONG_CSRF_TOKEN', true));
}

$adm_options = generalSettings();

$image_name = rand(rand(1,8000), rand(10000, 900000));

$image = new ImageUpload();
$image->uploadName			= "estateImages";
$image->imgRoot 			= "../../../images/estate_images/app_temp/";
$image->thumbRoot 			= "../../../images/estate_images/app_temp/";
$image->addWatermark 		= false;
$image->makeThumb           = false;
$image->maxUploadCounts		= 1;
$image->resize              = true;
$image->maxSizeKB 			= setting('MAX_IMG_SIZE_KB');
$image->widthMain 			= config('images/avatar/width');
$image->heightMain 			= config('images/avatar/height');
$image->validFormats 		= array("jpg","jpeg", 'JPG', "JPEG");
$image->validMimeTypes      = array('image/jpeg');
$image->isOnlyJPG           = true;
$image->ajaxUpload          = true;
$image->customName          = $image_name . '.jpg';

$output['success'] = false;
$output['file_name'] = null;
$output['file_path'] = null;

if($image->make())
{
    $file_name = removeExtension($image->getFileName());
    $file_path = '../'. ltrim($image->getFilePath(), '../') . '?' . rand(1,500);

    return ajaxSuccessResponse(['file_name' => $file_name, 'file_path' => $file_path]);
}else{
    return ajaxErrorResponse($image->getError());
}
