<?php

use App\Validate;


/**
 * Update User General Info
 */
if (input('action') === 'edit_general_info') {
    $backUrl = $_SERVER['HTTP_REFERER'] . '#user-info';
    $website = input('website');
    $_POST['website'] = addHttp($website);

    $rules = array(
        'email' => array(
            'name' => 'آدرس ایمیل',
            'prefix' => 'وارد کردن',
            'email' => true,
            'unique' => 'tbl_users',
            'unique_column' => "EMAIL|{$user->USER_ID}"
        ),
        'phone' => array(
            'name' => _e('MOBILE_PHONE_NUMBER', true),
            'prefix' => 'وارد کردن',
            'mobile' => true,
            'unique' => 'tbl_users',
            'unique_column' => "TEL|{$user->USER_ID}"
        ),
        'website' => array(
            'url' => true
        )
    );

    $Validate = new Validate();
    $validation = $Validate->check($_POST, $rules);

    if ($validation->passed()) {
        $email = input('email');
        $mobile = input('phone');
        $verified_email = $user->VERIFIED_EMAIL;
        $verified_mobile = $user->VERIFIED_MOBILE;

        if ($user->hasVerifiedEmail()) {
            $verified_email = $email;
        }
        if ($user->hasVerifiedMobile()) {
            $verified_mobile = $mobile;
        }
        if (!registerNeedsActivation()) {
            $verified_email = $email;
            $verified_mobile = $mobile;
        }

        $User->updateGeneralInfo(
            $user->USER_ID,
            input('name'),
            $email,
            $mobile,
            $verified_email,
            $verified_mobile,
            input('credit_card'),
            input('address'),
            input('biography'),
            $website
        );
        $user->updateMetas(inputs()->metas());

        session()->success();
        redirect($backUrl);
    } else {
        session()->error($validation->errors(), true);
        redirect($backUrl);
    }
}

/**
 * Update user password
 */
if (input('action') === "change_password") {
    $backUrl = $_SERVER['HTTP_REFERER'] . '#change-password';

    $rules = array(
        'password' => array(
            'name' => 'رمز عبور',
            'prefix' => 'وارد کردن',
            'required' => true
        ),
        'password_confirmation' => array(
            'name' => 'تکرار رمز عبور',
            'prefix' => 'وارد کردن',
            'required' => true,
            'matches' => 'password'
        )
    );

    $Validate = new Validate();
    $validation = $Validate->check($_POST, $rules);

    if ($validation->passed()) {
        $user->changePassword(input('password'));
        session()->success('رمز عبور با موفقیت تغییر یافت');
        redirect($backUrl);
    } else {
        session()->error($validation->errors(), true);
        redirect($backUrl);
    }

}

/**
 * Update user's status
 */
if (input('action') === "change_status") {
    $backUrl = $_SERVER['HTTP_REFERER'] . '#user-status';
    checkAccess('USER_DELETE_CHANGE-STATUS');

    $rules = array(
        'user_type' => array(
            'name' => 'سطح کاربری',
            'required' => true,
            'in_array_pure' => array_keys($UserlevelsArray)
        ),
        'status' => array(
            'name' => 'وضعیت',
            'required' => true,
            'numeric' => true,
            'in_array' => '1|2|3',
        )
    );

    $Validate = new Validate();
    $validation = $Validate->check($_POST, $rules);
    if ($validation->passed()) {
        $user->updateStatus(input('user_type'), input('status'), input('free_ads_count'));
        session()->success();
        redirect($backUrl);
    } else {
        session()->error($validation->errors(), true);
        redirect($backUrl);
    }
}

/**
 * Update user logo
 */
if (input('action') === "change_avatar") {

    $backUrl = $_SERVER['HTTP_REFERER'] . '#change-avatar';
    checkAccess('USER_DELETE_CHANGE-STATUS');

    /* move uploaded images to it's real destination */
    $uploaded_images = json_decode(input('uploaded_images'));
    $all_uploaded_images = json_decode(input('all_uploaded_images'));

    $images_root = "../images/users_images/{$user->ID}/";

    $i = 1;
    foreach ($uploaded_images as $image) {
        if (empty($image->name)) {
            unlink($images_root . $i . '.jpg');

            $i++;
            continue;
        }

        if (file_exists($images_root . $image->name)) {
            $i++;
            continue;
        }

        $source_main = "../images/estate_images/app_temp/{$image->name}.jpg";
        $destination_main = $images_root . "{$i}.jpg";

        if (! is_file($source_main)) {
            continue;
        }

        if (! is_dir($images_root)) {
            mkdir($images_root);
        }

        rename($source_main, $destination_main);

        $key = array_search($image->name, $all_uploaded_images);
        if ($key == 0 || $key != false) {
            unset($all_uploaded_images[$key]);
        }

        $i++;
    }

    /* delete redundant uploaded images */
    foreach ($all_uploaded_images as $image) {
        if (empty($image)) {
            continue;
        }

        $source_main = "images/estate_images/app_temp/{$image}.jpg";

        if (is_file($source_main)) {
            unlink($source_main);
        }
    }

    session()->success('آپلود با موفقیت انجام شد');
    redirect($backUrl);
}