<?php

use App\ImageUpload;
use App\Setting;

require '../../init.php';
require_once '../../check_auth.php';

checkUserCountry();
checkDemoMode();

if (! isPost() || ! token()->check()) {
    session()->alert('error', _e('WRONG_CSRF_TOKEN', true));
    redirect('refer');
}

$type = input('type');
$admOptions = generalSettings();

$image = new ImageUpload();

$image->uploadName = "imageUpload";
$image->resize = false;
$image->makeThumb = false;
$image->renameIteration = false;
$image->imgRoot = "../../../images/";
$image->directUpload = true;
$image->customName = 'search-background';
$image->customNameAutoExtension = true;
$image->validFormats = ['jpg', 'jpeg', "png"];
$image->validMimeTypes = ['image/jpeg', 'image/png'];

if (! $image->make()) {
    session()->error($image->getError());
    redirect('refer');
}

(new Setting())->updateOne('TEMPLATE__SEARCH_BACKGROUND_IMAGE', $image->getFileName());

session()->success('آپلود با موفقیت انجام شد');
redirect('refer');
