<?php

use App\Exception\ImageUploadException;
use App\ImageUpload;
use App\ImageUploadDynamic;

require_once '../init.php';
require_once '../check_auth.php';

checkUserCountry();
checkDemoMode();

if (! isPost() || ! token()->check()) {
    session()->alert('error', _e('WRONG_CSRF_TOKEN', true));
    redirect('refer');
}

$type = input('type');
$admOptions = generalSettings();

$image = new ImageUpload();

$image->uploadName = "imageUpload";
$image->resize = false;
$image->makeThumb = false;
$image->renameIteration = false;

if ($type === "logo") {

    $image->imgRoot = "../../images/";
    $image->customName = 'logo.png';
    $image->directUpload = true;
    $image->validFormats = ['png', 'PNG'];
    $image->validMimeTypes = ['image/png'];
    $image->isOnlyPNG = true;

} elseif ($type === "profile_poster") {

    $image->imgRoot = "../../images/";
    $image->customName = 'profile_poster.jpg';
    $image->directUpload = true;
    $image->validFormats = array("jpg", "jpeg");
    $image->validFormats = ['jpg', 'jpeg'];
    $image->validMimeTypes = ['image/jpeg'];
    $image->isOnlyJPG = true;

} elseif ($type === "default_ads_image") {
    try {
        $ImageUploadDynamic = new ImageUploadDynamic([
            'input_name' => 'imageUpload',
            'root' => '../../images/estate_images/app_temp/',
            'copy_sizes' => $image_sizes,
            'add_watermark' => false,
            'valid_formats' => ['jpg', 'jpeg', 'JPG', "JPEG"],
            'valid_mime_types' => ['image/jpeg'],
            'only_jpg' => true
        ]);

        if ($ImageUploadDynamic->upload()) {
            $uploaded_path = $ImageUploadDynamic->uploadedName();

            rename($uploaded_path, '../../images/estate_images/default.jpg');

            foreach ($image_sizes as $size_name => $size_options) {
                rename(imageNameForSize($uploaded_path, $size_name), "../../images/estate_images/default-{$size_name}.jpg");
            }

            session()->success('آپلود با موفقیت انجام شد');
            redirect('refer');
        } else {
            session()->error($ImageUploadDynamic->errors());
            redirect('refer');
        }
    } catch (ImageUploadException $e) {
        session()->error($e->errors());
        redirect('refer');
    }
} elseif ($type === "watermark_image") {

    $image->imgRoot = "../../images/";
    $image->customName = 'watermark.png';
    $image->directUpload = true;
    $image->validFormats = ['png'];
    $image->validMimeTypes = ['image/png'];
    $image->isOnlyPNG = true;

} elseif ($type === "preload_image") {

    $image->imgRoot = "../../images/";
    $image->customName = 'page_preloader.gif';
    $image->directUpload = true;
    $image->validFormats = ['gif'];
    $image->validMimeTypes = ['image/gif'];

}

if ($image->make()) {
    session()->success('آپلود با موفقیت انجام شد');
    redirect('refer');
}

session()->error($image->getError());
redirect('refer');
