<?php

use App\ImageUpload;
use App\Session;

require_once '../init.php';
require_once '../check_auth.php';

checkUserCountry();
checkDemoMode();

if( ! isPost() || ! token()->check() ) {
	session()->alert('error', _e('WRONG_CSRF_TOKEN', true));
	redirect('refer');
}

function newFaviconUploaderInstance($width, $height, $custom_name = null) {
	$image = new ImageUpload();

	$image->uploadName			= "imageUpload";
	$image->renameIteration 	= false;
	$image->resize 				= true;
	$image->makeThumb 			= true;

	$image->resize 			= true;
	$image->imgRoot 	 	= "../../images/favicons/";
	$image->thumbRoot 	 	= "../../images/favicons/";
	$image->customName 	 	= 'favicon.png';
	$image->thumbCustomName = "favicon-{$width}x{$height}.png";
	$image->validFormats 	= ['png', 'PNG'];
	$image->validMimeTypes  = ['image/png'];
	$image->isOnlyPNG		= true;

	$image->widthMain 		= 80;
	$image->heightMain 		= 80;
	$image->widthThumb 		= $width;
	$image->heightThumb 	= $height;

	if( ! empty($custom_name) ) {
		$image->thumbCustomName = $custom_name;
	}

	return $image;
}


$image = newFaviconUploaderInstance(16, 16);
if($image->make()) {

	$image = newFaviconUploaderInstance(32, 32);
	$image->make();

	$image = newFaviconUploaderInstance(96, 96);
	$image->make();

	$image = newFaviconUploaderInstance(120, 120, 'older-iPhone.png');
	$image->make();

	$image = newFaviconUploaderInstance(180, 180, 'iPhone-6-Plus.png');
	$image->make();

	$image = newFaviconUploaderInstance(152, 152, 'iPad-Retina.png');
	$image->make();

	$image = newFaviconUploaderInstance(167, 167, 'iPad-Pro.png');
	$image->make();

	$image = newFaviconUploaderInstance(120, 120, 'older-iPhone.png');
	$image->make();

	session()->alert('success', 'آپلود با موفقیت انجام شد');
	redirect('refer');

} else {
	session()->alert('success', $image->getError());
	redirect('refer');
}
