<?php
use App\ImageUpload;

require_once '../init.php';
require_once '../check_auth.php';

if( ! isCountryAllowed() ) {
    return ajaxErrorResponse(_e('IP_OR_VPN_ERROR', true));
}


$image = new ImageUpload();

$image->uploadName		= "estateImages";
$image->resize 			= false;
$image->makeThumb 		= false;
$image->renameIteration = false;
$image->autoNaming      = true;
$image->ajaxUpload      = true;
$image->imgRoot 	 	= "../../images/estate_images/app_temp/";
$image->validFormats 	= ['jpg', 'jpeg', 'JPG', "JPEG", 'png', 'PNG'];
$image->validMimeTypes  = ['image/jpeg', 'image/png'];


$output['success'] 	 = false;
$output['file_name'] = null;
$output['file_path'] = null;

if($image->make())
{
    $file_name = $image->getFileName();
    $file_path = siteroot() . ltrim($image->getFilePath(), '../') . '?' . rand(1,500);

    return ajaxSuccessResponse(['file_name' => $file_name, 'file_path' => $file_path]);
}else{
    return ajaxErrorResponse($image->getError());
}