<?php

use App\Input;
use App\PostCategory;
use App\Session;
use App\Token;
use App\Validate;

checkDemoMode();
checkAccess('POST_MANAGE');

if (! token()->check()) {
    session()->error(_e('WRONG_CSRF_TOKEN', true));
    redirect('refer');
}

$validation = new Validate();
$rules = [
    'CATEGORY_NAME' => [
        'name' => 'عنوان دسته',
        'prefix' => _e('ENTERING', true),
        'required' => true,
        'max' => 200
    ]
];

$slug = slug(input('CATEGORY_NAME'));
if (inputs()->not_empty('CATEGORY_SLUG')) {
    $slug = slug(input('CATEGORY_SLUG'));
}

if (is_empty($slug)) {
    $validation->addError('عنوان وارد شده برای دسته معتبر نیست');
}

/** @var Validate $validation */
$validation = $validation->check($_POST, $rules);
if (! $validation->passed()) {
    session()->error($validation->errors(), true);
    redirect('refer');
}

try {
    $PostCategory = new PostCategory();
    $category = $PostCategory->byId(input('id'));

    if ($category) {
        $category->update(inputs()->all(), $slug);
    }

    session()->success();
    redirect('refer');
} catch (PDOException $e) {
    session()->error();
    redirect('refer');
}