<?php

use App\Image;
use App\Session;
use App\Validate;

checkUserCountry();

$validate = new Validate();
$rules = array(
    'frm_title'  => ['name' => 'عنوان', 'prefix' => 'وارد کردن ', 'required' => true, 'min' => 5, 'max'=> 200 ],
    'category' 	 => ['name' => 'دسته بندی', 'prefix' => 'انتخاب کردن ', 'required' => true, 'not_any' => true]
);

$slug_name = slug(input('frm_title'));
if (inputs()->not_empty('slug')) {
	$slug_name = slug(input('slug'));
}

if(empty($slug_name) || trim($slug_name) == ''){
    $validate->addError('عنوان وارد شده معتبر نمی باشد');
}
if(strlen($slug_name) > 250){
    $validate->addError('طول عنوان وارد شده بیش از مقدار مجاز است');
}


$validation = $validate->check($_POST, $rules);

if($validation->passed())
{
	$postId = $post->POST_ID;
	try {

		/**
		 * Start Transaction
		 */
		$db->beginTransaction();

			/**
			 * Update Post
			 */
			$post->update(inputs()->all(), $slug_name);

			/*
			*  Handling Tags
			*/
			/** @var App\Tag $Tags */
			if (inputs()->not_empty('frm_keywords')) {
				$keywords = explode(',', input('frm_keywords'));

				$current_tags_array = $Tags->listsFor($postId, 'post');
				if (! isArrayEqual($current_tags_array, $keywords)) {
					$Tags->deleteAll($postId, 'post');
					$Tags->handle($keywords, $postId, 'post', $current_plan->MAX_KEYWORD_COUNT, false);
				}
			} else {
				$Tags->deleteAll($postId, 'post');
			}

		/**
		 * End Transaction
		 */
		$db->commit();

        /* move uploaded images to it's real destination */
        $uploaded_images = json_decode(input('uploaded_images'));
        $all_uploaded_images = json_decode(input('all_uploaded_images'));

        $source_root = "../images/estate_images/app_temp/";
        $destination_root = "../images/post_images/{$post->id()}/";

        if (! is_dir($destination_root)) {
            mkdir($destination_root);
        }

        foreach ($ads_images as $ads_image) {
            $ads_image = removeSizeFromImageName($ads_image);

            if (! in_array(removeExtension(basename($ads_image)), array_column($uploaded_images, 'name'))) {
                unlink("../{$ads_image}");

                foreach ($post_image_sizes as $size_name => $size_options) {
                    unlink(imageNameForSize("../{$ads_image}", $size_name));
                }
            }
        }

        $post->deleteImagesFromDatabase();

        $ImageDb = new Image();
        $db_images = [];

        $i = 1;
        foreach ($uploaded_images as $image)
        {
            $source_main = "{$source_root}{$image->name}.jpg";
            $destination_main = "{$destination_root}{$image->name}.jpg";

            if (file_exists($destination_main)) {
                $db_images[] = $ImageDb->createNew($post->id(), str_replace('../', '', $destination_main), null, 'post');
                $i++;
                continue;
            }

            if (! is_file($source_main) ) {
                continue;
            }

            rename($source_main, $destination_main);

            $db_images[] = $ImageDb->createNew($post->id(), str_replace('../', '', $destination_main), null, 'post');


            foreach ($post_image_sizes as $size_name => ['size' => $size]) {
                $sized_source =  "{$source_root}{$image->name}-{$size_name}.jpg";
                $sized_destination =  "{$destination_root}{$image->name}-{$size_name}.jpg";

                if (! is_file($sized_source)) {
                    continue;
                }

                rename($sized_source, $sized_destination);
            }

            $key = array_search($image->name, $all_uploaded_images);
            if( $key == 0 || $key != false) {
                unset($all_uploaded_images[$key]);
            }

            $i++;
        }

        /* delete redundant uploaded images */
        foreach($all_uploaded_images as $image) {

            if(empty($image)) {
                continue;
            }

            $source_main = "{$source_root}{$image->name}.jpg";

            if (is_file($source_main)) {
                unlink($source_main);
            }

            foreach ($post_image_sizes as $size_name => ['size' => $size]) {
                $sized_source = "{$source_root}{$image->name}-{$size_name}.jpg";

                if (is_file($sized_source)) {
                    unlink($sized_source);
                }
            }
        }

        $post = $post->setFeaturedImage($db_images[0]);

        if(input('send_to_telegram') == 1) {
            $featured_image = $post->featuredImage('main', false);
            $post->sendToTelegram(input('frm_title'), $featured_image);
        }

		session()->alert('success', 'عملیات ویرایش با موفقیت انجام شد');
		redirect('refer');

	}catch(PDOException $e){
		$db->rollBack();
		session()->alert('مشکلی در عملیات ثبت پیش آمده است ... لطفا مجددا تلاش نمایید');
	}
} else {
    session()->alert('error', $validation->errors(), true);
}
