<?php
use App\CustomFields;
use App\Image;
use App\Mailer;
use App\MessageBox;
use App\Plan;
use App\SMS;
use App\Template;
use App\User;
use App\Validate;

checkUserCountry();

$ads_id = $ads->ADS_ID;
$send_deny_email = false;

$validate = new Validate();

$rules = array(
    'frm_title' => ['name' => 'عنوان آگهی ', 'prefix' => 'وارد کردن ', 'required' => true, 'min' => 5, 'max' => 200],
    'frm_plan_type' => ['name' => 'نوع پلان آگهی ', 'prefix' => ' انتخاب کردن ', 'required' => true, 'not_any' => true],
    'frm_states' => ['name' => 'استان', 'prefix' => 'انتخاب ', 'required' => true, 'not_any' => true, 'numeric' => true],
    'frm_cities' => ['name' => 'شهر', 'prefix' => 'انتخاب ', 'required' => true, 'not_any' => true, 'numeric' => true],
    'frm_user' => ['name' => 'صاحب آگهی ', 'prefix' => ' انتخاب کردن ', 'required' => true, 'not_any' => true,],
    'frm_mail' => ['name' => 'آدرس ایمیل ', 'email' => true],
    'frm_discount' => ['name' => 'درصد تخفیف ', 'percent' => true]
);

if (input('category') == 'any' || input('subcategory') == 'any') {
    $validate->addError('لطفا دسته بندی آگهی را انتخاب نمایید');
}

// SLUG PART
$slug_name = slug(input('frm_title'));
if (inputs()->not_empty('slug')) {
    $slug_name = slug(input('slug'));
}

if (empty($slug_name) || trim($slug_name) == '') {
    $validate->addError('عنوان وارد شده برای آگهی معتبر نمی باشد');
}
if (strlen($slug_name) > 250) {
    $validate->addError('طول عنوان وارد شده برای آگهی بیش از مقدار مجاز است');
}

$CustomFields = new CustomFields();
$custom_fields = $CustomFields->getFieldsSmartly(input('category'), input('subcategory'), input('subsidiary'));

/** @var App\CustomFields $field */
foreach ($custom_fields as $field) {
    if ($field->field_type == 'price') {
        $rules = $field->set_price_field_rule($rules);
    } else {
        if ($field->field_name != 'usage') {
            $rules[$field->field_name] = $field->rules();
        }
    }
}

$validation = $validate->check($_POST, $rules);
if ($validation->passed()) {
    $categoryId = input('subcategory');
    if (inputs()->not_empty('subsidiary') && input('subsidiary') != 'any') {
        $categoryId = input('subsidiary');
    }

    $user = (new User())->findById(input('frm_user'));

    /**
     * Handling Tags
     */
    /** @var App\Tag $Tags */
    if (inputs()->not_empty('frm_keywords')) {
        $current_tags_array = $Tags->listsFor($ads_id, 'ads');
        if (! isArrayEqual($current_tags_array, input('frm_keywords'))) {
            $Tags->deleteAll($ads_id);
            $Tags->handle(input('frm_keywords'), $ads_id, 'ads', 0, false);
        }
    } else {
        $Tags->deleteAll($ads_id);
    }


    $is_paid     = $ads->IS_PAID;
    $is_shown    = $ads->IS_SHOWN;
    $is_rejected = $ads->IS_REJECTED;
    $is_expired  = $ads->IS_EXPIRED;
    $is_active   = $ads->IS_ACTIVE;
    $is_deleted  = $ads->IS_DELETED;
    $is_edited   = $ads->IS_EDITED;

    $status = input('frm_status');

    if ($status != 0) {
        $is_active = $is_shown = 1;

        switch ($status) {
            case 1:
                $is_rejected = 1;
                break;
            case 2:
                $is_paid = $is_active = $is_shown = 2;
                $is_rejected = $is_expired = $is_deleted = $is_edited = 1;
                break;
            case 3:
                $is_active = 2;
                $is_paid = $is_deleted = 1;
                break;
            case 4:
                $is_rejected = 2;
                $is_edited = 1;
                break;
            case 5:
                $is_expired = 2;
                break;
        }
    }


    if ($ads->IS_ACTIVE == 1 && $is_active == 2 && $is_shown == 2) { // if ads accepted by admin
        if (setting('SEND_EMAIL_AFTER_VERIFY_ADS') === "YES") {
            $send_verify_email = true;
        }
        if (setting('SEND_SMS_AFTER_VERIFY_ADS') === "YES") {
            $send_verify_sms = true;
        }
    }

    $Plan = new Plan();
    $plan = $Plan->byId(input('frm_plan_type'));

    $from_date = $ads->FROM_DATE;
    $to_date = $ads->TO_DATE;

    $link = input('frm_link');

    $from_timeStamp = partial_shamsi_to_mi_timestamp(input('frm_from_date'));

    $to_timeStamp = null;
    if ($plan->PLAN_ID != $ads->PLAN_ID) {// if plan changed ...
        $to_timeStamp = $from_timeStamp + $plan->PLAN_DAYS * 24 * 3600;
    } elseif ($plan->PLAN_ID == $ads->PLAN_ID && input('frm_from_date') != $ads->FROM_DATE) {
        $to_timeStamp1 = mi_timeStamp($ads->TO_DATE);
        $to_timeStamp2 = $from_timeStamp + $plan->PLAN_DAYS * 24 * 3600;

        $to_timeStamp = max($to_timeStamp1, $to_timeStamp2);
    }
    $from_date = date("Y-m-d H:i:s", $from_timeStamp);
    $to_date = date("Y-m-d H:i:s", $to_timeStamp);

    if ($ads->ads_general_status(true) != 6 && $status == 4) {
        $send_deny_email = true;
    }

    $discount = $price = null;
    if (inputs()->not_empty('frm_discount')) {
        $discount = (int)input('frm_discount');
    }
    if (!$custom_fields) {
        if (inputs()->not_empty('frm_price_deal')) {
            $price = 'DEAL';
        } elseif (inputs()->not_empty('frm_price')) {
            $price = money_to_num(en_digits(input('frm_price')));
        }
    }

    $email = $user->officialEmail();
    $phone = $user->officialMobile();
    if (inputs()->not_empty('frm_mail')) {
        $email = en_digits(input('frm_mail'));
    }
    if (inputs()->not_empty('frm_phone')) {
        $phone = en_digits(input('frm_phone'));
    }

    try {
        $status_array = compact('is_paid', 'is_shown', 'is_rejected', 'is_expired', 'is_active', 'is_deleted', 'is_edited');
        /**
         * Start Transaction
         */
        $db->beginTransaction();

        /**
         * Update Ads
         */
        $ads->update(inputs()->all(), $slug_name, $discount, $price, $email, $phone, $link, $categoryId, $is_active, $is_deleted, $is_edited);

        $ads->updateVotes(input('likes_count'), input('dislikes_count'));

        /**
         * Update Special Record
         */
        $ads->special()->update($plan, $status_array, $from_date, $to_date);

        /**
         * Update Custom Fields
         */
        $CustomFields->deleteAllAdsItem($ads->ADS_ID);
        if ($custom_fields) {
            foreach ($custom_fields as $field) {
                $field->save($ads->ADS_ID);
            }
        }

        /**
         * End Transaction
         */
        $db->commit();

        /* move uploaded images to it's real destination */
        $uploaded_images = json_decode(input('uploaded_images'));
        $all_uploaded_images = json_decode(input('all_uploaded_images'));

        $source_root = "../images/estate_images/app_temp/";
        $destination_root = "../images/estate_images/{$ads->id()}/";

        if (! is_dir($destination_root)) {
            mkdir($destination_root);
        }


        foreach ($ads_images as $ads_image) {
            $ads_image = removeSizeFromImageName($ads_image);

            if (! in_array(removeExtension(basename($ads_image)), array_column($uploaded_images, 'name'))) {
                unlink("../{$ads_image}");

                foreach ($image_sizes as $size_name => $size_options) {
                    unlink(imageNameForSize("../{$ads_image}", $size_name));
                }
            }
        }

        $ads->deleteImagesFromDatabase();

        $ImageDb = new Image();
        $db_images = [];

        $i = 1;
        foreach ($uploaded_images as $image) {
            $source_main = "{$source_root}{$image->name}.jpg";
            $destination_main = "{$destination_root}{$image->name}.jpg";


            if (file_exists($destination_main)) {
                $db_images[] = $ImageDb->createNew($ads->id(), str_replace('../', '', $destination_main));
                $i++;
                continue;
            }

            if (! is_file($source_main) ) {
                continue;
            }

            rename($source_main, $destination_main);

            $db_images[] = $ImageDb->createNew($ads->id(), str_replace('../', '', $destination_main));

            foreach ($image_sizes as $size_name => ['size' => $size]) {
                $sized_source =  "{$source_root}{$image->name}-{$size_name}.jpg";
                $sized_destination =  "{$destination_root}{$image->name}-{$size_name}.jpg";

                if (! is_file($sized_source)) {
                    continue;
                }

                rename($sized_source, $sized_destination);
            }

            $key = array_search($image->name, $all_uploaded_images);
            if ($key == 0 || $key != false) {
                unset($all_uploaded_images[$key]);
            }

            $i++;
        }

        /* delete redundant uploaded images */
        foreach ($all_uploaded_images as $image) {

            if (empty($image)) {
                continue;
            }

            $source_main = "{$source_root}{$image->name}.jpg";

            if (is_file($source_main)) {
                unlink($source_main);
            }

            foreach ($image_sizes as $size_name => ['size' => $size]) {
                $sized_source = "{$source_root}{$image->name}-{$size_name}.jpg";

                if (is_file($sized_source)) {
                    unlink($sized_source);
                }
            }
        }

        $ads = $ads->setFeaturedImage($db_images[0]);

        $username = null;
        if (!empty($user)) {
            $username = $user->publicName();
        }

        if ($send_verify_email) {
            // TODO:: use language file
            $email_subject = emailSubject(_e('YOUR_ADS_PUBLISHED', true));
            $mailVariables = array(
                "title" => $email_subject,
                "username" => $username,
                "adsTitle" => $ads->ADS_TITLE,
                "adsLink" => adsroot() . $ads->adsLink()
            );
            $message = Template::email('free_ads_verified', $mailVariables);

            $mailer = new Mailer();
            $mailer->send($user->officialEmail(), $message, $email_subject);

            $MessageBox = new MessageBox('email');
            $MessageBox->createAuto($loggedUser->USER_ID, $email_subject, $message, $ads->USER_ID, $ads->ADS_OWNER_EMAIL);
        }

        if ($send_deny_email) {
            // TODO:: use language file
            $email_subject = emailSubject(_e('YOUR_ADS_REJECTED', true));
            $mailVariables = array(
                "title" => $email_subject,
                "adsTitle" => $ads->ADS_TITLE,
                "username" => $username,
                "message" => input('REJECTION_CAUSE'),
            );
            $message = Template::email('ads_rejected', $mailVariables);

            $mailer = new Mailer();
            $mailer->send($user->officialEmail(), $message, $email_subject);

            $MessageBox = new MessageBox('email');
            $MessageBox->createAuto($loggedUser->USER_ID, $email_subject, $message, $ads->USER_ID, $ads->ADS_OWNER_EMAIL);
        }

        if ($send_verify_sms) {
            $smsVariables = array(
                "siteTitle" => setting('SITE_TITLE')
            );
            $message = Template::sms('ads_verified', $smsVariables);

            $to = $user->officialMobile();
            $resId = SMS::init()->send($to, $message);

            $MessageBox = new MessageBox('sms');
            $MessageBox->createAuto($loggedUser->USER_ID, _e('YOUR_ADS_PUBLISHED', true), $message, $ads->USER_ID, $to, $resId);
        }

        if ($is_shown == 2 && input('send_to_telegram') == 1) {
            $featured_image = $ads->featuredImage('main', false);

            $ads->sendToTelegram(input('frm_title'), $featured_image);
        }


        session()->alert('success', 'عملیات ویرایش با موفقیت انجام شد');
        redirect('refer');

    } catch (PDOException $e) {
        dd($e->getMessage());
        session()->alert('error', 'مشکلی در عملیات ویرایش پیش آمده است ... لطفا مجددا تلاش نمایید');
    }
} else {
    session()->alert('error', $validation->errors(), true);
}
