<?php
use App\Category;
use App\SubCategory;
use App\Validate;


checkUserCountry();

$validation = new Validate();
$rules = array(
    'name' => ['name' => 'عنوان', 'prefix' => 'وارد کردن ', 'required' => true, 'min' => 2, 'max' => 200]
);

$slug_name = slug(input('name'));
if (inputs()->not_empty('slug')) {
    $slug_name = slug(input('slug'));
}

if (empty($slug_name) || trim($slug_name) == '' || strlen($slug_name) > 250) {
    $validation->addError('عنوان وارد شده  معتبر نمی باشد');
}

/** @var Validate $validation */
$validation = $validation->check($_POST, $rules);
if ($validation->passed()) {

    /* move uploaded images to it's real destination */
    $image_name = $current_category->image;
    $uploaded_images = json_decode(input('uploaded_images'));
    $all_uploaded_images = json_decode(input('all_uploaded_images'));

    foreach ($uploaded_images as $image) {
        if (empty($image->name) && $current_category->hasImage()) {
            unlink($current_category->imagePath());
            $image_name = null;
            break;
        }
        if (empty($image->name)) {
            break;
        }

        $image_name = uniqid() . $image->name;
        $source_main = "../images/estate_images/app_temp/{$image->name}";
        $images_root = "../images/categories/";
        $destination_main = $images_root . $image_name;

        if (!is_file($source_main)) {
            break;
        }

        rename($source_main, $destination_main);
        if ($current_category->hasImage()) {
            unlink($current_category->imagePath());
        }
    }
    foreach ($all_uploaded_images as $image) {
        if (empty($image)) {
            continue;
        }
        $source_main = "../images/estate_images/app_temp/{$image}";
        if (is_file($source_main)) {
            unlink($source_main);
        }
    }


    $old_type = $current_category->type();
    $category_id = input('category_id');
    $subcategory_id = input('subcategory_id');

    $new_type = 'category';
    if (!empty($category_id) && empty($subcategory_id)) {
        $new_type = 'subcategory';
    }
    if (!empty($category_id) && !empty($subcategory_id)) {
        $new_type = 'subsidiary';
    }

    try {
        /**
         * Start Transaction
         */
        $db->beginTransaction();

        if ($old_type === 'category' && $new_type !== 'category') {
            $current_category->delete();
            $SubCategory = new SubCategory();
            $SubCategory->createNew(inputs()->all(), $slug_name, $image_name);

        } elseif ($old_type !== 'category' && $new_type === 'category') {
            $current_category->delete();
            $Category = new Category();
            $Category->createNew(inputs()->all(), $slug_name, $image_name);

        } else {
            $current_category->update(inputs()->all(), $slug_name, $image_name);
        }

        /**
         * End Transaction
         */
        $db->commit();

        session()->success();

        if ($new_type === 'category') {
            redirect(categoriesRoute());
        }
        redirect(subcategoriesRoute());

    } catch (PDOException $e) {
        $db->rollBack();
        session()->error();
    }
} else {
    session()->error($validation->errors(), true);
}

