<?php

use App\Input;
use App\PostCategory;
use App\Session;
use App\Token;
use App\Validate;

checkDemoMode();
checkAccess('POST_MANAGE');

if (! token()->check()) {
    session()->error(_e('WRONG_CSRF_TOKEN', true));
    redirect(postCategoriesRoute());
}
try {
    $PostCategory = new PostCategory();
    $category = $PostCategory->byId(input('id'));

    if ($category) {
        $category->update(inputs()->all(), $slug);
    }

    session()->success();
    redirect(postCategoriesRoute());
} catch (PDOException $e) {
    session()->error();
    redirect(postCategoriesRoute());
}