<?php

use Admin\Ads;

use App\Comment;
use App\Coupon;
use App\Link;
use App\Location;
use App\Plan;
use App\Post;
use Admin\User;
use App\Category;
use App\Menu;
use App\MessageBox;
use App\Page;
use App\PostCategory;
use App\SubCategory;
use App\Telegram;
use App\TelegramBox;
use App\WithdrawalRequest;

require_once '../init.php';
require_once '../check_auth.php';
checkUserCountry();

/**
 * Delete Ads
 */
if (input('action') === 'delete-ads') {
    checkDemoMode();
    checkAccess('ADS_DELETE');

    try {
        $Ads = new Ads();
        $ads = $Ads->byIdSimple(input('id'));

        if ($ads) {
            $ads->destroy();
        }

        session()->success();
        redirect('refer');

    } catch (PDOException $e) {
        session()->error();
        redirect('refer');
    }
}


/**
 * Delete Category
 */
if (input('action') === 'delete-category') {
    checkDemoMode();
    checkAccess('CATEGORY_MANAGE');

    try {
        $Category = new Category();
        $category = $Category->byId(input('id'), false);
        $category->delete();

        session()->success();
        redirect('refer');
    } catch (PDOException $e) {
        session()->error();
        redirect('refer');
    }
}

/**
 * Delete Subcategory
 */
if (input('action') === 'delete-subcategory') {
    checkDemoMode();
    checkAccess('CATEGORY_MANAGE');

    try {
        $SubCategory = new SubCategory();
        $subcategory = $SubCategory->byId(input('id'), false);
        $subcategory->delete();

        session()->success();
        redirect('refer');
    } catch (PDOException $e) {
        session()->error();
        redirect('refer');
    }
}

/**
 * Delete Coupon
 */
if (input('action') === 'delete-coupon') {
    checkDemoMode();
    checkAccess('COUPON_MANAGE');
    try {
        $Coupon = new Coupon();
        $coupon = $Coupon->byId(input('id'), false);

        if (! $coupon) {
            abort();
        }

        $coupon->delete();

        session()->success();
        redirect('refer');
    } catch (PDOException $e) {
        session()->error();
        redirect('refer');
    }
}
/*=============================================================================
                                       		DELETE A DATABASE BACKUP FILE
                                   ===============================================================*/
if (isset($_GET['dbBackId']) && !empty($_GET['dbBackId']) && $_GET['dbBackId'] !== " ") {

    checkDemoMode();

    if (file_exists($path = "../backups/{$_GET['dbBackId']}.sql")) {
        unlink($path);

        session()->success();
        redirect('refer');
    } else {
        session()->error();
        redirect('refer');
    }

}

/*=============================================================================
                                       		DELETE A PAGE
                                   ===============================================================*/
if (inputs()->not_empty('pageId')) {
    checkDemoMode();
    checkAccess('PAGE_MANAGE');

    try {
        $Page = new Page();
        $page = $Page->byId(input('pageId'));

        if ($page) {
            $page->delete();
        }

        session()->success(' عملیات حذف با موفقیت انجام شد ');
        redirect('refer');
    } catch (PDOException $e) {
        session()->error(' مشکلی در عملیات حذف پیش آمده است ... لطفا مجددا تلاش نمایید ');
        redirect('refer');
    }
}


/**
 * Delete telegram message
 */
if (input('action') === 'delete-telegram-message') {
    checkDemoMode();
    checkAccess('TELEGRAM_MANAGE');

    try {
        $Telegram = new Telegram();
        $TelegramBox = new TelegramBox();

        $message = $TelegramBox->find(input('id'));

        $Telegram->delete($message->message_id);
        $message->delete();

        session()->success();
        redirect('refer');
    } catch (PDOException $e) {
        session()->error();
        redirect('refer');
    }
}


/**
 * Delete User
 */
if (input('action') === 'delete-user') {
    checkDemoMode();
    checkAccess('USER_DELETE_CHANGE-STATUS');

    $User = new User();
    $user = $User->findById(input('userId'));

    if ($user) {
        $user->delete();
    }

    session()->success();
    redirect('refer');
}

/**
 * Delete post
 */
if (input('action') === 'delete-post') {
    checkDemoMode();
    checkAccess('POST_MANAGE');

    $Post = new Post();

    try {
        $post = $Post->byId(input('id'));
        if ($post) {
            $post->destroy();
        }

        session()->success();
        redirect('refer');
    } catch (PDOException $e) {
        session()->error();
        redirect('refer');
    }
}


/**
 * Delete post category
 */
if (input('action') === 'delete-post-category') {
    checkDemoMode();
    checkAccess('POST_MANAGE');

    try {
        $PostCategory = new PostCategory();
        $category = $PostCategory->byId(input('id'));

        if ($category) {
            $category->delete();
        }

        session()->success();
        redirect('refer');
    } catch (PDOException $e) {
        session()->error();
        redirect('refer');
    }

}
/*======================================================================
                    Bulk delete emails in mailbox
========================================================================*/
if (input('action') === 'bulk-delete-emails') {

    checkDemoMode();

    try {
        $checked = input('mail_multiple');
        /** @var array $checked */
        if (count($checked) == 0) {
            redirect('refer');
        }
        $MessageBox = new MessageBox('email');
        $MessageBox->bulkDelete($checked);

        session()->success();
        redirect('refer');

    } catch (PDOException $e) {

        session()->error();
        redirect('refer');
    }
}


/*======================================================================
                    Bulk delete sms in mailbox
========================================================================*/
if (input('action') === 'bulk-delete-sms') {

    checkDemoMode();

    try {
        $MessageBox = new MessageBox('sms');

        /** @var array $checked */
        $checked = input('mail_multiple');
        $MessageBox->bulkDelete($checked);

        session()->success();
        redirect('refer');

    } catch (PDOException $e) {
        session()->error();
        redirect('refer');
    }
}

/*=============================================================================
                            DELETE MENU
==============================================================================*/
if (input('action') === 'delete-menu') {
    checkDemoMode();
    checkAccess('MENU_MANAGE');

    try {
        $Menu = new Menu();
        $menu = $Menu->byId(input('menuId'));

        if (!$menu || !$menu->isDeletable()) {
            abort();
        }

        $menu->delete();
        session()->success();
        redirect('refer');

    } catch (PDOException $e) {
        session()->error();
        redirect('refer');
    }
}

/**
 * Delete Comment
 */
if (input('action') === 'delete-comment') {
    checkDemoMode();
    checkAccess('ADS_DELETE');

    try {
        $Comment = new Comment();
        $comment = $Comment->findById(input('id'));

        if ($comment) {
            $comment->delete();
        }

        session()->success();
        redirect('refer');
    } catch (PDOException $e) {
        session()->error();
        redirect('refer');
    }
}

/**
 * Delete Location
 */
if (input('action') === 'delete-location') {
    checkDemoMode();
    checkAccess('LOCATION_MANAGE');

    if (empty('type') || ! in_array(input('type'), ['state', 'city', 'zone'])) {
        abort();
    }

    try {
        $Location = new Location(input('type'));
        $location = $Location->byId(input('id'));
        if (! $location) {
            abort();
        }
        $location->delete();

        session()->success();
        redirect('refer');
    } catch (PDOException $e) {
        session()->error();
        redirect('refer');
    }
}

/**
 * Deletes the requested withdrawal request
 */
if (isPost() && token()->check() && input('action') === 'delete-withdrawal-request') {
    checkDemoMode();

    $WithdrawalRequest = new WithdrawalRequest();
    $request = $WithdrawalRequest->byId(input('id'));

    try {
        $request->delete();
    } catch (PDOException $e) {
        session()->error();
        redirect('refer');
    }
}

/**
 * Deletes the requested plan
 */
if (isPost() && token()->check() && input('action') === 'delete-plan') {
    checkDemoMode();

    try {
        $Plan = new Plan();
        $plan = $Plan->byId(input('id'));

        if (! $plan || ! $plan->is_deletable()) {
            session()->error('پلان مورد نظر قابل حذف نمی باشد');
            redirect('refer');
        }

        $plan->delete();

        session()->success();
        redirect('refer');
    }catch (PDOException $e) {
        session()->success();
        redirect('refer');
    }
}

/**
 * Deletes the requested plan
 */
if (isPost() && token()->check() && input('action') === 'delete-link') {
    checkDemoMode();

    try {
        $Link = new Link();
        $link = $Link->byId(input('id'));
        if ($link) {
            $link->delete();
        }

        session()->success();
        redirect('refer');
    }catch (PDOException $e) {
        session()->success();
        redirect('refer');
    }
}

redirect('refer');
