<?php
use App\Session;
use App\Setting;


require_once '../init.php';
require_once '../check_auth.php';

checkDemoMode();

/* move uploaded image to it's real destination */
$uploaded_images = json_decode(input('uploaded_images'));
$all_uploaded_images = json_decode(input('all_uploaded_images'));
$images_root  = "../../images/popup/";

if( ! empty($uploaded_images) && count($uploaded_images) == 1) {
    $image = data_get($uploaded_images, 0);

    $source       = $images_root . $image->name;
    $old_image    = $images_root . setting('POPUP__IMAGE');

    if( is_file($source) ) {
        $Setting = new Setting();
        $Setting->update(['POPUP__IMAGE' => $image->name]);

        $key = array_search($image->name, $all_uploaded_images);
        if( $key == 0 || $key != false) {
            unset($all_uploaded_images[$key]);
        }

        unlink($old_image);
    }
}

/* delete redundant uploaded images */
foreach($all_uploaded_images as $image) {

    if(empty($image)) {
        continue;
    }

    $source  = $images_root . $image->name;
    if( is_file($source) ) {
        unlink($source);
    }

}

clearSettingCache();
session()->success('تغییرات با موفقیت اعمال شد');
redirect(settingsRoute('pages', 5));
