<?php
use Admin\Ads;

use App\Validate;

checkUserCountry();

if( ! token()->check() ) {
    session()->error(_e('WRONG_CSRF_TOKEN', true));
    redirect('refer');
}

checkDemoMode();
checkAccess('USER_ADD');

$validate = new Validate();
$Ads = new Ads();

$rules = array(
    'register_param' => [
        'name'     => _e('MOBILE_OR_EMAIL', true),
        'prefix'   => _e('ENTERING', true),
        'required' => true,
        'username' => true,
        'unique'   => 'tbl_users'
    ],
    'password' => [
        'name'     => _e('PASSWORD', true),
        'prefix'   => _e('ENTERING', true),
        'required' => true,
        'min'      => 6
    ],
    'password_again' => [
        'name'     => _e('PASSWORD_CONFIRMATION', true),
        'prefix'   => _e('ENTERING', true),
        'required' => true ,
        'matches'  => 'password'
    ],
    'access_level'  => [
        'name' => 'سطح دسترسی',
        'required'  => true,
        'in_array_pure' => array_keys($UserlevelsArray)
    ],
    'is_active'  => [
        'name' => 'وضعیت',
        'required'  => true,
        'in_array' => '1|2|3'
    ],
);

$username = input('register_param');
if(is_email($username)) {
    $rules['register_param']['unique_column'] = 'EMAIL';
}
if(is_mobile($username)) {
    $rules['register_param']['unique_column'] = 'TEL';
}

$validation = $validate->check($_POST, $rules);
if( $validation->passed() ) {

    $username = input('register_param');
    $email = $mobile = $verified_email = $verified_mobile = null;
    $is_active = input('is_active');

    if( is_email($username) ) {
        $email = $username;
        if($is_active == 2) {
            $verified_email = $username;
        }
    }

    if( is_mobile($username) ) {
        $mobile = $username;
        if($is_active == 2) {
            $verified_mobile = $username;
        }
    }

    $created_user = $User->createNew(inputs()->all(), $username, $email, $mobile, $verified_email, $verified_mobile);

    session()->success();
    redirect($created_user->editLink());
} else {
    session()->error($validation->errors(), true);
}
