<?php
use Admin\Ads;

use App\Image;
use App\Special;
use App\Tag;
use App\CustomFields;
use App\Validate;

checkUserCountry();

$validate = new Validate();
$Ads = new Ads();

$rules = array(
    'frm_title' => ['name' => 'عنوان آگهی ', 'prefix' => 'وارد کردن ', 'required' => true, 'min' => 5, 'max' => 200],
    'frm_plan_type' => ['name' => 'نوع پلان آگهی ', 'prefix' => ' انتخاب کردن ', 'required' => true, 'not_any' => true,],
    'frm_user' => ['name' => 'صاحب آگهی ', 'prefix' => ' انتخاب کردن ', 'required' => true, 'not_any' => true,],
    'frm_mail' => ['name' => 'آدرس ایمیل ', 'email' => true],
    'frm_discount' => ['name' => 'درصد تخفیف ', 'percent' => true],
    'frm_states' => ['name' => 'استان', 'prefix' => 'انتخاب ', 'required' => true, 'not_any' => true, 'numeric' => true],
    'frm_cities' => ['name' => 'شهر', 'prefix' => 'انتخاب ', 'required' => true, 'not_any' => true, 'numeric' => true]
);
if (input('category') == 'any' || input('subcategory') == 'any') {
    $validate->addError('لطفا دسته بندی آگهی را انتخاب نمایید');
}

$slug_name = slug(input('frm_title'));
$slug_name = $Ads->slug($slug_name);

if (empty($slug_name) || trim($slug_name) == '') {
    $validate->addError('عنوان وارد شده برای آگهی معتبر نمی باشد');
}
if (strlen($slug_name) > 250) {
    $validate->addError('طول عنوان وارد شده برای آگهی بیش از مقدار مجاز است');
}

$CustomFields = new CustomFields();
$custom_fields = $CustomFields->getFieldsSmartly(input('category'), input('subcategory'), input('subsidiary'));

if ($custom_fields) {
    /** @var CustomFields $field */
    foreach ($custom_fields as $field) {
        if ($field->field_type == 'price') {
            $rules = $field->set_price_field_rule($rules);
        } else {
            if ($field->field_name != 'usage') {
                $rules[$field->field_name] = $field->rules();
            }
        }
    }
}

$validation = $validate->check($_POST, $rules);
if ($validation->passed()) {

    $plan = Ads::plan_by_id(input('frm_plan_type'));

    $categoryId = input('subcategory');
    if (inputs()->not_empty('subsidiary') && input('subsidiary') != 'any') {
        $categoryId = input('subsidiary');
    }

    $discount = $price = null;
    if (inputs()->not_empty('frm_discount')) {
        $discount = (int)input('frm_discount');
    }

    if (!$custom_fields) {
        if (inputs()->not_empty('frm_price_deal')) {
            $price = 'DEAL';
        } elseif (inputs()->not_empty('frm_price')) {
            $price = money_to_num(en_digits(input('frm_price')));
        }
    }

    $user = $User->findById(input('frm_user'));
    $email = $user->EMAIL;
    $phone = $user->TEL;
    if (inputs()->not_empty('frm_mail')) {
        $email = en_digits(input('frm_mail'));
    }
    if (inputs()->not_empty('frm_phone')) {
        $phone = en_digits(input('frm_phone'));
    }

    try {
        /**
         * Start Transaction
         */
        $db->beginTransaction();

        /**
         * Create Ads
         */
        $adsId = $Ads->createNew(inputs()->all(), $slug_name, $discount, $price, $email, $phone, $categoryId);

        /**
         * Create Special Record
         */
        $Special = new Special();
        $Special->createNew($adsId, input('frm_plan_type'), $plan->PLAN_DAYS, 2, 2);

        /**
         * Inserting Tags
         */
        $Tag = new Tag();
        $Tag->handle(input('frm_keywords'), $adsId, 'ads', 0,false);

        if ($custom_fields) {
            foreach ($custom_fields as $field) {
                $field->save($adsId);
            }
        }

        $db->commit();


        /* move uploaded images to it's real destination */
        $uploaded_images = json_decode(input('uploaded_images'));
        $all_uploaded_images = json_decode(input('all_uploaded_images'));

        $ImageDb = new Image();
        $db_images = [];

        $i = 1;
        foreach ($uploaded_images as $image) {
            if (empty($image->name)) {
                continue;
            }

            $source_root = '../images/estate_images/app_temp/';
            $destination_root = "../images/estate_images/{$adsId}/";

            $source_main = "{$source_root}{$image->name}.jpg";
            $destination_main = "{$destination_root}{$image->name}.jpg";

            if (! is_file($source_main) ) {
                continue;
            }

            if (! is_dir($destination_root)) {
                mkdir($destination_root);
            }

            rename($source_main, $destination_main);

            $db_images[] = $ImageDb->createNew($adsId, str_replace('../', '', $destination_main));

            foreach ($image_sizes as $size_name => ['size' => $size]) {
                $sized_source =  "{$source_root}{$image->name}-{$size_name}.jpg";
                $sized_destination =  "{$destination_root}{$image->name}-{$size_name}.jpg";

                if (! is_file($sized_source)) {
                    continue;
                }

                rename($sized_source, $sized_destination);
            }

            $key = array_search($image->name, $all_uploaded_images);
            if ($key == 0 || $key != false) {
                unset($all_uploaded_images[$key]);
            }

            $i++;
        }

        /* delete redundant uploaded images */
        foreach ($all_uploaded_images as $image) {

            if (empty($image)) {
                continue;
            }

            $source_root = '../images/estate_images/app_temp/';

            $source_main = "{$source_root}{$image->name}.jpg";

            if (is_file($source_main)) {
                unlink($source_main);
            }

            foreach ($image_sizes as $size_name => ['size' => $size]) {
                $sized_source = "{$source_root}{$image->name}-{$size_name}.jpg";

                if (is_file($sized_source)) {
                    unlink($sized_source);
                }
            }
        }

        /**
         * Fetch newly created ads
         */
        $ads = $Ads->ads_by_id($adsId, false);

        $ads = $ads->setFeaturedImage($db_images[0]);


        if (input('send_to_telegram') == 1) {
            $featured_image = $ads->featuredImage('main', false);
            $ads->sendToTelegram(input('frm_title'), $featured_image);
        }

        session()->success('ثبت آگهی با موفقیت انجام شد');
        redirect($ads->adminEditLink());
    } catch (PDOException $e) {
        $db->rollBack();
        session()->error('مشکلی در عملیات ثبت پیش آمده است ... لطفا مجددا تلاش نمایید');
    }
} else {
    session()->error($validation->errors(), true);
}
