<?php

use App\Category;
use App\SubCategory;
use App\Validate;

checkUserCountry();

$validation = new Validate();
$rules = array(
    'name' => ['name' => 'عنوان', 'prefix' => 'وارد کردن ', 'required' => true, 'min' => 2, 'max' => 200]
);

$category_id = input('category_id');
$subcategory_id = input('subcategory_id');

$type = 'category';
if(! empty($category_id) && empty($subcategory_id)) {
    $type = 'subcategory';
}
if(! empty($category_id) && ! empty($subcategory_id)) {
    $type = 'subsidiary';
}

$slug_name = slug(input('name'));
if (inputs()->not_empty('slug')) {
    $slug_name = slug(input('slug'));
}

if (empty($slug_name) || trim($slug_name) == '' || strlen($slug_name) > 250) {
    $validation->addError('عنوان وارد شده  معتبر نمی باشد');
}

/** @var Validate $validation */
$validation = $validation->check($_POST, $rules);
if ($validation->passed()) {
    $image_name = null;

    /* move uploaded images to it's real destination */
    $uploaded_images = json_decode(input('uploaded_images'));
    $all_uploaded_images = json_decode(input('all_uploaded_images'));

    foreach ($uploaded_images as $image) {
        if (empty($image->name)) {
            continue;
        }

        $image_name = uniqid() . $image->name;
        $source_main = "../images/estate_images/app_temp/{$image->name}";
        $images_root = "../images/categories/";
        $destination_main = $images_root . $image_name;

        if (! is_file($source_main)) {
            continue;
        }

        rename($source_main, $destination_main);
    }
    foreach ($all_uploaded_images as $image) {
        if (empty($image)) {
            continue;
        }
        $source_main = "../images/estate_images/app_temp/{$image}";
        if (is_file($source_main)) {
            unlink($source_main);
        }
    }

    if ($type === 'category') {
        $Category = new Category();
        $Category->createNew(inputs()->all(), $slug_name, $image_name);
    }

    if ($type === 'subcategory' || $type === 'subsidiary') {
        $SubCategory = new SubCategory();
        $SubCategory->createNew(inputs()->all(), $slug_name, $image_name);
    }

    session()->success();
    redirect('refer');
} else {
    session()->error($validation->errors(), true);
}
