<?php

use Admin\User;
use App\Affiliate;
use App\WithdrawalRequest;

checkDemoMode();

$requestId = input('id');
$WithdrawInstance = new WithdrawalRequest();

/** @var WithdrawalRequest $request */
$request = $WithdrawInstance->findById($requestId);
$affIds = json_decode($request->referal_ids);
try {
    $db->beginTransaction();

    foreach ($affIds AS $affId) {
        $Affiliate = new Affiliate();
        $aff = $Affiliate->findById($affId);
        $aff->update(0, 'settled');
    }

    $request->update(0, 'settled');

    $db->commit();

    if (setting('SEND_EMAIL_AFTER_WITHDRAWAL_SETTLEMENT') === "YES") {
        $User = new User();
        $user = $User->findById($request->user_id);

        $WithdrawInstance->sendWithdrawalSettledEmailToUser($user->EMAIL, $user->NAME, $user->USER_ID);
    }

    session()->success();

} catch (PDOException $e) {
    $db->rollBack();
    session()->error();
}

redirect('refer');
