<?php

use App\Image;
use App\Post;
use App\Tag;
use App\Validate;

checkDemoMode();
checkUserCountry();

$Post = new Post();
$validate = new Validate();

$rules = array(
    'frm_title' => ['name' => 'عنوان', 'prefix' => 'وارد کردن ', 'required' => true, 'min' => 5, 'max' => 200],
    'category' => ['name' => 'دسته بندی', 'prefix' => 'انتخاب کردن ', 'required' => true, 'not_any' => true]
);

$slug_name = slug(input('frm_title'));
$slug_name = $Post->slug($slug_name);

if (empty($slug_name) || trim($slug_name) == '') {
    $validate->addError('عنوان وارد شده معتبر نمی باشد');
}
if (strlen($slug_name) > 250) {
    $validate->addError('طول عنوان وارد شده بیش از مقدار مجاز است');
}

$validation = $validate->check($_POST, $rules);

if ($validation->passed()) {
    try {
        /**
         * Start transaction
         */
        $db->beginTransaction();

        /**
         * Creating Post
         */
        $postId = $Post->createNew(inputs()->all(), $slug_name);

        /**
         * Inserting Tags
         */
        $Tag = new Tag();
        $Tag->handle(input('frm_keywords'), $postId, 'post', 0, false);

        /**
         * Ends Transaction
         */
        $db->commit();

        /* move uploaded images to it's real destination */
        $uploaded_images = json_decode(input('uploaded_images'));
        $all_uploaded_images = json_decode(input('all_uploaded_images'));

        $ImageDb = new Image();
        $db_images = [];

        $i = 1;
        foreach ($uploaded_images as $image) {
            if (empty($image->name)) {
                continue;
            }

            $source_root = '../images/estate_images/app_temp/';
            $destination_root = "../images/post_images/{$postId}/";

            $source_main = "{$source_root}{$image->name}.jpg";
            $destination_main = "{$destination_root}{$image->name}.jpg";


            if (! is_file($source_main) ) {
                continue;
            }

            if (! is_dir($destination_root)) {
                mkdir($destination_root);
            }

            rename($source_main, $destination_main);

            $db_images[] = $ImageDb->createNew($postId, str_replace('../', '', $destination_main), null, 'post');

            foreach ($post_image_sizes as $size_name => ['size' => $size]) {
                $sized_source =  "{$source_root}{$image->name}-{$size_name}.jpg";
                $sized_destination =  "{$destination_root}{$image->name}-{$size_name}.jpg";

                if (! is_file($sized_source)) {
                    continue;
                }

                rename($sized_source, $sized_destination);
            }

            $key = array_search($image->name, $all_uploaded_images);
            if ($key == 0 || $key != false) {
                unset($all_uploaded_images[$key]);
            }

            $i++;
        }

        /* delete redundant uploaded images */
        foreach ($all_uploaded_images as $image) {

            if (empty($image)) {
                continue;
            }

            $source_root = '../images/estate_images/app_temp/';

            $source_main = "{$source_root}{$image->name}.jpg";

            if (is_file($source_main)) {
                unlink($source_main);
            }

            foreach ($post_image_sizes as $size_name => ['size' => $size]) {
                $sized_source = "{$source_root}{$image->name}-{$size_name}.jpg";

                if (is_file($sized_source)) {
                    unlink($sized_source);
                }
            }
        }

        $post = $Post->byId($postId);

        $post = $post->setFeaturedImage($db_images[0]);

        if (input('send_to_telegram') == 1) {
            $featured_image = $post->featuredImage('main', false);
            $post->sendToTelegram(input('frm_title'), $featured_image);
        }

        session()->alert('success', 'ثبت پست با موفقیت انجام شد');

        redirect($post->editLink());

    } catch (PDOException $e) {
        $db->rollBack();

        session()->error('مشکلی در عملیات ثبت پیش آمده است ... لطفا مجددا تلاش نمایید');
    }

} else {
    session()->error($validation->errors(), true);
}
