<?php

use App\PostCategory;
use App\Validate;

checkDemoMode();

$validation = new Validate();
$rules = [
    'CATEGORY_NAME' => [
        'name' => 'عنوان دسته',
        'prefix' => _e('ENTERING', true),
        'required' => true,
        'max' => 200
    ]
];

$slug = slug(input('CATEGORY_NAME'));
if (inputs()->not_empty('CATEGORY_SLUG')) {
    $slug = slug(input('CATEGORY_SLUG'));
}

if (is_empty($slug)) {
    $validation->addError('عنوان وارد شده برای دسته معتبر نیست');
}

/** @var Validate $validation */
$validation = $validation->check($_POST, $rules);

if ($validation->passed()) {
    try {
        $PostCategory = new PostCategory();
        $PostCategory->createNew(inputs()->all(), $slug);

        session()->success();
        redirect('refer');
    } catch (PDOException $e) {
        session()->error();
    }
} else {
    session()->error($validation->errors(), true);
}

