<?php

use App\ColorPalette;

require '../../init.php';

if (! isPost() && ! token()->check()) {
    session()->alert('error', _e('WRONG_CSRF_TOKEN', true));
    redirect('refer');
}

$palette = (new ColorPalette())->byId(input('id'));

if (! $palette) {
    session()->alert('error', _e('OPERATION_FAILED', true));
    redirect('refer');
}

$colors = inputs()->startsWith('STYLES__COLOR__');
$styles = [
    'colors' => $colors
];
$palette->update(input('name'), json_encode($styles));

if ($palette->id === setting('COLOR_SCHEME')) {
    writeVariablesCssFile($colors);
}

session()->success();
redirect('refer');
