<?php

use App\PageList;
use App\Validate;

$validate = new Validate();
$rules = array(
    'frm_title' => ['name' => 'عنوان برگه', 'prefix' => 'وارد کردن ', 'required' => true ],
    'frm_slug' => ['name' => 'نامک', 'prefix' => 'وارد کردن ', 'required' => true, 'max' => 250 ]
);
if (! $page->canEditTitle()) {
    unset($rules['frm_title']);
}
if (! $page->canEditSlug()) {
    unset($rules['frm_slug']);
}

$slug = $page->SLUG;
if ($page->canEditSlug()) {
    $slug_name = slug(input('frm_slug'));
    $slug = $Page->slug($slug_name, $page->ID);

    if (empty($slug_name) || trim($slug_name) == '') {
        $validate->addError('نامک وارد شده معتبر نمی باشد');
    }
    if (strlen($slug_name) > 250) {
        $validate->addError('طول نامک بیش از مقدار مجاز است');
    }
}

$validation = $validate->check($_POST, $rules);
if ($validation->passed()) {

    $page->setSettings(inputs()->metas())->update(inputs()->all(), $slug);

    (new PageList())->clearCache();

    session()->success();
    redirect('refer');
} else {
    session()->alert('error', $validation->errors(), true);
}