<?php

use App\PageList;
use App\Validate;

$validate = new Validate();

$rules = array(
    'frm_title' => ['name' => 'عنوان برگه', 'prefix' => 'وارد کردن ', 'required' => true ],
    'frm_slug' => ['name' => 'نامک', 'prefix' => 'وارد کردن ', 'required' => true, 'max' => 250 ]
);

$slug_name = slug(input('frm_slug'));
$slug = $Page->slug($slug_name);

if (empty($slug_name) || trim($slug_name) == '') {
    $validate->addError('نامک وارد شده معتبر نمی باشد');
}
if (strlen($slug_name) > 250) {
    $validate->addError('طول نامک بیش از مقدار مجاز است');
}

$validation = $validate->check($_POST, $rules);
if ($validation->passed()) {
    $page_id = $Page->createNew(inputs()->all(), $slug);

    (new PageList())->clearCache();

    session()->success();
    redirect(pagesRoute('edit', $page_id));
} else {
    session()->alert('error', $validation->errors(), true);
}