<?php
use Admin\User;
use App\SMS;

checkDemoMode();

$emails = $users = $resId = null;
if (input('compose-radio') == "email") {
    if (inputs()->not_empty('to')) {
        $emails = input('to');
    } else {
        session()->error('لطفا در قسمت ارسال به شماره تلفن ، یک یا چند شماره تلفن را به عنوان شماره های مقصد وارد نمایید');
        redirect('refer');
    }
} elseif (input('compose-radio') == "custom-users") {

    if (is_empty(implode(',', input('frm_select_users')))) {
        session()->error('لطفا در قسمت ارسال به کاربران سایت ، یک یا چند کاربر را به عنوان هدف ارسال پیامک مشخص نمایید');
        redirect('refer');
    }

} elseif (input('compose-radio') == "all-users") {
    $users = 0;
}

$message = input('message');

try {

    if (input('compose-radio') == "email") { // send to multiple emails
        $numbers = explode(',', $emails);
        $receiver_number = implode(',', $numbers);
    } elseif (input('compose-radio') == "custom-users") {
        $target_users = input('frm_select_users');

        $users = implode(',', $target_users);

        foreach ($target_users as $target_user) {
            $numbers[] = User::user_by_id($target_user)->TEL;
        }

        $receiver_number = null;
    } elseif (input('compose-radio') == "all-users") {
        $User = new User();
        $target_users = $User->listOnly('TEL');
        $users = 0;
        foreach ($target_users AS $user) {
            if (!empty($user->TEL)) {
                $numbers[] = $user->TEL;
            }
        }

        $receiver_number = null;
    }

    $resId = SMS::init()->send($numbers, $message);

    $MessageBox->createNew([
        'USER_ID' => $loggedUser->USER_ID,
        'TITLE' => input('subject'),
        'SENDER_NAME' => _e('SITE_ADMIN', true),
        'SENDER_NUMBER' => setting('SITE_SMS_NUMBER'),
        'MESSAGE' => $message,
        'RECIVER_USER_ID' => $users,
        'RECIVER_NUMBER' => $receiver_number,
        'FROM' => 'ADMIN',
        'TO' => 'USER',
        'RES_ID' => $resId
    ]);

    session()->success();
    redirect('refer');

} catch (PDOException $e) {
    session()->error();
    redirect('refer');
}