<?php

use Admin\User;
use App\Input;
use App\Mailer;
use App\Session;
use App\Template;

checkDemoMode();
$emails = $users = null;

if (input('compose-radio') === "email") {
    if (inputs()->not_empty('to')) {
        $emails = input('to');
    } else {
        session()->alert('error', 'لطفا در قسمت ارسال به ایمیل ، یک یا چند ایمیل را به عنوان ایمیلهای مقصد وارد نمایید');
        redirect('refer');
    }

} elseif (input('compose-radio') === "custom-users") {
    if (inputs()->not_empty('frm_select_users')) {
        $users = implode(',', input('frm_select_users'));
    } else {
        session()->alert('error', 'لطفا در قسمت ارسال به کاربران سایت ، یک یا چند کاربر را به عنوان هدف ایمیل  مشخص نمایید');
        redirect('refer');
    }

} elseif (input('compose-radio') === "all-users") {
    $users = 0;
}

$mailVariables = array(
    "title" => input('subject'),
    "subTitle" => "",
    "senderName" => "مدیریت " . setting('SITE_TITLE'),
    "senderMail" => setting('EMAIL'),
    "senderPhone" => "",
    "subject" => input('subject'),
    "message" => input('message')
);
$message = Template::email('default', $mailVariables);

$reply_mail = new Mailer();
$reply_mail->set_from_name("مدیریت " . setting('SITE_TITLE'));
$reply_mail->set_from_email(setting('EMAIL'));
$reply_mail->set_to_name("");
$reply_mail->set_subject(input('subject'));
$reply_mail->set_message($message);

try {

    if (input('compose-radio') == "email") { // send to multiple emails
        $target_emails = explode(',', $emails);

        foreach ($target_emails AS $email) {
            $reply_mail->set_to_email($email);
            $res = $reply_mail->send_mail();
        }
    } elseif (input('compose-radio') == "custom-users") {
        $target_users = input('frm_select_users');

        foreach ($target_users as $target_user) {
            $user_mail = User::user_by_id($target_user)->EMAIL;// find user mail

            $reply_mail->set_to_email($user_mail);
            $reply_mail->send_mail();
        }
    } elseif (input('compose-radio') == "all-users") {
        $User = new User();
        $target_users = $User->listOnly('EMAIL');

        foreach ($target_users AS $user) {
            $reply_mail->set_to_email($user->EMAIL);
            $reply_mail->send_mail();
        }
    }

    $MessageBox->createNew([
        'USER_ID' => $loggedUser->USER_ID,
        'TITLE' => input('subject'),
        'SENDER_NAME' => _e('SITE_ADMIN', true),
        'SENDER_MAIL' => setting('EMAIL'),
        'MESSAGE' => input('message'),
        'RECIVER_USER_ID' => $users,
        'RECIVER_MAIL' => $emails,
        'FROM' => 'ADMIN',
        'TO' => 'USER'
    ]);

    session()->success();
    redirect('refer');

} catch (PDOException $e) {

    session()->error();
    redirect('refer');
}